/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dim.db.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.cacheservice.XLARuleThreadCache;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpItemDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpTypeCfgDTO;

public class DimBlockIndexCreateTask
implements Callable<Boolean> {
    private static final int SPLIT_SIZE = 300;
    private SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
    private int blockId;
    Map<Long, List<PairTuple<Long, List<Object>>>> indexParamMap;

    public DimBlockIndexCreateTask(int blockId, Map<Long, List<PairTuple<Long, List<Object>>>> indexParamMap) {
        this.blockId = blockId;
        this.indexParamMap = indexParamMap;
    }

    @Override
    public Boolean call() throws Exception {
        HashMap<Long, List<Object>> txtDataMap = new HashMap<Long, List<Object>>(16);
        HashMap<Long, List<Object>> dtDataMap = new HashMap<Long, List<Object>>(16);
        HashMap<Long, List<Object>> amtDataMap = new HashMap<Long, List<Object>>(16);
        LinkedList<PairTuple<Long, Object>> idDataList = new LinkedList<PairTuple<Long, Object>>();
        this.sortColumData(this.indexParamMap, txtDataMap, dtDataMap, amtDataMap, idDataList);
        HashMap<Long, Map<Object, PairTuple<Long, Set<Long>>>> idxDataMap = new HashMap<Long, Map<Object, PairTuple<Long, Set<Long>>>>(16);
        Map<Long, PairTuple<Long, Object>> txtData = this.queryRegDimData(txtDataMap, "TXT", idxDataMap, this.blockId);
        Map<Long, PairTuple<Long, Object>> dtData = this.queryRegDimData(dtDataMap, "DT", idxDataMap, this.blockId);
        Map<Long, PairTuple<Long, Object>> amtData = this.queryRegDimData(amtDataMap, "AMT", idxDataMap, this.blockId);
        this.queryExistIdxRecord(idDataList, "ID", this.blockId, idxDataMap);
        HashMap<Object, DimValBlockIdxData> addMap = new HashMap<Object, DimValBlockIdxData>(16);
        for (Map.Entry<Long, List<PairTuple<Long, List<Object>>>> entry : this.indexParamMap.entrySet()) {
            Iterator dimGrpTypeId = entry.getKey();
            List<PairTuple<Long, List<Object>>> dataList = entry.getValue();
            BizDimGrpTypeCfgDTO dimGrpTypeCfg = XLARuleThreadCache.getBizDimGrpTypeCfgCached((Long)((Object)dimGrpTypeId));
            int colIndex = 0;
            for (BizDimGrpItemDTO item : dimGrpTypeCfg) {
                if (item.getDimDataType().getFlexColumnPrefix().equals("TxtAttr")) {
                    this.generatePreInsertData(colIndex, item, dataList, txtData, idxDataMap, addMap);
                } else if (item.getDimDataType().getFlexColumnPrefix().equals("DateAttr")) {
                    this.generatePreInsertData(colIndex, item, dataList, dtData, idxDataMap, addMap);
                } else if (item.getDimDataType().getFlexColumnPrefix().equals("NumAttr")) {
                    this.generatePreInsertData(colIndex, item, dataList, amtData, idxDataMap, addMap);
                } else {
                    this.generatePreInsertData(colIndex, item, dataList, null, idxDataMap, addMap);
                }
                ++colIndex;
            }
        }
        HashMap pkMap = new HashMap(4);
        HashMap<String, Integer> pkCntMap = new HashMap<String, Integer>(4);
        for (DimValBlockIdxData idxData : addMap.values()) {
            String tbFlag = this.getTableFlag(idxData.getDataType());
            if (idxData.getIdxPk() != null) continue;
            if (pkCntMap.get(tbFlag) == null) {
                pkCntMap.put(tbFlag, 1);
                continue;
            }
            pkCntMap.put(tbFlag, (Integer)pkCntMap.get(tbFlag) + 1);
        }
        for (Map.Entry entry : pkCntMap.entrySet()) {
            Long[] pks = (Long[])this.sReader.getSequences((Object[])new Long[((Integer)entry.getValue()).intValue()], "t_fah_BlockIdx_" + (String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            pkMap.put(entry.getKey(), this.getRemovableList(pks));
        }
        HashMap<String, List> sql_param_Map = new HashMap<String, List>(12);
        String idx_insert = "insert into t_fah_BlockIdx_%s (fid,fDimValue,fDimType,fDataBlockId,fRefCnt,fSingleDimGrpId,fStatus) values(?,?,?,?,?,?,?)";
        String idx_map_insert = "insert into t_fah_BlockIdx_%s_Map (FIdxGrpId,fDimGrpId) values(?,?)";
        String idx_update = "update t_fah_BlockIdx_%s set fRefCnt = ?, fSingleDimGrpId = 0 where fid = ?";
        for (Map.Entry entry : addMap.entrySet()) {
            Object[] idx_map_insert_param;
            LinkedList<Object[]> idx_insert_params = new LinkedList<Object[]>();
            LinkedList<Object[]> idx_map_insert_params = new LinkedList<Object[]>();
            LinkedList<Object[]> idx_update_params = new LinkedList<Object[]>();
            Object dimValue = entry.getKey();
            DimValBlockIdxData idxData = (DimValBlockIdxData)entry.getValue();
            String tbFlag = this.getTableFlag(idxData.getDataType());
            if (idxData.getIdxPk() == null) {
                Long pk = (Long)((List)pkMap.get(tbFlag)).get(0);
                Object[] idx_insert_param = new Object[]{pk, dimValue, idxData.getDimTypeId(), this.blockId, idxData.getDimValGrpIds().size(), idxData.getDimValGrpIds().size() == 1 ? idxData.getDimValGrpIds().iterator().next() : Long.valueOf(0L), "1"};
                idx_insert_params.add(idx_insert_param);
                if (idxData.getDimValGrpIds().size() > 1) {
                    for (Long dimGrpValId : idxData.getDimValGrpIds()) {
                        idx_map_insert_param = new Object[]{pk, dimGrpValId};
                        idx_map_insert_params.add(idx_map_insert_param);
                    }
                }
                ((List)pkMap.get(tbFlag)).remove(0);
            } else {
                Set dupGrpids = (Set)idxDataMap.get(idxData.getDimTypeId()).get(dimValue).getValue();
                Object[] idx_update_param = new Object[]{idxData.getDimValGrpIds().size() + dupGrpids.size(), idxData.getIdxPk()};
                idx_update_params.add(idx_update_param);
                for (Long dimGrpValId : idxData.getDimValGrpIds()) {
                    idx_map_insert_param = new Object[]{idxData.getIdxPk(), dimGrpValId};
                    idx_map_insert_params.add(idx_map_insert_param);
                }
                if (dupGrpids.size() == 1) {
                    Object[] idx_map_insert_param2 = new Object[]{idxData.getIdxPk(), dupGrpids.iterator().next()};
                    idx_map_insert_params.add(idx_map_insert_param2);
                }
            }
            sql_param_Map.computeIfAbsent(String.format(idx_insert, tbFlag), k -> new LinkedList()).addAll(idx_insert_params);
            sql_param_Map.computeIfAbsent(String.format(idx_map_insert, tbFlag), k -> new LinkedList()).addAll(idx_map_insert_params);
            sql_param_Map.computeIfAbsent(String.format(idx_update, tbFlag), k -> new LinkedList()).addAll(idx_update_params);
        }
        for (Map.Entry entry : sql_param_Map.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)((String)entry.getKey()), (List)((List)entry.getValue()));
        }
        return Boolean.TRUE;
    }

    private Map<Long, PairTuple<Long, Object>> queryRegDimData(Map<Long, List<Object>> dataMap, String tableFlag, HashMap<Long, Map<Object, PairTuple<Long, Set<Long>>>> idxDataMap, Integer blockId) {
        HashMap<Long, PairTuple<Long, Object>> result = new HashMap<Long, PairTuple<Long, Object>>(16);
        if (!dataMap.isEmpty()) {
            LinkedList pks = new LinkedList();
            for (Map.Entry<Long, List<Object>> entry : dataMap.entrySet()) {
                pks.addAll(entry.getValue());
            }
            SqlBuilder sb = new SqlBuilder();
            sb.append("Select fid, fBizDimTypeId, fDimValue from ", new Object[0]).append("t_fah_Reg_DimVal_" + tableFlag, new Object[0]).appendIn(" where fid ", pks);
            DataSet dataSet = DB.queryDataSet((String)"createDimGrpIndex_1", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.put(row.getLong("fid"), (PairTuple<Long, Object>)new PairTuple((Object)row.getLong("fBizDimTypeId"), row.get("fDimValue")));
            }
            this.queryExistIdxRecord(result.values(), tableFlag, blockId, idxDataMap);
        }
        return result;
    }

    private void sortColumData(Map<Long, List<PairTuple<Long, List<Object>>>> indexParamMap, Map<Long, List<Object>> txtDataMap, Map<Long, List<Object>> dtDataMap, Map<Long, List<Object>> amtDataMap, List<PairTuple<Long, Object>> idDataList) {
        for (Map.Entry<Long, List<PairTuple<Long, List<Object>>>> entry : indexParamMap.entrySet()) {
            Long dimGrpTypeId = entry.getKey();
            BizDimGrpTypeCfgDTO dimGrpTypeCfg = XLARuleThreadCache.getBizDimGrpTypeCfgCached(dimGrpTypeId);
            int index = 0;
            for (BizDimGrpItemDTO bizDimGrpItemDTO : dimGrpTypeCfg) {
                int finalIndex;
                if (bizDimGrpItemDTO.getDimDataType().getFlexColumnPrefix().equals("TxtAttr")) {
                    finalIndex = index;
                    HashSet txtIdList = new HashSet(indexParamMap.size());
                    entry.getValue().stream().forEach(o -> txtIdList.add(((List)o.getValue()).get(finalIndex)));
                    txtDataMap.computeIfAbsent((Long)bizDimGrpItemDTO.getId(), k -> new ArrayList(txtIdList.size())).addAll(txtIdList);
                } else if (bizDimGrpItemDTO.getDimDataType().getFlexColumnPrefix().equals("DateAttr")) {
                    finalIndex = index;
                    HashSet dtIdList = new HashSet(indexParamMap.size());
                    entry.getValue().stream().forEach(o -> dtIdList.add(((List)o.getValue()).get(finalIndex)));
                    dtDataMap.computeIfAbsent((Long)bizDimGrpItemDTO.getId(), k -> new ArrayList(dtIdList.size())).addAll(dtIdList);
                } else if (bizDimGrpItemDTO.getDimDataType().getFlexColumnPrefix().equals("NumAttr")) {
                    finalIndex = index;
                    HashSet amtIdList = new HashSet(indexParamMap.size());
                    entry.getValue().stream().forEach(o -> amtIdList.add(((List)o.getValue()).get(finalIndex)));
                    amtDataMap.computeIfAbsent((Long)bizDimGrpItemDTO.getId(), k -> new ArrayList(amtIdList.size())).addAll(amtIdList);
                } else {
                    finalIndex = index;
                    entry.getValue().stream().forEach(o -> idDataList.add(new PairTuple(bizDimGrpItemDTO.getId(), ((List)o.getValue()).get(finalIndex))));
                }
                ++index;
            }
        }
    }

    private List<Long> getRemovableList(Long[] pks) {
        LinkedList<Long> list = new LinkedList<Long>();
        for (Long pk : pks) {
            list.add(pk);
        }
        return list;
    }

    private void generatePreInsertData(int colIndex, BizDimGrpItemDTO item, List<PairTuple<Long, List<Object>>> dataList, Map<Long, PairTuple<Long, Object>> dataMap, HashMap<Long, Map<Object, PairTuple<Long, Set<Long>>>> idxDataMap, Map<Object, DimValBlockIdxData> addMap) {
        Long dimType = (Long)item.getId();
        for (PairTuple<Long, List<Object>> dimGrpValueData : dataList) {
            Long dimGrpValId = (Long)dimGrpValueData.getKey();
            Object dimValue = ((List)dimGrpValueData.getValue()).get(colIndex);
            if (dimValue == null || dimValue instanceof Long && 0L == (long)((Long)dimValue).intValue()) continue;
            if (dataMap != null) {
                dimValue = dataMap.get((Long)dimValue).getValue();
            }
            if (null == idxDataMap.get(dimType) || null == idxDataMap.get(dimType).get(dimValue)) {
                addMap.computeIfAbsent(dimValue, k -> new DimValBlockIdxData(dimType, item.getDimDataType())).addDimValGrpId(dimGrpValId);
                continue;
            }
            PairTuple<Long, Set<Long>> pair = idxDataMap.get(dimType).get(dimValue);
            if (((Set)pair.getValue()).contains(dimGrpValId)) continue;
            addMap.computeIfAbsent(dimValue, k -> new DimValBlockIdxData((Long)pair.getKey(), dimType, item.getDimDataType())).addDimValGrpId(dimGrpValId);
        }
    }

    private void queryExistIdxRecord(Collection<PairTuple<Long, Object>> dimValues, String tableFlag, Integer blockId, HashMap<Long, Map<Object, PairTuple<Long, Set<Long>>>> idxDataMap) {
        if (CollectionUtils.isEmpty(dimValues)) {
            return;
        }
        List<List<Object>> dimValueSplitList = this.splitCollection(dimValues, 300);
        for (List<Object> dimValueList : dimValueSplitList) {
            Object dimValue;
            int index = 0;
            SqlBuilder idxQuerySql = new SqlBuilder();
            idxQuerySql.append("select fid,fDimValue,fDimType,fRefCnt,fSingleDimGrpId from t_fah_BlockIdx_" + tableFlag + " where (", new Object[0]);
            for (Object dimValue2 : dimValueList) {
                ++index;
                idxQuerySql.append("( fDimType = ?", new Object[]{((PairTuple)dimValue2).getKey()});
                idxQuerySql.append(" and fDimValue = ?", new Object[]{((PairTuple)dimValue2).getValue()});
                idxQuerySql.append(")", new Object[0]);
                if (index >= dimValueList.size()) continue;
                idxQuerySql.append(" or ", new Object[0]);
            }
            idxQuerySql.append(") and fDataBlockId = ?", new Object[]{blockId});
            DataSet idxResult = DB.queryDataSet((String)"createDimGrpIndex_2", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)idxQuerySql);
            HashMap<Long, PairTuple> mapTableParam = new HashMap<Long, PairTuple>(16);
            while (idxResult.hasNext()) {
                Row row = idxResult.next();
                Long id = row.getLong("fid");
                Integer cnt = row.getInteger("fRefCnt");
                Long dimType = row.getLong("fDimType");
                Long dimGrpId = row.getLong("fSingleDimGrpId");
                dimValue = row.get("fDimValue");
                if (cnt == 1) {
                    ((Set)idxDataMap.computeIfAbsent(dimType, k1 -> new HashMap()).computeIfAbsent(dimValue, k2 -> new PairTuple((Object)id, new HashSet(1))).getValue()).add(dimGrpId);
                    continue;
                }
                mapTableParam.put(id, new PairTuple((Object)dimType, dimValue));
            }
            if (mapTableParam.isEmpty()) continue;
            SqlBuilder mapSql = new SqlBuilder();
            mapSql.appendIn("select FIdxGrpId, fDimGrpId from t_fah_BlockIdx_" + tableFlag + "_Map where FIdxGrpId ", mapTableParam.keySet().toArray());
            DataSet mapData = DB.queryDataSet((String)"createDimGrpIndex_3", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)mapSql);
            while (mapData.hasNext()) {
                Row row = mapData.next();
                Long idxId = row.getLong("FIdxGrpId");
                Long dimType = (Long)((PairTuple)mapTableParam.get(idxId)).getKey();
                dimValue = ((PairTuple)mapTableParam.get(idxId)).getValue();
                ((Set)idxDataMap.computeIfAbsent(dimType, k1 -> new HashMap()).computeIfAbsent(dimValue, k2 -> new PairTuple((Object)idxId, new HashSet(8))).getValue()).add(row.getLong("fDimGrpId"));
            }
        }
    }

    private List<List<Object>> splitCollection(Collection collection, int size) {
        LinkedList<List<Object>> result = new LinkedList<List<Object>>();
        if (collection.size() <= size) {
            result.add(new ArrayList(collection));
        } else {
            int count = 0;
            LinkedList temp = new LinkedList();
            for (Object o : collection) {
                temp.add(o);
                if (++count != size) continue;
                result.add(new ArrayList(temp));
                temp.clear();
                count = 0;
            }
            if (!temp.isEmpty()) {
                result.add(new ArrayList(temp));
            }
        }
        return result;
    }

    private String getTableFlag(DataValueTypeEnum typeEnum) {
        String flag = "ID";
        if (typeEnum.getFlexColumnPrefix().equals("TxtAttr")) {
            flag = "TXT";
        } else if (typeEnum.getFlexColumnPrefix().equals("DateAttr")) {
            flag = "DT";
        } else if (typeEnum.getFlexColumnPrefix().equals("NumAttr")) {
            flag = "AMT";
        }
        return flag;
    }

    private static class DimValBlockIdxData {
        Long idxPk;
        Long dimTypeId;
        Set<Long> dimValGrpIds;
        DataValueTypeEnum dataType;

        public DimValBlockIdxData(Long dimTypeId, DataValueTypeEnum dataType) {
            this.dimTypeId = dimTypeId;
            this.dataType = dataType;
            this.dimValGrpIds = new HashSet<Long>(16);
        }

        public DimValBlockIdxData(Long idxPk, Long dimTypeId, DataValueTypeEnum dataType) {
            this.idxPk = idxPk;
            this.dimTypeId = dimTypeId;
            this.dataType = dataType;
            this.dimValGrpIds = new HashSet<Long>(16);
        }

        public Long getIdxPk() {
            return this.idxPk;
        }

        public void setIdxPk(Long idxPk) {
            this.idxPk = idxPk;
        }

        public void addDimValGrpId(Long dimValGrpId) {
            this.dimValGrpIds.add(dimValGrpId);
        }

        public DataValueTypeEnum getDataType() {
            return this.dataType;
        }

        public void setDataType(DataValueTypeEnum dataType) {
            this.dataType = dataType;
        }

        public Set<Long> getDimValGrpIds() {
            return this.dimValGrpIds;
        }

        public Long getDimTypeId() {
            return this.dimTypeId;
        }

        public void setDimTypeId(Long dimTypeId) {
            this.dimTypeId = dimTypeId;
        }
    }
}

