/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dim.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.event.BizDataStatusEnum;
import kd.fi.v2.fah.dim.db.task.DimBlockIndexCreateTask;
import kd.fi.v2.fah.meta.BizDataColumnMeta;
import kd.fi.v2.fah.meta.BizDataSimpleTableMeta;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;
import kd.fi.v2.fah.utils.FastHashHelper;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;

public class DimValueSaveService {
    public static final String TB_TXT_REG = "t_fah_Reg_DimVal_TXT";
    public static final String TB_DT_REG = "t_fah_Reg_DimVal_DT";
    public static final String TB_AMT_REG = "t_fah_Reg_DimVal_Amt";
    public static final String FLEX_FIELD_PREFIX = "fIDValue";
    private final SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
    private static final SimpleDataDistributeCacheService instance = SimpleDataDistributeCacheService.getInstance();
    private static final Log log = LogFactory.getLog(DimValueSaveService.class);

    public void saveDimValue(BizDataSimpleTableMeta tableMeta, SimpleTableColStorage storage) {
        if (storage == null || storage.isEmpty()) {
            return;
        }
        TreeMap<Integer, Integer> indexMap = new TreeMap<Integer, Integer>();
        this.registerNewValue(tableMeta, storage, this.sReader, indexMap);
        int[] indexes = new int[indexMap.size()];
        int i = 0;
        for (Map.Entry entry : indexMap.entrySet()) {
            indexes[i] = (Integer)entry.getValue();
            ++i;
        }
        int flexFieldCnt = 0;
        Long[] pks = (Long[])this.sReader.getSequences((Object[])new Long[storage.size()], "t_fah_dimgrp_values_tmp", storage.size());
        String valueSql = "insert into t_fah_dimgrp_values_tmp (fid, fTrans_Id, fDimGrpTypeId, fDimCnt, fEvtLineId, fStatus, fGrpValHash, fMsg, fTrans_Batch_Id %1$s) values(?,%2$s,%3$s,%4$s,?,?,?,?,?%5$s)";
        StringBuilder s1 = new StringBuilder();
        StringBuilder s2 = new StringBuilder();
        for (BizDataColumnMeta columnMeta : tableMeta.getColumnMetas()) {
            if (IAddSqlColumn.ColumnGrpType.FlexColumn != columnMeta.getColumnGrpType()) continue;
            s1.append(",").append(FLEX_FIELD_PREFIX).append(columnMeta.getWritePos() + 1);
            s2.append(",?");
            ++flexFieldCnt;
        }
        valueSql = String.format(valueSql, s1, tableMeta.getTransId(), tableMeta.getDimGrpTypeId(), flexFieldCnt, s2);
        ArrayList<Object[]> valueParamList = new ArrayList<Object[]>(storage.size());
        Iterator iterator = storage.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object[] values = (Object[])iterator.next();
            long hashcode = FastHashHelper.javaHashCode((Object[])values, (int[])indexes);
            LinkedList<Object> valueParam = new LinkedList<Object>();
            valueParam.add(pks[index]);
            valueParam.add(values[BizDataSimpleTableMeta.evtLineIdFieldIndex]);
            valueParam.add(values[BizDataSimpleTableMeta.statusFieldIndex]);
            valueParam.add(hashcode);
            valueParam.add(values[BizDataSimpleTableMeta.errMsgFieldIndex]);
            valueParam.add(values[BizDataSimpleTableMeta.batchIdFieldIndex]);
            for (BizDataColumnMeta columnMeta : tableMeta.getColumnMetas()) {
                if (IAddSqlColumn.ColumnGrpType.FlexColumn != columnMeta.getColumnGrpType()) continue;
                valueParam.add(values[columnMeta.getReadPos()]);
            }
            valueParamList.add(valueParam.toArray());
            ++index;
        }
        if (CollectionUtils.isEmpty(valueParamList)) {
            return;
        }
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)valueSql, valueParamList);
    }

    private void registerNewValue(BizDataSimpleTableMeta meta, SimpleTableColStorage storage, SequenceReader sReader, Map<Integer, Integer> indexMap) {
        for (BizDataColumnMeta bizDataColumnMeta : meta.getColumnMetas()) {
            ArrayList<Object> newValues;
            Object[] pks;
            HashMap<Object, Long> undup_value_map;
            DataSet dataSet;
            HashMap<Object, Object> value_map;
            SqlBuilder sb;
            Set values;
            Object[] columnValues;
            if (IAddSqlColumn.ColumnGrpType.FlexColumn != bizDataColumnMeta.getColumnGrpType()) continue;
            long dimTypeId = bizDataColumnMeta.getDimTypeId();
            int colIndex = bizDataColumnMeta.getReadPos();
            indexMap.put(bizDataColumnMeta.getDimTypeGlobalIndex(), colIndex);
            DataValueTypeEnum dimDataType = bizDataColumnMeta.getDataType();
            if (DataValueTypeEnum.Bool != dimDataType && ("CharAttr".equals(dimDataType.getFlexColumnPrefix()) || "TxtAttr".equals(dimDataType.getFlexColumnPrefix()))) {
                columnValues = storage.getColumnValues(colIndex);
                values = Arrays.stream(columnValues).filter(o -> !(o instanceof Long) || 0L != (Long)o).map(o -> (String)o).collect(Collectors.toSet());
                if (values.isEmpty()) continue;
                sb = new SqlBuilder();
                sb.append("select fid, fdimvalue from ", new Object[0]).append(TB_TXT_REG, new Object[0]);
                sb.append(" where fbizdimtypeid = ?", new Object[]{dimTypeId});
                sb.appendIn(" and fdimvalue ", values.toArray());
                value_map = new HashMap<Object, Object>(values.size());
                dataSet = DB.queryDataSet((String)TB_TXT_REG, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
                Object[] objectArray = null;
                try {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        String dimValue = row.getString("fdimvalue");
                        value_map.put(dimValue, row.getLong("fid"));
                        values.remove(dimValue);
                    }
                }
                catch (Throwable row) {
                    objectArray = row;
                    throw row;
                }
                finally {
                    if (dataSet != null) {
                        if (objectArray != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row) {
                                objectArray.addSuppressed(row);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                if (values.size() > 0) {
                    undup_value_map = new HashMap<Object, Long>(values.size());
                    pks = (Long[])sReader.getSequences((Object[])new Long[values.size()], TB_TXT_REG, values.size());
                    int index = 0;
                    for (Object value : values) {
                        value_map.put(value, pks[index]);
                        undup_value_map.put(value, (Long)pks[index]);
                        ++index;
                    }
                    this.saveRegTable(TB_TXT_REG, dimTypeId, undup_value_map);
                }
                newValues = new ArrayList<Object>(columnValues.length);
                for (Object columnValue : columnValues) {
                    if (columnValue instanceof Long && 0L == (Long)columnValue) {
                        newValues.add(columnValue);
                        continue;
                    }
                    newValues.add(value_map.get((String)columnValue));
                }
                storage.setColumn(colIndex, newValues.toArray());
                continue;
            }
            if ("DateAttr".equals(dimDataType.getFlexColumnPrefix())) {
                columnValues = storage.getColumnValues(colIndex);
                values = Arrays.stream(columnValues).filter(o -> !(o instanceof Long) || 0L != (Long)o).map(o -> (Date)o).collect(Collectors.toSet());
                if (values.isEmpty()) continue;
                sb = new SqlBuilder();
                sb.append("select fid, fdimvalue from ", new Object[0]).append(TB_DT_REG, new Object[0]);
                sb.append(" where fbizdimtypeid = ?", new Object[]{dimTypeId});
                sb.appendIn(" and fdimvalue ", values.toArray());
                value_map = new HashMap(values.size());
                dataSet = DB.queryDataSet((String)TB_DT_REG, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
                pks = null;
                try {
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        Date dimValue = row.getDate("fdimvalue");
                        value_map.put(dimValue, row.getLong("fid"));
                        values.remove(dimValue);
                    }
                }
                catch (Throwable row) {
                    pks = row;
                    throw row;
                }
                finally {
                    if (dataSet != null) {
                        if (pks != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable row) {
                                pks.addSuppressed(row);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                if (values.size() > 0) {
                    undup_value_map = new HashMap(values.size());
                    pks = (Long[])sReader.getSequences((Object[])new Long[values.size()], TB_DT_REG, values.size());
                    int index = 0;
                    for (Object value : values) {
                        value_map.put(value, pks[index]);
                        undup_value_map.put(value, (Long)pks[index]);
                        ++index;
                    }
                    this.saveRegTable(TB_DT_REG, dimTypeId, undup_value_map);
                }
                newValues = new ArrayList(columnValues.length);
                for (Object columnValue : columnValues) {
                    if (columnValue instanceof Long && 0L == (Long)columnValue) {
                        newValues.add(columnValue);
                        continue;
                    }
                    newValues.add(value_map.get((Date)columnValue));
                }
                storage.setColumn(colIndex, newValues.toArray());
                continue;
            }
            if (!"NumAttr".equals(dimDataType.getFlexColumnPrefix()) || (values = Arrays.stream(columnValues = storage.getColumnValues(colIndex)).filter(o -> !(o instanceof Long) || 0L != (Long)o).map(o -> {
                if (o instanceof BigDecimal) {
                    return (BigDecimal)o;
                }
                if (o instanceof Integer) {
                    return new BigDecimal((Integer)o);
                }
                if (o instanceof Long) {
                    return new BigDecimal((Long)o);
                }
                if (o instanceof Short) {
                    return new BigDecimal(((Short)o).shortValue());
                }
                throw new RuntimeException("not support data type: " + o.getClass());
            }).collect(Collectors.toSet())).isEmpty()) continue;
            sb = new SqlBuilder();
            sb.append("select fid, fdimvalue from ", new Object[0]).append(TB_AMT_REG, new Object[0]);
            sb.append(" where fbizdimtypeid = ?", new Object[]{dimTypeId});
            sb.appendIn(" and fdimvalue ", values.toArray());
            value_map = new HashMap(values.size());
            dataSet = DB.queryDataSet((String)TB_AMT_REG, (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
            pks = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    BigDecimal dimValue = row.getBigDecimal("fdimvalue");
                    value_map.put(dimValue, row.getLong("fid"));
                    values.remove(dimValue);
                }
            }
            catch (Throwable row) {
                pks = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (pks != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            pks.addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            if (values.size() > 0) {
                undup_value_map = new HashMap(values.size());
                pks = (Long[])sReader.getSequences((Object[])new Long[values.size()], TB_AMT_REG, values.size());
                int index = 0;
                for (Object value : values) {
                    value_map.put(value, pks[index]);
                    undup_value_map.put(value, (Long)pks[index]);
                    ++index;
                }
                this.saveRegTable(TB_AMT_REG, dimTypeId, undup_value_map);
            }
            newValues = new ArrayList(columnValues.length);
            for (Object columnValue : columnValues) {
                BigDecimal bigDecimalColumnValue;
                if (columnValue instanceof Long && 0L == (Long)columnValue) {
                    newValues.add(columnValue);
                    continue;
                }
                if (columnValue instanceof BigDecimal) {
                    bigDecimalColumnValue = (BigDecimal)columnValue;
                } else if (columnValue instanceof Integer) {
                    bigDecimalColumnValue = new BigDecimal((Integer)columnValue);
                } else if (columnValue instanceof Long) {
                    bigDecimalColumnValue = new BigDecimal((Long)columnValue);
                } else if (columnValue instanceof Short) {
                    bigDecimalColumnValue = new BigDecimal(((Short)columnValue).shortValue());
                } else {
                    throw new RuntimeException("not support data type: " + columnValue.getClass());
                }
                newValues.add(value_map.get(bigDecimalColumnValue));
            }
            storage.setColumn(colIndex, newValues.toArray());
        }
    }

    private void saveRegTable(String tableName, Long id, Map<Object, Long> value_map) {
        String sql = "insert into " + tableName + "(fid,fBizDimTypeId,fDimValue,fStatus) values(?,?,?,?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(value_map.size());
        for (Map.Entry<Object, Long> entry : value_map.entrySet()) {
            Object[] param = new Object[]{entry.getValue(), id, entry.getKey(), "1"};
            paramList.add(param);
        }
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql, paramList);
    }

    public void activateDimValTmpData(Long trans_id, List<Object> successBatchIds, int maxDimCnt) {
        Integer maxBlock_Offset;
        Integer maxBlockId;
        Serializable fid;
        Serializable fid2;
        if (CollectionUtils.isEmpty(successBatchIds)) {
            return;
        }
        String query_sql_prefix = "select fid,fEvtLineId,fDimGrpTypeId,fDimCnt,fStatus,fGrpValHash %s from t_fah_dimgrp_values_tmp ";
        String insert_info_sql = "insert into t_fah_dimgrp_Info (fid,fDataBlockID,fDataBlockOffset,fGrpValHash,fhashfix) values(?,?,?,?,?)";
        String insert_values_sql = "insert into t_fah_dimgrp_values (fid,fDimGrpTypeId,fDataBlockID,fDimCnt,fStatus%s) values(?,?,?,?,?%s)";
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (int i = 1; i <= maxDimCnt; ++i) {
            sb1.append(",").append(FLEX_FIELD_PREFIX).append(i);
            sb2.append(",?");
        }
        query_sql_prefix = String.format(query_sql_prefix, sb1);
        insert_values_sql = String.format(insert_values_sql, sb1, sb2);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(query_sql_prefix, new Object[0]);
        sqlBuilder.append("where fTrans_Id = ? ", new Object[]{trans_id});
        sqlBuilder.appendIn("and fTrans_Batch_Id ", successBatchIds);
        DataSet dataSet = DB.queryDataSet((String)"activateDimValTmpData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
        if (dataSet.isEmpty()) {
            return;
        }
        HashMap<Long, List<PairTuple<Long, List<Long>>>> tmp_map = new HashMap<Long, List<PairTuple<Long, List<Long>>>>(16);
        HashSet<Long> fGrpValHashSet = new HashSet<Long>(16);
        HashSet<Long> fDimGrpTypeIdSet = new HashSet<Long>(16);
        try (DataSet copyDataSet = dataSet.copy();){
            while (copyDataSet.hasNext()) {
                Row row = copyDataSet.next();
                Long hashCode = row.getLong("fGrpValHash");
                fGrpValHashSet.add(hashCode);
                fDimGrpTypeIdSet.add(row.getLong("fDimGrpTypeId"));
                fid2 = row.getLong("fid");
                ArrayList<Long> values = new ArrayList<Long>(maxDimCnt);
                for (int i = 1; i <= maxDimCnt; ++i) {
                    String fieldName = FLEX_FIELD_PREFIX + i;
                    Long value = row.getLong(fieldName);
                    values.add(value);
                }
                tmp_map.computeIfAbsent(hashCode, k -> new LinkedList()).add(new PairTuple((Object)fid2, values));
            }
        }
        Map<Long, Long> idMap = this.selfDupCheck(tmp_map);
        HashMap<Long, List> dup_map = new HashMap<Long, List>(16);
        SqlBuilder hashCodeSql = new SqlBuilder();
        hashCodeSql.append("select info.fid,info.fGrpValHash,info.fHashFix", new Object[0]);
        for (int i = 1; i <= maxDimCnt; ++i) {
            hashCodeSql.append(",va.fIDValue" + i, new Object[0]);
        }
        hashCodeSql.append(" from t_fah_dimgrp_Info info join t_fah_dimgrp_values va on info.fid = va.fid where ", new Object[0]);
        hashCodeSql.appendIn("va.fDimGrpTypeId", fDimGrpTypeIdSet.toArray());
        hashCodeSql.appendIn("and info.fGrpValHash", fGrpValHashSet.toArray());
        DataSet dupDataSet = DB.queryDataSet((String)"activateDimValTmpData_dupcheck", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)hashCodeSql);
        fid2 = null;
        try {
            while (dupDataSet.hasNext()) {
                Row row = dupDataSet.next();
                Long l = row.getLong("fGrpValHash");
                Long fid3 = row.getLong("fid");
                ArrayList<Long> values = new ArrayList<Long>(maxDimCnt);
                for (int i = 1; i <= maxDimCnt; ++i) {
                    String fieldName = FLEX_FIELD_PREFIX + i;
                    Long value = row.getLong(fieldName);
                    values.add(value);
                }
                dup_map.computeIfAbsent(l, k -> new LinkedList()).add(new DupCheckInfo(fid3, l, row.getInteger("fHashFix"), values));
            }
        }
        catch (Throwable row) {
            fid2 = row;
            throw row;
        }
        finally {
            if (dupDataSet != null) {
                if (fid2 != null) {
                    try {
                        dupDataSet.close();
                    }
                    catch (Throwable row) {
                        ((Throwable)fid2).addSuppressed(row);
                    }
                } else {
                    dupDataSet.close();
                }
            }
        }
        HashMap<Long, Long> result_map = new HashMap<Long, Long>(16);
        HashMap<Long, Integer> hashfix_map = new HashMap<Long, Integer>(1);
        for (Map.Entry entry : dup_map.entrySet()) {
            Long hashcode = (Long)entry.getKey();
            List dupValues = (List)entry.getValue();
            List pairTuples = (List)tmp_map.get(hashcode);
            for (PairTuple pair : pairTuples) {
                Long fid4 = (Long)pair.getKey();
                if (idMap.get(fid4) != null) continue;
                List values = (List)pair.getValue();
                boolean bl = false;
                int max_hashfix = 0;
                for (DupCheckInfo dupValue : dupValues) {
                    if (dupValue.getHashFix() > max_hashfix) {
                        max_hashfix = dupValue.getHashFix();
                    }
                    if (!ICommonDataValueUtil.deepEquals((Object)values, dupValue.getValues())) continue;
                    bl = true;
                    result_map.put(fid4, dupValue.getFid());
                    break;
                }
                if (bl) continue;
                hashfix_map.put(fid4, max_hashfix + 1);
            }
        }
        String updateLineGrpIdSql = "update t_fah_event_line set fDimGrpValId = ?, fBizLineStatus = ? where fEntryId = ?";
        LinkedList linkedList = new LinkedList();
        LinkedList<Object[]> updateParams = new LinkedList<Object[]>();
        try (DataSet dataSet3 = dataSet;){
            while (dataSet3.hasNext()) {
                Serializable final_fid;
                boolean db_repeat;
                Integer hashfix;
                Long db_repeat_id;
                boolean cache_repeat;
                Row row = dataSet3.next();
                fid = row.getLong("fid");
                Long fEvtLineId = row.getLong("fEvtLineId");
                String fStatus = row.getString("fStatus");
                Long l = idMap.get(fid);
                boolean bl = cache_repeat = l != null;
                if (cache_repeat) {
                    db_repeat_id = (Long)result_map.get(l);
                    hashfix = (Integer)hashfix_map.get(l);
                } else {
                    db_repeat_id = (Long)result_map.get(fid);
                    hashfix = (Integer)hashfix_map.get(fid);
                }
                boolean bl2 = db_repeat = db_repeat_id != null;
                if (!(cache_repeat || db_repeat && hashfix == null)) {
                    HashMap<String, Object> insertParam = new HashMap<String, Object>();
                    insertParam.put("fGrpValHash", row.getLong("fGrpValHash"));
                    insertParam.put("hashfix", hashfix == null ? Integer.valueOf(0) : hashfix);
                    insertParam.put("fid", fid);
                    insertParam.put("fDimGrpTypeId", row.getLong("fDimGrpTypeId"));
                    insertParam.put("fDimCnt", row.getInteger("fDimCnt"));
                    insertParam.put("fStatus", row.getString("fStatus"));
                    ArrayList<Object> values = new ArrayList<Object>(maxDimCnt);
                    for (int i = 1; i <= maxDimCnt; ++i) {
                        String fieldName = FLEX_FIELD_PREFIX + i;
                        Object value = row.get(fieldName);
                        values.add(value);
                    }
                    insertParam.put("values", values);
                    linkedList.add(insertParam);
                    final_fid = fid;
                } else {
                    final_fid = cache_repeat && !db_repeat ? l : db_repeat_id;
                }
                Object[] updateParam = new Object[]{final_fid, fStatus, fEvtLineId};
                updateParams.add(updateParam);
            }
        }
        TXHandle h = TX.requiresNew();
        fid = null;
        try {
            try {
                PairTuple<Integer, Integer> maxBlockIdAndOffset = this.getMaxBlockIdAndOffset(trans_id, linkedList.size());
                maxBlockId = (Integer)maxBlockIdAndOffset.getKey();
                maxBlock_Offset = (Integer)maxBlockIdAndOffset.getValue();
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        catch (Throwable e) {
            fid = e;
            throw e;
        }
        finally {
            if (h != null) {
                if (fid != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)fid).addSuppressed(e);
                    }
                } else {
                    h.close();
                }
            }
        }
        LinkedList<Object[]> infoParams = new LinkedList<Object[]>();
        LinkedList<Object[]> valuesParams = new LinkedList<Object[]>();
        LinkedHashMap<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>> blockIndexParamMap = new LinkedHashMap<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>>();
        for (Map map : linkedList) {
            if (maxBlock_Offset < 4095) {
                maxBlock_Offset = maxBlock_Offset + 1;
            } else {
                maxBlock_Offset = 0;
                maxBlockId = maxBlockId + 1;
            }
            Object[] infoParam = new Object[]{map.get("fid"), maxBlockId, maxBlock_Offset, map.get("fGrpValHash"), map.get("hashfix")};
            infoParams.add(infoParam);
            LinkedList<Object> valuesParam = new LinkedList<Object>();
            valuesParam.add(map.get("fid"));
            valuesParam.add(map.get("fDimGrpTypeId"));
            valuesParam.add(maxBlockId);
            valuesParam.add(map.get("fDimCnt"));
            valuesParam.add(map.get("fStatus"));
            List values = (List)map.get("values");
            for (Object value : values) {
                valuesParam.add(value);
            }
            valuesParams.add(valuesParam.toArray());
            blockIndexParamMap.computeIfAbsent(maxBlockId, k -> new LinkedHashMap()).computeIfAbsent((Long)map.get("fDimGrpTypeId"), k -> new LinkedList()).add(new PairTuple((Object)((Long)map.get("fid")), (Object)values));
        }
        if (!infoParams.isEmpty()) {
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)insert_info_sql, infoParams);
        }
        if (!valuesParams.isEmpty()) {
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)insert_values_sql, valuesParams);
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateLineGrpIdSql, updateParams);
        }
        this.buildDimGrpIndex(blockIndexParamMap);
        SqlBuilder delete_sql = new SqlBuilder();
        delete_sql.append("delete from t_fah_dimgrp_values_tmp where fTrans_Id = ? ", new Object[]{trans_id});
        delete_sql.appendIn("and fTrans_Batch_Id", successBatchIds);
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)delete_sql);
    }

    private PairTuple<Integer, Integer> getMaxBlockIdAndOffset(Long trans_id, Integer dataSize) {
        Integer maxBlockId = 1;
        Integer maxBlock_Offset = -1;
        Integer casVersion = 0;
        String indexSql = "select fMaxDataBlock, fMaxDataBlockOffset, fcasversion from t_fah_dim_index_info where fid = 1";
        try (DataSet maxIndex = DB.queryDataSet((String)"queryMaxIndexSql", (DBRoute)FAHCommonConstant.AI, (String)indexSql);){
            if (maxIndex.isEmpty()) {
                String insertSql = "INSERT INTO t_fah_dim_index_info (fid,fMaxDataBlock,fMaxDataBlockOffset,fcasversion) VALUES(1,1,-1,0)";
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)insertSql);
            } else {
                Row row = maxIndex.next();
                maxBlockId = row.getInteger("fMaxDataBlock");
                maxBlock_Offset = row.getInteger("fMaxDataBlockOffset");
                casVersion = row.getInteger("fcasversion");
            }
        }
        log.info("#########trans_id:[" + trans_id + "],and maxBlockId:" + maxBlockId + ",maxBlock_Offset:" + maxBlock_Offset);
        Integer acutalIndex = (maxBlockId - 1) * 4096 + maxBlock_Offset;
        acutalIndex = acutalIndex + dataSize;
        int newBlockId = acutalIndex / 4096 + 1;
        int newBlockOffset = acutalIndex % 4096;
        log.info("#########trans_id:[" + trans_id + "],and newBlockId:" + newBlockId + ",newBlockOffset:" + newBlockOffset + ",insertParamSize:" + dataSize + ",acutalIndex:" + acutalIndex);
        Object[] infoParam = new Object[]{newBlockId, newBlockOffset, casVersion + 1, casVersion};
        String updateSql = "UPDATE t_fah_dim_index_info SET fMaxDataBlock = ?, fMaxDataBlockOffset = ?, fcasversion = ? WHERE fid= 1 and fcasversion = ?";
        int affectRows = DB.update((DBRoute)FAHCommonConstant.AI, (String)updateSql, (Object[])infoParam);
        if (affectRows == 0) {
            return this.getMaxBlockIdAndOffset(trans_id, dataSize);
        }
        return new PairTuple((Object)maxBlockId, (Object)maxBlock_Offset);
    }

    private void buildDimGrpIndex(Map<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>> blockIndexParamMap) {
        String testMode;
        switch (testMode = SysParamConfig.get((String)"fah.evt.biz.data.test", (String)"3")) {
            case "1": {
                this.buildDimGrpIndex1(blockIndexParamMap);
                break;
            }
            case "2": {
                this.buildDimGrpIndex2(blockIndexParamMap);
                break;
            }
        }
    }

    private void buildDimGrpIndex1(Map<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>> blockIndexParamMap) {
        for (Map.Entry<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>> entry : blockIndexParamMap.entrySet()) {
            DimBlockIndexCreateTask task = new DimBlockIndexCreateTask(entry.getKey(), entry.getValue());
            try {
                task.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void buildDimGrpIndex2(Map<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>> blockIndexParamMap) {
        LinkedList<Future> list = new LinkedList<Future>();
        for (Map.Entry<Integer, Map<Long, List<PairTuple<Long, List<Object>>>>> entry : blockIndexParamMap.entrySet()) {
            DimBlockIndexCreateTask task = new DimBlockIndexCreateTask(entry.getKey(), entry.getValue());
            Future submit = ThreadService.submit((Callable)task, (TaskType)TaskType.FEA_EXPORT_TASK_DETAIL);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<Long, Long> selfDupCheck(Map<Long, List<PairTuple<Long, List<Long>>>> map) {
        ArrayList<Set<Long>> result = new ArrayList<Set<Long>>(16);
        for (List<PairTuple<Long, List<Long>>> list : map.values()) {
            for (int i = 0; i < list.size() - 1; ++i) {
                for (int j = i + 1; j < list.size(); ++j) {
                    if (!ICommonDataValueUtil.deepEquals((Object)list.get(i).getValue(), (Object)list.get(j).getValue())) continue;
                    this.addToResult(result, (Long)list.get(i).getKey(), (Long)list.get(j).getKey());
                }
            }
        }
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        for (Set set : result) {
            Long baseId = (Long)set.iterator().next();
            for (Long id : set) {
                if (id.longValue() == baseId.longValue()) continue;
                resultMap.put(id, baseId);
            }
        }
        return resultMap;
    }

    private void addToResult(List<Set<Long>> result, Long key1, Long key2) {
        boolean alreadyAdded = false;
        for (Set<Long> longs : result) {
            if (!longs.contains(key1) && !longs.contains(key2)) continue;
            longs.add(key1);
            longs.add(key2);
            alreadyAdded = true;
        }
        if (!alreadyAdded) {
            HashSet<Long> longs = new HashSet<Long>(2);
            longs.add(key1);
            longs.add(key2);
            result.add(longs);
        }
    }

    public void deactivateDimValTmpData(Long trans_id, List<Object> failBatchIds) {
        if (CollectionUtils.isEmpty(failBatchIds)) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fEvtLineId,fStatus from t_fah_dimgrp_values_tmp", new Object[0]);
        sqlBuilder.append("where fTrans_Id = ? ", new Object[]{trans_id});
        sqlBuilder.appendIn("and fTrans_Batch_Id ", failBatchIds);
        String updateLineGrpIdSql = "update t_fah_event_line set fDimGrpValId = ?, fBizLineStatus = ? where fEntryId = ?";
        LinkedList<Object[]> updateParams = new LinkedList<Object[]>();
        try (DataSet dataSet = DB.queryDataSet((String)"activateDimValTmpData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Object[] param = new Object[]{row.getLong("fid"), row.getString("fStatus"), row.getLong("fEvtLineId")};
                updateParams.add(param);
            }
        }
        if (!updateParams.isEmpty()) {
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateLineGrpIdSql, updateParams);
        }
    }

    public void updateBizDataStatus(List<Object> noNeedEvtIds, List<Object> successEvtIds, List<Object> failedEvtIds) {
        Date modifyTime = new Date();
        long modifier = RequestContext.get().getCurrUserId();
        if (CollectionUtils.isNotEmpty(noNeedEvtIds)) {
            SqlBuilder noNeedSqlBuilder = new SqlBuilder();
            noNeedSqlBuilder.append("update t_fah_event_header set ", new Object[0]);
            noNeedSqlBuilder.append("fbizdatastatus = ?", new Object[]{BizDataStatusEnum.NO_NEED.getCode()});
            noNeedSqlBuilder.append(",fmodifierid = ?", new Object[]{modifier});
            noNeedSqlBuilder.append(",fmodifytime = ?", new Object[]{modifyTime});
            noNeedSqlBuilder.appendIn("where fid", noNeedEvtIds);
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)noNeedSqlBuilder);
        }
        if (CollectionUtils.isNotEmpty(successEvtIds)) {
            SqlBuilder successSqlBuilder = new SqlBuilder();
            successSqlBuilder.append("update t_fah_event_header set ", new Object[0]);
            successSqlBuilder.append("fbizdatastatus = ?", new Object[]{BizDataStatusEnum.SUCCESS.getCode()});
            successSqlBuilder.append(",fmodifierid = ?", new Object[]{modifier});
            successSqlBuilder.append(",fmodifytime = ?", new Object[]{modifyTime});
            successSqlBuilder.appendIn("where fid", successEvtIds);
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)successSqlBuilder);
        }
        if (CollectionUtils.isNotEmpty(failedEvtIds)) {
            SqlBuilder failedSqlBuilder = new SqlBuilder();
            failedSqlBuilder.append("update t_fah_event_header set ", new Object[0]);
            failedSqlBuilder.append("fbizdatastatus = ?", new Object[]{BizDataStatusEnum.FAIL.getCode()});
            failedSqlBuilder.append(",fmodifierid = ?", new Object[]{modifier});
            failedSqlBuilder.append(",fmodifytime = ?", new Object[]{modifyTime});
            failedSqlBuilder.appendIn("where fid", failedEvtIds);
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)failedSqlBuilder);
        }
    }

    private static class DupCheckInfo {
        Long fid;
        Long hashCode;
        Integer hashFix;
        List<Long> values;

        public DupCheckInfo(Long fid, Long hashCode, Integer hashFix, List<Long> values) {
            this.fid = fid;
            this.hashCode = hashCode;
            this.hashFix = hashFix;
            this.values = values;
        }

        public Long getFid() {
            return this.fid;
        }

        public void setFid(Long fid) {
            this.fid = fid;
        }

        public Long getHashCode() {
            return this.hashCode;
        }

        public void setHashCode(Long hashCode) {
            this.hashCode = hashCode;
        }

        public Integer getHashFix() {
            return this.hashFix;
        }

        public void setHashFix(Integer hashFix) {
            this.hashFix = hashFix;
        }

        public List<Long> getValues() {
            return this.values;
        }

        public void setValues(List<Long> values) {
            this.values = values;
        }
    }
}

