/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dto.upstream.service;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import kd.bos.db.ResultSetHandler;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.dto.upstream.service.QueryUpStreamXlaInfo;
import kd.fi.v2.fah.dto.upstream.xla.QueryUpSteamXlaFieldEnum;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;

public class QueryUpStreamXlaResult
implements Serializable,
ResultSetHandler<QueryUpStreamXlaResult> {
    protected QueryUpStreamXlaInfo<?> queryCommonInfo;
    SimpleTableColStorage matchedResult;
    protected Collection<Long> unmatchedResultIds;
    protected Collection<PairTuple<Long, Long>> foundMultiResultIds;
    protected QueryUpSteamXlaFieldEnum[] queryFields;

    public QueryUpStreamXlaResult() {
        this.queryFields = QueryUpSteamXlaFieldEnum.values();
    }

    public QueryUpStreamXlaResult(QueryUpSteamXlaFieldEnum[] queryFields) {
        this.queryFields = queryFields;
    }

    public String toString() {
        return "QueryUpStreamXlaResult{matchedResult.RowCnt=" + this.matchedResult.getRowCnt() + ", unmatchedResultIds=" + this.unmatchedResultIds + ", foundMultiResultIds=" + this.foundMultiResultIds + '}';
    }

    public QueryUpStreamXlaResult handle(ResultSet resultSet) throws Exception {
        int fieldCnt = this.queryFields.length;
        this.matchedResult = new SimpleTableColStorage(fieldCnt);
        while (resultSet.next()) {
            Object[] rowBuf = new Object[fieldCnt];
            this.matchedResult.add((Object)rowBuf);
            for (int i = 0; i < fieldCnt; ++i) {
                if (this.queryFields[i] == null) continue;
                rowBuf[i] = this.queryFields[i].getDataType().getResultSetValue(resultSet, i);
            }
        }
        return this;
    }

    public int getMatchResultCnt() {
        return this.matchedResult != null ? this.matchedResult.getRowCnt() : 0;
    }

    public Collection<Long> getUnmatchedResultIds() {
        return this.unmatchedResultIds;
    }

    public void setUnmatchedResultIds(Collection<Long> unmatchedResultIds) {
        this.unmatchedResultIds = unmatchedResultIds;
    }

    public Collection<PairTuple<Long, Long>> getFoundMultiResultIds() {
        return this.foundMultiResultIds;
    }

    public void setFoundMultiResultIds(Collection<PairTuple<Long, Long>> foundMultiResultIds) {
        this.foundMultiResultIds = foundMultiResultIds;
    }

    public QueryUpSteamXlaFieldEnum[] getQueryFields() {
        return this.queryFields;
    }

    public void setQueryFields(QueryUpSteamXlaFieldEnum[] queryFields) {
        this.queryFields = queryFields;
    }

    public QueryUpStreamXlaInfo<?> getQueryCommonInfo() {
        return this.queryCommonInfo;
    }

    public void setQueryCommonInfo(QueryUpStreamXlaInfo<?> queryCommonInfo) {
        this.queryCommonInfo = queryCommonInfo;
    }

    public SimpleTableColStorage getMatchedResult() {
        return this.matchedResult;
    }
}

