/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.engine.processor.impl;

import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.fi.v2.fah.engine.config.impl.MappingConvertUnitCfgModel;
import kd.fi.v2.fah.engine.config.impl.MappingGrpCfgModel;
import kd.fi.v2.fah.engine.enums.DataProcessorClassTypeEnum;
import kd.fi.v2.fah.engine.processor.common.AbstractMemTableProcessorUnit;
import kd.fi.v2.fah.models.mapping.MappingSearchParam;
import kd.fi.v2.fah.models.mapping.impl.SearchParamValueSetCollection;
import kd.fi.v2.fah.models.table.meta.impl.SimpleTableFieldMeta;
import kd.fi.v2.fah.services.SingleValueDataMappingServiceImpl;
import kd.fi.v2.fah.storage.tables.IDataTableStorage;
import kd.fi.v2.fah.task.context.IBackgroundTaskContext;

public class BizMappingGrpConvertProcessorUnit
extends AbstractMemTableProcessorUnit<MappingGrpCfgModel> {
    public DataProcessorClassTypeEnum getProcessorClassType() {
        return DataProcessorClassTypeEnum.Mapping_Convert;
    }

    protected IDataTableStorage doProcess(IDataTableStorage input, IBackgroundTaskContext taskContext, Object param) {
        Map<MappingConvertUnitCfgModel, Map<Long, BitSet>> mapTableGrps = this.parseMapTableGrps(input);
        SimpleTableFieldMeta outputField = ((MappingGrpCfgModel)this.cfg).getOutputField();
        for (Map.Entry<MappingConvertUnitCfgModel, Map<Long, BitSet>> en : mapTableGrps.entrySet()) {
            this.doSingleMapTableQuery(input, en.getKey(), en.getValue(), outputField, taskContext);
        }
        return input;
    }

    protected Map<MappingConvertUnitCfgModel, Map<Long, BitSet>> parseMapTableGrps(IDataTableStorage input) {
        HashMap<MappingConvertUnitCfgModel, Map<Long, BitSet>> result = new HashMap<MappingConvertUnitCfgModel, Map<Long, BitSet>>(((MappingGrpCfgModel)this.cfg).getOrgCnt());
        Iterator rowIterator = input.getSelectColumnValues(new int[]{((MappingGrpCfgModel)this.cfg).getInputField().getReadPos()}, false);
        int i = 0;
        while (rowIterator.hasNext()) {
            Object[] rowBuf = (Object[])rowIterator.next();
            Long orgId = (Long)rowBuf[0];
            MappingConvertUnitCfgModel mapTableCfg = ((MappingGrpCfgModel)this.cfg).getMappingTable(orgId);
            if (mapTableCfg != null) {
                result.computeIfAbsent(mapTableCfg, v -> new HashMap(2)).computeIfAbsent(orgId, v -> new BitSet()).set(i);
            }
            ++i;
        }
        return result;
    }

    protected SearchParamValueSetCollection buildMappingSearchParam(IDataTableStorage input, MappingConvertUnitCfgModel cfgModel, Map<Long, BitSet> orgRowIdxs) {
        SearchParamValueSetCollection searchParam = new SearchParamValueSetCollection();
        int[] inputParamPos = cfgModel.getInputParamPos();
        int rowIdx = 0;
        Date bizDate = new Date();
        for (Map.Entry<Long, BitSet> en : orgRowIdxs.entrySet()) {
            Long orgId = en.getKey();
            BitSet bitSet = en.getValue();
            while ((rowIdx = bitSet.nextSetBit(rowIdx)) >= 0) {
                Object[] rowBuf = input.getSelectColumnValues(rowIdx, inputParamPos);
                MappingSearchParam paramValBuf = new MappingSearchParam(orgId, bizDate, rowBuf, rowIdx);
                searchParam.add((Object)paramValBuf);
            }
        }
        return searchParam;
    }

    protected void doSingleMapTableQuery(IDataTableStorage input, MappingConvertUnitCfgModel cfgModel, Map<Long, BitSet> orgRowIdxs, SimpleTableFieldMeta outputField, IBackgroundTaskContext taskContext) {
        SearchParamValueSetCollection searchParams = this.buildMappingSearchParam(input, cfgModel, orgRowIdxs);
        int outputFieldIdx = outputField.getWritePos();
        int mapReadIdx = Math.max(0, outputField.getReadPos());
        SingleValueDataMappingServiceImpl.getInstance().batchSearchMapping(cfgModel.getMappingRuleId(), searchParams, (inParam, result) -> input.setCellValue(inParam.getRefRowId(), outputFieldIdx, result.get(mapReadIdx)));
    }
}

