/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.getvaluehandle.IAccountBookGetValueService;
import kd.fi.v2.fah.models.xla.XLAAccountBook;

public class AccountSystemGetValueServiceImpl
implements IAccountBookGetValueService {
    @Override
    public Collection<XLAAccountBook> getValue(Long orgId, Long accountPurposeId) {
        ArrayList<XLAAccountBook> result = new ArrayList<XLAAccountBook>();
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashMap<Long, Set> sysAndOrgCache = new HashMap<Long, Set>(8);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.getvaluehandle.AccountSystemGetValueServiceImpl", (String)"bd_accountingsys", (String)"id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg", (QFilter[])new QFilter("bizorgentry.bizorg", "=", (Object)orgId).toArray(), null);){
            for (Row row : queryDataSet) {
                Long bizAcctOrg = row.getLong("bizacctorg");
                orgIds.add(bizAcctOrg);
                sysAndOrgCache.computeIfAbsent(row.getLong("id"), v -> new HashSet()).add(bizAcctOrg);
            }
        }
        HashSet<Long> accountBookIds = new HashSet<Long>(8);
        String sql = "select faccountbookid from t_fah_evt_accountbookcfg where fid = " + accountPurposeId;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.getvaluehandle.AccountSystemGetValueServiceImpl", (DBRoute)FAHCommonConstant.FI, (String)sql);){
            for (Row row : queryDataSet) {
                accountBookIds.add(row.getLong("faccountbookid"));
            }
        }
        queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.getvaluehandle.AccountSystemGetValueServiceImpl", (String)"gl_accountbook", (String)"org.id,id,bookstype.id,accountingsys.id,basecurrency.id,accounttable.id,periodtype.id,exratetable.id,curperiod.id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("id", "in", accountBookIds), new QFilter("isbizunit", "=", (Object)Boolean.TRUE), new QFilter("accountingsys", "in", sysAndOrgCache.keySet()), new QFilter("enable", "=", (Object)Boolean.TRUE)}, null);
        var9_11 = null;
        try {
            for (Row row : queryDataSet) {
                Long actOrgId = row.getLong("org.id");
                Set currSysOrgIds = (Set)sysAndOrgCache.get(row.getLong("accountingsys.id"));
                if (currSysOrgIds == null || !currSysOrgIds.contains(actOrgId)) continue;
                XLAAccountBook xlaBook = new XLAAccountBook(row.getLong("id"), actOrgId, row.getLong("basecurrency.id"), row.getLong("bookstype.id"), row.getLong("accounttable.id"), row.getLong("periodtype.id"), row.getLong("exratetable.id"), row.getLong("curperiod.id"));
                result.add(xlaBook);
            }
        }
        catch (Throwable throwable) {
            var9_11 = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (var9_11 != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        var9_11.addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        return result;
    }
}

