/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.fi.v2.fah.cache.meta.BosMetaThreadLocalCacheService;
import kd.fi.v2.fah.dao.FahBosMetaEntityDao;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.dao.FahXLADaoImpl;
import kd.fi.v2.fah.dao.engine.common.FahQueryUpStreamRecordDaoImpl;
import kd.fi.v2.fah.getvaluehandle.ITrackerGetBillEntityService;
import kd.fi.v2.fah.models.event.eventrule.FahEventTrackerConfig;

public class BOTPTrackerGetBillEntityService
implements ITrackerGetBillEntityService {
    private static final BosMetaThreadLocalCacheService metaCacheService = BosMetaThreadLocalCacheService.getInstance();
    private static final FahQueryUpStreamRecordDaoImpl upstreamDao = FahQueryUpStreamRecordDaoImpl.getInstance();
    private static final FahXLADaoImpl xlaDao = FahXLADaoImpl.getInstance();
    private static final BOTPTrackerGetBillEntityService instance = new BOTPTrackerGetBillEntityService();

    public static BOTPTrackerGetBillEntityService getInstance() {
        return instance;
    }

    @Override
    public Object getTrackerEntityData(FahEventTrackerConfig config, String src_billEntity, String sourceEntry, Long src_billEntityId) {
        String tableName;
        if (config == null) {
            return null;
        }
        Map<String, Long> tarEntity_allTableId = FahBosMetaEntityDao.getAllTableIdFromEntity(config.getTarBillType());
        Long srcEntityTableId = FahBosMetaEntityDao.getTableIdFromEntity(sourceEntry);
        Object data = this.getTrackerSourceEntityData(srcEntityTableId, tarEntity_allTableId, src_billEntityId, tableName = EntityMetadataCache.getLinkSet((String)src_billEntity).getTrackerTable());
        if (data != null || src_billEntity.equals(sourceEntry)) {
            // empty if block
        }
        return data;
    }

    private Object getTrackerSourceEntityData(Long srcEntityTableId, Map<String, Long> tarEntity_allTableId, Long currEntryId, String tableName) {
        Long result = null;
        Long next_srcEntityTableId = 0L;
        Long next_currEntityId = 0L;
        try (DataSet queryDataSet = FahGenerateXLADataDao.queryBillSourceData(tableName, srcEntityTableId, currEntryId);){
            HashSet<Long> tableIds = new HashSet<Long>(tarEntity_allTableId.values());
            for (Row row : queryDataSet) {
                Long fstableid = row.getLong("fstableid");
                Long fsid = row.getLong("fsid");
                if (tableIds.contains(fstableid)) {
                    result = fsid;
                    break;
                }
                next_srcEntityTableId = fstableid;
                next_currEntityId = fsid;
            }
        }
        if (result == null && next_srcEntityTableId != 0L && next_currEntityId != 0L) {
            String billTypeFromTableId = FahBosMetaEntityDao.getBillTypeFromTableId(next_srcEntityTableId);
            String next_tableName = EntityMetadataCache.getLinkSet((String)billTypeFromTableId).getTrackerTable();
            return this.getTrackerSourceEntityData(next_srcEntityTableId, tarEntity_allTableId, next_currEntityId, next_tableName);
        }
        return result;
    }
}

