/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchTplExpression;
import kd.fi.v2.fah.getvaluehandle.FormulaGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class DynamicTextGetValueHandle
implements IGetValueHandle {
    protected String expressionValue;
    private Map<String, FormulaGetValueHandle> vars = new HashMap<String, FormulaGetValueHandle>();

    public DynamicTextGetValueHandle(String expressionValue) {
        this.expressionValue = expressionValue;
        this.compilerFormula();
    }

    @Override
    public Object getValue(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)this.expressionValue)) {
            return "";
        }
        VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)this.expressionValue, VchTplExpression.class);
        if (expression == null) {
            return "";
        }
        String formula = expression.getExpression();
        if (formula.contains("{")) {
            String[] split;
            for (String newStr : split = formula.split("\\{")) {
                if (newStr.contains("}")) {
                    FormulaGetValueHandle formulaGetValueHandle;
                    String[] secondStr = newStr.split("\\}");
                    String var = secondStr[0];
                    if (StringUtils.isNotBlank((CharSequence)var) && (formulaGetValueHandle = this.vars.get(var)) != null) {
                        result.append(formulaGetValueHandle.getValue(value, fieldAliasInfos));
                    }
                    if (secondStr.length <= 1) continue;
                    result.append(secondStr[1]);
                    continue;
                }
                result.append(newStr);
            }
        } else {
            result.append(formula);
        }
        return result.toString();
    }

    @Override
    public Map<String, Object> batchGetValue(Collection<Object[]> values, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        return null;
    }

    @Override
    public boolean isBatchGetValue() {
        return true;
    }

    @Override
    public void preSupData(SupplementaryField sf) {
    }

    @Override
    public Set<String> compileFieldInfo() {
        HashSet<String> result = new HashSet<String>(8);
        if (!this.vars.isEmpty()) {
            this.vars.values().forEach(f -> result.addAll(f.compileFieldInfo()));
        }
        return result;
    }

    private void compilerFormula() {
        if (StringUtils.isBlank((CharSequence)this.expressionValue)) {
            return;
        }
        VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)this.expressionValue, VchTplExpression.class);
        if (expression == null) {
            return;
        }
        String formula = expression.getExpression();
        if (formula.contains("{")) {
            String[] split;
            for (String newStr : split = formula.split("\\{")) {
                String var;
                if (!newStr.contains("}") || !StringUtils.isNotBlank((CharSequence)(var = newStr.split("\\}")[0]))) continue;
                this.vars.put(var, new FormulaGetValueHandle(var, false));
            }
        }
    }
}

