/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class FieldGetValueHandle
implements IGetValueHandle {
    protected String textValue;
    protected ExtractTypeEnum getValueType;
    protected Object defaultValue = null;

    public FieldGetValueHandle(DynamicExtractFieldValueSetData config) {
        DynamicExtractFieldValueSet fieldConfig = (DynamicExtractFieldValueSet)config.getFieldValueSetList().get(0);
        this.textValue = fieldConfig.getTextValue();
        this.getValueType = fieldConfig.getGetValueType();
        this.defaultValue = fieldConfig.getActualConstantValue();
    }

    public FieldGetValueHandle(String textValue, ExtractTypeEnum getValueType, Object defaultValue) {
        this.textValue = textValue;
        this.getValueType = getValueType;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getValue(Row row, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        Object result = null;
        if (ExtractTypeEnum.SOURCE_FIELD == this.getValueType) {
            result = row.get(((FieldAliasInfo)fieldAliasInfos.get((Object)this.textValue)).getAlias());
        } else if (ExtractTypeEnum.CONSTANT_VALUE == this.getValueType) {
            result = this.defaultValue;
        }
        return result;
    }

    @Override
    public Object getValue(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        Object result = null;
        if (ExtractTypeEnum.SOURCE_FIELD == this.getValueType) {
            int index = ((FieldAliasInfo)fieldAliasInfos.get((Object)this.textValue)).getReadPos();
            result = value[index];
        } else if (ExtractTypeEnum.CONSTANT_VALUE == this.getValueType) {
            result = this.defaultValue;
        }
        return result;
    }

    @Override
    public Map<String, Object> batchGetValue(Collection<Object[]> values, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        return null;
    }

    @Override
    public boolean isBatchGetValue() {
        return false;
    }

    @Override
    public void preSupData(SupplementaryField sf) {
    }

    @Override
    public Set<String> compileFieldInfo() {
        HashSet<String> result = new HashSet<String>();
        if (ExtractTypeEnum.SOURCE_FIELD == this.getValueType) {
            result.add(this.textValue);
        }
        return result;
    }
}

