/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.Visitor;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class FormulaGetValueHandle
implements IGetValueHandle {
    protected String expressionValue;
    private String formula;
    protected Map<String, Object> cacheMap = new HashMap<String, Object>(1000);

    public FormulaGetValueHandle(DynamicExtractFieldValueSetData config) {
        this(((DynamicExtractFieldValueSet)config.getFieldValueSetList().get(0)).getExpressionValue(), true);
    }

    public FormulaGetValueHandle(String expressionValue, Boolean isPrimaryExpress) {
        if (isPrimaryExpress.booleanValue()) {
            this.expressionValue = expressionValue;
            this.compilePrimaryExpress();
        } else {
            this.formula = expressionValue;
        }
    }

    private void compilePrimaryExpress() {
        if (StringUtils.isBlank((CharSequence)this.expressionValue)) {
            return;
        }
        VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)this.expressionValue, VchTplExpression.class);
        if (expression == null) {
            return;
        }
        this.formula = expression.getExpression();
    }

    @Override
    public Object getValue(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        Expr parseFormula;
        Object result = null;
        if (StringUtils.isBlank((CharSequence)this.formula)) {
            return null;
        }
        String[] varStrings = new String[]{};
        HashSet funcNames = new HashSet();
        try {
            varStrings = FormulaEngine.extractVariables((String)this.formula);
            parseFormula = FormulaEngine.parseFormula((String)this.formula);
            UDFunctionVisitor mainEntityType = new UDFunctionVisitor();
            parseFormula.accept((Visitor)mainEntityType);
            funcNames = mainEntityType.getFuncNames();
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            sb.append(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a\u201c%s\u201d\u3002", (String)"FormulaGetValueHandle_0", (String)"fi-ai-business", (Object[])new Object[0]), exp.getMessage()));
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>(varStrings.length);
        for (String var : varStrings) {
            Object valueData = value[((FieldAliasInfo)fieldAliasInfos.get((Object)var)).getReadPos()];
            ctx.put(var, valueData);
        }
        try {
            BOSUDFunction[] funcInstances = null;
            FunctionManage funcLib = FunctionManage.get((FunctionTypes)DapFunctionTypes.get());
            CRExpressionContext expContext = new CRExpressionContext(null, null, null);
            if (!funcNames.isEmpty()) {
                ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
                for (String funcName : funcNames) {
                    if (!funcLib.getFuncMap().containsKey(funcName)) continue;
                    BOSUDFunction instance = ((BOSUDFunction)funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
                    instances.add(instance);
                }
                funcInstances = instances.toArray(new BOSUDFunction[instances.size()]);
            }
            result = FormulaEngine.execExcelFormula((Expr)parseFormula, ctx, funcInstances);
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.formula);
            sb.append("  \r\n");
            sb.append(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u53d6\u503c\u51fa\u9519\uff1a\u201c%s\u201d\u3002", (String)"FormulaGetValueHandle_1", (String)"fi-ai-business", (Object[])new Object[0]), exp.getMessage()));
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        return result;
    }

    @Override
    public Map<String, Object> batchGetValue(Collection<Object[]> values, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        return null;
    }

    @Override
    public boolean isBatchGetValue() {
        return true;
    }

    @Override
    public void preSupData(SupplementaryField sf) {
    }

    @Override
    public Set<String> compileFieldInfo() {
        String[] varStrings;
        if (StringUtils.isBlank((CharSequence)this.formula)) {
            return new HashSet<String>();
        }
        HashSet<String> result = new HashSet<String>(8);
        for (String var : varStrings = FormulaEngine.extractVariables((String)this.formula)) {
            result.add(var);
        }
        return result;
    }
}

