/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.v2.fah.constant.enums.MappingTypeEnum;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.getvaluehandle.GetValueHandleFactory;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetEntry;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.ISearchParamValueSet;
import kd.fi.v2.fah.models.mapping.MappingMetaCache;
import kd.fi.v2.fah.models.mapping.MappingSearchParam;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.SingleValueDataMappingServiceImpl;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class MappingGetValueHandle
implements IGetValueHandle {
    protected Long orgId;
    protected Date bookDate;
    protected Long accountTableId;
    protected Long asstActId;
    protected MappingTypeEnum mappingType;
    protected Long mappingRuleGroupId;
    protected List<DynamicExtractFieldValueSetEntry> fieldValueSetEntry;
    protected Map<String, Object> cacheMap = new HashMap<String, Object>(1000);
    protected String sourceField;
    private Map<Long, Long> mappingRuleIdCacheMap = new HashMap<Long, Long>(16);

    public MappingGetValueHandle(DynamicExtractFieldValueSetData config, SupplementaryField sf) {
        DynamicExtractFieldValueSet fieldConfig = (DynamicExtractFieldValueSet)config.getFieldValueSetList().get(0);
        this.mappingType = fieldConfig.getMappingType();
        this.fieldValueSetEntry = fieldConfig.getFieldValueSetEntry();
        this.mappingRuleGroupId = fieldConfig.getMappingGroupId();
        this.sourceField = fieldConfig.getDynExtFieldCfg().getSourceField();
        if (sf != null) {
            this.orgId = sf.getOrgId();
            this.bookDate = sf.getBookDate();
            this.accountTableId = sf.getAccountTableId();
        }
    }

    public MappingGetValueHandle(MappingTypeEnum mappingType, Long mappingRuleGroupId, String sourceField, List<DynamicExtractFieldValueSetEntry> fieldValueSetEntry) {
        this.mappingRuleGroupId = mappingRuleGroupId;
        this.mappingType = mappingType;
        this.fieldValueSetEntry = fieldValueSetEntry;
        this.sourceField = sourceField;
    }

    public MappingGetValueHandle(MappingTypeEnum mappingType, Long mappingRuleGroupId, String sourceField, List<DynamicExtractFieldValueSetEntry> fieldValueSetEntry, Long asstActId) {
        this(mappingType, mappingRuleGroupId, sourceField, fieldValueSetEntry);
        this.asstActId = asstActId;
    }

    private Object getValueFromValueSetMapping(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos, Long mappingRuleGroupId, List<DynamicExtractFieldValueSetEntry> fieldValueSetEntry) {
        Long mappingRuleId;
        if (this.mappingRuleIdCacheMap.containsKey(mappingRuleGroupId)) {
            mappingRuleId = this.mappingRuleIdCacheMap.get(mappingRuleGroupId);
        } else {
            mappingRuleId = FahGenerateXLADataDao.getMappingRuleByOrg(mappingRuleGroupId, this.orgId);
            this.mappingRuleIdCacheMap.put(mappingRuleGroupId, mappingRuleId);
        }
        if (mappingRuleId == 0L) {
            return null;
        }
        List fieldValue = fieldValueSetEntry.stream().filter(f -> f.getMappingId().equals(mappingRuleId)).collect(Collectors.toList());
        MappingStructureMeta mappingMetaCached = MappingMetaCache.getMappingMetaCached((Long)mappingRuleId, (Object[])new Object[0]);
        FlexFieldGrpCfg inputParamMeta = mappingMetaCached.getInputParamMeta();
        Object[] params = new Object[fieldValue.size()];
        for (DynamicExtractFieldValueSetEntry def : fieldValue) {
            Object valueData = GetValueHandleFactory.getEntryGetValueHandle(def).getValue(value, fieldAliasInfos);
            int index = ((FlexFieldCfg)inputParamMeta.get((Object)def.getParam())).getSeq();
            params[index] = valueData;
        }
        MappingSearchParam msp = new MappingSearchParam((IValueSetMeta)mappingMetaCached);
        msp.setOrgId(this.orgId);
        msp.setValues(params);
        msp.setQueryDate(this.bookDate);
        SingleValueDataMappingServiceImpl service = new SingleValueDataMappingServiceImpl();
        Object result = null;
        switch (this.sourceField) {
            case "account": {
                result = service.searchAcctMapping(this.bookDate, mappingRuleId, this.accountTableId, (ISearchParamValueSet)msp);
                break;
            }
            case "assgrp": {
                result = service.searchAsstDimMapping(this.bookDate, mappingRuleId, this.asstActId, (ISearchParamValueSet)msp);
                break;
            }
            case "cashflowitem": 
            case "cashflowsupitem": {
                result = service.searchCashFlowItemMapping(this.bookDate, mappingRuleId, (ISearchParamValueSet)msp);
                break;
            }
        }
        return result;
    }

    @Override
    public Object getValue(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        Object result = null;
        switch (this.mappingType) {
            case VAL_MAP: {
                result = this.getValueFromValueSetMapping(value, fieldAliasInfos, this.mappingRuleGroupId, this.fieldValueSetEntry);
                break;
            }
            case ACCOUNT_MAP: {
                break;
            }
            case BASE_DATA_MAP: {
                break;
            }
            case ASST_MAP: {
                break;
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> batchGetValue(Collection<Object[]> values, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        return null;
    }

    @Override
    public boolean isBatchGetValue() {
        return true;
    }

    @Override
    public void preSupData(SupplementaryField sf) {
        if (sf != null) {
            this.orgId = sf.getOrgId();
            this.bookDate = sf.getBookDate();
            this.accountTableId = sf.getAccountTableId();
        }
    }

    @Override
    public Set<String> compileFieldInfo() {
        HashSet<String> result = new HashSet<String>();
        for (DynamicExtractFieldValueSetEntry def : this.fieldValueSetEntry) {
            Set<String> compileFieldInfo = GetValueHandleFactory.getEntryGetValueHandle(def).compileFieldInfo();
            result.addAll(compileFieldInfo);
        }
        return result;
    }
}

