/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.getvaluehandle;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchTplExpression;
import kd.fi.v2.fah.getvaluehandle.FormulaGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.ReferenceFieldConfig;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;

public class ReferenceGetValueHandle
implements IGetValueHandle {
    private ReferenceFieldConfig config;
    private FormulaGetValueHandle handle;
    protected Map<String, Object> cacheMap = new HashMap<String, Object>(1000);

    public ReferenceGetValueHandle(ReferenceFieldConfig config) {
        this.config = config;
        String src_expression = this.compilePrimaryExpress();
        if (src_expression != null) {
            this.handle = new FormulaGetValueHandle(src_expression, false);
        }
    }

    private String compilePrimaryExpress() {
        if (this.config == null || StringUtils.isBlank((CharSequence)this.config.getExpress())) {
            return null;
        }
        VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)this.config.getExpress(), VchTplExpression.class);
        if (expression == null) {
            return null;
        }
        return expression.getExpression();
    }

    @Override
    public Object getValue(Object[] value, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        if (this.handle != null) {
            Object result = this.handle.getValue(value, fieldAliasInfos);
            return result;
        }
        return null;
    }

    @Override
    public Map<String, Object> batchGetValue(Collection<Object[]> values, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        return null;
    }

    @Override
    public boolean isBatchGetValue() {
        return false;
    }

    @Override
    public void preSupData(SupplementaryField sf) {
    }

    @Override
    public Set<String> compileFieldInfo() {
        if (this.handle != null) {
            return this.handle.compileFieldInfo();
        }
        return new HashSet<String>();
    }
}

