/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.job;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.v2.fah.job.IFahJobContext;
import kd.fi.v2.fah.log.FahBgTaskLogger;

public class FahJobContext
implements IFahJobContext {
    private static final Log logger = LogFactory.getLog(FahJobContext.class);
    private static final Map<Long, IFahJobContext> MEM_CACHE = new ConcurrentHashMap<Long, IFahJobContext>(8);
    private Long requestId;
    private boolean mainTaskUsing = true;
    private boolean bizDataTaskUsing;
    private boolean writeBackTaskUsing;
    private AtomicInteger partitionGrpCode;
    private boolean fisPreview;
    private int bigEntrySizeConfig;
    private FahBgTaskLogger fahBgTaskLogger;

    public FahBgTaskLogger getFahBgTaskLogger() {
        return this.fahBgTaskLogger;
    }

    public void setFahBgTaskLogger(FahBgTaskLogger fahBgTaskLogger) {
        this.fahBgTaskLogger = fahBgTaskLogger;
    }

    public void addStartLog(String billType, int size) {
        this.fahBgTaskLogger.addDetailEntry(FahBgTaskLogger.appendPrefixInfo((String)String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5f00\u59cb\uff0c\u5355\u636e\u7c7b\u578b\uff1a\u201c%1$s\u201d\uff0c\u6570\u91cf\uff1a\u201c%2$d\u201d\u3002", (String)"FahJobContext_01", (String)"fi-ai-business", (Object[])new Object[0]), billType, size)));
        this.fahBgTaskLogger.createNewTask();
    }

    public void addEndLog() {
        this.fahBgTaskLogger.addDetailEntry(ResManager.loadKDString((String)"\u4efb\u52a1\u7ed3\u675f\u3002", (String)"FahJobContext_02", (String)"fi-ai-business", (Object[])new Object[0]));
        this.fahBgTaskLogger.updateTaskToEnd();
    }

    public void addDetailEntry(String billType, int size) {
        this.fahBgTaskLogger.addDetailEntry(FahBgTaskLogger.appendPrefixInfo((String)String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u5f00\u59cb\uff0c\u5355\u636e\u7c7b\u578b\uff1a\u201c%1$s\u201d\uff0c\u6570\u91cf\uff1a\u201c%2$d\u201d\u3002", (String)"FahJobContext_01", (String)"fi-ai-business", (Object[])new Object[0]), billType, size)));
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
        FahJobContext.putInCache(this);
    }

    public static IFahJobContext getIFahJobContext(Long requestId) {
        if (null == requestId) {
            return null;
        }
        return MEM_CACHE.get(requestId);
    }

    public static synchronized IFahJobContext removeCache(Long requestId) {
        logger.info("FahJobContext.removeCache MEM_CACHE: {}, requestId: {}, requestIdSet: {}", new Object[]{MEM_CACHE.size(), requestId, MEM_CACHE.keySet()});
        return MEM_CACHE.remove(requestId);
    }

    public static synchronized void putInCache(IFahJobContext fahJobContext) {
        MEM_CACHE.put(fahJobContext.getRequestId(), fahJobContext);
        logger.info("FahJobContext.putInCache MEM_CACHE: {}, requestIdSet: {}", (Object)MEM_CACHE.size(), MEM_CACHE.keySet());
    }

    public static synchronized void removeAllCache() {
        MEM_CACHE.clear();
    }

    public void close() {
        if (!(this.mainTaskUsing || this.bizDataTaskUsing || this.writeBackTaskUsing)) {
            FahJobContext.removeCache(this.requestId);
        }
    }

    public boolean getFisPreview() {
        return this.fisPreview;
    }

    public void setFisPreview(boolean fisPreview) {
        this.fisPreview = fisPreview;
    }

    public int getBigEntrySizeConfig() {
        return this.bigEntrySizeConfig;
    }

    public void setBigEntrySizeConfig(int bigEntrySizeConfig) {
        this.bigEntrySizeConfig = bigEntrySizeConfig;
    }

    public AtomicInteger getPartitionGrpCode() {
        return this.partitionGrpCode;
    }

    public void setPartitionGrpCode(AtomicInteger partitionGrpCode) {
        this.partitionGrpCode = partitionGrpCode;
    }

    public void setBizDataTaskUsing(boolean bizDataTaskUsing) {
        this.bizDataTaskUsing = bizDataTaskUsing;
    }

    public void setWriteBackTaskUsing(boolean writeBackTaskUsing) {
        this.writeBackTaskUsing = writeBackTaskUsing;
    }

    public void setMainTaskUsing(boolean mainTaskUsing) {
        this.mainTaskUsing = mainTaskUsing;
    }
}

