/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.enums.ImportLogStatusEnum;
import kd.fi.v2.fah.converters.basedata.IDConverterHelper;
import kd.fi.v2.fah.dao.FahImportLogDao;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class BaseFlexTabExcelProcessContext<BATCH_ID, LOOKUP extends FlexFieldGrpCfg, T extends IInsertSqlBuilder, RESULT> {
    private static Log logger = LogFactory.getLog(BaseFlexTabExcelProcessContext.class);
    protected BATCH_ID batchId;
    protected String entityId;
    protected Workbook wb;
    protected final int excelHeaderRowCnt;
    protected int currentSheetIdx;
    protected int mainSheetDataStartPos = 0;
    protected SheetRowIteratorWrapper currentExcelRowIterator;
    protected String valSetNumber = null;
    protected String[] entryNumberFields = null;
    protected long flexTypeId;
    protected List<String> flexFields;
    protected long flexStrucId;
    protected Map<Integer, String> datePos;
    protected transient T _sqlBuilder;
    protected LOOKUP fieldGrpCfg;
    protected IDConverterHelper converterHelper;

    public BaseFlexTabExcelProcessContext(String entityId, Workbook wb, BATCH_ID batchId, int excelHeaderRowCnt) {
        this.entityId = entityId;
        this.wb = wb;
        this.excelHeaderRowCnt = excelHeaderRowCnt;
        this.currentSheetIdx = 0;
        this.batchId = batchId;
        this.datePos = new HashMap<Integer, String>(2);
        this.currentExcelRowIterator = new SheetRowIteratorWrapper();
        this.converterHelper = new IDConverterHelper(null);
    }

    public BaseFlexTabExcelProcessContext(String entityId, Workbook wb, BATCH_ID batchId) {
        this(entityId, wb, batchId, 6);
    }

    protected String getTableName() {
        return "t_fah_flex_val_tmp";
    }

    public RESULT processExcelFile() {
        this.processExcelSheetHeaders(this.currentSheetIdx);
        this.retrieveFlexTypeAndStrucId();
        FahImportLogDao.saveImportLog(this.batchId, this.entityId, this.flexTypeId, null, null);
        try {
            do {
                this.processCurrentSheet(this.currentSheetIdx);
            } while ((this.currentSheetIdx = this.getNextProcessSheet()) > 0);
            this.finalDataProcess();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), e, null);
        }
        return null;
    }

    protected void processExcelSheetHeaders(int sheetIdx) {
        Sheet firstSheet = this.wb.getSheetAt(sheetIdx);
        int excelRowNum = firstSheet.getPhysicalNumberOfRows();
        if (6 >= excelRowNum) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f\uff0c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f55\u5165\u6570\u636e\u540e\u5bfc\u5165\u3002", (String)"BaseFlexTabExcelProcessContext_0", (String)"fi-ai-business", (Object[])new Object[0]));
        }
        this.currentExcelRowIterator.reset(firstSheet.iterator(), firstSheet.getFirstRowNum(), firstSheet.getLastRowNum());
        int excelHeaderRowCnt = 6;
        block4: for (int rowIdx = 0; rowIdx < 6; ++rowIdx) {
            Row excelRowBuf = this.currentExcelRowIterator.next();
            switch (rowIdx) {
                case 3: {
                    Cell cellStr = excelRowBuf.getCell(0);
                    if (null == cellStr) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseFlexTabExcelProcessContext_1", (String)"fi-ai-business", (Object[])new Object[0]));
                    }
                    cellStr.setCellType(CellType.STRING);
                    this.valSetNumber = cellStr.getStringCellValue();
                    if (!StringUtils.isEmpty((CharSequence)this.valSetNumber)) continue block4;
                    throw new KDBizException(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseFlexTabExcelProcessContext_1", (String)"fi-ai-business", (Object[])new Object[0]));
                }
                case 4: {
                    this.entryNumberFields = new String[excelRowBuf.getPhysicalNumberOfCells()];
                    int colIdx = 0;
                    for (Cell cell : excelRowBuf) {
                        cell.setCellType(CellType.STRING);
                        this.entryNumberFields[colIdx++] = cell.getStringCellValue();
                    }
                    continue block4;
                }
            }
        }
        this.mainSheetDataStartPos = this.currentExcelRowIterator.currentSheetRow + 1;
    }

    protected void retrieveFlexTypeAndStrucId() {
        DynamicObject dynamic = QueryServiceHelper.queryOne((String)this.entityId, (String)"id,struc", (QFilter[])new QFilter("number", "=", (Object)this.valSetNumber).toArray());
        if (null == dynamic) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u5e94\u7f16\u7801\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u7cfb\u7edf\u5185\u65b0\u589e\u5bf9\u5e94\u7f16\u7801\u7684\u6570\u636e\u540e\u901a\u8fc7\u5bfc\u5165\u6dfb\u52a0\u5206\u5f55\u3002", (String)"BaseFlexTabExcelProcessContext_2", (String)"fi-ai-business", (Object[])new Object[0]));
        }
        this.flexTypeId = dynamic.getLong("id");
        this.flexStrucId = dynamic.getLong("struc");
    }

    protected boolean processCurrentSheet(int sheetIdx) {
        this.createBuilder(sheetIdx);
        this.processExcelData(sheetIdx);
        this.saveData(sheetIdx);
        return true;
    }

    protected int getNextProcessSheet() {
        if (++this.currentSheetIdx >= this.wb.getNumberOfSheets()) {
            return -1;
        }
        return this.currentSheetIdx;
    }

    protected abstract IInsertSqlBuilder createBuilder(int var1);

    protected abstract void processExcelData(int var1);

    protected abstract boolean saveData(int var1);

    protected abstract boolean finalDataProcess();

    public BATCH_ID getBatchId() {
        return this.batchId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    protected void saveFahImportLog(String code, Exception e, List<String> errors) {
        HashMap<String, Object> fields = new HashMap<String, Object>(2);
        fields.put("status", code);
        if (e != null) {
            fields.put("error", e);
        }
        FahImportLogDao.saveImportLog(this.batchId, this.entityId, this.flexTypeId, fields, errors);
    }

    protected class SheetRowIteratorWrapper
    implements Iterator<Row> {
        Iterator<Row> srcIterator;
        int currentSheetRow = 0;
        int endRowNumber;
        boolean eof;

        public void reset(Iterator<Row> currentExcelRowIterator, int startRowNum, int endRowNumber) {
            this.srcIterator = currentExcelRowIterator;
            this.eof = !currentExcelRowIterator.hasNext() || startRowNum == endRowNumber;
            for (int i = 0; i < startRowNum; ++i) {
                if (!currentExcelRowIterator.hasNext()) {
                    this.eof = true;
                    break;
                }
                currentExcelRowIterator.next();
            }
            this.currentSheetRow = startRowNum;
            this.endRowNumber = endRowNumber;
        }

        @Override
        public boolean hasNext() {
            return !this.eof && this.currentSheetRow <= this.endRowNumber && this.srcIterator != null && this.srcIterator.hasNext();
        }

        @Override
        public Row next() {
            if (!this.srcIterator.hasNext()) {
                throw new IllegalArgumentException("Sheet Iterator EOF!");
            }
            ++this.currentSheetRow;
            this.eof = this.currentSheetRow > this.endRowNumber;
            return this.srcIterator.next();
        }

        public int getCurrentSheetRow() {
            return this.currentSheetRow;
        }
    }
}

