/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FahVoucherTrackerContext {
    private Long requestId;
    private Map<Long, Set<Long>> voucherIdAndXlaIdMap = new HashMap<Long, Set<Long>>(64);
    private Map<Long, Set<Long>> vchEntryIDAndXlaEntryIdMap = new HashMap<Long, Set<Long>>(128);
    private Map<Long, List<Long>> mergeIdAndVoucherIdMap = new HashMap<Long, List<Long>>(8);
    private List<Long> notPushVoucherIds_maybe = new ArrayList<Long>(8);
    private transient int __cache_TotalXlaIdCnt = -1;
    private transient int __cache_TotalXlaEntryIdCnt = -1;

    public FahVoucherTrackerContext(Long requestId) {
        this.requestId = requestId;
    }

    public void refreshTotalXlaIdAndEntryIdCnt() {
        this.__cache_TotalXlaIdCnt = 0;
        for (Set<Long> en : this.voucherIdAndXlaIdMap.values()) {
            if (en == null) continue;
            this.__cache_TotalXlaIdCnt += en.size();
        }
        this.__cache_TotalXlaEntryIdCnt = 0;
        for (Set<Long> en : this.vchEntryIDAndXlaEntryIdMap.values()) {
            if (en == null) continue;
            this.__cache_TotalXlaEntryIdCnt += en.size();
        }
    }

    protected Map<Long, Long> __build_ReverseLookupMap(Map<Long, Set<Long>> srcMap, int initialSize) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(initialSize);
        srcMap.forEach((mergedId, value) -> value.forEach(srcId -> resultMap.put((Long)srcId, (Long)mergedId)));
        return resultMap;
    }

    public Map<Long, Long> buildXlaIdToMergedVchIdMap() {
        if (this.__cache_TotalXlaIdCnt < 0) {
            this.refreshTotalXlaIdAndEntryIdCnt();
        }
        return this.__build_ReverseLookupMap(this.voucherIdAndXlaIdMap, this.__cache_TotalXlaIdCnt);
    }

    public Map<Long, Long> buildXlaEntryIdToMergedVchEntryIdMap() {
        if (this.__cache_TotalXlaEntryIdCnt < 0) {
            this.refreshTotalXlaIdAndEntryIdCnt();
        }
        return this.__build_ReverseLookupMap(this.vchEntryIDAndXlaEntryIdMap, this.__cache_TotalXlaEntryIdCnt);
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public Map<Long, Set<Long>> getVoucherIdAndXlaIdMap() {
        return this.voucherIdAndXlaIdMap;
    }

    public Map<Long, Set<Long>> getVchEntryIDAndXlaEntryIdMap() {
        return this.vchEntryIDAndXlaEntryIdMap;
    }

    public Map<Long, List<Long>> getMergeIdAndVoucherIdMap() {
        return this.mergeIdAndVoucherIdMap;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public void setVoucherIdAndXlaIdMap(Map<Long, Set<Long>> voucherIdAndXlaIdMap) {
        this.voucherIdAndXlaIdMap = voucherIdAndXlaIdMap;
    }

    public void setVchEntryIDAndXlaEntryIdMap(Map<Long, Set<Long>> vchEntryIDAndXlaEntryIdMap) {
        this.vchEntryIDAndXlaEntryIdMap = vchEntryIDAndXlaEntryIdMap;
    }

    public void setMergeIdAndVoucherIdMap(Map<Long, List<Long>> mergeIdAndVoucherIdMap) {
        this.mergeIdAndVoucherIdMap = mergeIdAndVoucherIdMap;
    }

    public synchronized void putVoucherIdAndXlaIdMap(Long key, Long value) {
        this.voucherIdAndXlaIdMap.computeIfAbsent(key, v -> new HashSet()).add(value);
    }

    public synchronized void putVchEntryIDAndXlaEntryIdMap(Long key, Long value) {
        this.vchEntryIDAndXlaEntryIdMap.computeIfAbsent(key, v -> new HashSet()).add(value);
    }

    public synchronized void putMergeIdAndVoucherIdMap(Long key, Long value) {
        this.mergeIdAndVoucherIdMap.computeIfAbsent(key, v -> new ArrayList()).add(value);
    }

    public List<Long> getNotPushVoucherIds_maybe() {
        return this.notPushVoucherIds_maybe;
    }

    public void setNotPushVoucherIds_maybe(List<Long> notPushVoucherIds_maybe) {
        this.notPushVoucherIds_maybe = notPushVoucherIds_maybe;
    }

    public synchronized void putNotPushVoucherIds_maybe(Long value) {
        this.notPushVoucherIds_maybe.add(value);
    }
}

