/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.models.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.FahMappingConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.FahValMapEntryPropEnum;
import kd.fi.v2.fah.constant.enums.ImportLogStatusEnum;
import kd.fi.v2.fah.constant.enums.MappingValueType;
import kd.fi.v2.fah.converters.basedata.IDConverterHelper;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.dao.FahImportLogDao;
import kd.fi.v2.fah.dao.FlexMapValTempDao;
import kd.fi.v2.fah.dao.flex.MappingFlexFieldSearchDao;
import kd.fi.v2.fah.models.context.BaseFlexTabExcelProcessContext;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.flex.IFlexFieldMeta;
import kd.fi.v2.fah.models.mapping.MappingDataValueSetCollection;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.models.valueset.IBaseSimpleValueSet;
import kd.fi.v2.fah.models.valueset.IGroupSimpleBaseValueSetCollection;
import kd.fi.v2.fah.models.valueset.base.CombItemGrpValueSetWrapperIterator;
import kd.fi.v2.fah.models.valueset.base.DateRangeDataValueSet;
import kd.fi.v2.fah.poi.FahPOIHelper;
import kd.fi.v2.fah.sqlbuilder.BaseSqlBuilderFactory;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.sqlbuilder.IFlexFieldLookup;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.FlexMappingTabInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.FlexTableInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.MulValueInsertSqlBuilder;
import kd.fi.v2.fah.util.ValueSetAndMappingutil;
import kd.fi.v2.fah.util.ValueSetDuplicateCheckUtil;
import kd.fi.v2.fah.utils.FastHashHelper;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class MulValueSetMappingExcelProcContext
extends BaseFlexTabExcelProcessContext<Long, FlexFieldGrpCfg, FlexTableInsertSqlBuilder, Object> {
    private final Set<String> orgNumberSet = new HashSet<String>();
    private final List<Integer> orgNumberBlankRowList = new ArrayList<Integer>(8);

    public MulValueSetMappingExcelProcContext(String entityId, Workbook wb, Long batchId, int excelHeaderRowCnt) {
        super(entityId, wb, batchId, excelHeaderRowCnt);
    }

    public MulValueSetMappingExcelProcContext(String entityId, Workbook wb, Long batchId) {
        super(entityId, wb, batchId);
    }

    protected FlexFieldGrpCfg getFlexFieldGrpCfg(Long flexStrucId, String entityId) {
        if (this.fieldGrpCfg == null) {
            this.fieldGrpCfg = BaseFlexFieldDao.loadFlexFieldGrpCfg(new QFilter("id", "=", (Object)flexStrucId), entityId);
        }
        return this.fieldGrpCfg;
    }

    @Override
    protected IInsertSqlBuilder createBuilder(int sheetIdx) {
        if (this._sqlBuilder == null) {
            FlexTableInsertSqlBuilder sqlBuilder = BaseSqlBuilderFactory.createFlexTableInsertSqlBuilder(this.getTableName(), this.valSetNumber, this.entityId);
            sqlBuilder.setNeedAutoUpdateSeqNo(false);
            sqlBuilder.setFlexFieldLookup((IFlexFieldLookup)this.getFlexFieldGrpCfg(this.flexStrucId, this.entityId));
            sqlBuilder.addConstantValueColumn("fbatchid", this.batchId);
            sqlBuilder.addConstantValueColumn("fsrctype", (Object)this.entityId);
            sqlBuilder.addConstantValueColumn("fvaltypeid", (Object)this.flexTypeId);
            sqlBuilder.addConstantValueColumn("fHasMulValue", (Object)0);
            sqlBuilder.addConstantValueColumn("forgtype", (Object)"10");
            int colIdx = 0;
            sqlBuilder.addPKColumn("fid", new Object[0]);
            sqlBuilder.addFixPosColumn("fexcelrownum", new Object[0]);
            this.flexFields = new LinkedList();
            for (String number : this.entryNumberFields) {
                String enumNumber = FahValMapEntryPropEnum.getEnumByNumber((String)number);
                if (enumNumber != null) {
                    switch (enumNumber) {
                        case "feffectdate": 
                        case "fexpiredate": 
                        case "fownorgid": {
                            sqlBuilder.addFixPosColumn(enumNumber, new Object[0]);
                            this.datePos.put(colIdx, number);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown FahValMapEntryPropEnum\uff01");
                        }
                    }
                } else {
                    sqlBuilder.addFlexColumn(number, new Object[0]);
                    this.flexFields.add(number);
                }
                ++colIdx;
            }
            this._sqlBuilder = sqlBuilder;
        }
        return this._sqlBuilder;
    }

    @Override
    protected void processExcelData(int sheetIdx) {
        if (sheetIdx > 0) {
            this.readExcelDataOfMultiValue(this.wb, (Long)this.batchId);
            return;
        }
        int writeableColCnt = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getWriteableColumnCnt();
        ISqlParamBuffer sqlParamBuf = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlParamBuffer();
        while (this.currentExcelRowIterator.hasNext()) {
            boolean needMoveNext = false;
            Row excelRowBuf = this.currentExcelRowIterator.next();
            int colIdx = 0;
            sqlParamBuf.set(colIdx++, (Object)this.currentExcelRowIterator.getCurrentSheetRow());
            int cellIdx = 0;
            int length = this.entryNumberFields.length;
            for (int i = 0; i < length && colIdx < writeableColCnt; ++colIdx, ++i) {
                String cellValue;
                Cell cell = excelRowBuf.getCell(i);
                String string = cellValue = null == cell ? " " : FahPOIHelper.forceGetCellStringValue((Cell)cell);
                if (this.datePos.containsKey(cellIdx)) {
                    switch ((String)this.datePos.get(cellIdx)) {
                        case "effectdate": {
                            if (StringUtils.isEmpty((String)cellValue)) {
                                sqlParamBuf.set(colIdx, (Object)FahMappingConstant.effectDate);
                                break;
                            }
                            needMoveNext = true;
                            sqlParamBuf.set(colIdx, (Object)ObjectConverterFactory.getDate((Object)cellValue));
                            break;
                        }
                        case "expiredate": {
                            if (StringUtils.isEmpty((String)cellValue)) {
                                sqlParamBuf.set(colIdx, (Object)FahMappingConstant.expireDate);
                                break;
                            }
                            needMoveNext = true;
                            sqlParamBuf.set(colIdx, (Object)ObjectConverterFactory.getDate((Object)cellValue));
                            break;
                        }
                        case "ownorg": {
                            if (StringUtils.isEmpty((String)cellValue)) {
                                cellValue = " ";
                                this.orgNumberBlankRowList.add(excelRowBuf.getRowNum() + 1);
                            } else {
                                needMoveNext = true;
                                this.orgNumberSet.add(cellValue);
                            }
                            sqlParamBuf.set(colIdx, (Object)cellValue);
                            break;
                        }
                    }
                } else {
                    if (StringUtils.isEmpty((String)cellValue)) {
                        cellValue = " ";
                    } else {
                        needMoveNext = true;
                    }
                    sqlParamBuf.set(colIdx, (Object)cellValue);
                }
                ++cellIdx;
            }
            if (needMoveNext) {
                sqlParamBuf.moveToNextParamRow();
                continue;
            }
            sqlParamBuf.clearDataChangeFlag();
        }
        ((FlexTableInsertSqlBuilder)this._sqlBuilder).completeAndPack();
    }

    protected void readExcelDataOfMultiValue(Workbook workBook, Long batchId) {
        int numberOfSheets = workBook.getNumberOfSheets();
        if (numberOfSheets < 2) {
            return;
        }
        MulValueInsertSqlBuilder sqlBuilder = BaseSqlBuilderFactory.createMulValueInsertSqlBuilder(batchId, "t_fah_flex_mapval_en_tmp");
        ISqlParamBuffer buffer = sqlBuilder.getSqlParamBuffer();
        FlexFieldGrpCfg flexCfg = this.getFlexFieldGrpCfg(this.flexStrucId, this.entityId);
        for (int sheetIndex = 0; sheetIndex < numberOfSheets; ++sheetIndex) {
            Row firstRow;
            Sheet sheet = workBook.getSheetAt(sheetIndex);
            if (ResManager.loadKDString((String)"\u6620\u5c04\u53d6\u503c", (String)"MulValueSetMappingExcelProcContext_12", (String)"fi-ai-business", (Object[])new Object[0]).equalsIgnoreCase(sheet.getSheetName()) || null == (firstRow = sheet.getRow(0))) continue;
            int lastColumnIndex = firstRow.getLastCellNum();
            boolean startColumnIdx = false;
            boolean needToMoveNextRow = false;
            int rows = sheet.getPhysicalNumberOfRows();
            for (int columnIndex = 0; columnIndex < lastColumnIndex; ++columnIndex) {
                Long rowNum = null;
                int seq = 0;
                LinkedList<String> valueList = new LinkedList<String>();
                for (int i = 0; i < rows; ++i) {
                    Row row = sheet.getRow(i);
                    if (row == null) continue;
                    Cell cell = row.getCell(columnIndex);
                    if (null == cell) break;
                    cell.setCellType(CellType.STRING);
                    String cellValue = FahPOIHelper.forceGetCellStringValue((Cell)cell);
                    if (i > 2 && StringUtils.isNotEmpty((String)cellValue)) {
                        valueList.add(cellValue);
                        continue;
                    }
                    if (i == 0) {
                        if (!StringUtils.isNumeric((String)cellValue)) break;
                        rowNum = Long.parseLong(cellValue);
                        continue;
                    }
                    if (i != 1) continue;
                    FlexFieldCfg fieldCfg = flexCfg.getFlexFieldCfgByFlexFieldNum((Object)cellValue);
                    if (fieldCfg == null) {
                        throw new IllegalArgumentException("Column Name not existed in Flex Configuration:" + cellValue);
                    }
                    if (fieldCfg.getFieldUsageType() != MappingValueType.INPUT.getCode()) break;
                    seq = fieldCfg.getSeq();
                }
                if (valueList.isEmpty()) continue;
                if (!needToMoveNextRow) {
                    needToMoveNextRow = true;
                } else {
                    buffer.moveToNextParamRow();
                }
                buffer.set(0, rowNum);
                buffer.set(1, (Object)seq);
                buffer.set(2, valueList);
            }
            if (sqlBuilder.getSqlParams().isEmpty()) continue;
            BaseFlexFieldDao.doMulValueInsert(sqlBuilder);
        }
    }

    @Override
    protected boolean saveData(int sheetIdx) {
        if (sheetIdx > 0) {
            return true;
        }
        MappingStructureMeta meta = MappingFlexFieldSearchDao.queryValueMapStructure((Long)this.flexTypeId, (Boolean)Boolean.TRUE);
        BiFunction<String, Integer, Object[]> idGeneratorFunction = (tableName, cnt) -> {
            Object[] pks = new Object[cnt.intValue()];
            long[] ids = DB.genLongIds((String)tableName, (int)cnt);
            for (int i = 0; i < ids.length; ++i) {
                pks[i] = ids[i];
            }
            return pks;
        };
        FlexMappingTabInsertSqlBuilder wrapperBuilder = new FlexMappingTabInsertSqlBuilder((FlexTableInsertSqlBuilder)this._sqlBuilder, meta, idGeneratorFunction);
        BaseFlexFieldDao.doFlexMappingInsert(wrapperBuilder);
        return true;
    }

    @Override
    protected boolean finalDataProcess() {
        LinkedList<String> errorInfos = new LinkedList<String>();
        Map<String, Long> numberOrgIdMap = this.checkOrgLegal(errorInfos);
        if (!errorInfos.isEmpty()) {
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return false;
        }
        List[] paramNames = new List[2];
        HashMap<String, Object[]> assisDimType = new HashMap<String, Object[]>();
        paramNames[MappingValueType.INPUT.getCode()] = new ArrayList(this.flexFields.size());
        paramNames[MappingValueType.OUTPUT.getCode()] = new LinkedList();
        LinkedHashMap<String, String> comboMap = new LinkedHashMap<String, String>();
        for (String field : this.flexFields) {
            MappingValueType paramType;
            IFlexFieldMeta tableField = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getFlexFieldLookup().getFlexFieldCfgByFlexFieldNum((Object)field);
            if (tableField == null || (paramType = MappingValueType.parseFromCode((Object)tableField.getFieldUsageType())) == null) continue;
            paramNames[paramType.getCode()].add(tableField);
            if (DataValueTypeEnum.Kingdee_AcctAssistDim == tableField.getDataType()) {
                assisDimType.put(field, this.getAssisDimType(tableField.getRefEntity(), tableField.getRefTypeId()));
            }
            if (DataValueTypeEnum.Kingdee_BillDropDownList != tableField.getDataType()) continue;
            this.setComboMap(comboMap, tableField.getRefEntity(), tableField.getRefFieldNum());
        }
        HashMap<String, IDConverterHelper> converterMap = new HashMap<String, IDConverterHelper>(numberOrgIdMap.size());
        boolean checkFlag = this.checkImportData(numberOrgIdMap, converterMap, paramNames, assisDimType, comboMap, errorInfos);
        if (checkFlag) {
            this.saveFormalData(numberOrgIdMap, converterMap, paramNames, assisDimType, comboMap, errorInfos);
        }
        return true;
    }

    private boolean checkImportData(Map<String, Long> numberOrgIdMap, Map<String, IDConverterHelper> converterMap, List<IFlexFieldMeta>[] paramNames, Map<String, Object[]> assisDimType, Map<String, String> comboMap, List<String> errorInfos) {
        errorInfos = FlexMapValTempDao.queryDateEffectTemp((Long)this.batchId);
        if (!errorInfos.isEmpty()) {
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return false;
        }
        LinkedHashMap<IFlexFieldMeta, Set<String>> valueMap = new LinkedHashMap<IFlexFieldMeta, Set<String>>();
        Collection sqlColumnNames = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlColumnNames();
        LinkedHashSet colNames = new LinkedHashSet(sqlColumnNames.size());
        colNames.addAll(sqlColumnNames);
        String collectionToString = StringUtils.collectionToString(colNames);
        String sql = "select " + collectionToString + ", fmapvaluetype from " + ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlTableName() + " where fbatchid = ? and fmapvaluetype = ?";
        for (MappingValueType mappingValueType : MappingValueType.values()) {
            SqlBuilder sb = new SqlBuilder();
            sb.append(sql, new Object[]{this.batchId, String.valueOf(mappingValueType.getCode())});
            try (DataSet queryDataSet = DB.queryDataSet((String)MulValueSetMappingExcelProcContext.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
                for (kd.bos.algo.Row row : queryDataSet) {
                    String ownOrgNUmber = row.getString("fownorgid");
                    IDConverterHelper idConverterHelper = converterMap.computeIfAbsent(ownOrgNUmber, k -> new IDConverterHelper((Long)numberOrgIdMap.get(ownOrgNUmber)));
                    boolean hasTargetData = true;
                    for (IFlexFieldMeta tableField : paramNames[mappingValueType.getCode()]) {
                        String dbValue = row.getString(tableField.getDbFieldNum());
                        if (0 == mappingValueType.getCode() && StringUtils.isNotEmpty((String)dbValue)) {
                            hasTargetData = false;
                        }
                        switch (tableField.getDataType()) {
                            case BaseProp: 
                            case Kingdee_CashFlow: {
                                idConverterHelper.collectBasedataNumber(tableField.getRefEntity(), dbValue);
                                break;
                            }
                            case AssistProp: {
                                idConverterHelper.collectAssistantNumber(tableField.getRefTypeId(), dbValue);
                                break;
                            }
                            case Kingdee_AcctAssistDim: {
                                Object[] objects = assisDimType.get(tableField.getNumber());
                                if (null == objects) break;
                                if ("1".equals(objects[0])) {
                                    idConverterHelper.collectBasedataNumber(objects[1].toString(), dbValue);
                                }
                                if (!"2".equals(objects[0])) break;
                                idConverterHelper.collectAssistantNumber(ObjectConverterFactory.getLong((Object)objects[2]), dbValue);
                                break;
                            }
                            case Kingdee_AccountTable: {
                                idConverterHelper.collectAccountNumber(tableField.getRefTypeId(), dbValue);
                                break;
                            }
                            case FahValueSet: {
                                if (!StringUtils.isNotEmpty((String)dbValue)) break;
                                Set segments = valueMap.computeIfAbsent(tableField, k -> new HashSet());
                                segments.add(dbValue);
                                break;
                            }
                            case Kingdee_BillDropDownList: {
                                if (!StringUtils.isNotEmpty((String)dbValue) || comboMap.containsKey(dbValue)) break;
                                errorInfos.add(String.format(ResManager.loadKDString((String)"\u4e0b\u62c9\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u201c%1$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_13", (String)"fi-ai-business", (Object[])new Object[0]), dbValue));
                                break;
                            }
                        }
                    }
                    if (!hasTargetData || 0 != mappingValueType.getCode()) continue;
                    errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u6620\u5c04\u76ee\u6807\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_0", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum")));
                }
            }
        }
        SqlBuilder enBuilder = new SqlBuilder();
        enBuilder.append("select t.fexcelrownum,t.fcolindex,t.ftxtattr,t.fbatchid,a.fownorgid from t_fah_flex_mapval_en_tmp t join t_fah_flex_val_tmp a on t.fbatchid = a.fbatchid and t.fexcelrownum = a.fexcelrownum and t.fbatchid = ?", new Object[]{this.batchId});
        DataSet queryDataSet = DB.queryDataSet((String)MulValueSetMappingExcelProcContext.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)enBuilder);
        Iterator<IDConverterHelper> iterator = null;
        try {
            for (kd.bos.algo.Row row : queryDataSet) {
                String ownOrgNUmber = row.getString("fownorgid");
                IDConverterHelper idConverterHelper = converterMap.computeIfAbsent(ownOrgNUmber, k -> new IDConverterHelper((Long)numberOrgIdMap.get(ownOrgNUmber)));
                int colIdx = row.getInteger("fcolindex");
                String txtAttr = row.getString("ftxtattr");
                for (IFlexFieldMeta tableField : paramNames[MappingValueType.INPUT.getCode()]) {
                    Object[] objects;
                    if (DataValueTypeEnum.BaseProp == tableField.getDataType() && tableField.getSeq() == colIdx) {
                        idConverterHelper.collectBasedataNumber(tableField.getRefEntity(), txtAttr);
                    }
                    if (DataValueTypeEnum.AssistProp == tableField.getDataType() && tableField.getSeq() == colIdx) {
                        idConverterHelper.collectAssistantNumber(tableField.getRefTypeId(), txtAttr);
                    }
                    if (DataValueTypeEnum.FahValueSet == tableField.getDataType() && tableField.getSeq() == colIdx && StringUtils.isNotEmpty((String)txtAttr)) {
                        Set segments = valueMap.computeIfAbsent(tableField, k -> new HashSet());
                        segments.add(txtAttr);
                    }
                    if (DataValueTypeEnum.Kingdee_BillDropDownList == tableField.getDataType() && tableField.getSeq() == colIdx && StringUtils.isNotEmpty((String)txtAttr) && !comboMap.containsKey(txtAttr)) {
                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u4e0b\u62c9\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u201c%1$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_13", (String)"fi-ai-business", (Object[])new Object[0]), txtAttr));
                    }
                    if (DataValueTypeEnum.Kingdee_AcctAssistDim != tableField.getDataType() || tableField.getSeq() != colIdx || null == (objects = assisDimType.get(tableField.getNumber()))) continue;
                    if ("1".equals(objects[0])) {
                        idConverterHelper.collectBasedataNumber(objects[1].toString(), txtAttr);
                    }
                    if (!"2".equals(objects[0])) continue;
                    idConverterHelper.collectAssistantNumber(ObjectConverterFactory.getLong((Object)objects[2]), txtAttr);
                }
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (iterator != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)iterator)).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        Map<IFlexFieldMeta, Set<String>> notFindNumberMap = FahImportLogDao.findNotValueSet(valueMap);
        if (!notFindNumberMap.isEmpty()) {
            for (Map.Entry entry : notFindNumberMap.entrySet()) {
                String refEntity = ((IFlexFieldMeta)entry.getKey()).getRefEntity();
                for (String code : (Set)entry.getValue()) {
                    errorInfos.add(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u503c\u96c6\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528/\u4e0d\u5728\u751f\u6548\u65f6\u95f4\u5185\uff09\u503c\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_1", (String)"fi-ai-business", (Object[])new Object[0]), refEntity, code));
                }
            }
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return false;
        }
        if (!errorInfos.isEmpty()) {
            this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
            return false;
        }
        for (IDConverterHelper iDConverterHelper : converterMap.values()) {
            iDConverterHelper.finishCollect();
        }
        return true;
    }

    private Map<String, Long> checkOrgLegal(List<String> errorInfos) {
        if (CollectionUtils.isNotEmpty(this.orgNumberBlankRowList)) {
            errorInfos.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u9002\u7528\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u884c\uff1a%s", (String)"MulValueSetMappingExcelProcContext_14", (String)"fi-ai-business", (Object[])new Object[0]), this.orgNumberBlankRowList));
            return Collections.emptyMap();
        }
        HashMap<String, Long> numberOrgIdMap = new HashMap<String, Long>(this.orgNumberSet.size());
        HashMap<Long, String> idOrgNumberMap = new HashMap<Long, String>(this.orgNumberSet.size());
        SqlBuilder sb = new SqlBuilder();
        sb.append("SELECT fnumber, fid FROM t_org_org where ", new Object[0]);
        sb.appendIn("fnumber", new ArrayList<String>(this.orgNumberSet));
        try (DataSet queryDataSet = DB.queryDataSet((String)MulValueSetMappingExcelProcContext.class.getName(), (DBRoute)DBRoute.of((String)"sys"), (SqlBuilder)sb);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                kd.bos.algo.Row row = (kd.bos.algo.Row)iterator.next();
                numberOrgIdMap.put(row.getString("fnumber"), row.getLong("fid"));
                idOrgNumberMap.put(row.getLong("fid"), row.getString("fnumber"));
            }
        }
        if (numberOrgIdMap.size() != this.orgNumberSet.size()) {
            for (String orgNumber : this.orgNumberSet) {
                if (numberOrgIdMap.containsKey(orgNumber)) continue;
                errorInfos.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_2", (String)"fi-ai-business", (Object[])new Object[0]), orgNumber));
            }
            return numberOrgIdMap;
        }
        Collection values = numberOrgIdMap.values();
        LinkedList<Long> ownOrgIds = new LinkedList<Long>();
        SqlBuilder valMapOrg = new SqlBuilder();
        valMapOrg.append("SELECT fownorgid FROM t_fah_valmap_type_org where ", new Object[0]);
        valMapOrg.append("fmaptypeid = ?", new Object[]{this.flexTypeId});
        valMapOrg.append(" and fiscustom = ?", new Object[]{"1"});
        valMapOrg.appendIn(" and fownorgid ", new ArrayList(values));
        DataSet queryDataSet = DB.queryDataSet((String)MulValueSetMappingExcelProcContext.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)valMapOrg);
        Object object = null;
        try {
            for (kd.bos.algo.Row row : queryDataSet) {
                ownOrgIds.add(row.getLong("fownorgid"));
            }
        }
        catch (Throwable iterator) {
            object = iterator;
            throw iterator;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable iterator) {
                        ((Throwable)object).addSuppressed(iterator);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        if (values.size() != ownOrgIds.size()) {
            HashSet ownOrgIdSet = new HashSet(ownOrgIds);
            for (Long orgId : values) {
                if (ownOrgIdSet.contains(orgId)) continue;
                errorInfos.add(String.format(ResManager.loadKDString((String)"\u4e2a\u6027\u5316\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u7ef4\u62a4\u4e2a\u6027\u5316\u7ec4\u7ec7\u540e\u5bfc\u5165\u3002", (String)"MulValueSetMappingExcelProcContext_3", (String)"fi-ai-business", (Object[])new Object[0]), idOrgNumberMap.get(orgId)));
            }
            return numberOrgIdMap;
        }
        HasPermOrgResult userHasPermOrgs = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
        if (!userHasPermOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = userHasPermOrgs.getHasPermOrgs();
            HashSet hasPermOrgSet = new HashSet(hasPermOrgs);
            for (Long orgId : values) {
                if (hasPermOrgSet.contains(orgId)) continue;
                errorInfos.add(String.format(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_4", (String)"fi-ai-business", (Object[])new Object[0]), idOrgNumberMap.get(orgId)));
            }
        }
        return numberOrgIdMap;
    }

    private void saveFormalData(Map<String, Long> numberOrgIdMap, Map<String, IDConverterHelper> converterMap, List<IFlexFieldMeta>[] paramNames, Map<String, Object[]> assisDimType, Map<String, String> comboMap, List<String> errorInfos) {
        Map<Long, Integer> maxSerialNoMap = BaseFlexFieldDao.getTableMaxSerialNoMap("t_fah_flex_mapval", "fserialnumber", "fownorgid", this.flexTypeId, numberOrgIdMap.values().toArray());
        for (Map.Entry<String, Long> entry : numberOrgIdMap.entrySet()) {
            MappingDataValueSetCollection setCollection = new MappingDataValueSetCollection(this.flexFields.size(), this.flexTypeId);
            Collection sqlColumnNames = ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlColumnNames();
            LinkedHashSet colNames = new LinkedHashSet(sqlColumnNames.size());
            colNames.addAll(sqlColumnNames);
            String collectionToString = StringUtils.collectionToString(colNames);
            String sql = "select " + collectionToString + ", fmapvaluetype from " + ((FlexTableInsertSqlBuilder)this._sqlBuilder).getSqlTableName() + " where fbatchid = ? and fmapvaluetype = ? and fownorgid = ? ";
            LinkedList<Integer> excelRowList = new LinkedList<Integer>();
            for (MappingValueType mappingValueType : MappingValueType.values()) {
                SqlBuilder sb = new SqlBuilder();
                sb.append(sql, new Object[]{this.batchId, String.valueOf(mappingValueType.getCode()), entry.getKey()});
                try (DataSet queryDataSet = DB.queryDataSet((String)MulValueSetMappingExcelProcContext.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
                    for (kd.bos.algo.Row row : queryDataSet) {
                        String ownOrgNumber = row.getString("fownorgid");
                        excelRowList.add(row.getInteger("fexcelrownum"));
                        IDConverterHelper iDConverterHelper = converterMap.get(ownOrgNumber);
                        DateRangeDataValueSet row1 = new DateRangeDataValueSet(paramNames[mappingValueType.getCode()].size() + 4);
                        row1.setValueMergeCollectionSupplier(() -> new LinkedHashSet(16));
                        setCollection.cache(mappingValueType.getCode(), row1);
                        block35: for (IFlexFieldMeta tableField : paramNames[mappingValueType.getCode()]) {
                            String dbFieldNum = tableField.getDbFieldNum().trim();
                            String dbValue = row.getString(dbFieldNum);
                            switch (tableField.getDataType()) {
                                case BaseProp: {
                                    if (StringUtils.isEmpty((String)dbValue)) {
                                        row1.addColumnValue(tableField.getSeq().intValue(), (Object)0);
                                        break;
                                    }
                                    List baseData = iDConverterHelper.convertBasedataNumber(tableField.getRefEntity(), dbValue);
                                    if (null == baseData || baseData.isEmpty()) {
                                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_5", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), tableField.getName(), dbValue));
                                        break;
                                    }
                                    row1.addColumnValue(tableField.getSeq().intValue(), baseData.get(0));
                                    break;
                                }
                                case AssistProp: {
                                    if (StringUtils.isEmpty((String)dbValue)) {
                                        row1.addColumnValue(tableField.getSeq().intValue(), (Object)0);
                                        break;
                                    }
                                    List assistant = iDConverterHelper.convertAssistantNumber(tableField.getRefTypeId(), dbValue);
                                    if (null == assistant || assistant.isEmpty()) {
                                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u8f85\u52a9\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_11", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), tableField.getName(), dbValue));
                                        break;
                                    }
                                    row1.addColumnValue(tableField.getSeq().intValue(), assistant.get(0));
                                    break;
                                }
                                case Kingdee_AcctAssistDim: {
                                    Object[] objects = assisDimType.get(tableField.getNumber());
                                    if (null == objects) continue block35;
                                    if (StringUtils.isEmpty((String)dbValue)) {
                                        row1.addColumnValue(tableField.getSeq().intValue(), (Object)0);
                                        break;
                                    }
                                    if ("1".equals(objects[0])) {
                                        List assistBaseData = iDConverterHelper.convertBasedataNumber(objects[1].toString(), dbValue);
                                        if (null == assistBaseData || assistBaseData.isEmpty()) {
                                            errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_6", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), dbValue));
                                        } else {
                                            row1.addColumnValue(tableField.getSeq().intValue(), assistBaseData.get(0));
                                        }
                                    }
                                    if (!"2".equals(objects[0])) continue block35;
                                    List assistAsstant = iDConverterHelper.convertAssistantNumber(ObjectConverterFactory.getLong((Object)objects[2]), dbValue);
                                    if (null == assistAsstant || assistAsstant.isEmpty()) {
                                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_6", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), dbValue));
                                        break;
                                    }
                                    row1.addColumnValue(tableField.getSeq().intValue(), assistAsstant.get(0));
                                    break;
                                }
                                case Kingdee_CashFlow: {
                                    if (StringUtils.isEmpty((String)dbValue)) {
                                        row1.addColumnValue(tableField.getSeq().intValue(), (Object)dbValue);
                                        break;
                                    }
                                    List cashFlowList = iDConverterHelper.convertBasedataNumber(tableField.getRefEntity(), dbValue);
                                    if (null == cashFlowList || cashFlowList.isEmpty()) {
                                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u73b0\u91d1\u6d41\u91cf\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_8", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), dbValue));
                                        break;
                                    }
                                    row1.addColumnValue(tableField.getSeq().intValue(), (Object)dbValue);
                                    break;
                                }
                                case Kingdee_AccountTable: {
                                    if (StringUtils.isEmpty((String)dbValue)) {
                                        row1.addColumnValue(tableField.getSeq().intValue(), (Object)dbValue);
                                        break;
                                    }
                                    List accountIdList = iDConverterHelper.convertAccountNumber(tableField.getRefTypeId(), dbValue);
                                    if (null == accountIdList || accountIdList.isEmpty()) {
                                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u79d1\u76ee\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_9", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), dbValue));
                                        break;
                                    }
                                    row1.addColumnValue(tableField.getSeq().intValue(), (Object)dbValue);
                                    break;
                                }
                                case Kingdee_BillDropDownList: {
                                    if (StringUtils.isEmpty((String)dbValue)) {
                                        row1.addColumnValue(tableField.getSeq().intValue(), (Object)dbValue);
                                        break;
                                    }
                                    row1.addColumnValue(tableField.getSeq().intValue(), (Object)comboMap.get(dbValue));
                                    break;
                                }
                                default: {
                                    row1.addColumnValue(tableField.getSeq().intValue(), (Object)dbValue);
                                }
                            }
                        }
                        int fixColIdx = paramNames[mappingValueType.getCode()].size();
                        row1.addColumnValue(fixColIdx++, (Object)row.getDate("feffectdate"));
                        row1.addColumnValue(fixColIdx++, (Object)row.getDate("fexpiredate"));
                        row1.addColumnValue(fixColIdx++, (Object)numberOrgIdMap.get(ownOrgNumber));
                        row1.addColumnValue(fixColIdx, (Object)numberOrgIdMap.get(ownOrgNumber));
                    }
                }
                setCollection.flush(mappingValueType.getCode());
            }
            List<IFlexFieldMeta> flexFieldCfgs = paramNames[MappingValueType.INPUT.getCode()];
            SqlBuilder enBuilder = new SqlBuilder();
            enBuilder.append("select t.fexcelrownum,t.fcolindex,t.ftxtattr,t.fbatchid,a.fownorgid from t_fah_flex_mapval_en_tmp t join t_fah_flex_val_tmp a on t.fbatchid = a.fbatchid and t.fexcelrownum = a.fexcelrownum and t.fbatchid = ? ", new Object[]{this.batchId});
            enBuilder.appendIn("and t.fexcelrownum ", excelRowList);
            Throwable throwable = null;
            try (DataSet queryDataSet = DB.queryDataSet((String)MulValueSetMappingExcelProcContext.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)enBuilder);){
                block36: for (kd.bos.algo.Row row : queryDataSet) {
                    IFlexFieldMeta tableField;
                    IDConverterHelper iDConverterHelper = converterMap.get(row.getString("fownorgid"));
                    int mainDataRowSeqNo = row.getInteger("fexcelrownum") - this.mainSheetDataStartPos;
                    int colIndex = row.getInteger("fcolindex");
                    if (colIndex < flexFieldCfgs.size() && (tableField = flexFieldCfgs.get(colIndex)) != null) {
                        String txtAttr = row.getString("ftxtattr");
                        switch (tableField.getDataType()) {
                            case BaseProp: {
                                if (StringUtils.isEmpty((String)txtAttr)) {
                                    setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)0);
                                    break;
                                }
                                List baseData = iDConverterHelper.convertBasedataNumber(tableField.getRefEntity(), txtAttr);
                                if (null == baseData || baseData.isEmpty()) {
                                    errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_5", (String)"fi-ai-business", (Object[])new Object[0]), mainDataRowSeqNo, tableField.getName(), txtAttr));
                                    break;
                                }
                                setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, baseData.get(0));
                                break;
                            }
                            case AssistProp: {
                                if (StringUtils.isEmpty((String)txtAttr)) {
                                    setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)0);
                                    break;
                                }
                                List assistant = iDConverterHelper.convertAssistantNumber(tableField.getRefTypeId(), txtAttr);
                                if (null == assistant || assistant.isEmpty()) {
                                    errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u8f85\u52a9\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_11", (String)"fi-ai-business", (Object[])new Object[0]), mainDataRowSeqNo, tableField.getName(), txtAttr));
                                    break;
                                }
                                setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, assistant.get(0));
                                break;
                            }
                            case Kingdee_AcctAssistDim: {
                                Object[] objects = assisDimType.get(tableField.getNumber());
                                if (null == objects) continue block36;
                                if (StringUtils.isEmpty((String)txtAttr)) {
                                    setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)0);
                                    break;
                                }
                                if ("1".equals(objects[0])) {
                                    List assisDimData = iDConverterHelper.convertBasedataNumber(objects[1].toString(), txtAttr);
                                    if (null == assisDimData || assisDimData.isEmpty()) {
                                        errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_6", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), txtAttr));
                                    } else {
                                        setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, assisDimData.get(0));
                                    }
                                }
                                if (!"2".equals(objects[0])) continue block36;
                                List assisDimAssistant = iDConverterHelper.convertAssistantNumber(ObjectConverterFactory.getLong((Object)objects[2]), txtAttr);
                                if (null == assisDimAssistant || assisDimAssistant.isEmpty()) {
                                    errorInfos.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\uff0c\u4e0d\u5b58\u5728\uff08\u6216\u88ab\u7981\u7528\uff09\u7f16\u7801\u4e3a\u201c%2$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MulValueSetMappingExcelProcContext_6", (String)"fi-ai-business", (Object[])new Object[0]), row.getInteger("fexcelrownum"), txtAttr));
                                    break;
                                }
                                setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, assisDimAssistant.get(0));
                                break;
                            }
                            case Kingdee_BillDropDownList: {
                                if (StringUtils.isEmpty((String)txtAttr)) {
                                    setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)0);
                                    break;
                                }
                                setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)comboMap.get(txtAttr));
                                break;
                            }
                            default: {
                                setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)txtAttr);
                            }
                        }
                        continue;
                    }
                    setCollection.addRowColumnData(MappingValueType.INPUT, mainDataRowSeqNo, colIndex, (Object)row.getString("ftxtattr"));
                }
            }
            catch (Throwable iterator) {
                Throwable throwable2 = iterator;
                throw iterator;
            }
            if (!errorInfos.isEmpty()) {
                this.saveFahImportLog(ImportLogStatusEnum.FAILED.getCode(), null, errorInfos);
                return;
            }
            setCollection.flush();
            setCollection.repairingInOutParamRowCnt();
            BaseInsertSqlBuilder mainTabSqlBuilder = new BaseInsertSqlBuilder((Object)0L, "t_fah_flex_mapval", BaseSqlBuilderFactory::pkGenerator);
            mainTabSqlBuilder.addConstantValueColumn("fid", null);
            mainTabSqlBuilder.setPK_Column_Index(0);
            mainTabSqlBuilder.addSequenceColumn("fserialnumber", new Object[0]);
            mainTabSqlBuilder.setSeq_Column_Index(1);
            mainTabSqlBuilder.setNeedAutoUpdateSeqNo(true);
            int n = null == maxSerialNoMap.get(entry.getValue()) ? 1 : maxSerialNoMap.get(entry.getValue()) + 1;
            mainTabSqlBuilder.setStartSeqNo((long)n);
            mainTabSqlBuilder.addConstantValueColumn("fenable", (Object)"1");
            mainTabSqlBuilder.addConstantValueColumn("fhasmulvalue", (Object)"0");
            mainTabSqlBuilder.addConstantValueColumn("fmaptypeid", (Object)this.flexTypeId);
            mainTabSqlBuilder.addConstantValueColumn("fstatus", (Object)"A");
            mainTabSqlBuilder.addConstantValueColumn("forgtype", (Object)"10");
            Date date = new Date();
            long userId = Long.parseLong(RequestContext.get().getUserId());
            mainTabSqlBuilder.addConstantValueColumn("fcreatetime", (Object)date);
            mainTabSqlBuilder.addConstantValueColumn("fmodifytime", (Object)date);
            mainTabSqlBuilder.addConstantValueColumn("fcreatorid", (Object)userId);
            mainTabSqlBuilder.addConstantValueColumn("fmodifierid", (Object)userId);
            boolean needToMoveNext = false;
            CombItemGrpValueSetWrapperIterator wrapperIterator = new CombItemGrpValueSetWrapperIterator((IGroupSimpleBaseValueSetCollection)setCollection, setCollection.getColumnCnt());
            do {
                int currentUsedDataGroupIndex = wrapperIterator.getCurrentUsedDataGroupIndex();
                int i = 0;
                for (IFlexFieldMeta col : paramNames[currentUsedDataGroupIndex]) {
                    mainTabSqlBuilder.addFlexColumn(col.getDbFieldNum(), new Object[0]);
                }
                mainTabSqlBuilder.addFixPosColumn("feffectdate", new Object[0]);
                mainTabSqlBuilder.addFixPosColumn("fexpiredate", new Object[0]);
                mainTabSqlBuilder.addFixPosColumn("fownorgid", new Object[0]);
                mainTabSqlBuilder.addFixPosColumn("fgroupid", new Object[0]);
                mainTabSqlBuilder.addFixPosColumn("fmapvaluetype", new Object[0]);
                mainTabSqlBuilder.addFixPosColumn("fHashCode", new Object[0]);
                int[] hashCodeColPos = mainTabSqlBuilder.getFlexFieldAccessPos((IFlexFieldLookup)this.fieldGrpCfg, currentUsedDataGroupIndex);
                ISqlParamBuffer sqlParamBuffer = mainTabSqlBuilder.getSqlParamBuffer();
                while (wrapperIterator.hasNext()) {
                    IBaseSimpleValueSet valueSetBuf = wrapperIterator.next();
                    Object[] rowBuf = valueSetBuf.getValues();
                    if (!needToMoveNext) {
                        needToMoveNext = true;
                    }
                    sqlParamBuffer.moveToNextParamRow();
                    for (i = 0; i < rowBuf.length; ++i) {
                        sqlParamBuffer.set(i, rowBuf[i]);
                    }
                    sqlParamBuffer.set(i++, (Object)currentUsedDataGroupIndex);
                    sqlParamBuffer.set(i, (Object)FastHashHelper.javaHashCode((Object[])sqlParamBuffer.getValues(), (int[])hashCodeColPos));
                }
                BaseFlexFieldDao.doInsert((IInsertSqlBuilder)mainTabSqlBuilder);
                mainTabSqlBuilder.cleanColumns(new IAddSqlColumn.ColumnGrpType[]{IAddSqlColumn.ColumnGrpType.FlexColumn, IAddSqlColumn.ColumnGrpType.FixPosColumn});
                mainTabSqlBuilder.setNeedAutoUpdateSeqNo(true);
            } while (wrapperIterator.nextDataGroup() >= 0);
        }
        ValueSetDuplicateCheckUtil.checkDuplicate(this.flexTypeId);
        this.saveFahImportLog(ImportLogStatusEnum.SUCCEED.getCode(), null, null);
        ValueSetAndMappingutil.updateMapCountCache(this.flexTypeId);
    }

    private void setComboMap(Map<String, String> comboMap, String refEntity, String refFieldNum) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)refEntity);
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)entityType.getAllFields().get(refFieldNum);
        List comboItems = null;
        if (dataEntityProperty instanceof ComboProp) {
            ComboProp comboProp = (ComboProp)dataEntityProperty;
            comboItems = comboProp.getComboItems();
        }
        if (comboItems != null && !comboItems.isEmpty()) {
            for (ValueMapItem mapItem : comboItems) {
                comboMap.put(mapItem.getName().getLocaleValue(), mapItem.getValue());
            }
        }
    }

    private Object[] getAssisDimType(String refEntity, Object refEntityId) {
        String sql = "valuetype,valuesource.id,valuesource.number,assistanttype.id,assistanttype.number";
        DynamicObject dynamic = QueryServiceHelper.queryOne((String)refEntity, (String)sql, (QFilter[])new QFilter("id", "=", refEntityId).toArray());
        if (null != dynamic) {
            Object[] Objects = new Object[]{dynamic.getString("valuetype"), dynamic.getString("valuesource.number"), dynamic.getLong("assistanttype.id")};
            return Objects;
        }
        return null;
    }
}

