/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.dao.config.event.FahDispatchRuleDaoImpl;
import kd.fi.v2.fah.models.mapping.dupcheck.DupCheckPojo;

public class DuplicateDispatchChecker {
    public Map<String, List<Set<Integer>>> checkDuplicate(Long pkId) {
        DataSet dataSet = FahDispatchRuleDaoImpl.queryRepeatedRecordsByHashCode(pkId);
        HashMap<String, List<Set<Integer>>> result = new HashMap<String, List<Set<Integer>>>();
        PairTuple cache = new PairTuple(null, new LinkedList());
        TreeSet<Integer> serialNumsCache = new TreeSet<Integer>();
        String lastOrgZone = "";
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long orgId = row.getLong("forgid");
            String valuezone = row.getString("fvaluezone");
            Long hashcode = row.getLong("fhashcode");
            String key = orgId + valuezone + hashcode;
            if (cache.getKey() == null) {
                lastOrgZone = orgId + "$" + valuezone;
                cache.setKey((Object)key);
            }
            DupCheckPojo currentObj = this.generateDupCheckPojo(row);
            if (key.equals(cache.getKey())) {
                if (!((List)cache.getValue()).isEmpty()) {
                    this.hasDupValue(currentObj, (List)cache.getValue(), serialNumsCache);
                }
                ((List)cache.getValue()).add(currentObj);
                continue;
            }
            if (!serialNumsCache.isEmpty()) {
                result.computeIfAbsent(lastOrgZone, k -> new LinkedList()).add(serialNumsCache);
                serialNumsCache = new TreeSet();
            }
            lastOrgZone = orgId + "$" + valuezone;
            cache.setKey((Object)key);
            cache.setValue(new LinkedList());
            ((List)cache.getValue()).add(currentObj);
        }
        if (!serialNumsCache.isEmpty()) {
            result.computeIfAbsent(lastOrgZone, k -> new LinkedList()).add(serialNumsCache);
        }
        dataSet.close();
        return result;
    }

    private boolean hasDupValue(DupCheckPojo currentObj, List<DupCheckPojo> values, Set<Integer> serialNumsCache) {
        for (DupCheckPojo dupCheckPojo : values) {
            if (!currentObj.isEqual(dupCheckPojo)) continue;
            serialNumsCache.add(currentObj.getSerialNum());
            serialNumsCache.add(dupCheckPojo.getSerialNum());
            return true;
        }
        return false;
    }

    private DupCheckPojo generateDupCheckPojo(Row row) {
        DupCheckPojo dupCheckPojo = new DupCheckPojo();
        dupCheckPojo.setEffectdate(row.getDate("feffectdate"));
        dupCheckPojo.setExpiredate(row.getDate("fexpiredate"));
        dupCheckPojo.setSerialNum(row.getInteger("fserialnumber"));
        ArrayList<Object> values = new ArrayList<Object>(10);
        for (int i = 1; i <= 10; ++i) {
            Object value = row.get("ftxtattr" + i);
            values.add(value);
        }
        dupCheckPojo.setValues(values);
        return dupCheckPojo;
    }
}

