/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.dao.DaoFactory;
import kd.fi.v2.fah.dao.flex.MappingValueDao;
import kd.fi.v2.fah.models.context.DuplicateMappingCheckerContextV2;
import kd.fi.v2.fah.models.context.ValueSetDuplicateCheckResultV2;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.IMapInput;
import kd.fi.v2.fah.models.mapping.MappingMetaCache;
import kd.fi.v2.fah.models.mapping.dupcheck.DupCheckPojo;
import kd.fi.v2.fah.models.mapping.impl.MapInput;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.models.valueset.IDataValueSet;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.dto.MappingData;
import kd.fi.v2.fah.services.dto.MixedValueMappingDataCollection;
import kd.fi.v2.fah.services.dto.MultiValueMappingDataCollection;
import kd.fi.v2.fah.services.dto.SingleValueMappingDataCollection;

public class DuplicateMappingChecker {
    private final MappingValueDao daoInstance = (MappingValueDao)DaoFactory.getInstance(MappingValueDao.class);

    public PairTuple<Map<Long, List<Set<Integer>>>, List<Long>> checkSingleValueDuplicate(Long mapTypeId) {
        MappingStructureMeta mappingMetaCached = MappingMetaCache.getMappingMetaCached((Long)mapTypeId, (Object[])new Object[0]);
        FlexFieldGrpCfg inputParamMeta = mappingMetaCached.getInputParamMeta();
        DataSet dataSet = this.daoInstance.queryRepeatedRecordsByHashcodeAndGroupId(mapTypeId, (IValueSetMeta)inputParamMeta);
        DataSet limit = dataSet.limit(0, 50000);
        dataSet.close();
        return this.checkDuplicate(limit, (IValueSetMeta)inputParamMeta);
    }

    private PairTuple<Map<Long, List<Set<Integer>>>, List<Long>> checkDuplicate(DataSet dataSet, IValueSetMeta inputParamMeta) {
        HashMap<Long, List> result = new HashMap<Long, List>();
        PairTuple cache = new PairTuple(null, new LinkedList());
        TreeSet<Integer> serialNumsCache = new TreeSet<Integer>();
        ArrayList<Long> ids = new ArrayList<Long>(50000);
        Long last_groupid = 0L;
        int count = 1;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ++count;
            ids.add(row.getLong("fid"));
            Long groupid = row.getLong("fgroupid");
            Long hashcode = row.getLong("fhashcode");
            String key = "" + groupid + hashcode;
            if (cache.getKey() == null) {
                last_groupid = groupid;
                cache.setKey((Object)key);
            }
            DupCheckPojo currentObj = this.generateDupCheckPojo(row, inputParamMeta);
            if (key.equals(cache.getKey())) {
                if (!((List)cache.getValue()).isEmpty()) {
                    this.hasDupValue(currentObj, (List)cache.getValue(), serialNumsCache);
                }
                ((List)cache.getValue()).add(currentObj);
                continue;
            }
            if (!serialNumsCache.isEmpty()) {
                result.computeIfAbsent(last_groupid, k -> new LinkedList()).add(serialNumsCache);
                serialNumsCache = new TreeSet();
            }
            last_groupid = groupid;
            cache.setKey((Object)key);
            cache.setValue(new LinkedList());
            ((List)cache.getValue()).add(currentObj);
        }
        if (!serialNumsCache.isEmpty()) {
            result.computeIfAbsent(last_groupid, k -> new LinkedList()).add(serialNumsCache);
        }
        dataSet.close();
        if (count == 50000) {
            return new PairTuple(result, ids);
        }
        return new PairTuple(result, null);
    }

    private boolean hasDupValue(DupCheckPojo currentObj, List<DupCheckPojo> values, Set<Integer> serialNumsCache) {
        for (DupCheckPojo dupCheckPojo : values) {
            if (!currentObj.isEqual(dupCheckPojo)) continue;
            serialNumsCache.add(currentObj.getSerialNum());
            serialNumsCache.add(dupCheckPojo.getSerialNum());
            return true;
        }
        return false;
    }

    private DupCheckPojo generateDupCheckPojo(Row row, IValueSetMeta inputParamMeta) {
        DupCheckPojo dupCheckPojo = new DupCheckPojo();
        dupCheckPojo.setEffectdate(row.getDate("feffectdate"));
        dupCheckPojo.setExpiredate(row.getDate("fexpiredate"));
        dupCheckPojo.setSerialNum(row.getInteger("fserialnumber"));
        ArrayList<Object> values = new ArrayList<Object>(inputParamMeta.columnCnt());
        for (int columnIndex = 0; columnIndex < inputParamMeta.columnCnt(); ++columnIndex) {
            Object value = row.get(inputParamMeta.getColumnBySeq(columnIndex).getDbFieldNum());
            values.add(value);
        }
        dupCheckPojo.setValues(values);
        return dupCheckPojo;
    }

    public void checkDuplicate(Long mapTypeId, Consumer<Map<Long, ValueSetDuplicateCheckResultV2>> consumer) {
        MappingStructureMeta mappingMetaCached = MappingMetaCache.getMappingMetaCached((Long)mapTypeId, (Object[])new Object[0]);
        FlexFieldGrpCfg inputParamMeta = mappingMetaCached.getInputParamMeta();
        int startSN = -1;
        block12: while (true) {
            DataSet dataSet = this.queryMixMappingDataSet((IValueSetMeta)inputParamMeta, startSN);
            Throwable throwable = null;
            try {
                if (!dataSet.hasNext()) break;
                MixedValueMappingDataCollection mixedValueMappingDataCollection = new MixedValueMappingDataCollection((IValueSetMeta)inputParamMeta, dataSet);
                while (true) {
                    if (!mixedValueMappingDataCollection.hasNext()) continue block12;
                    DuplicateMappingCheckerContextV2 checkerContextV2 = this.checkDuplicateBatch(mixedValueMappingDataCollection);
                    consumer.accept(checkerContextV2.getDuplicateResultMap());
                    startSN = checkerContextV2.getSerialNumber();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
                continue;
            }
            break;
        }
    }

    private DataSet queryMixMappingDataSet(IValueSetMeta inputParamMeta, int startSN) {
        String batchSizeStr = SysParamConfig.getFromDB((String)"DuplicateMappingChecker.batchSize");
        int batchSize = Integer.parseInt(Optional.ofNullable(batchSizeStr).orElse("1000"));
        return this.daoInstance.queryMappingValues(inputParamMeta, StatusEnum.UNPUBLISHED.getCode(), null, startSN, batchSize, null);
    }

    public DuplicateMappingCheckerContextV2 checkDuplicateBatch(MixedValueMappingDataCollection toCheckDataCollection) {
        Iterable<IMapInput> mappingDataCollection;
        IValueSetMeta inputMeta = toCheckDataCollection.getInputMeta();
        DuplicateMappingCheckerContextV2 checkerContextV2 = new DuplicateMappingCheckerContextV2(inputMeta.columnCnt());
        for (IMapInput dataValueSet : toCheckDataCollection) {
            checkerContextV2.addAndCheckSingleValue((IDataValueSet)dataValueSet);
        }
        try (DataSet dataSet = this.daoInstance.queryAllMappingSingleValues(inputMeta.getTypeId(), inputMeta, StatusEnum.PUBLISHED.getCode());){
            mappingDataCollection = new SingleValueMappingDataCollection(inputMeta, dataSet);
            for (IMapInput iMapInput : mappingDataCollection) {
                checkerContextV2.checkSingleFromDBValue(iMapInput);
            }
        }
        dataSet = this.daoInstance.queryAllMappingMultiValues(inputMeta.getTypeId(), inputMeta, StatusEnum.PUBLISHED.getCode());
        var5_5 = null;
        try {
            mappingDataCollection = new MultiValueMappingDataCollection(inputMeta, dataSet);
            for (MappingData mappingData : mappingDataCollection) {
                IMapInput dataValueSetFromDB = this.transToDataValueSet(mappingData, inputMeta);
                checkerContextV2.checkSingleFromDBValue(dataValueSetFromDB);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var5_5 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return checkerContextV2;
    }

    private IMapInput transToDataValueSet(MappingData mappingData, IValueSetMeta inputMeta) {
        MapInput dataValueSet = new MapInput();
        dataValueSet.setMeta(inputMeta);
        Object[] values = new Set[inputMeta.columnCnt()];
        for (int columnIndex = 0; columnIndex < inputMeta.columnCnt(); ++columnIndex) {
            values[columnIndex] = mappingData.getMultiFieldValues(columnIndex);
        }
        dataValueSet.setValues(values);
        dataValueSet.setEffectDate(mappingData.getEffectDate());
        dataValueSet.setExpireDate(mappingData.getExpireDate());
        dataValueSet.setHasMulValue(true);
        dataValueSet.setId(Long.valueOf(mappingData.getMappingId()));
        dataValueSet.setSerialNumber(Integer.valueOf(mappingData.getSerialNumber()));
        dataValueSet.setStatus(mappingData.getStatus());
        return dataValueSet;
    }
}

