/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.DateUtil;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import kd.fi.v2.fah.models.mapping.ISearchParamValueSet;
import kd.fi.v2.fah.models.mapping.MappingDataCache;
import kd.fi.v2.fah.models.mapping.MappingMetaCache;
import kd.fi.v2.fah.models.mapping.MappingSearchParam;
import kd.fi.v2.fah.models.mapping.impl.ArrayDataValueSetImpl;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;
import kd.fi.v2.fah.models.mapping.impl.SearchParamValueSetCollection;
import kd.fi.v2.fah.models.valueset.IBaseValueSet;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.services.IDataMappingService;
import kd.fi.v2.fah.util.ValueSetAndMappingutil;
import kd.fi.v2.fah.utils.StringUtils;

public class SingleValueDataMappingServiceImpl
implements IDataMappingService {
    private static final Log logger = LogFactory.getLog(SingleValueDataMappingServiceImpl.class);
    private static final SingleValueDataMappingServiceImpl instance = new SingleValueDataMappingServiceImpl();

    public static SingleValueDataMappingServiceImpl getInstance() {
        return instance;
    }

    @Override
    public IBaseValueSet searchMatchMapping(ISearchParamValueSet searchParamValueSet) {
        boolean inCache = ValueSetAndMappingutil.checkMapCountCacheConfig(searchParamValueSet.getMeta().getTypeId());
        PairTuple<Integer, Long> outValueSetSNAndOrg = this.searchMappingSingleValue(searchParamValueSet, inCache);
        if (null == outValueSetSNAndOrg) {
            if (DebugTrace.enable()) {
                logger.info("searchMatchMapping not found, inCache: {}, searchParamValueSet: {}", (Object)inCache, (Object)searchParamValueSet);
            }
            return null;
        }
        return this.querySingleMappingOutValueSet((Integer)outValueSetSNAndOrg.getKey(), (Long)outValueSetSNAndOrg.getValue(), searchParamValueSet.getMeta().getTypeId(), ((MappingStructureMeta)searchParamValueSet.getMeta()).getOrgId(), inCache);
    }

    private PairTuple<Integer, Long> searchMappingSingleValue(ISearchParamValueSet searchParamValueSet, boolean inCache) {
        IValueSetMeta meta = searchParamValueSet.getMeta();
        Long mapTypeId = meta.getTypeId();
        Map mappingInMap = inCache ? MappingDataCache.getMappingInCache((Long)mapTypeId) : MappingDataCache.getMappingInByDB((Long)mapTypeId, (Long)searchParamValueSet.getHashCode());
        if (mappingInMap.size() <= 0) {
            return null;
        }
        List dataValueSetList = (List)mappingInMap.get(searchParamValueSet.getHashCode());
        if (CollectionUtils.isEmpty((Collection)dataValueSetList)) {
            return null;
        }
        ArrayDataValueSetImpl customData = null;
        ArrayDataValueSetImpl defaultData = null;
        for (ArrayDataValueSetImpl dataValueSet : dataValueSetList) {
            if (!dataValueSet.isSameData((IBaseValueSet)searchParamValueSet) || !DateUtil.isAffective((Date)searchParamValueSet.getQueryDate(), (Date)dataValueSet.getEffectDate(), (Date)dataValueSet.getExpireDate())) continue;
            if (Objects.equals(searchParamValueSet.getOrgId(), dataValueSet.getOrgGroupId())) {
                customData = dataValueSet;
            }
            if (!Objects.equals(((MappingStructureMeta)searchParamValueSet.getMeta()).getOrgId(), dataValueSet.getOrgGroupId())) continue;
            defaultData = dataValueSet;
        }
        if (null != customData) {
            return new PairTuple((Object)customData.getSerialNumber(), (Object)customData.getOrgGroupId());
        }
        if (null != defaultData) {
            return new PairTuple((Object)defaultData.getSerialNumber(), (Object)defaultData.getOrgGroupId());
        }
        return null;
    }

    private IBaseValueSet querySingleMappingOutValueSet(Integer outValueSetSN, Long outValueSetOrg, Long mapTypeId, Long mapTypeOrgId, boolean inCache) {
        Map mappingOutMap = inCache ? MappingDataCache.getMappingOutCache((Long)mapTypeId) : MappingDataCache.getMappingOutByDB((Integer)outValueSetSN, (Long)outValueSetOrg, (Long)mapTypeId, (Long)mapTypeOrgId);
        return (IBaseValueSet)mappingOutMap.computeIfAbsent(outValueSetOrg, k -> Collections.emptyMap()).get(outValueSetSN);
    }

    @Override
    public Long searchAcctMapping(Date bookDate, long mappingType, long acctTableId, ISearchParamValueSet searchParams) {
        if (DebugTrace.enable()) {
            logger.info("searchAcctMapping params, bookDate: {}, mappingType: {}, acctTableId: {}, searchParams: {}", new Object[]{bookDate, mappingType, acctTableId, searchParams});
        }
        if (this.isMetaInValid(mappingType, searchParams)) {
            return null;
        }
        MappingStructureMeta mappingMeta = MappingMetaCache.getMappingMetaCached((Long)mappingType, (Object[])new Object[0]);
        IBaseValueSet iBaseValueSet = this.searchMatchMapping(searchParams);
        if (DebugTrace.enable()) {
            logger.info("searchAcctMapping res1: {}", (Object)iBaseValueSet);
        }
        if (iBaseValueSet == null) {
            return null;
        }
        Integer outPutColumnIndex = mappingMeta.searchOutputColumnIndexByRefType("bd_accountview", Long.valueOf(acctTableId));
        if (outPutColumnIndex == null || outPutColumnIndex < 0) {
            logger.info("searchAcctMapping map data not found bd_accountview, mappingType:{}, acctTableId:{}", (Object)mappingType, (Object)acctTableId);
            return null;
        }
        Object accountNumValue = iBaseValueSet.get(outPutColumnIndex.intValue());
        if (StringUtils.isEmpty((Object)accountNumValue)) {
            return null;
        }
        String accountNum = (String)accountNumValue;
        return this.getAccountIdFromThreadCache(accountNum, acctTableId, bookDate, searchParams.getOrgId());
    }

    private Long getAccountIdFromThreadCache(String accountNum, long acctTableId, Date bookDate, Long orgId) {
        Map accountCache = (Map)ThreadCache.get((Object)"SingleValueDataMappingServiceImpl.getAccountIdFromThreadCache", HashMap::new);
        AccountCacheKey accountCacheKey = new AccountCacheKey(accountNum, acctTableId, bookDate, orgId);
        return accountCache.computeIfAbsent(accountCacheKey, k -> {
            LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
            qFilters.add(new QFilter("accounttable", "=", (Object)acctTableId));
            qFilters.add(new QFilter("number", "=", (Object)accountNum));
            qFilters.add(new QFilter("startdate", "<=", (Object)bookDate));
            qFilters.add(new QFilter("enddate", ">", (Object)bookDate));
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
            qFilters.add(baseDataFilter);
            DynamicObject account = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (null == account) {
                return null;
            }
            return account.getLong("id");
        });
    }

    @Override
    public Object searchAsstDimMapping(Date bookDate, long mappingType, Long asstDimId, ISearchParamValueSet searchParams) {
        if (DebugTrace.enable()) {
            logger.info("searchAsstDimMapping params, bookDate: {}, mappingType: {}, asstDimId: {}, searchParams: {}", new Object[]{bookDate, mappingType, asstDimId, searchParams});
        }
        if (this.isMetaInValid(mappingType, searchParams)) {
            return null;
        }
        MappingStructureMeta mappingMeta = MappingMetaCache.getMappingMetaCached((Long)mappingType, (Object[])new Object[0]);
        IBaseValueSet result = this.searchMatchMapping(searchParams);
        if (null == result) {
            return null;
        }
        Integer outPutColumnIndex = mappingMeta.searchOutputColumnIndexByRefType("bd_asstacttype", asstDimId);
        if (outPutColumnIndex != null && outPutColumnIndex >= 0) {
            if (DebugTrace.enable()) {
                logger.info("searchAsstDimMapping res, outPutColumnIndex:{}, result:{}", (Object)outPutColumnIndex, (Object)result);
            }
            return result.get(outPutColumnIndex.intValue());
        }
        if (DebugTrace.enable()) {
            logger.info("searchAsstDimMapping map data not found bd_asstacttype, mappingType:{}, asstDimId:{}", (Object)mappingType, (Object)asstDimId);
        }
        return null;
    }

    @Override
    public Long searchCashFlowItemMapping(Date bookDate, long mappingType, ISearchParamValueSet searchParams) {
        if (DebugTrace.enable()) {
            logger.info("searchCashFlowItemMapping params, bookDate: {}, mappingType: {}, searchParams: {}", new Object[]{bookDate, mappingType, searchParams});
        }
        if (this.isMetaInValid(mappingType, searchParams)) {
            return null;
        }
        MappingStructureMeta mappingMeta = MappingMetaCache.getMappingMetaCached((Long)mappingType, (Object[])new Object[0]);
        IBaseValueSet result = this.searchMatchMapping(searchParams);
        if (null == result) {
            return null;
        }
        Integer outPutColumnIndex = mappingMeta.searchOutputColumnIndexByRefEntity("gl_cashflowitem");
        if (outPutColumnIndex != null && outPutColumnIndex >= 0) {
            QFilter qFilter = new QFilter("number", "=", result.get(outPutColumnIndex.intValue()));
            QFilter baseDataFilter = SysBasePropDataDaoImpl.getBaseDataFilter((String)"gl_cashflowitem", (Long)searchParams.getOrgId());
            DynamicObject cashItem = QueryServiceHelper.queryOne((String)"gl_cashflowitem", (String)"id", (QFilter[])new QFilter[]{qFilter, baseDataFilter});
            if (DebugTrace.enable()) {
                logger.info("searchCashFlowItemMapping res, outPutColumnIndex:{}, result:{}, cashItem:{}", new Object[]{outPutColumnIndex, result, cashItem});
            }
            return null == cashItem ? null : Long.valueOf(cashItem.getLong("id"));
        }
        if (DebugTrace.enable()) {
            logger.info("searchCashFlowItemMapping map data not found gl_cashflowitem, mappingType:{}", (Object)mappingType);
        }
        return null;
    }

    private boolean isMetaInValid(long mappingType, ISearchParamValueSet searchParams) {
        MappingStructureMeta mappingMetaCached = MappingMetaCache.getMappingMetaCached((Long)mappingType, (Object[])new Object[0]);
        ((MappingSearchParam)searchParams).setMeta((IValueSetMeta)mappingMetaCached);
        return !mappingMetaCached.getEnabledOrgIdList().contains(searchParams.getOrgId());
    }

    @Override
    public Map<ISearchParamValueSet, IBaseValueSet> searchMatchMapping(Long mappingType, SearchParamValueSetCollection source) {
        return null;
    }

    public void batchSearchMapping(Long mappingType, SearchParamValueSetCollection source, BiConsumer<ISearchParamValueSet, IBaseValueSet> consumerFunc) {
    }

    private static class AccountCacheKey {
        private final String accountNum;
        private final long acctTableId;
        private final Date bookDate;
        private final Long orgId;

        public AccountCacheKey(String accountNum, long acctTableId, Date bookDate, Long orgId) {
            this.accountNum = accountNum;
            this.acctTableId = acctTableId;
            this.bookDate = bookDate;
            this.orgId = orgId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AccountCacheKey that = (AccountCacheKey)o;
            return this.acctTableId == that.acctTableId && Objects.equals(this.accountNum, that.accountNum) && Objects.equals(this.bookDate, that.bookDate) && Objects.equals(this.orgId, that.orgId);
        }

        public int hashCode() {
            return Objects.hash(this.accountNum, this.acctTableId, this.bookDate, this.orgId);
        }
    }
}

