/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.services.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.fi.v2.fah.models.register.RegisterBillType;
import kd.fi.v2.fah.models.register.RegisterBillTypeCollection;
import kd.fi.v2.fah.util.EventGenTaskUtils;

public class RegisterBillTypeCheckService {
    private static final RegisterBillTypeCheckService instance = new RegisterBillTypeCheckService();
    private volatile RegisterBillTypeCollection _registerBillTypeCollection_cache;

    public static RegisterBillTypeCheckService getInstance() {
        return instance;
    }

    protected RegisterBillTypeCollection reload_RegisterBillTypeCollection_cache() {
        return EventGenTaskUtils.getRegisterDateOrgFiled();
    }

    protected synchronized RegisterBillTypeCollection getRegisterBillTypeCollection_cache() {
        return this._registerBillTypeCollection_cache == null ? this.reload_RegisterBillTypeCollection_cache() : this._registerBillTypeCollection_cache;
    }

    public RegisterBillTypeCheckResult checkValidateBillType(Collection<String> srcBillTypes) {
        RegisterBillTypeCollection _lookup_cache = this.getRegisterBillTypeCollection_cache();
        RegisterBillTypeCheckResult result = new RegisterBillTypeCheckResult();
        for (String billType : srcBillTypes) {
            RegisterBillType billTypeInfo = _lookup_cache.getRegisterBillType(billType);
            if (billTypeInfo != null) {
                result.addValidBillType(billTypeInfo.clone());
                continue;
            }
            result.addInvalidBillType(billType);
        }
        return result;
    }

    public RegisterBillTypeCheckResult checkValidateBillType(String srcBillType) {
        return this.checkValidateBillType(Collections.singleton(srcBillType));
    }

    public static class RegisterBillTypeCheckResult
    implements Serializable {
        List<RegisterBillType> validBillType = new LinkedList<RegisterBillType>();
        List<String> invalidBillType = new LinkedList<String>();

        public boolean hasValidBillType() {
            return !this.validBillType.isEmpty();
        }

        public boolean addValidBillType(RegisterBillType srcBillTypeInfo) {
            return this.validBillType.add(srcBillTypeInfo);
        }

        public boolean addInvalidBillType(String srcBillTypeNum) {
            return this.invalidBillType.add(srcBillTypeNum);
        }

        public List<RegisterBillType> getValidBillType() {
            return this.validBillType;
        }

        public List<String> getInvalidBillType() {
            return this.invalidBillType;
        }
    }
}

