/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.instance.Instance;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.task.FahTaskStatus;
import kd.fi.v2.fah.task.status.TaskStatusEnum;
import kd.fi.v2.fah.utils.StringUtils;

public class FahTaskStatusPushService {
    private final Long rootId;
    private final Long parentId;
    private final Long taskId;
    private final String taskType;
    private String cacheKey;
    private static final String CACHE_KEY_PREFIX = "fah_task_status";
    private static final String COLON = ":";
    private static final int ONE_MONTH = 2592000;
    private final int expireSeconds;
    private final DistributeSessionlessCache taskStatusCache;

    public FahTaskStatusPushService(String taskType, Long taskId) {
        this(taskType, taskId, taskId, taskId);
    }

    public FahTaskStatusPushService(String taskType, Long rootId, Long taskId) {
        this(taskType, rootId, rootId, taskId);
    }

    public FahTaskStatusPushService(String taskType, Long rootId, Long parentId, Long taskId) {
        this.taskType = taskType;
        this.rootId = rootId;
        this.parentId = parentId;
        this.taskId = taskId;
        String expireSecondsConfig = SysParamConfig.get((String)"expireSecondsConfig");
        if (StringUtils.isEmpty((String)expireSecondsConfig)) {
            this.expireSeconds = 2592000;
        } else {
            assert (expireSecondsConfig != null);
            this.expireSeconds = Integer.parseInt(expireSecondsConfig);
        }
        this.taskStatusCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi");
    }

    public FahTaskStatus getStatus() {
        String hashKey = this.getCacheKey();
        byte[] value = this.taskStatusCache.hget(hashKey, StringUtils.encode((String)String.valueOf(this.taskId)));
        if (null == value || value.length == 0) {
            return null;
        }
        String fahTaskStatusJsonStr = StringUtils.decode((byte[])value);
        return (FahTaskStatus)JSON.parseObject((String)fahTaskStatusJsonStr, FahTaskStatus.class);
    }

    public List<FahTaskStatus> getAllStatus() {
        String hashKey = this.getCacheKey();
        LinkedList<FahTaskStatus> resList = new LinkedList<FahTaskStatus>();
        Map map = this.taskStatusCache.hgetAll(hashKey);
        for (byte[] value : map.values()) {
            if (null == value || value.length == 0) continue;
            String fahTaskStatusJsonStr = StringUtils.decode((byte[])value);
            FahTaskStatus fahTaskStatus = (FahTaskStatus)JSON.parseObject((String)fahTaskStatusJsonStr, FahTaskStatus.class);
            resList.add(fahTaskStatus);
        }
        return resList;
    }

    public void updateStatus(int percent) {
        this.updateStatus(percent, null);
    }

    public void updateStatus(int percent, String msg) {
        this.updateStatus(0, 0, percent, msg);
    }

    public void updateStatus(int totalPoints, int completePoints) {
        this.updateStatus(totalPoints, completePoints, null);
    }

    public void updateStatus(int totalPoints, int completePoints, String msg) {
        this.updateStatus(totalPoints, completePoints, 0, msg);
    }

    public void updateStatus(int totalPoints, int completePoints, int percent, String msg) {
        Date now = new Date();
        ThreadService.execute(() -> {
            FahTaskStatus taskStatus = this.getStatus();
            if (taskStatus == null) {
                taskStatus = new FahTaskStatus();
                taskStatus.setRootId(this.rootId);
                taskStatus.setParentId(this.parentId);
                taskStatus.setTaskId(this.taskId);
                taskStatus.setTaskType(this.taskType);
                taskStatus.setStart(now);
                taskStatus.setTaskStatus(String.valueOf(TaskStatusEnum.NEW.getCode()));
            }
            taskStatus.setTotalPoints(totalPoints);
            taskStatus.setCompletePoints(completePoints);
            taskStatus.setPercent(percent);
            taskStatus.setMsg(msg);
            if (percent > 0 || completePoints > 0) {
                taskStatus.setTaskStatus(String.valueOf(TaskStatusEnum.PROCESSING.getCode()));
            }
            if (percent >= 100 || completePoints >= totalPoints) {
                taskStatus.setEnd(now);
                taskStatus.setTaskStatus(String.valueOf(TaskStatusEnum.COMPLETED.getCode()));
            }
            String hashKey = this.getCacheKey();
            this.taskStatusCache.hset(hashKey, StringUtils.encode((String)String.valueOf(this.taskId)), StringUtils.encode((String)taskStatus.toString()), this.expireSeconds);
        }, (TaskType)TaskType.FAH_TASK_STATUS);
    }

    private String getCacheKey() {
        if (this.cacheKey == null) {
            RequestContext requestContext = RequestContext.get();
            this.cacheKey = Instance.getClusterName() + COLON + requestContext.getAccountId() + COLON + CACHE_KEY_PREFIX + COLON + this.taskType + COLON + this.rootId;
        }
        return this.cacheKey;
    }
}

