/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.FourTuple;
import kd.bos.db.DB;
import kd.fi.v2.fah.dao.task.FahBuildvchReportDao;
import kd.fi.v2.fah.models.xla.GenerateXLAErrorCode;

public class BuildVoucherReportInfoContext {
    private final Long requestId;
    private final String billType;
    private ReportBuildType reportBuildType;
    private Boolean hasBuildException = false;
    private final Map<GenerateXLAErrorCode, Set<Long>> errorInfoMap = new EnumMap<GenerateXLAErrorCode, Set<Long>>(GenerateXLAErrorCode.class);
    private final Map<Long, String> errorOperationMap = new HashMap<Long, String>(16);

    public BuildVoucherReportInfoContext(Long requestId, String billType, ReportBuildType reportBuildType) {
        this.requestId = requestId;
        this.billType = billType;
        this.reportBuildType = reportBuildType;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void genBatchErrorMessage(Set<Long> ids, GenerateXLAErrorCode xlaError) {
        if (!ids.isEmpty()) {
            this.errorInfoMap.computeIfAbsent(xlaError, v -> new HashSet()).addAll(ids);
        }
    }

    public void genBatchErrorMessage(Set<Long> ids, String errorMessage) {
        if (ids != null && !ids.isEmpty()) {
            ids.forEach(f -> this.errorOperationMap.put((Long)f, errorMessage));
        }
    }

    public void genStackErrorMessage(Exception exceptionInfo) {
        if (this.hasBuildException.booleanValue()) {
            return;
        }
        this.hasBuildException = true;
        this.taskToEnd();
    }

    public void genErrorMessage(Long id, GenerateXLAErrorCode xlaError) {
        this.errorInfoMap.computeIfAbsent(xlaError, v -> new HashSet()).add(id);
    }

    protected Map<Long, FourTuple<Long, Long, String, String>> getIdFromSrcIds(List<Long> allErrorIds) {
        switch (this.reportBuildType) {
            case GENXLAVOUCHER: {
                return FahBuildvchReportDao.queryEventFromSrcIds(allErrorIds);
            }
            case GROUPMERGEVOUCHER: {
                return FahBuildvchReportDao.queryXlaFromSrcIds(allErrorIds);
            }
            case PUSHGLVOUCHER: {
                return FahBuildvchReportDao.queryVoucherFromSrcIds(allErrorIds);
            }
        }
        return new HashMap<Long, FourTuple<Long, Long, String, String>>();
    }

    public void taskToEnd() {
        if (this.errorInfoMap.isEmpty() && this.errorOperationMap.isEmpty()) {
            return;
        }
        ArrayList<Long> allErrorIds = new ArrayList<Long>();
        if (!this.errorInfoMap.isEmpty()) {
            this.errorInfoMap.values().forEach(ids -> allErrorIds.addAll((Collection<Long>)ids));
        } else {
            allErrorIds.addAll(this.errorOperationMap.keySet());
        }
        Map<Long, FourTuple<Long, Long, String, String>> eventAndSrcBillMap = this.getIdFromSrcIds(allErrorIds);
        long[] newIds = DB.genLongIds((String)"t_fah_task_fail_bills", (int)allErrorIds.size());
        HashSet<Object> sourcebillIdCol = new HashSet<Object>(eventAndSrcBillMap.size());
        int i = 0;
        ArrayList<Object[]> params = new ArrayList<Object[]>(allErrorIds.size());
        for (Map.Entry<GenerateXLAErrorCode, Set<Long>> next : this.errorInfoMap.entrySet()) {
            for (Long id : next.getValue()) {
                FourTuple<Long, Long, String, String> sdata = eventAndSrcBillMap.get(id);
                if (sdata == null || !sourcebillIdCol.add(sdata.item1)) continue;
                params.add(new Object[]{newIds[i++], this.requestId, this.billType, sdata.item1, next.getKey().getErrorMessage(), Character.valueOf('8'), sdata.item2, sdata.item3});
            }
        }
        for (Map.Entry<Long, String> next : this.errorOperationMap.entrySet()) {
            FourTuple<Long, Long, String, String> sdata = eventAndSrcBillMap.get(next.getKey());
            if (sdata == null || !sourcebillIdCol.add(sdata.item1)) continue;
            params.add(new Object[]{newIds[i++], this.requestId, sdata.item4, sdata.item1, next.getValue(), Character.valueOf('9'), sdata.item2, sdata.item3});
        }
        FahBuildvchReportDao.insertErrorInfo(params);
        this.errorInfoMap.clear();
        this.errorOperationMap.clear();
    }

    public static enum ReportBuildType {
        GENXLAVOUCHER,
        GROUPMERGEVOUCHER,
        PUSHGLVOUCHER;

    }
}

