/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.context;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.fi.v2.fah.task.context.request.ProcessBillDataRootTaskContext;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.params.input.ReverseBillDataRootTaskInputParam;
import kd.fi.v2.fah.task.statistics.TaskBatchStatusStatistics;

public class ReverseBillDataRootTaskContext
extends ProcessBillDataRootTaskContext {
    protected ReverseBillDataRootTaskInputParam inputParam;
    protected transient Map<FahTaskGrpTypeEnum, Integer> taskGrpIdx;
    protected transient TaskBatchStatusStatistics[] subTaskBatchGrps;

    public ReverseBillDataRootTaskContext() {
    }

    public ReverseBillDataRootTaskContext(ReverseBillDataRootTaskInputParam inputParam) {
        if (inputParam == null) {
            throw new IllegalArgumentException("InputParam cannot be null!");
        }
        this.inputParam = inputParam;
    }

    public Long getRequestId() {
        return this.inputParam.getRequestId();
    }

    @Override
    public boolean isPreviewMode() {
        return this.inputParam.isPreviewMode();
    }

    @Override
    public Iterator<FahTaskGrpTypeEnum[]> getTaskGrpIterator() {
        return this.inputParam.getExecuteTaskGrp() == null ? Collections.emptyIterator() : Arrays.asList(this.inputParam.getExecuteTaskGrp()).iterator();
    }

    public TaskBatchStatusStatistics getTaskBatchGrpStatistic(FahTaskGrpTypeEnum taskGrpType) {
        if (this.taskGrpIdx == null) {
            return null;
        }
        Integer idx = this.taskGrpIdx.get(taskGrpType);
        return idx != null ? this.subTaskBatchGrps[idx] : null;
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FahTaskGrpTypeEnum[][] getExecuteTaskGrp() {
        return this.inputParam.getExecuteTaskGrp();
    }

    protected int updateTaskGrpIndex(FahTaskGrpTypeEnum[] includeTaskGrp) {
        int i = 0;
        if (includeTaskGrp != null && includeTaskGrp.length > 0) {
            this.taskGrpIdx = new HashMap<FahTaskGrpTypeEnum, Integer>(includeTaskGrp.length);
            this.subTaskBatchGrps = new TaskBatchStatusStatistics[includeTaskGrp.length];
            for (FahTaskGrpTypeEnum grp : includeTaskGrp) {
                this.taskGrpIdx.put(grp, i);
                this.subTaskBatchGrps[i] = new TaskBatchStatusStatistics();
                ++i;
            }
        }
        return i;
    }
}

