/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.context.request;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.fi.v2.fah.log.ProcessBillDataRequestTaskLogger;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.context.FahDataProcessTaskBaseContext;
import kd.fi.v2.fah.task.context.request.ProcessBillDataRequestInParamContext;
import kd.fi.v2.fah.task.context.request.ProcessBillRequestErrorContext;
import kd.fi.v2.fah.task.context.request.RequestTaskThresholdConfig;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.params.input.ProcessBillDataRootTaskInputParam;
import kd.fi.v2.fah.task.result.TaskBatchResultWrapper;

public class ProcessBillDataRootTaskContext
extends FahDataProcessTaskBaseContext {
    protected ProcessBillDataRequestInParamContext inputParamContext;
    protected RequestTaskThresholdConfig taskConfig;
    protected ProcessBillRequestErrorContext errorContext;
    protected Map<FahTaskGrpTypeEnum, FahTaskGrpTypeEnum> nextTaskLookupMap;
    protected transient ProcessBillDataRequestTaskLogger taskLogger;

    public ProcessBillDataRootTaskContext() {
        this.errorContext = new ProcessBillRequestErrorContext();
        this.taskConfig = new RequestTaskThresholdConfig();
    }

    public ProcessBillDataRootTaskContext(ProcessBillDataRootTaskInputParam inputParam) {
        this();
        if (inputParam == null) {
            throw new IllegalArgumentException("InputParam cannot be null!");
        }
        this.taskId = inputParam.getRequestId();
        this.inputParamContext = new ProcessBillDataRequestInParamContext(inputParam);
    }

    public ProcessBillDataRootTaskContext(Long requestId, FahTaskGrpTypeEnum[][] includeTaskGrp, Collection<String> billTypes, boolean isPreviewMode, int paramMode) {
        this.taskId = requestId;
        if (includeTaskGrp == null || includeTaskGrp.length == 0) {
            throw new IllegalArgumentException("Task Group Cannot be Empty!");
        }
        if (billTypes == null || billTypes.isEmpty()) {
            throw new IllegalArgumentException("Bill Type(s) Cannot be Empty!");
        }
        this.inputParamContext = new ProcessBillDataRequestInParamContext(includeTaskGrp, new ArrayList<String>(billTypes), isPreviewMode, paramMode);
    }

    public void setCurrentParallelTaskGrps(FahTaskGrpTypeEnum[] currentParallelTaskGrps) {
        if (currentParallelTaskGrps == null || currentParallelTaskGrps.length <= 1) {
            return;
        }
        int length = currentParallelTaskGrps.length;
        if (this.nextTaskLookupMap == null) {
            this.nextTaskLookupMap = new HashMap<FahTaskGrpTypeEnum, FahTaskGrpTypeEnum>(length);
        }
        int idx = 0;
        FahTaskGrpTypeEnum parent = currentParallelTaskGrps[idx];
        FahTaskGrpTypeEnum child = null;
        while (idx < length) {
            child = currentParallelTaskGrps[++idx];
            this.nextTaskLookupMap.put(parent, child);
            parent = child;
        }
        if (child != null) {
            this.nextTaskLookupMap.put(child, null);
        }
    }

    public FahTaskGrpTypeEnum getNextTaskTypeOnCurrentParallelGrp(FahTaskGrpTypeEnum currentTaskGrpType) {
        return this.nextTaskLookupMap != null ? this.nextTaskLookupMap.get(currentTaskGrpType) : null;
    }

    public void cacheBatchResult(IFahDataWorkTask srcWorkTask, int batchSeqNo, Object batchResult) {
        if (batchResult == null) {
            return;
        }
        FahTaskGrpTypeEnum nextTaskGrpType = this.getNextTaskTypeOnCurrentParallelGrp((FahTaskGrpTypeEnum)srcWorkTask.getTaskTypeCode());
        if (nextTaskGrpType == null) {
            return;
        }
        TaskBatchResultWrapper batchResultWrapper = new TaskBatchResultWrapper(nextTaskGrpType, batchSeqNo, batchResult.getClass(), batchResult);
    }

    public boolean isActive() {
        return this.taskGroupCondition.isActive();
    }

    public void setActive(boolean active) {
        this.taskGroupCondition.setActive(active);
    }

    public synchronized boolean isCompleted() {
        return this.taskStatus.isTaskEnd();
    }

    public boolean isPreviewMode() {
        return this.inputParamContext.isPreviewMode();
    }

    @JSONField(serialize=false)
    @JsonIgnore
    public FahTaskGrpTypeEnum[][] getIncludeTaskGrp() {
        return this.inputParamContext.getExecuteTaskGrp();
    }

    public Iterator<FahTaskGrpTypeEnum[]> getTaskGrpIterator() {
        return this.inputParamContext.getExecuteTaskGrp() == null ? Collections.emptyIterator() : Arrays.asList(this.inputParamContext.getExecuteTaskGrp()).iterator();
    }

    public ProcessBillDataRequestInParamContext getInputParamContext() {
        return this.inputParamContext;
    }

    public void setInputParamContext(ProcessBillDataRequestInParamContext inputParamContext) {
        this.inputParamContext = inputParamContext;
    }

    public RequestTaskThresholdConfig getTaskConfig() {
        return this.taskConfig;
    }

    public void setTaskConfig(RequestTaskThresholdConfig taskConfig) {
        this.taskConfig = taskConfig;
    }

    public ProcessBillRequestErrorContext getErrorContext() {
        return this.errorContext;
    }

    public void setErrorContext(ProcessBillRequestErrorContext errorContext) {
        this.errorContext = errorContext;
    }

    public ProcessBillDataRequestTaskLogger getTaskLogger() {
        return this.taskLogger;
    }

    public void setTaskLogger(ProcessBillDataRequestTaskLogger taskLogger) {
        this.taskLogger = taskLogger;
    }
}

