/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.maintask;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.fi.v2.fah.cache.common.ITaskResultCacheManager;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;
import kd.fi.v2.fah.task.FahDataProcessTaskFactory;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTaskEx;
import kd.fi.v2.fah.task.common.DummyFuture;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.context.ReverseBillDataRootTaskContext;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.params.input.IProcessBillDataTaskInputParam;
import kd.fi.v2.fah.task.params.input.ReverseBillDataRootTaskInputParam;
import kd.fi.v2.fah.task.params.input.ReverseEventSubTaskInputParam;
import kd.fi.v2.fah.task.params.input.ReverseGLSubTaskInputParam;
import kd.fi.v2.fah.task.params.input.ReverseWriteBackBillVchStatusInputParam;
import kd.fi.v2.fah.task.params.input.ReverseWriteBackInputParam;
import kd.fi.v2.fah.task.params.input.ReverseXLASubTaskInputParam;
import kd.fi.v2.fah.task.params.output.ReverseEventSubTaskOutputParam;
import kd.fi.v2.fah.task.result.FahSimpleTaskResult;
import kd.fi.v2.fah.task.statistics.FahTaskGrpBatchBarrier;
import kd.fi.v2.fah.task.statistics.TaskBatchStatusStatistics;
import kd.fi.v2.fah.task.subtask.ReverseEventSubTask;
import kd.fi.v2.fah.task.subtask.ReverseGLSubTask;
import kd.fi.v2.fah.task.subtask.ReverseWriteBackBillVchStatusSubTask;
import kd.fi.v2.fah.task.subtask.ReverseWriteBackSubTask;
import kd.fi.v2.fah.task.subtask.ReverseXLASubTask;

public class ProcessReverseDataRootTask
extends AbstractCommonDataWorkTaskEx<ReverseBillDataRootTaskInputParam, FahSimpleTaskResult, ReverseBillDataRootTaskContext>
implements ITaskStatusChangeListener {
    private static final Log logger = LogbackFactory.getLog(ProcessReverseDataRootTask.class);
    protected static FahDataProcessTaskFactory factory = FahDataProcessTaskFactory.getInstance();
    protected ITaskResultCacheManager cacheService;
    protected Queue<Future<?>> currentTaskGrpSubTaskFutures;
    protected FahTaskGrpBatchBarrier taskGrpBatchBarrier;
    protected boolean enableParallel = false;

    public void beforeTaskStart(IFahDataWorkTask srcWorkTask) {
    }

    public ProcessReverseDataRootTask(ReverseBillDataRootTaskInputParam inputParam) {
        super(inputParam);
        this.rootTaskContext = new ReverseBillDataRootTaskContext(inputParam);
        this.taskGrpBatchBarrier = new FahTaskGrpBatchBarrier();
        this.cacheService = new SimpleDataDistributeCacheService();
        this.taskResult = new FahSimpleTaskResult();
    }

    protected FahSimpleTaskResult doTaskJob() throws Exception {
        long requestId_cache = ((ReverseBillDataRootTaskContext)this.rootTaskContext).getRequestId();
        String cacheTypeKey = this.cacheService.buildCacheTypeKey((Object)requestId_cache, new Object[]{FahTaskGrpTypeEnum.Reverse_Bill_Data_RootTaskGrp.name()});
        Iterator<FahTaskGrpTypeEnum[]> taskGrpIterator = ((ReverseBillDataRootTaskContext)this.rootTaskContext).getTaskGrpIterator();
        this.currentTaskGrpSubTaskFutures = new LinkedList();
        block8: while (this.taskGroupCondition.isActive() && !this.taskGroupCondition.isCancelled() && taskGrpIterator.hasNext()) {
            FahTaskGrpTypeEnum taskGrp = taskGrpIterator.next()[0];
            if (taskGrp == null) continue;
            TaskBatchStatusStatistics taskBatches = ((ReverseBillDataRootTaskContext)this.rootTaskContext).getTaskBatchGrpStatistic(taskGrp);
            switch (taskGrp) {
                case Reverse_GL_Voucher_TaskGrp: {
                    ReverseGLSubTaskInputParam glParam = new ReverseGLSubTaskInputParam();
                    glParam.setRequestId(((ReverseBillDataRootTaskInputParam)this.inputParam).getRequestId());
                    ReverseGLSubTask subTask = (ReverseGLSubTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)glParam, (ITaskStatusChangeListener)this, this.taskGroupCondition);
                    subTask.call();
                    break;
                }
                case Reverse_XLA_TaskGrp: {
                    ReverseEventSubTaskOutputParam input1 = (ReverseEventSubTaskOutputParam)this.cacheService.getAndRemove((Object)cacheTypeKey, (Object)0, ReverseEventSubTaskOutputParam.class);
                    logger.info("ReverseEventSubTaskOutputParam:{}", (Object)input1);
                    ReverseXLASubTaskInputParam xlaParam = new ReverseXLASubTaskInputParam();
                    xlaParam.setMaps(input1.getMaps());
                    xlaParam.setRequestId(((ReverseBillDataRootTaskInputParam)this.inputParam).getRequestId());
                    xlaParam.setBillType(input1.getBillType());
                    xlaParam.setIds(input1.getIds());
                    ReverseXLASubTask subTask1 = (ReverseXLASubTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)xlaParam, (ITaskStatusChangeListener)this, this.taskGroupCondition);
                    subTask1.call();
                    break;
                }
                case Reverse_Event_TaskGrp: {
                    ReverseEventSubTaskInputParam eventParam = new ReverseEventSubTaskInputParam();
                    eventParam.setRequestId(((ReverseBillDataRootTaskInputParam)this.inputParam).getRequestId());
                    ReverseEventSubTask subTask2 = (ReverseEventSubTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)eventParam, (ITaskStatusChangeListener)this, this.taskGroupCondition);
                    subTask2.call();
                    break;
                }
                case Reverse_Update_Evt_Xla_Tracker_TaskGrp: {
                    ReverseWriteBackInputParam updateEvtXlaParam = new ReverseWriteBackInputParam();
                    updateEvtXlaParam.setRequestId(((ReverseBillDataRootTaskInputParam)this.inputParam).getRequestId());
                    ReverseWriteBackSubTask subTask3 = (ReverseWriteBackSubTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)updateEvtXlaParam, (ITaskStatusChangeListener)this, this.taskGroupCondition);
                    subTask3.call();
                    break;
                }
                case GLVoucher_Writeback_TaskGrp: {
                    ReverseWriteBackBillVchStatusInputParam writeBackParam = new ReverseWriteBackBillVchStatusInputParam();
                    writeBackParam.setRequestId(((ReverseBillDataRootTaskInputParam)this.inputParam).getRequestId());
                    ReverseWriteBackBillVchStatusSubTask subTaskBill = (ReverseWriteBackBillVchStatusSubTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)writeBackParam, (ITaskStatusChangeListener)this, this.taskGroupCondition);
                    subTaskBill.call();
                    break;
                }
                case Clean_Data_TaskGrp: {
                    break;
                }
                default: {
                    this.onException(this, this.currentBatchSeqNo, "No support Task Group Code:" + taskGrp, taskGrp, null);
                    continue block8;
                }
            }
            cacheTypeKey = this.cacheService.buildCacheTypeKey((Object)requestId_cache, new Object[]{taskGrp.name()});
            this.waitTaskGrpCompleted();
        }
        return (FahSimpleTaskResult)this.taskResult;
    }

    protected void waitTaskGrpCompleted() {
        for (Future future : this.currentTaskGrpSubTaskFutures) {
            if (future == null) continue;
            try {
                future.get();
            }
            catch (Exception ex) {
                this.onException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends IProcessBillDataTaskInputParam> int executeBatch(TaskBatchStatusStatistics taskBatches, String cacheTypeKey, Class<T> inputParamClassType) throws Exception {
        if (taskBatches == null) {
            return 0;
        }
        int executedBatchCnt = 0;
        while (taskBatches.hasNext()) {
            T inputParam = this.getTaskInputParamBatches(cacheTypeKey, taskBatches.next(), inputParamClassType);
            if (inputParam == null) continue;
            ProcessReverseDataRootTask processReverseDataRootTask = this;
            synchronized (processReverseDataRootTask) {
                this.currentTaskGrpSubTaskFutures.add(this.executeSubTask((IProcessBillDataTaskInputParam)inputParam));
            }
            ++executedBatchCnt;
        }
        return executedBatchCnt;
    }

    protected <T extends IProcessBillDataTaskInputParam> T getTaskInputParamBatches(String cacheTypeKey, int batchSeqNo, Class<T> inputParamClassType) {
        IProcessBillDataTaskInputParam inputParam = (IProcessBillDataTaskInputParam)this.cacheService.getAndRemove((Object)cacheTypeKey, (Object)batchSeqNo, inputParamClassType);
        if (inputParam != null) {
            inputParam.setBatchSeqNo(batchSeqNo);
        }
        return (T)inputParam;
    }

    protected Future executeSubTask(IProcessBillDataTaskInputParam inputParam) throws Exception {
        Object subTask = factory.buildTaskInstance(inputParam, this);
        if (this.enableParallel) {
            return null;
        }
        return new DummyFuture<Object>(subTask.call());
    }

    public boolean onException(IFahDataWorkTask srcWorkTask, int batchSeqNo, String errorMsg, Object errorDataParam, Throwable ex) {
        this.taskStatusChangeListener.onException(srcWorkTask, batchSeqNo, errorMsg, errorDataParam, ex);
        this.getTaskGroupCondition().cancel(true);
        return false;
    }

    public boolean onBatchCompleted(IFahDataWorkTask srcWorkTask, int batchSeqNo, Object batchResult, boolean withError) {
        if (srcWorkTask == null) {
            return true;
        }
        FahTaskGrpTypeEnum taskGrpType = (FahTaskGrpTypeEnum)srcWorkTask.getTaskTypeCode();
        String cacheTypeKey = this.cacheService.buildCacheTypeKey((Object)((ReverseBillDataRootTaskContext)this.rootTaskContext).getRequestId(), new Object[]{taskGrpType});
        this.cacheService.put((Object)cacheTypeKey, (Object)batchSeqNo, batchResult);
        this.taskGrpBatchBarrier.addTaskGrpBatchCnt(((ReverseBillDataRootTaskInputParam)this.inputParam).getTaskGrpType());
        return true;
    }

    public boolean onPartitionGrpCompleted(IFahDataWorkTask srcWorkTask) {
        return false;
    }

    public void afterTaskCompleted(IFahDataWorkTask srcWorkTask, Object taskResult, boolean withError) {
        FahTaskGrpTypeEnum taskGrpType = (FahTaskGrpTypeEnum)srcWorkTask.getTaskTypeCode();
        String cacheTypeKey = this.cacheService.buildCacheTypeKey((Object)((ReverseBillDataRootTaskContext)this.rootTaskContext).getRequestId(), new Object[]{taskGrpType});
        switch (taskGrpType) {
            case Reverse_Event_TaskGrp: {
                this.cacheService.put((Object)cacheTypeKey, (Object)0, taskResult);
                break;
            }
        }
    }
}

