/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.maintask;

import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.dao.task.FahRequestTaskDaoImpl;
import kd.fi.v2.fah.models.register.RegisterBillType;
import kd.fi.v2.fah.models.request.FahRequestProcessBillDataBatchDTO;
import kd.fi.v2.fah.models.request.FahRequestProcessBillDataTaskDTO;
import kd.fi.v2.fah.services.cache.RegisterBillTypeCheckService;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTask;
import kd.fi.v2.fah.task.common.FahTaskGroupCondition;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.params.input.SubmitProcessBillDataRequestTaskInputParam;
import kd.fi.v2.fah.task.result.FahSimpleTaskResult;
import kd.fi.v2.fah.util.BuildEvtDataUtil;

public abstract class SubmitProcessBillDataRequestTask
extends AbstractCommonDataWorkTask<SubmitProcessBillDataRequestTaskInputParam> {
    protected RegisterBillTypeCheckService billTypeCheckService = RegisterBillTypeCheckService.getInstance();
    protected RegisterBillTypeCheckService.RegisterBillTypeCheckResult billTypeCheckResult;
    protected BiFunction<String, Integer, long[]> idProvider;
    protected int batchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.buildEvtBillBatchSize", (String)"999"));

    public SubmitProcessBillDataRequestTask(SubmitProcessBillDataRequestTaskInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener, FahTaskGroupCondition taskGroupCondition) {
        super(inputParam, taskStatusChangeListener, taskGroupCondition);
    }

    public SubmitProcessBillDataRequestTask(SubmitProcessBillDataRequestTaskInputParam inputParam, ITaskStatusChangeListener taskStatusChangeListener) {
        super(inputParam, taskStatusChangeListener);
    }

    public SubmitProcessBillDataRequestTask(SubmitProcessBillDataRequestTaskInputParam inputParam) {
        super(inputParam);
    }

    @Override
    public Class getBatchResultClassType() {
        return FahRequestProcessBillDataBatchDTO.class;
    }

    protected FahSimpleTaskResult doTaskJob() throws Exception {
        this.billTypeCheckResult = this.checkValidateBillTypes();
        long requestId = ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getRequestId();
        if (requestId <= 0L) {
            requestId = this.idProvider.apply("t_fah_request_task", 1)[0];
        }
        ((FahSimpleTaskResult)this.taskResult).setRequestId(Long.valueOf(requestId));
        FahRequestProcessBillDataTaskDTO requestTaskDTO = this.buildRequestTaskDTO(requestId);
        int notSplitBatchSize = this.batchSize / 3;
        int totalBatchCnt = 0;
        try (TXHandle h = TX.requiresNew();){
            for (RegisterBillType billType : this.billTypeCheckResult.getValidBillType()) {
                totalBatchCnt += this.createRequestBatch(requestTaskDTO, totalBatchCnt, billType, this.batchSize, notSplitBatchSize);
            }
            this.saveRequestTaskDTO(requestTaskDTO);
        }
        return (FahSimpleTaskResult)this.taskResult;
    }

    protected FahRequestProcessBillDataTaskDTO buildRequestTaskDTO(long requestId) {
        FahRequestProcessBillDataTaskDTO dataTaskDTO = new FahRequestProcessBillDataTaskDTO();
        dataTaskDTO.setId(requestId);
        if (null != ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange()) {
            dataTaskDTO.setQueryStartDate(((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange()[0]);
            dataTaskDTO.setQueryEndDate(((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange()[1]);
        }
        dataTaskDTO.setProcessEvtCnt(((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getSrcIds().size());
        return dataTaskDTO;
    }

    protected boolean saveRequestTaskDTO(FahRequestProcessBillDataTaskDTO requestTaskDTO) {
        String taskType = this.getTaskType();
        if (null == ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange()) {
            FahRequestTaskDaoImpl.createNewRequest(requestTaskDTO.getId(), ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getBillTypes(), ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getOrgIds(), taskType, ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getSrcIds().size(), null, null);
        } else {
            FahRequestTaskDaoImpl.createNewRequest(requestTaskDTO.getId(), ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getBillTypes(), ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getOrgIds(), taskType, ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getSrcIds().size(), ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange()[0], ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getQueryDateRange()[1]);
        }
        return true;
    }

    public String getTaskType() {
        Map<String, String> paramMap = ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).getSrcOperationParamMap();
        if (null == paramMap) {
            return FahEventGenOprEnum.REVERSE_GL_XLA_EVENT.getCode();
        }
        boolean previewMode = ((SubmitProcessBillDataRequestTaskInputParam)this.inputParam).isPreviewMode();
        String paramMode = paramMap.get("includeTaskGrp");
        String taskType = FahEventGenOprEnum.CREATE_EVENT.getCode();
        if (null != paramMode) {
            boolean contains = paramMode.contains(String.valueOf(FahTaskGrpTypeEnum.GLVoucher_Validate_And_Sumbit_TaskGrp.getCode()));
            if (!contains && previewMode) {
                taskType = FahEventGenOprEnum.CREATE_TMP_EVENT.getCode();
            }
            if (contains && !previewMode) {
                taskType = FahEventGenOprEnum.CREATE_EVENT_DELIVER_GL.getCode();
            }
        }
        return taskType;
    }

    protected abstract int createRequestBatch(FahRequestProcessBillDataTaskDTO var1, int var2, RegisterBillType var3, int var4, int var5);

    protected FahRequestProcessBillDataBatchDTO buildRequestTaskBatchDTO(long requestId, int seqNo, RegisterBillType billType, Collection<Long> srcBillIds) {
        FahRequestProcessBillDataBatchDTO batchDTO = new FahRequestProcessBillDataBatchDTO(requestId, seqNo, billType.getBillType());
        long batchId = this.idProvider.apply("t_fah_task_batch", 1)[0];
        batchDTO.setId(batchId);
        batchDTO.setSrcBillIds(srcBillIds);
        return batchDTO;
    }

    protected int saveRequestTaskBatachDTO(FahRequestProcessBillDataBatchDTO requestTaskBatchDTO) {
        BuildEvtDataUtil.saveFahTaskBatch(requestTaskBatchDTO.getId(), requestTaskBatchDTO.getRequestId(), requestTaskBatchDTO.getSeqNo(), requestTaskBatchDTO.getSrcBillType(), requestTaskBatchDTO.getSrcBillIds());
        this.cacheData(requestTaskBatchDTO);
        this.taskStatusChangeListener.onBatchCompleted((IFahDataWorkTask)this, requestTaskBatchDTO.getSeqNo(), (Object)requestTaskBatchDTO, false);
        return requestTaskBatchDTO.getSeqNo();
    }

    protected abstract RegisterBillTypeCheckService.RegisterBillTypeCheckResult checkValidateBillTypes();

    public void setBillTypeCheckService(RegisterBillTypeCheckService billTypeCheckService) {
        this.billTypeCheckService = billTypeCheckService;
    }

    public BiFunction<String, Integer, long[]> getIdProvider() {
        return this.idProvider;
    }

    public void setIdProvider(BiFunction<String, Integer, long[]> idProvider) {
        this.idProvider = idProvider;
    }
}

