/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.task.params.input;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.sqlbuilder.filter.SimpleQFilter;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.params.input.AbstractProcessBillDataTaskInputParam;

public class SubmitProcessBillDataRequestTaskInputParam
extends AbstractProcessBillDataTaskInputParam {
    public static final int ParamMode_Single_BillType = 0;
    public static final int ParamMode_Multi_BillType_WithCommonFilter = 1;
    public static final int ParamMode_Multi_BillType_WithCustomFilter = 2;
    protected Map<String, String> srcOperationParamMap;
    protected int paramMode;
    protected String billType;
    protected Collection<String> billTypes;
    protected String billStatus;
    protected FahTaskGrpTypeEnum[][] executeTaskGrp;
    protected Date[] queryDateRange;
    protected Collection<Long> orgIds;
    protected Map<String, List<SimpleQFilter>> customBillQueryConditions;

    public SubmitProcessBillDataRequestTaskInputParam() {
    }

    public SubmitProcessBillDataRequestTaskInputParam(String billType, Collection<Long> srcBillIds, FahTaskGrpTypeEnum[][] executeTaskGrp) {
        this.paramMode = 0;
        this.billType = billType;
        this.srcIds = srcBillIds;
        this.executeTaskGrp = executeTaskGrp;
    }

    public SubmitProcessBillDataRequestTaskInputParam(Collection<String> billTypes, Date queryStartDate, Date queryEndDate, Collection<Long> orgIds, FahTaskGrpTypeEnum[][] executeTaskGrp) {
        this.paramMode = 1;
        this.billTypes = billTypes;
        this.queryDateRange = new Date[]{queryStartDate, queryEndDate};
        this.orgIds = orgIds;
        this.executeTaskGrp = executeTaskGrp;
    }

    public SubmitProcessBillDataRequestTaskInputParam(Map<String, List<SimpleQFilter>> customBillQueryConditions, FahTaskGrpTypeEnum[][] executeTaskGrp) {
        this.paramMode = 2;
        this.customBillQueryConditions = customBillQueryConditions;
        this.executeTaskGrp = executeTaskGrp;
    }

    public void addBillQueryCondition(String billType, List<SimpleQFilter> queryFilters) {
        if (queryFilters == null || queryFilters.isEmpty()) {
            return;
        }
        this.paramMode = 2;
        if (this.customBillQueryConditions == null) {
            this.customBillQueryConditions = new HashMap<String, List<SimpleQFilter>>(4);
        }
        this.customBillQueryConditions.computeIfAbsent(billType, v -> new LinkedList()).addAll(queryFilters);
    }

    public String toString() {
        return "SubmitProcessBillDataRequestTaskInputParam{billType='" + this.billType + '\'' + ", executeTaskGrp=" + Arrays.toString((Object[])this.executeTaskGrp) + ", queryDateRange=" + Arrays.toString(this.queryDateRange) + ", orgIds=" + this.orgIds + ", customBillQueryConditions=" + this.customBillQueryConditions + ", requestId=" + this.requestId + ", batchSeqNo=" + this.batchSeqNo + ", taskType=" + this.getTaskGrpType() + ", srcIds=" + this.srcIds + ", paramMode=" + this.paramMode + '}';
    }

    public String getBillType() {
        return this.billType;
    }

    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public Date[] getQueryDateRange() {
        return this.queryDateRange;
    }

    public void setQueryDateRange(Date[] queryDateRange) {
        this.queryDateRange = queryDateRange;
    }

    public Collection<Long> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(Collection<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public Map<String, List<SimpleQFilter>> getCustomBillQueryConditions() {
        return this.customBillQueryConditions;
    }

    public void setCustomBillQueryConditions(Map<String, List<SimpleQFilter>> customBillQueryConditions) {
        this.customBillQueryConditions = customBillQueryConditions;
    }

    public Collection<String> getBillTypes() {
        return this.billTypes;
    }

    public void setBillTypes(Collection<String> billTypes) {
        this.billTypes = billTypes;
    }

    public FahTaskGrpTypeEnum getTaskGrpType() {
        return FahTaskGrpTypeEnum.Submit_Bill_Request_TaskGrp;
    }

    public BackgroundTaskTypeEnum getOwnerTaskType() {
        return BackgroundTaskTypeEnum.Submit_Bill_Request_Task;
    }

    public int getParamMode() {
        return this.paramMode;
    }

    public void setParamMode(int paramMode) {
        this.paramMode = paramMode;
    }

    public FahTaskGrpTypeEnum[][] getExecuteTaskGrp() {
        return this.executeTaskGrp;
    }

    public void setExecuteTaskGrp(FahTaskGrpTypeEnum[][] executeTaskGrp) {
        this.executeTaskGrp = executeTaskGrp;
    }

    public Map<String, String> getSrcOperationParamMap() {
        return this.srcOperationParamMap;
    }

    public void setSrcOperationParamMap(Map<String, String> srcOperationParamMap) {
        this.srcOperationParamMap = srcOperationParamMap;
    }
}

