/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.v2.fah.constant.enums.event.DataChangeTypeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.config.event.FahDispatchRuleDaoImpl;
import kd.fi.v2.fah.event.DispatchZoneFieldSettingInfo;
import kd.fi.v2.fah.event.DispatchZoneInfo;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchRuleData;
import kd.fi.v2.fah.utils.StringUtils;

public class EventDispatchSchemeUtils {
    public static void gengerateDeleteData(Long pkId, String batchId, Long orgId, String valueZone) {
        LinkedList<EventDispatchRuleData> deleteData = new LinkedList<EventDispatchRuleData>();
        try (DataSet dataSet = FahDispatchRuleDaoImpl.queryDataSet(pkId, batchId, orgId, valueZone, null, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                EventDispatchRuleData data = new EventDispatchRuleData();
                data.setId(row.getLong("id"));
                data.setInParamKey(new LinkedList());
                data.setDispatchId(pkId);
                data.setSerialNumber(row.getInteger("serialnumber").intValue());
                data.setOrgId(row.getLong("orgid"));
                data.setValueZone(row.getString("valuezone"));
                data.setBatchId(batchId);
                data.setEnable("0");
                data.setNeedGenEvt("0");
                data.setStatus("A");
                data.setChangeType(DataChangeTypeEnum.DELETE.getCode());
                data.setDispGrp(Long.valueOf(0L));
                deleteData.add(data);
            }
        }
        if (!deleteData.isEmpty()) {
            HashMap<DataChangeTypeEnum, List<EventDispatchRuleData>> tempData = new HashMap<DataChangeTypeEnum, List<EventDispatchRuleData>>();
            tempData.put(DataChangeTypeEnum.DELETE, deleteData);
            FahDispatchRuleDaoImpl.insertTempData(null, tempData);
        }
    }

    public static String findFieldNameByNumber(String sourceBill, String zone) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        if (mainEntityType.getAllFields().containsKey(zone)) {
            return ((IDataEntityProperty)mainEntityType.getAllFields().get(zone)).getDisplayName().getLocaleValue();
        }
        if (mainEntityType.getAllEntities().containsKey(zone)) {
            return ((EntityType)mainEntityType.getAllEntities().get(zone)).getDisplayName().getLocaleValue();
        }
        return null;
    }

    public static List<ComboItem> getComboItemList(String sourceBill, Collection<String> numbers) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        for (EntityType entityType : mainEntityType.getAllEntities().values()) {
            if (entityType instanceof LinkEntryType || !numbers.contains(entityType.getName())) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(entityType.getDisplayName().toString()));
            comboItem.setValue(entityType.getName());
            items.add(comboItem);
        }
        return items;
    }

    public static String getSourceBillEntryName(String sourcebill, String sourcefield) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourcebill);
        if (null == mainEntityType.getAllFields().get(sourcefield)) {
            return sourcebill + "bill metadata not contains field:" + sourcefield;
        }
        return ((IDataEntityProperty)mainEntityType.getAllFields().get(sourcefield)).getDisplayName().getLocaleValue();
    }

    public static MappingValueTypeOrg findOrgById(List<MappingValueTypeOrg> orgList, Long id) {
        for (MappingValueTypeOrg org : orgList) {
            if (((Long)org.getId()).longValue() != id.longValue()) continue;
            return org;
        }
        return null;
    }

    public static TreeNode getRoot(List<MappingValueTypeOrg> orgList, Long orgId, String orgName, IPageCache pageCache) {
        TreeNode root = new TreeNode();
        root.setId("root");
        root.setIsOpened(true);
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8\u7ec4\u7ec7", (String)"FahValMapEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        LinkedHashMap<String, TreeNode> treeNodeMap = new LinkedHashMap<String, TreeNode>();
        TreeNode createOrg = new TreeNode();
        createOrg.setId(ObjectConverterFactory.getString((Object)orgId));
        createOrg.setLongNumber(ObjectConverterFactory.getString((Object)orgId));
        orgName = orgName + ResManager.loadKDString((String)"(\u9ed8\u8ba4\u7ec4\u7ec7)", (String)"FahValMapEdit_17", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        createOrg.setText(orgName);
        treeNodeMap.put(createOrg.getId(), createOrg);
        root.addChild(createOrg);
        if (orgList != null && !orgList.isEmpty()) {
            for (MappingValueTypeOrg org : orgList) {
                if (!org.isCustom().booleanValue() || ((Long)org.getId()).longValue() == orgId.longValue()) continue;
                TreeNode node = new TreeNode();
                String orgGroupId = ObjectConverterFactory.getString((Object)org.getId());
                node.setId(orgGroupId);
                node.setText(org.getName());
                node.setLongNumber(org.getNumber());
                treeNodeMap.put(orgGroupId, node);
                root.addChild(node);
            }
        }
        pageCache.put("treeNodeMap", SerializationUtils.serializeToBase64(treeNodeMap));
        return root;
    }

    public static String getFullNameByFullNumber(String fullnumber, Map<String, String> ruleNumberNameMap) {
        String[] split;
        StringBuilder sb = new StringBuilder();
        for (String number : split = fullnumber.split(",")) {
            sb.append(ruleNumberNameMap.get(number)).append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    public static Map<String, String> getValueZoneInfoMap(String sourceBillNo) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillNo);
        HashMap<String, String> result = new HashMap<String, String>(mainEntityType.getAllEntities().size());
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            result.put((String)entry.getKey(), ((EntityType)entry.getValue()).getDisplayName().getLocaleValue());
        }
        return result;
    }

    public static String getNumberStrByPk(List<Object> pKs) {
        List<String> numbers = FahDispatchRuleDaoImpl.getModelNumberById(pKs);
        StringBuilder sb = new StringBuilder();
        for (String number : numbers) {
            sb.append(number).append(",");
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        return sb.toString();
    }

    public static DispatchZoneInfo findZoneInfoByZone(String zone, DispatchZoneFieldSettingInfo newInfo) {
        if (StringUtils.isNotEmpty((String)zone) && newInfo != null) {
            for (DispatchZoneInfo zoneInfo : newInfo) {
                if (!zone.equals(zoneInfo.getZone())) continue;
                return zoneInfo;
            }
        }
        return null;
    }

    public static DynamicObject generateSchemeSetData(Long pkId, Set<Long> evtRulePks) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_evt_disp_en");
        obj.set("number", (Object)ObjectConverterFactory.getString((Object)new Date().getTime()));
        obj.set("dispatchid", (Object)pkId);
        DynamicObjectCollection evtgenrule = obj.getDynamicObjectCollection("entryentity");
        for (Long evtRulePk : evtRulePks) {
            DynamicObject entryObj = evtgenrule.addNew();
            entryObj.set("evtgenrule", (Object)evtRulePk);
        }
        return (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj})[0];
    }

    public static String getFullName(Long schemeSetPk) {
        DynamicObject schemeSet = BusinessDataServiceHelper.loadSingle((Object)schemeSetPk, (String)"fah_evt_disp_en");
        DynamicObjectCollection entryentity = schemeSet.getDynamicObjectCollection("entryentity");
        if (entryentity == null || entryentity.size() == 0) {
            return null;
        }
        Set evtgenrules = entryentity.stream().map(o -> o.getLong("evtgenrule.id")).collect(Collectors.toSet());
        DynamicObjectCollection evtRuleObjs = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", evtgenrules)});
        HashMap map = new HashMap(entryentity.size());
        evtRuleObjs.stream().forEach(o -> map.put(ObjectConverterFactory.getString((Object)o.getLong("id")), o.getString("name")));
        StringBuilder sb = new StringBuilder();
        for (DynamicObject obj : entryentity) {
            String pk = ObjectConverterFactory.getString((Object)obj.getLong("evtgenrule.id"));
            sb.append((String)map.get(pk)).append(";");
        }
        return sb.toString();
    }
}

