/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.DefaultDataFieldGroupEnum;
import kd.fi.v2.fah.constant.enums.FieldPropEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCfg;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldCollection;
import kd.fi.v2.fah.models.modeling.impl.DataModelFieldPropCfg;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.ParamUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class ExtDataModelUtils {
    public static List<String> validateCanSave(DataModelCfg extDataModel) {
        QFilter filter;
        LinkedList<String> errorMsgList = new LinkedList<String>();
        HashMap<String, List<PairTuple<Integer, String>>> errorMsg = new HashMap<String, List<PairTuple<Integer, String>>>();
        if (!DataModelUtils.isNumberMatch((String)extDataModel.getNumber())) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u4ec5\u652f\u6301\u5b57\u6bcd\u5f00\u5934\uff0c\u4e14\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002%1$s", (String)"DataModelDaoImpl_39", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
        }
        if (StringUtils.isEmpty((String)extDataModel.getName())) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002%1$s", (String)"DataModelDaoImpl_40", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
        }
        if (extDataModel.getNumber().length() > 20) {
            errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u957f\u5ea6\u8d85\u8fc720\u4e2a\u5b57\u6bb5\uff0c\u8bf7\u4fee\u6539\u3002%1$s", (String)"DataModelDaoImpl_41", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
        }
        LinkedList<String> numbers = new LinkedList<String>();
        LinkedList<String> interfaceNumbers = new LinkedList<String>();
        numbers.add(extDataModel.getNumber().toLowerCase());
        LinkedList<String> groupNames = new LinkedList<String>();
        HashSet<String> allGroupNames = new HashSet<String>(1);
        LinkedList<String> tableNames = new LinkedList<String>();
        LinkedHashMap<String, List> baseNumberMap = new LinkedHashMap<String, List>(4);
        for (DataModelFieldCollection group : (BaseMutableArrayMapStorage)extDataModel.getCollections()) {
            numbers.add(DataModelUtils.getNumber((String)group.getNumber()));
            LinkedList<PairTuple> errorList = new LinkedList<PairTuple>();
            if (group.getCollections() != null && !((BaseMutableArrayMapStorage)group.getCollections()).isEmpty()) {
                for (DataModelFieldCfg field : (BaseMutableArrayMapStorage)group.getCollections()) {
                    if (StringUtils.isEmpty((String)field.getNumber()) || StringUtils.isEmpty((String)field.getName()) || field.getDataType() == null) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u586b\u5b57\u6bb5\u672a\u586b", (String)"DataModelDaoImpl_20", (String)"fi-ai-common", (Object[])new Object[0])));
                    } else if (DataValueTypeEnum.BaseProp == field.getDataType()) {
                        if (StringUtils.isEmpty((String)field.getRefBaseProp())) {
                            errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u65f6\uff0c\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u5fc5\u586b", (String)"DataModelDaoImpl_21", (String)"fi-ai-common", (Object[])new Object[0])));
                        } else {
                            baseNumberMap.computeIfAbsent(field.getRefBaseProp(), v -> new LinkedList()).add(new PairTuple((Object)group, (Object)field));
                        }
                    } else if (DataValueTypeEnum.AssistProp == field.getDataType()) {
                        if (field.getRefAssistProp() == null || field.getRefAssistProp() == 0L) {
                            errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u8f85\u52a9\u8d44\u6599\u65f6\uff0c\u8f85\u52a9\u8d44\u6599\u5b57\u6bb5\u5fc5\u586b", (String)"DataModelDaoImpl_22", (String)"fi-ai-common", (Object[])new Object[0])));
                        } else if (field.getRefAssistProp() == -1L) {
                            errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ed1\u5b9a\u7684\u8f85\u52a9\u8d44\u6599\u4e0d\u5b58\u5728", (String)"DataModelDaoImpl_38", (String)"fi-ai-common", (Object[])new Object[0]), field.getName())));
                        }
                    }
                    if (field.getNumber().equalsIgnoreCase("billstatus")) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"billStatus\u7f16\u7801\u4e3a\u7cfb\u7edf\u9884\u7f6e\u5b57\u6bb5\uff0c\u65e0\u6cd5\u6dfb\u52a0", (String)"DataModelDaoImpl_23", (String)"fi-ai-common", (Object[])new Object[0])));
                    }
                    if (!DataModelUtils.isNumberMatch((String)field.getNumber())) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u4ec5\u652f\u6301\u5c0f\u5199\u5b57\u6bcd\u5f00\u5934\uff0c\u4e14\u7531\u5b57\u6bcd\u3001\u4e0b\u5212\u7ebf\u548c\u6570\u5b57\u7ec4\u6210", (String)"DataModelDaoImpl_24", (String)"fi-ai-common", (Object[])new Object[0])));
                    }
                    if (StringUtils.isNotEmpty((String)field.getApifield()) && DataModelUtils.isContainChinese((String)field.getApifield())) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u5b57\u6bb5\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u4e2d\u6587\u5b57\u7b26\u6216\u8005\u6c49\u5b57\u3002", (String)"DataModelDaoImpl_53", (String)"fi-ai-common", (Object[])new Object[0])));
                    }
                    if (DataValueTypeEnum.Bool != field.getDataType() && DataValueTypeEnum.Int != field.getDataType() && (field.getProps() == null || field.getProps().isEmpty())) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u5b57\u6bb5\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5b57\u6bb5\u5c5e\u6027\u5b57\u6bb5", (String)"DataModelDaoImpl_25", (String)"fi-ai-common", (Object[])new Object[0])));
                    }
                    if (!(DataValueTypeEnum.Decimal != field.getDataType() || !ParamUtils.isMustInput() || StringUtils.isEmpty((String)field.getRequiredCondition()) && field.isRequired())) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u5fc5\u987b\u9009\u62e9\u5fc5\u5f55\u4e14\u5fc5\u5f55\u6761\u4ef6\u9700\u8981\u8bbe\u7f6e\u4e3a\u7a7a", (String)"DataModelDaoImpl_26", (String)"fi-ai-common", (Object[])new Object[0])));
                    }
                    if (field.isRequired() && StringUtils.isEmpty((String)field.getApifield())) {
                        errorList.add(new PairTuple((Object)(field.getSeq() + 1), (Object)String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u5fc5\u5f55\u7684\u60c5\u51b5\u4e0b\uff0c\u63a5\u53e3\u5b57\u6bb5\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"DataModelDaoImpl_52", (String)"fi-ai-common", (Object[])new Object[0]), new Object[0])));
                    }
                    numbers.add(field.getNumber().toLowerCase());
                    String apifield = field.getApifield();
                    if (StringUtils.isEmpty((String)apifield)) continue;
                    interfaceNumbers.add(apifield);
                }
            } else if (group.getParentId() != 0L && group.getGroupLevel() != 0) {
                groupNames.add(group.getName());
            }
            if (group.getParentId() != 0L && group.getGroupLevel() != 0) {
                allGroupNames.add(DataModelUtils.getNumber((String)group.getNumber()));
            }
            if (DefaultDataFieldGroupEnum.ENTRY == group.getGroupType() && group.getGroupLevel() >= 1) {
                String checkNumber;
                if (group.getGroupLevel() == 1) {
                    checkNumber = extDataModel.getNumber() + "_" + group.getGroupSeq();
                } else {
                    String longNumber = group.getNumber();
                    checkNumber = extDataModel.getNumber() + "_" + ((DataModelFieldCollection)extDataModel.get((Object)longNumber.substring(0, longNumber.lastIndexOf(124)))).getGroupSeq() + "_" + group.getGroupSeq();
                }
                filter = new QFilter("number", "=", (Object)checkNumber);
                filter.and(new QFilter("number", "!=", (Object)extDataModel.getNumber()));
                if (QueryServiceHelper.exists((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{filter})) {
                    tableNames.add(group.getName());
                    continue;
                }
            }
            if (errorList.isEmpty()) continue;
            errorMsg.put(group.getName(), errorList);
        }
        DynamicObjectCollection baseDatas = QueryServiceHelper.query((String)"bos_entityobject", (String)"number", (QFilter[])new QFilter[]{new QFilter("modeltype", "=", (Object)"BaseFormModel").and(new QFilter("number", "in", baseNumberMap.keySet()))});
        baseDatas.stream().forEach(o -> {
            List cfr_ignored_0 = (List)baseNumberMap.remove(o.getString("number"));
        });
        String errorMsgDetial = ResManager.loadKDString((String)"\u201c%s\u201d\u7ed1\u5b9a\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728", (String)"DataModelDaoImpl_37", (String)"fi-ai-common", (Object[])new Object[0]);
        if (!baseNumberMap.values().isEmpty()) {
            baseNumberMap.values().forEach(entry -> entry.forEach(pairTuple -> errorMsg.computeIfAbsent(((DataModelFieldCollection)pairTuple.getKey()).getName(), v -> new LinkedList()).add(new PairTuple((Object)(((DataModelFieldCfg)pairTuple.getValue()).getSeq() + 1), (Object)String.format(errorMsgDetial, ((DataModelFieldCfg)pairTuple.getValue()).getName())))));
        }
        String modelTableName = DataModelDaoImpl.getTableName((String)extDataModel.getNumber());
        String tableNameMessge = null;
        filter = new QFilter("tablename", "=", (Object)modelTableName);
        filter.and(new QFilter("model.number", "!=", (Object)extDataModel.getNumber()));
        if (QueryServiceHelper.exists((String)"fah_ext_model_fldgrp", (QFilter[])new QFilter[]{filter})) {
            tableNameMessge = ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u4e3b\u8868\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u6a21\u578b\u7f16\u7801\u3002", (String)"DataModelDaoImpl_27", (String)"fi-ai-common", (Object[])new Object[0]);
        }
        HashSet<String> showedNumbers = new HashSet<String>(16);
        HashSet<String> multiNumbers = new HashSet<String>(1);
        HashSet<String> showedInterfaceNumbers = new HashSet<String>(16);
        HashSet<String> multiInterfaceNumbers = new HashSet<String>(1);
        HashSet<String> multiApiNumbers = new HashSet<String>(1);
        for (String number : numbers) {
            if (showedNumbers.contains(number)) {
                multiNumbers.add(number);
                continue;
            }
            showedNumbers.add(number);
        }
        for (String interfaceNumber : interfaceNumbers) {
            if (showedInterfaceNumbers.contains(interfaceNumber)) {
                multiInterfaceNumbers.add(interfaceNumber);
            } else {
                showedInterfaceNumbers.add(interfaceNumber);
            }
            if (!allGroupNames.contains(interfaceNumber)) continue;
            multiApiNumbers.add(interfaceNumber);
        }
        if (!(errorMsg.isEmpty() && multiNumbers.isEmpty() && multiInterfaceNumbers.isEmpty() && groupNames.isEmpty() && tableNames.isEmpty() && StringUtils.isEmpty((String)tableNameMessge) && multiApiNumbers.isEmpty())) {
            ExtDataModelUtils.appendErrorMsg(errorMsgList, errorMsg, multiNumbers, multiInterfaceNumbers, groupNames, tableNames, tableNameMessge, multiApiNumbers);
        } else {
            if (!DataModelDaoImpl.numberCheck((DataModelCfg)extDataModel)) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u5df2\u53d1\u5e03\u6a21\u578b\u7684\u7f16\u7801\u3002%1$s", (String)"DataModelDaoImpl_42", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
            }
            if (!DataModelDaoImpl.uniqueNumberCheck((Long)extDataModel.getMasterId(), (String)extDataModel.getNumber())) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u6570\u636e\u6a21\u578b\u3002%1$s", (String)"DataModelDaoImpl_43", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
            }
            if (DataModelDaoImpl.uniqueNameCheck((Long)extDataModel.getMasterId(), (String)extDataModel.getName())) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\u6a21\u578b\u3002%1$s", (String)"DataModelDaoImpl_44", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
            }
            if (DataModelDaoImpl.isPublished((Long)extDataModel.getId())) {
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fdd\u5b58\u53d1\u5e03\u72b6\u6001\u7684\u6a21\u578b\u3002%1$s", (String)"DataModelDaoImpl_45", (String)"fi-ai-common", (Object[])new Object[0]), "\r\n"));
            }
            ExtDataModelUtils.fieldChangeCheckForUsedModelPerSave(extDataModel, errorMsgList);
        }
        return errorMsgList;
    }

    public static void appendErrorMsg(List<String> errorMsgList, Map<String, List<PairTuple<Integer, String>>> errorMsg, Set<String> multiNumbers, Set<String> multiInterfaceNumbers, List<String> groupNames, List<String> tableNames, String tableNameMessge, Set<String> multiApiNumbers) {
        Object messgeText;
        Object formatErrorText;
        StringBuilder errorText = new StringBuilder();
        for (Map.Entry<String, List<PairTuple<Integer, String>>> entry : errorMsg.entrySet()) {
            for (PairTuple<Integer, String> pair : entry.getValue()) {
                errorText.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\uff0c%2$s", (String)"DataModelDaoImpl_29", (String)"fi-ai-common", (Object[])new Object[0]), pair.getKey(), pair.getValue())).append("\r\n");
            }
            String formatErrorText2 = String.format(ResManager.loadKDString((String)"\u5206\u7ec4\u201c%1$s\u201d\u4e0b\uff1a%2$s%3$s", (String)"DataModelDaoImpl_28", (String)"fi-ai-common", (Object[])new Object[0]), entry.getKey(), "\r\n", errorText);
            errorMsgList.add(formatErrorText2);
            errorText = new StringBuilder();
        }
        if (!multiNumbers.isEmpty()) {
            for (String multiNumber : multiNumbers) {
                errorText.append(multiNumber).append("\u3001");
            }
            if (errorText.length() > 0) {
                errorText.deleteCharAt(errorText.lastIndexOf("\u3001"));
            }
            formatErrorText = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u578b\u7f16\u7801\u3001\u5206\u7ec4\u7f16\u7801\u53ca\u5b57\u6bb5\u7f16\u7801\u4e2d\u5b58\u5728\u91cd\u590d\u7f16\u7801\uff1a%1$s\u3002", (String)"DataModelDaoImpl_30", (String)"fi-ai-common", (Object[])new Object[0]), errorText);
            errorMsgList.add((String)formatErrorText);
            errorText = new StringBuilder();
        }
        if (!multiInterfaceNumbers.isEmpty()) {
            for (String interfaceNumber : multiInterfaceNumbers) {
                errorText.append(interfaceNumber).append("\u3001");
            }
            errorText.deleteCharAt(errorText.lastIndexOf("\u3001"));
            messgeText = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u63a5\u53e3\u5b57\u6bb5\u7f16\u7801\uff1a\u3010%1$s\u3011\u3002", (String)"DataModelDaoImpl_51", (String)"fi-ai-common", (Object[])new Object[0]), errorText) + "\n";
            errorMsgList.add((String)messgeText);
            errorText = new StringBuilder();
        }
        if (!multiApiNumbers.isEmpty()) {
            for (String interfaceNumber : multiApiNumbers) {
                errorText.append(interfaceNumber).append("\u3001");
            }
            errorText.deleteCharAt(errorText.lastIndexOf("\u3001"));
            messgeText = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u7ec4\u7f16\u7801\u548c\u63a5\u53e3\u5b57\u6bb5\u7f16\u7801\u91cd\u590d\uff1a\u3010%1$s\u3011\u3002", (String)"DataModelDaoImpl_54", (String)"fi-ai-common", (Object[])new Object[0]), errorText) + "\n";
            errorMsgList.add((String)messgeText);
            errorText = new StringBuilder();
        }
        if (groupNames.size() > 0) {
            for (String groupName : groupNames) {
                errorText.append(groupName).append("\u3001");
            }
            if (errorText.length() > 0) {
                errorText.deleteCharAt(errorText.lastIndexOf("\u3001"));
            }
            formatErrorText = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5206\u7ec4\u5206\u5f55\u4e3a\u7a7a\uff1a%1$s\u3002", (String)"DataModelDaoImpl_31", (String)"fi-ai-common", (Object[])new Object[0]), errorText);
            errorMsgList.add((String)formatErrorText);
            errorText = new StringBuilder();
        }
        if (tableNames.size() > 0) {
            for (String tableName : tableNames) {
                errorText.append(tableName).append("\u3001");
            }
            if (errorText.length() > 0) {
                errorText.deleteCharAt(errorText.lastIndexOf("\u3001"));
            }
            formatErrorText = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5206\u7ec4\u5206\u5f55\u8868\u540d\u91cd\u590d\uff0c\u9700\u8981\u4fee\u6539\u6a21\u578b\u7f16\u7801\uff1a%1$s\u3002", (String)"DataModelDaoImpl_32", (String)"fi-ai-common", (Object[])new Object[0]), errorText);
            errorMsgList.add((String)formatErrorText);
            errorText = new StringBuilder();
        }
        if (!StringUtils.isEmpty((String)tableNameMessge)) {
            errorText.append(tableNameMessge);
            errorMsgList.add(errorText.toString());
        }
    }

    public static void fieldChangeCheckForUsedModelPerSave(DataModelCfg saveCfg, List<String> errorMsgList) {
        PairTuple result;
        DataModelCfg backUpCfg = DataModelDaoImpl.loadModelFromCache((String)saveCfg.getNumber());
        if (backUpCfg == null) {
            return;
        }
        boolean havingExtData = DataModelDaoImpl.isHavingExtData((Long)backUpCfg.getId());
        Set groupNums = new HashSet(8);
        Set fieldNums = new HashSet(8);
        if (!havingExtData && DataModelDaoImpl.isHavingExtData((String)backUpCfg.getNumber()) && (result = DataModelDaoImpl.getGroupAndFieldNumberSet((String)backUpCfg.getNumber(), (int)(ObjectConverterFactory.getInteger((Object)backUpCfg.getVersion()) - 1))) != null) {
            groupNums = (Set)result.getKey();
            fieldNums = (Set)result.getValue();
        }
        for (DataModelFieldCollection backUpGroup : (BaseMutableArrayMapStorage)backUpCfg.getCollections()) {
            if (DefaultDataFieldGroupEnum.SYSTEM.getKey().equals(backUpGroup.getNumber()) || DefaultDataFieldGroupEnum.HEAD.getKey().equals(backUpGroup.getNumber()) || DefaultDataFieldGroupEnum.ENTRY.getKey().equals(backUpGroup.getNumber())) continue;
            DataModelFieldCollection saveGroup = (DataModelFieldCollection)saveCfg.get((Object)backUpGroup.getNumber());
            if (saveGroup == null) {
                if (!havingExtData && !groupNums.contains(DataModelUtils.getNumber((String)backUpGroup.getNumber()))) continue;
                errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u5386\u53f2\u5206\u7ec4\uff1a\u201c%s\u201d\u3002", (String)"DataModelDaoImpl_9", (String)"fi-ai-common", (Object[])new Object[0]), DataModelUtils.getNumber((String)backUpGroup.getNumber())) + "\r\n");
                continue;
            }
            for (DataModelFieldCfg backUpField : (BaseMutableArrayMapStorage)backUpGroup.getCollections()) {
                String saveFieldPropJson;
                String backUpFieldPropJson;
                DataModelFieldCfg saveField = (DataModelFieldCfg)saveGroup.get((Object)backUpField.getNumber());
                if (saveField == null) {
                    if (!havingExtData && !fieldNums.contains(backUpField.getNumber())) continue;
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u5386\u53f2\u5b57\u6bb5\uff1a\u201c%s\u201d\u3002", (String)"DataModelDaoImpl_10", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                    continue;
                }
                if (!havingExtData && !fieldNums.contains(saveField.getNumber())) continue;
                if (backUpField.getDataType() != saveField.getDataType()) {
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\u201c%s\u201d\u7684\u7c7b\u578b\u3002", (String)"DataModelDaoImpl_11", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                    continue;
                }
                if (!Objects.equals(backUpField.getRefBaseProp(), saveField.getRefBaseProp())) {
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"DataModelDaoImpl_35", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                } else if (!Objects.equals(backUpField.getRefAssistProp(), saveField.getRefAssistProp())) {
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\u201c%s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u7c7b\u578b\u3002", (String)"DataModelDaoImpl_36", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                }
                if ((backUpFieldPropJson = backUpField.getProps() == null ? "" : JSON.toJSONString((Object)backUpField.getProps().getValues())).equals(saveFieldPropJson = saveField.getProps() == null ? "" : JSON.toJSONString((Object)saveField.getProps().getValues()))) continue;
                for (DataModelFieldPropCfg fieldCfg : backUpField.getProps()) {
                    int length;
                    String number = fieldCfg.getName();
                    if (!(number.equals(FieldPropEnum.DEFVALUE.getNumber()) || number.equals(FieldPropEnum.DEFVALUEDESIGN.getNumber()) || number.equals(FieldPropEnum.DISPLAY.getNumber()) || number.equals(FieldPropEnum.SCALE.getNumber()) || StringUtils.isEquals((String)String.valueOf(fieldCfg.getPropValue()), (String)String.valueOf(((DataModelFieldPropCfg)saveField.getProps().get((Object)fieldCfg.getItemKey())).getPropValue())) || number.equals(FieldPropEnum.MAXLENGTH.getNumber()))) {
                        errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u63a5\u5165\u5916\u90e8\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u6539\u5b57\u6bb5\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u5c5e\u6027\uff1a\u201c%2$s\u201d\u3002", (String)"DataModelDaoImpl_12", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber(), FieldPropEnum.getEnumByNumber((String)fieldCfg.getItemKey()).getName()) + "\r\n");
                        continue;
                    }
                    if (!number.equals(FieldPropEnum.MAXLENGTH.getNumber()) || (length = Integer.parseInt(String.valueOf(((DataModelFieldPropCfg)saveField.getProps().get((Object)fieldCfg.getItemKey())).getPropValue()))) >= Integer.parseInt(String.valueOf(fieldCfg.getPropValue()))) continue;
                    errorMsgList.add(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u5df2\u6709\u5916\u90e8\u6570\u636e\uff0c\u201c%1$s\u201d\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u51cf\u5c0f\u3002", (String)"DataModelDaoImpl_50", (String)"fi-ai-common", (Object[])new Object[0]), backUpField.getNumber()) + "\r\n");
                }
            }
        }
    }

    public static String getMsgOfResult(Map<Long, Set<String>> result, String modelNum) {
        DataModelCfg extDataModel1 = DataModelDaoImpl.loadModelFromCache((String)modelNum);
        StringBuilder resultInfo = new StringBuilder();
        String resultStr = "";
        DynamicObjectCollection vchTemplates = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"name,number,id", (QFilter[])new QFilter("id", "in", result.keySet()).toArray());
        if (null != vchTemplates && !vchTemplates.isEmpty()) {
            String numberFormat = ResManager.loadKDString((String)"\u3010\u5b57\u6bb5\u7f16\u7801\uff1a%s\u3011", (String)"ExtDataModelPlugin_70", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            String nameFormat = ResManager.loadKDString((String)"<\u5b57\u6bb5\u540d\u79f0\uff1a%s>", (String)"ExtDataModelPlugin_71", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            String vchTemplateFormat = ResManager.loadKDString((String)"\u3010%1$s\uff08\u7f16\u7801\uff09\uff0c%1$s\uff08\u540d\u79f0\uff09\u3011", (String)"ExtDataModelPlugin_72", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            for (DynamicObject template : vchTemplates) {
                String vchTempInfo = String.format(vchTemplateFormat, template.getString("number"), template.getString("name"));
                Set<String> fields = result.get(template.getLong("id"));
                if (null == fields) continue;
                StringBuilder fieldStringBuilder = new StringBuilder();
                for (String field : fields) {
                    String fieldName = String.format(nameFormat, ExtDataModelUtils.getFieldNameByNumber(field, extDataModel1));
                    field = String.format(numberFormat, field);
                    fieldStringBuilder.append(field).append(fieldName).append("\u3001");
                }
                fieldStringBuilder.deleteCharAt(fieldStringBuilder.lastIndexOf("\u3001"));
                resultInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u88ab\u51ed\u8bc1\u6a21\u677f%2$s\u5f15\u7528%3$s", (String)"ExtDataModelPlugin_73", (String)"fi-ai-formplugin", (Object[])new Object[0]), fieldStringBuilder, vchTempInfo, "\uff1b"));
            }
            resultInfo.deleteCharAt(resultInfo.lastIndexOf("\uff1b"));
            resultStr = String.format(ResManager.loadKDString((String)"%1$s\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u6a21\u677f\u4e2d\u7684\u5f15\u7528\u540e\u518d\u4fee\u6539\u5b57\u6bb5\u3002", (String)"ExtDataModelPlugin_74", (String)"fi-ai-formplugin", (Object[])new Object[0]), resultInfo);
        }
        return resultStr;
    }

    public static String getFieldNameByNumber(String number, DataModelCfg extDataModel) {
        for (DataModelFieldCollection collection : (BaseMutableArrayMapStorage)extDataModel.getCollections()) {
            for (DataModelFieldCfg fieldCfg : (BaseMutableArrayMapStorage)collection.getCollections()) {
                if (!number.equals(fieldCfg.getNumber())) continue;
                return fieldCfg.getName();
            }
        }
        return " ";
    }
}

