/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.v2.fah.constant.enums.event.FahBillEvtStatusBaseDataEnum;
import kd.fi.v2.fah.util.EventGenTaskUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahWriteBackPluginExecutor {
    private final String billType;
    private final String plugin;
    private final String serviceAppId;
    private final Map<String, Map<Long, Set<Long>>> postGlMap;
    private final Map<Long, String> vchIdNoMap;

    public FahWriteBackPluginExecutor(String billType, Map<String, Map<Long, Set<Long>>> postGlMap, Map<Long, String> vchIdNoMap) {
        this.billType = billType;
        this.postGlMap = postGlMap;
        this.vchIdNoMap = vchIdNoMap;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        this.serviceAppId = ServiceLookup.getServiceAppId((String)mainEntityType.getAppId());
        this.plugin = EventGenTaskUtils.getWriteBackPlugin(billType);
    }

    public void execute(FahBillEvtStatusBaseDataEnum billEvtStatusEnum, Collection<Long> billIds) {
        VoucherOperation voucherOperation;
        if (StringUtils.isEmpty((String)this.plugin)) {
            return;
        }
        switch (billEvtStatusEnum) {
            case VOUCHER: {
                voucherOperation = VoucherOperation.Create;
                break;
            }
            case CROSS: {
                voucherOperation = VoucherOperation.Delete;
                break;
            }
            default: {
                voucherOperation = null;
            }
        }
        if (null == voucherOperation) {
            return;
        }
        Collection<Map<Long, String>> billToVchParamList = FahWriteBackPluginExecutor.buildBillToVchParam(this.billType, billIds, this.postGlMap, this.vchIdNoMap);
        try (TXHandle h = TX.requiresNew((String)"BuildEvtDataUtil.executeDapWriteBackPlugin");){
            try {
                DispatchService dispatchService = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)this.serviceAppId);
                for (Map<Long, String> billToVchParam : billToVchParamList) {
                    dispatchService.invoke("kd.bos.ext.fi.servicehelper.ServiceFactory", "DapWriteBackService", "writeBack", new Object[]{this.plugin.trim(), voucherOperation.getValue(), this.billType, billToVchParam});
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static Collection<Map<Long, String>> buildBillToVchParam(String billType, Collection<Long> billIds, Map<String, Map<Long, Set<Long>>> postGlMap, Map<Long, String> vchIdNoMap) {
        HashMap<Integer, Map> billToVchParamListIndexMap = new HashMap<Integer, Map>(8);
        Map<Long, Set<Long>> billIdVchIdsMap = postGlMap.get(billType);
        for (Long billId : billIds) {
            Set<Long> vchIds = billIdVchIdsMap.get(billId);
            int index = 0;
            for (Long vchId : vchIds) {
                Map billToVchParamMap = billToVchParamListIndexMap.computeIfAbsent(index, k -> new HashMap(billIds.size()));
                Voucher vch = new Voucher();
                vch.setId(vchId.longValue());
                String vchNo = vchIdNoMap.get(vchId);
                vch.setVoucherNo(vchNo);
                String vchIdAndNoJson = SerializationUtils.toJsonString((Object)vch);
                billToVchParamMap.put(billId, vchIdAndNoJson);
                ++index;
            }
        }
        return billToVchParamListIndexMap.values();
    }

    public String toString() {
        return "FahWriteBackPluginExecutor{billType='" + this.billType + '\'' + ", plugin='" + this.plugin + '\'' + ", serviceAppId='" + this.serviceAppId + '\'' + '}';
    }
}

