/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.util.Collection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.constant.enums.event.FahBillEvtStatusBaseDataEnum;
import kd.fi.v2.fah.util.EventGenTaskUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahWriteBackSqlExecutor {
    private final String tableName;
    private final String evtStatusFieldNumAlias;
    private final String pkFiled;
    private final String dbRouteKey;

    public FahWriteBackSqlExecutor(String billType) {
        String tableGroup;
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        this.dbRouteKey = mainEntityType.getDBRouteKey();
        String tableNameTmp = mainEntityType.getAlias();
        String evtStatusFieldNum = EventGenTaskUtils.getBillEvtStatusFieldNum(billType);
        DynamicProperty property = mainEntityType.getProperty(evtStatusFieldNum);
        if (null == property) {
            String errMsg = ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e0a\u672a\u627e\u5230\u53cd\u5199\u5b57\u6bb5\uff1a%2$s\u3002", (String)"FahWriteBackSqlExecutor_0", (String)"fi-ai-business", (Object[])new Object[]{mainEntityType.getDisplayName().getLocaleValue(), evtStatusFieldNum});
            throw new KDBizException(errMsg);
        }
        boolean supportTableGroup = Boolean.parseBoolean(SysParamConfig.get((String)"fah.evt.writeBack.supportTableGroup", (String)"true"));
        if (supportTableGroup && StringUtils.isNotEmpty((String)(tableGroup = property.getTableGroup()))) {
            tableNameTmp = tableNameTmp + "_" + tableGroup;
        }
        this.tableName = tableNameTmp;
        this.evtStatusFieldNumAlias = property.getAlias();
        this.pkFiled = mainEntityType.getPrimaryKey().getAlias();
    }

    private SqlBuilder createSqlBuilder(FahBillEvtStatusBaseDataEnum billEvtStatusEnum, Collection<Long> billIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update ", new Object[0]).append(this.tableName, new Object[0]).append(" set ", new Object[0]).append(this.evtStatusFieldNumAlias, new Object[0]).append(" = ? ", new Object[]{billEvtStatusEnum.getId()});
        sqlBuilder.append("where ", new Object[0]).appendIn(this.pkFiled, billIds.toArray());
        return sqlBuilder;
    }

    public void execute(String txTag, FahBillEvtStatusBaseDataEnum billEvtStatusEnum, Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        SqlBuilder sqlBuilder = this.createSqlBuilder(billEvtStatusEnum, billIds);
        try (TXHandle h = TX.requiresNew((String)txTag);){
            try {
                DB.execute((DBRoute)DBRoute.of((String)this.dbRouteKey), (SqlBuilder)sqlBuilder);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public String toString() {
        return "FahWriteBackSqlExecutor{tableName='" + this.tableName + '\'' + ", evtStatusFieldNumAlias='" + this.evtStatusFieldNumAlias + '\'' + ", pkFiled='" + this.pkFiled + '\'' + ", dbRouteKey='" + this.dbRouteKey + '\'' + '}';
    }
}

