/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.orm.query.QFilter;
import kd.fi.v2.fah.cache.threadcache.EvtRuleThreadCache;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.constant.enums.PresetSysFieldEnum;
import kd.fi.v2.fah.constant.enums.xla.FahXLAHeadField;
import kd.fi.v2.fah.constant.enums.xla.FahXLALineField;
import kd.fi.v2.fah.dao.FahAcctRuleDataDao;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.getvaluehandle.AccountSystemGetValueServiceImpl;
import kd.fi.v2.fah.getvaluehandle.AsstGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.DynamicTextGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.FieldGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.FormulaGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.MappingGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.MultiRuleGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.PreSetSysFieldGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.ReferenceGetValueHandle;
import kd.fi.v2.fah.getvaluehandle.TrackerGetValueHandle;
import kd.fi.v2.fah.models.MainEntityKey;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineGroup;
import kd.fi.v2.fah.models.event.eventrule.EventRuleModelCfg;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.AutoSetValueHandle;
import kd.fi.v2.fah.models.xla.ReferenceFieldConfig;
import kd.fi.v2.fah.models.xla.XLARuleAcctPurpGroup;
import kd.fi.v2.fah.models.xla.XLARuleLineConfig;
import kd.fi.v2.fah.models.xla.XLARuleModelConfig;
import kd.fi.v2.fah.models.xla.XLARuleSourceDataGroup;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.ExtractFieldUtils;

public class FahXLARuleModelUtil {
    private static final Object[][] XlaRuleAcctPurp_FieldHandle_Infos = new Object[][]{{"vouchertype", FahXLAHeadField.FTYPEID}, {"creator", FahXLAHeadField.FCREATORID}, {"attachment", FahXLAHeadField.FATTACHMENTS}, {"referenceinformation", FahXLAHeadField.FDESCRIPTION}};
    private static final Object[][] AcctRule_FieldHandle_Infos = new Object[][]{{"amount", FahXLALineField.FLOCAL_CREDIT}, {"amount", FahXLALineField.FLOCAL_DEBIT}, {"currency", FahXLALineField.FCURRENCYID}, {"exchangerate", FahXLALineField.FLOCAL_EXCHANGERATE}, {"account", FahXLALineField.FACCOUNTID}, {"assgrp", FahXLALineField.FASSGRPID}, {"summary", FahXLALineField.FDESCRIPTION}, {"quantity", FahXLALineField.FQUANTITY}, {"measurement", FahXLALineField.FMEASUREUNITID}, {"unitprice", FahXLALineField.FPRICE}, {"biznumber", FahXLALineField.FBUSINESSNUM}, {"expiredate", FahXLALineField.FEXPIRE_DATE}, {"cashflowitem", FahXLALineField.FMAINCF_ITEMID}, {"cashflowsupitem", FahXLALineField.FSUPCF_ITEMID}, {"cashflowitemassgrp", FahXLALineField.FMAINCF_ASSGRPID}};

    public static XLARuleModelConfig getXLARuleModelConfig(Long eventRuleId) {
        XLARuleModelConfig model = new XLARuleModelConfig();
        if (eventRuleId == 0L) {
            return model;
        }
        QFilter filter = new QFilter("eventrule.id", "=", (Object)eventRuleId);
        filter.and(new QFilter("enable", "=", (Object)true));
        DynamicObject acctRuleHead = FahAcctRuleDataDao.querySingleAcctRuleHead(filter.toArray());
        if (acctRuleHead == null) {
            return model;
        }
        Long acctRuleId = acctRuleHead.getLong("id");
        model.setId(acctRuleId);
        model.setNumber(acctRuleHead.getString("number"));
        model.setName(acctRuleHead.getString("name"));
        model.setStatus(acctRuleHead.getString("status"));
        model.setEnable(acctRuleHead.getBoolean("enable"));
        model.setEventRuleId(acctRuleHead.getLong("eventrule"));
        model.setCreator(acctRuleHead.getLong("creator"));
        model.setCreateTime(acctRuleHead.getDate("createtime"));
        model.setModifier(acctRuleHead.getLong("modifier"));
        model.setModifyTime(acctRuleHead.getDate("modifytime"));
        model.setBillEntityName(acctRuleHead.getString("sourcebill"));
        filter = new QFilter("acctrule.id", "=", (Object)acctRuleId);
        DynamicObjectCollection acctPurpGroup = FahAcctRuleDataDao.queryAcctPurpGroup(filter.toArray());
        ArrayList<XLARuleAcctPurpGroup> xlaRuleAcctPurpCol = new ArrayList<XLARuleAcctPurpGroup>();
        for (DynamicObject acctPurpRule : acctPurpGroup) {
            XLARuleAcctPurpGroup xlaRuleAcctPurp = new XLARuleAcctPurpGroup();
            xlaRuleAcctPurpCol.add(xlaRuleAcctPurp);
            xlaRuleAcctPurp.setAcctPurposeId(acctPurpRule.getLong("acctpurpose"));
            xlaRuleAcctPurp.setId_acctpublic(acctPurpRule.getLong("id"));
            for (Object[] handle : XlaRuleAcctPurp_FieldHandle_Infos) {
                FahXLAHeadField field = (FahXLAHeadField)handle[1];
                xlaRuleAcctPurp.addFieldHandle(FahXLARuleModelUtil.createSetValueHandle(acctPurpRule.getLong((String)handle[0]), field.getNumber(), field.getIndex()));
            }
            xlaRuleAcctPurp.setAcctBookHandle(new AccountSystemGetValueServiceImpl());
            xlaRuleAcctPurp.setAttachment(FahXLARuleModelUtil.createSetValueHandle(acctPurpRule.getLong("attachment"), FahXLAHeadField.FATTACHMENTS.getNumber(), FahXLAHeadField.FATTACHMENTS.getIndex()));
            xlaRuleAcctPurp.setVoucherType(FahXLARuleModelUtil.createSetValueHandle(acctPurpRule.getLong("vouchertype"), FahXLAHeadField.FTYPEID.getNumber(), FahXLAHeadField.FTYPEID.getIndex()));
            xlaRuleAcctPurp.setGroupmergeruleId(acctPurpRule.getLong("groupmergerule"), acctRuleHead.getString("sourcebill"));
        }
        DynamicObjectCollection acctRuleLineData = FahAcctRuleDataDao.queryAcctRuleLineData(filter.toArray());
        ArrayList<XLARuleLineConfig> xlaRuleLineCol = new ArrayList<XLARuleLineConfig>();
        for (DynamicObject acctRuleLine : acctRuleLineData) {
            XLARuleLineConfig ruleLineModel = new XLARuleLineConfig();
            xlaRuleLineCol.add(ruleLineModel);
            ruleLineModel.setEventLineId(acctRuleLine.getLong("eventlineruleid"));
            ruleLineModel.setId(acctRuleLine.getLong("id"));
            ruleLineModel.setSeq(acctRuleLine.getInt("dseq"));
            ruleLineModel.setXlaRuleModel(model);
            ruleLineModel.setDc(acctRuleLine.getString("acctdirection"));
            ruleLineModel.setAcctPurposeId(acctRuleLine.getLong("acctpurpose"));
            ruleLineModel.setIsNeedMerge(acctRuleLine.getBoolean("isneedmerge"));
            ruleLineModel.setAmountReverse(acctRuleLine.getBoolean("amountreverse"));
            for (Object[] handle : AcctRule_FieldHandle_Infos) {
                FahXLALineField field = (FahXLALineField)handle[1];
                ruleLineModel.addFieldHandle(FahXLARuleModelUtil.createSetValueHandle(acctRuleLine.getLong((String)handle[0]), field.getNumber(), field.getWriteIndex()));
            }
        }
        List<Map<Long, Long>> eventRuleLineGroup = FahXLARuleModelUtil.getEventRuleLineGroup(eventRuleId);
        ArrayList<Long> allEventLineCol = new ArrayList<Long>();
        boolean size = false;
        for (Map<Long, Long> eventRuleLineIds : eventRuleLineGroup) {
            allEventLineCol.addAll(eventRuleLineIds.keySet());
            XLARuleSourceDataGroup ruleSourceDataModel = new XLARuleSourceDataGroup();
            model.addXlaRuleSourceDataGroup(ruleSourceDataModel);
            List<XLARuleAcctPurpGroup> ruleAcctPurpCol = null;
            if (!size) {
                ruleAcctPurpCol = xlaRuleAcctPurpCol;
                size = true;
            } else {
                ruleAcctPurpCol = xlaRuleAcctPurpCol.stream().map(m -> m.copy()).collect(Collectors.toList());
            }
            ruleSourceDataModel.setXlaRuleAcctPurpCol(ruleAcctPurpCol);
            for (XLARuleAcctPurpGroup rapg : ruleAcctPurpCol) {
                Long acctPurposeId = rapg.getAcctPurposeId();
                List<XLARuleLineConfig> linec = xlaRuleLineCol.stream().filter(f -> f.getAcctPurposeId().equals(acctPurposeId) && eventRuleLineIds.containsKey(f.getEventLineId())).collect(Collectors.toList());
                for (XLARuleLineConfig l : linec) {
                    l.setAmountId(eventRuleLineIds.get(l.getEventLineId()));
                }
                rapg.setXlaRuleLineCol(linec);
            }
        }
        HashMap allUsedEvtLineIds = new HashMap();
        xlaRuleLineCol.forEach(f -> allUsedEvtLineIds.put(f.getEventLineId(), allUsedEvtLineIds.getOrDefault(f.getEventLineId(), 0) + 1));
        boolean isComplete = true;
        int requiredRuleCnt = xlaRuleAcctPurpCol.size();
        HashSet allRequiredEvtLineIds = new HashSet(allEventLineCol);
        for (Map.Entry en : allUsedEvtLineIds.entrySet()) {
            if (allRequiredEvtLineIds.remove(en.getKey()) && (Integer)en.getValue() >= requiredRuleCnt) continue;
            isComplete = false;
            break;
        }
        if (isComplete) {
            isComplete = allRequiredEvtLineIds.isEmpty();
        }
        model.setCompleteLine(isComplete);
        for (XLARuleSourceDataGroup ruleSourceDataModel : model.getXlaRuleSourceDataGroup()) {
            FahXLARuleModelUtil.generateFiledAlias(ruleSourceDataModel, model.getBillEntityName());
        }
        return model;
    }

    public static AutoSetValueHandle createSetValueHandle(Long configId, String number, int index) {
        return FahXLARuleModelUtil.getAutoSetValueHandleByModel(ExtractFieldUtils.loadDynamicExtractFieldValueSetData((Long)configId), number, index);
    }

    public static AutoSetValueHandle getAutoSetValueHandleByModel(DynamicExtractFieldValueSetData config, String number, int index) {
        if (config == null) {
            if (number.equals(FahXLALineField.FEXPIRE_DATE.getNumber())) {
                return new AutoSetValueHandle(new FieldGetValueHandle(null, ExtractTypeEnum.CONSTANT_VALUE, null), index);
            }
            if (number.equals(FahXLALineField.FDESCRIPTION.getNumber()) || number.equals(FahXLAHeadField.FDESCRIPTION.getNumber())) {
                return new AutoSetValueHandle(new FieldGetValueHandle(null, ExtractTypeEnum.CONSTANT_VALUE, ""), index);
            }
            if (number.equals(FahXLALineField.FQUANTITY.getNumber()) || number.equals(FahXLALineField.FPRICE.getNumber())) {
                return new AutoSetValueHandle(new FieldGetValueHandle(null, ExtractTypeEnum.CONSTANT_VALUE, new BigDecimal(0)), index);
            }
            if (number.equals(FahXLALineField.FBUSINESSNUM.getNumber())) {
                return new AutoSetValueHandle(new FieldGetValueHandle(null, ExtractTypeEnum.CONSTANT_VALUE, ""), index);
            }
            return new AutoSetValueHandle(new FieldGetValueHandle(null, ExtractTypeEnum.CONSTANT_VALUE, 0L), index);
        }
        IGetValueHandle gvHandle = null;
        if (config.isAsstAct()) {
            gvHandle = new AsstGetValueHandle(config);
        } else if (config.isNeedRetrieveFromParent()) {
            gvHandle = new TrackerGetValueHandle();
        } else if (config.isMultiBranch()) {
            gvHandle = new MultiRuleGetValueHandle();
        } else {
            DynamicExtractFieldValueSet dynamicExtractFieldValueSet = (DynamicExtractFieldValueSet)config.getFieldValueSetList().get(0);
            ExtractTypeEnum getValueType = dynamicExtractFieldValueSet.getGetValueType();
            switch (getValueType) {
                case CONSTANT_VALUE: 
                case SOURCE_FIELD: {
                    gvHandle = new FieldGetValueHandle(dynamicExtractFieldValueSet.getTextValue(), getValueType, dynamicExtractFieldValueSet.getActualConstantValue());
                    break;
                }
                case EXPRESSION: {
                    Boolean isDesc = number.equals(FahXLALineField.FDESCRIPTION.getNumber()) || number.equals(FahXLAHeadField.FDESCRIPTION.getNumber());
                    if (isDesc.booleanValue()) {
                        gvHandle = new DynamicTextGetValueHandle(dynamicExtractFieldValueSet.getExpressionValue());
                        break;
                    }
                    gvHandle = new FormulaGetValueHandle(dynamicExtractFieldValueSet.getExpressionValue(), true);
                    break;
                }
                case MAPPING: {
                    gvHandle = new MappingGetValueHandle(dynamicExtractFieldValueSet.getMappingType(), dynamicExtractFieldValueSet.getMappingGroupId(), dynamicExtractFieldValueSet.getDynExtFieldCfg().getNumber(), dynamicExtractFieldValueSet.getFieldValueSetEntry());
                    break;
                }
                case PRESET_FILED: {
                    gvHandle = null;
                    break;
                }
                case REFERENCE_FIELD: {
                    String textValue = dynamicExtractFieldValueSet.getTextValue();
                    if (StringUtils.isBlank((CharSequence)textValue)) {
                        gvHandle = new ReferenceGetValueHandle(null);
                        break;
                    }
                    EvtReferenceFieldDto evtReferenceFieldDto = FahEventRuleDao.queryReferenceFieldById(Long.parseLong(textValue));
                    gvHandle = new ReferenceGetValueHandle(new ReferenceFieldConfig(evtReferenceFieldDto.getId(), "", evtReferenceFieldDto.getFieldName(), evtReferenceFieldDto.getCustomValue(), evtReferenceFieldDto.getFieldType(), evtReferenceFieldDto.getValueSource()));
                    break;
                }
                case PRESET_SYS_FIELD: {
                    gvHandle = new PreSetSysFieldGetValueHandle(PresetSysFieldEnum.parseByCode((String)dynamicExtractFieldValueSet.getTextValue()));
                    break;
                }
                default: {
                    gvHandle = null;
                }
            }
        }
        AutoSetValueHandle result = new AutoSetValueHandle(gvHandle, index);
        return result;
    }

    private static List<Map<Long, Long>> getEventRuleLineGroup(Long eventRuleId) {
        LinkedList<Map<Long, Long>> result = new LinkedList<Map<Long, Long>>();
        EventRuleModelCfg ruleModelCfg = EvtRuleThreadCache.getEventRuleModelCfgCached(eventRuleId);
        List eventRuleLineGroups = ruleModelCfg.getEventRuleLineGroups();
        for (EventRuleLineGroup erg : eventRuleLineGroups) {
            Map<Long, Long> ergids = erg.getEventRuleLineCfgs().stream().collect(Collectors.toMap(k -> k.getId(), v -> v.getAmountCfg().getBranchId()));
            result.add(ergids);
        }
        return result;
    }

    private static void generateFiledAlias(XLARuleSourceDataGroup ruleSourceDataModel, String billEntityName) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billEntityName);
        List<XLARuleAcctPurpGroup> xlaRuleAcctPurpCol = ruleSourceDataModel.getXlaRuleAcctPurpCol();
        MainEntityKey mainEntityKey = ruleSourceDataModel.getKey();
        HashSet<String> allFields = new HashSet<String>();
        HashMap<String, String> srcFieldAndQueryFieldMap = new HashMap<String, String>();
        for (XLARuleAcctPurpGroup rapc : xlaRuleAcctPurpCol) {
            Collection<AutoSetValueHandle> fieldHandle = rapc.getFieldHandle();
            for (AutoSetValueHandle valueHandle : fieldHandle) {
                Set<String> FieldProp = FahXLARuleModelUtil.analysisFieldProp(valueHandle, mainEntityKey, dataEntityType, srcFieldAndQueryFieldMap);
                allFields.addAll(FieldProp);
            }
            Set<String> FieldProps = FahXLARuleModelUtil.analysisFieldProp(new HashSet<String>(rapc.getBillMergeField()), mainEntityKey, dataEntityType, srcFieldAndQueryFieldMap, false);
            allFields.addAll(FieldProps);
            for (XLARuleLineConfig lineRule : rapc.getXlaRuleLineCol()) {
                Collection<AutoSetValueHandle> fieldHandleCol = lineRule.getFieldHandle();
                for (AutoSetValueHandle valueHandle : fieldHandleCol) {
                    Set<String> FieldProp = FahXLARuleModelUtil.analysisFieldProp(valueHandle, mainEntityKey, dataEntityType, srcFieldAndQueryFieldMap);
                    allFields.addAll(FieldProp);
                }
                Set<String> FieldProp = FahXLARuleModelUtil.analysisFieldProp(FahXLARuleModelUtil.createSetValueHandle(lineRule.getAmountId(), "", 999), mainEntityKey, dataEntityType, srcFieldAndQueryFieldMap);
                allFields.addAll(FieldProp);
            }
        }
        if (StringUtils.isBlank((CharSequence)mainEntityKey.getMainKey())) {
            String key = "id";
            mainEntityKey.setMainKey(key);
            allFields.add(key);
            srcFieldAndQueryFieldMap.put(key, key);
        }
        BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos = ruleSourceDataModel.getFieldAliasInfos();
        String billno = ((BillEntityType)dataEntityType).getBillNo();
        allFields.remove(billno);
        FieldAliasInfo info_number = new FieldAliasInfo(billno, "f0");
        info_number.setReadPos(0);
        info_number.setWritePos(0);
        info_number.setQueryFieldNumber(billno);
        fieldAliasInfos.add((Object)info_number);
        int index = 1;
        for (String field : allFields) {
            FieldAliasInfo info = new FieldAliasInfo((String)srcFieldAndQueryFieldMap.get(field), "f" + index);
            info.setReadPos(index);
            info.setWritePos(index);
            info.setQueryFieldNumber(field);
            fieldAliasInfos.add((Object)info);
            ++index;
        }
    }

    public static Set<String> analysisFieldProp(AutoSetValueHandle valueHandle, MainEntityKey mainEntityKey, MainEntityType dataEntityType, Map<String, String> srcFieldAndQueryFieldMap) {
        Set<String> compileFieldInfo = valueHandle.getGetValueHandle().compileFieldInfo();
        return FahXLARuleModelUtil.analysisFieldProp(compileFieldInfo, mainEntityKey, dataEntityType, srcFieldAndQueryFieldMap, valueHandle.getWriteIndex() == 999);
    }

    public static Set<String> analysisFieldProp(Set<String> compileFieldInfo, MainEntityKey mainEntityKey, MainEntityType dataEntityType, Map<String, String> srcFieldAndQueryFieldMap, Boolean isAmount) {
        HashSet<String> fields = new HashSet<String>();
        for (String propName : compileFieldInfo) {
            String key;
            String fullPropName;
            IDataEntityProperty property;
            String[] keyItems = StringUtils.split((String)propName, (String)".");
            if (isAmount.booleanValue()) {
                propName = keyItems[keyItems.length - 1];
                keyItems = new String[]{propName};
            }
            if ((property = dataEntityType.findProperty(keyItems[0])) == null) continue;
            if (property.getParent() instanceof MainEntityType) {
                fullPropName = propName;
                key = "id";
                mainEntityKey.setMainKey(key);
                fields.add(fullPropName);
                fields.add(key);
                srcFieldAndQueryFieldMap.put(fullPropName, propName);
                srcFieldAndQueryFieldMap.put(key, key);
                continue;
            }
            if (property.getParent() instanceof SubEntryType) {
                fullPropName = property.getParent().getParent().getName() + "." + property.getParent().getName() + "." + propName;
                key = property.getParent().getParent().getName() + "." + property.getParent().getName() + ".id";
                String sub_key = property.getParent().getParent().getName() + ".id";
                mainEntityKey.setSubEntryKey(key);
                mainEntityKey.setEntryKey(sub_key);
                fields.add(fullPropName);
                fields.add(key);
                fields.add(sub_key);
                srcFieldAndQueryFieldMap.put(fullPropName, propName);
                srcFieldAndQueryFieldMap.put(key, key);
                srcFieldAndQueryFieldMap.put(sub_key, sub_key);
                continue;
            }
            fullPropName = property.getParent().getName() + "." + propName;
            key = property.getParent().getName() + ".id";
            mainEntityKey.setEntryKey(key);
            fields.add(fullPropName);
            fields.add(key);
            srcFieldAndQueryFieldMap.put(fullPropName, propName);
            srcFieldAndQueryFieldMap.put(key, key);
        }
        return fields;
    }
}

