/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.cache.cacheservice.FAHDataCacheMgr;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.MappingDataCollection;
import kd.fi.v2.fah.models.mapping.SingleLineMappingData;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.models.valueset.SingleValueSetData;
import kd.fi.v2.fah.models.valueset.ValueSetDataCollection;
import kd.fi.v2.fah.utils.ValueSetUtil;

public class ValueSetAndMappingutil {
    private static final Log logger = LogFactory.getLog(ValueSetAndMappingutil.class);

    public static String buildValueSetAndMappingSql(Object metaType, buildSqlType bt, buildSqlSource bs) {
        if (metaType == null) {
            return null;
        }
        String sql = "";
        if (buildSqlSource.SingleLineValueSetTypeModel != bs) {
            if (buildSqlSource.SingleValueSetData == bs) {
                if (metaType instanceof SingleValueSetData) {
                    SingleValueSetData dataModel = (SingleValueSetData)metaType;
                    if (dataModel.getMeta() == null) {
                        return null;
                    }
                    FlexFieldGrpCfg vstmeta = (FlexFieldGrpCfg)dataModel.getMeta();
                    String[] valueSetTypeSort = ValueSetUtil.getValueSetTypeSort((FlexFieldGrpCfg)vstmeta);
                    StringBuilder params = new StringBuilder();
                    dataModel.getBaseprops().entrySet().forEach(f -> {
                        Object param = ((Object[])f.getValue())[0];
                        if (param != null) {
                            params.append(param);
                            params.append(",");
                        }
                    });
                    for (int i = 0; i < valueSetTypeSort.length; ++i) {
                        String param = valueSetTypeSort[i];
                        params.append(param);
                        params.append(",");
                    }
                    String buildSQLParamHolder = QFilterBuilder.buildSQLParamHolder((int)(dataModel.getBaseprops().size() + valueSetTypeSort.length));
                    sql = "INSERT INTO t_fah_flex_valueset (" + params.substring(0, params.length() - 1) + ") VALUES " + buildSQLParamHolder;
                }
            } else if (buildSqlSource.ValueSetDataCollection == bs) {
                if (metaType instanceof ValueSetDataCollection) {
                    boolean isInsert;
                    ValueSetDataCollection dataModel = (ValueSetDataCollection)metaType;
                    boolean bl = isInsert = buildSqlType.insert == bt;
                    if (isInsert) {
                        dataModel.setId(Long.valueOf(DB.genLongId((String)"t_fah_valueset_type")));
                    }
                    StringBuilder params = new StringBuilder();
                    StringBuilder values = new StringBuilder();
                    dataModel.getProps().entrySet().forEach(f -> {
                        Object param = ((Object[])f.getValue())[0];
                        Object value = ((Object[])f.getValue())[1];
                        if (value != null && param != null) {
                            params.append(param);
                            params.append(",");
                            values.append("?");
                            values.append(",");
                        }
                    });
                    sql = "INSERT INTO t_fah_valueset_type (" + params.substring(0, params.length() - 1) + ") VALUES (" + values.substring(0, params.length() - 1) + ")";
                }
            } else if (buildSqlSource.ValueSetTypeCollectionMeta != bs) {
                if (buildSqlSource.MappingDataCollection == bs) {
                    if (metaType instanceof MappingDataCollection) {
                        if (buildSqlType.delete == bt) {
                            sql = "delete from t_fah_valmap_type where fid = ?";
                        } else {
                            MappingDataCollection dataModel = (MappingDataCollection)metaType;
                            boolean isInsert = buildSqlType.insert == bt;
                            logger.info("FLEXMAIN--isInsert:" + isInsert + ";isEdit:" + dataModel.isEdit());
                            StringBuilder params = new StringBuilder();
                            StringBuilder values = new StringBuilder();
                            dataModel.queryProps().entrySet().forEach(f -> {
                                Object param = ((Object[])f.getValue())[0];
                                Object value = ((Object[])f.getValue())[1];
                                if (param != null) {
                                    params.append(param);
                                    params.append(",");
                                    values.append("?");
                                    values.append(",");
                                }
                            });
                            sql = "INSERT INTO t_fah_valmap_type (" + params.substring(0, params.length() - 1) + ") VALUES (" + values.substring(0, values.length() - 1) + ")";
                        }
                    }
                } else if (buildSqlSource.SingleLineMappingData == bs) {
                    if (metaType instanceof SingleLineMappingData) {
                        if (buildSqlType.delete == bt) {
                            HashMap<String, String> sqlCol = new HashMap<String, String>(2);
                            String sql_del_single = "delete from t_fah_flex_mapval where fid = ?";
                            String sql_del_multi = "delete from t_fah_flex_mapval_en where fid = ?";
                            sqlCol.put("del_single", sql_del_single);
                            sqlCol.put("del_multi", sql_del_multi);
                            sql = SerializationUtils.toJsonString(sqlCol);
                        } else {
                            String param;
                            int i;
                            SingleLineMappingData dataModel = (SingleLineMappingData)metaType;
                            IValueSetMeta meta = dataModel.getMeta();
                            if (meta == null) {
                                return null;
                            }
                            HashMap<String, String> sqlCol = new HashMap<String, String>(3);
                            StringBuilder params_in = new StringBuilder();
                            StringBuilder params_out = new StringBuilder();
                            StringBuilder params_sub = new StringBuilder();
                            int index_in = 0;
                            int index_out = 0;
                            int index_sub = 0;
                            Iterator iterator = dataModel.getBaseprops().entrySet().iterator();
                            while (iterator.hasNext()) {
                                Object param2 = ((Object[])iterator.next().getValue())[0];
                                if (param2 == null) continue;
                                params_in.append(param2);
                                params_in.append(",");
                                params_out.append(param2);
                                params_out.append(",");
                                ++index_in;
                                ++index_out;
                            }
                            Iterator iterator_sub = dataModel.getSubbaseprops().entrySet().iterator();
                            while (iterator_sub.hasNext()) {
                                Object param3 = ((Object[])iterator_sub.next().getValue())[0];
                                if (param3 == null) continue;
                                params_sub.append(param3);
                                params_sub.append(",");
                                ++index_sub;
                            }
                            FlexFieldGrpCfg metaModel = (FlexFieldGrpCfg)meta;
                            Map mappingTypeSort = ValueSetUtil.getMappingTypeSort((FlexFieldGrpCfg)metaModel);
                            String[] output_prop = (String[])mappingTypeSort.get("output");
                            String[] input_prop = (String[])mappingTypeSort.get("input");
                            for (i = 0; i < output_prop.length; ++i) {
                                param = output_prop[i];
                                params_out.append(param);
                                params_out.append(",");
                                ++index_out;
                            }
                            for (i = 0; i < input_prop.length; ++i) {
                                param = input_prop[i];
                                params_in.append(param);
                                params_in.append(",");
                                ++index_in;
                            }
                            String buildSQLParamHolder_in = QFilterBuilder.buildSQLParamHolder((int)index_in);
                            String buildSQLParamHolder_out = QFilterBuilder.buildSQLParamHolder((int)index_out);
                            String buildSQLParamHolder_sub = QFilterBuilder.buildSQLParamHolder((int)index_sub);
                            String sql_in = "INSERT INTO t_fah_flex_mapval (" + params_in.substring(0, params_in.length() - 1) + ") VALUES " + buildSQLParamHolder_in;
                            String sql_out = "INSERT INTO t_fah_flex_mapval  (" + params_out.substring(0, params_out.length() - 1) + ") VALUES " + buildSQLParamHolder_out;
                            String sql_sub = "INSERT INTO t_fah_flex_mapval_en (" + params_sub.substring(0, params_sub.length() - 1) + ") VALUES " + buildSQLParamHolder_sub;
                            sqlCol.put("in", sql_in);
                            sqlCol.put("out", sql_out);
                            sqlCol.put("sub", sql_sub);
                            sql = SerializationUtils.toJsonString(sqlCol);
                        }
                    }
                } else if (buildSqlSource.SingleLineMappingDataTmp == bs) {
                    if (metaType instanceof SingleLineMappingData) {
                        String param;
                        int i;
                        SingleLineMappingData dataModel = (SingleLineMappingData)metaType;
                        IValueSetMeta meta = dataModel.getMeta();
                        HashMap<String, String> sqlCol = new HashMap<String, String>(3);
                        StringBuilder params_in = new StringBuilder();
                        StringBuilder params_out = new StringBuilder();
                        StringBuilder params_del = new StringBuilder();
                        int index_in = 1;
                        int index_out = 1;
                        int index_del = 1;
                        params_in.append("ftmpid");
                        params_in.append(",");
                        params_out.append("ftmpid");
                        params_out.append(",");
                        params_del.append("ftmpid");
                        params_del.append(",");
                        Iterator iterator = dataModel.getBaseprops().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Object param4 = ((Object[])iterator.next().getValue())[0];
                            if (param4 == null) continue;
                            params_in.append(param4);
                            params_in.append(",");
                            params_out.append(param4);
                            params_out.append(",");
                            params_del.append(param4);
                            params_del.append(",");
                            ++index_in;
                            ++index_out;
                            ++index_del;
                        }
                        if (meta == null) {
                            String buildSQLParamHolder_del = QFilterBuilder.buildSQLParamHolder((int)index_del);
                            String sql_del = "INSERT INTO t_fah_flex_mapval_tmp (" + params_del.substring(0, params_del.length() - 1) + ") VALUES " + buildSQLParamHolder_del;
                            sqlCol.put("del", sql_del);
                            sql = SerializationUtils.toJsonString(sqlCol);
                            return sql;
                        }
                        FlexFieldGrpCfg metaModel = (FlexFieldGrpCfg)meta;
                        Map mappingTypeSort = ValueSetUtil.getMappingTypeSort((FlexFieldGrpCfg)metaModel);
                        String[] output_prop = (String[])mappingTypeSort.get("output");
                        String[] input_prop = (String[])mappingTypeSort.get("input");
                        for (i = 0; i < output_prop.length; ++i) {
                            param = output_prop[i];
                            params_out.append(param);
                            params_out.append(",");
                            ++index_out;
                        }
                        for (i = 0; i < input_prop.length; ++i) {
                            param = input_prop[i];
                            params_in.append(param);
                            params_in.append(",");
                            ++index_in;
                        }
                        String buildSQLParamHolder_in = QFilterBuilder.buildSQLParamHolder((int)index_in);
                        String buildSQLParamHolder_out = QFilterBuilder.buildSQLParamHolder((int)index_out);
                        String buildSQLParamHolder_del = QFilterBuilder.buildSQLParamHolder((int)index_del);
                        String sql_del = "INSERT INTO t_fah_flex_mapval_tmp (" + params_del.substring(0, params_del.length() - 1) + ")  VALUES " + buildSQLParamHolder_del;
                        String sql_in = "INSERT INTO t_fah_flex_mapval_tmp (" + params_in.substring(0, params_in.length() - 1) + ") VALUES " + buildSQLParamHolder_in;
                        String sql_out = "INSERT INTO t_fah_flex_mapval_tmp  (" + params_out.substring(0, params_out.length() - 1) + ") VALUES " + buildSQLParamHolder_out;
                        sqlCol.put("in", sql_in);
                        sqlCol.put("out", sql_out);
                        sqlCol.put("del", sql_del);
                        sql = SerializationUtils.toJsonString(sqlCol);
                    }
                } else if (buildSqlSource.FlexFieldCfg == bs || buildSqlSource.FlexFieldGrpCfg == bs) {
                    // empty if block
                }
            }
        }
        return sql;
    }

    public static void updateMapCountCache(Long mapTypeId) {
        try {
            Integer mapCount = FAHDataCacheMgr.instance.getMappingRowCountCacheService().reloadCache(mapTypeId, new Object[0]);
            logger.info("ValueSetAndMappingutil_updateMapCountCache, mapTypeId: {}, mapCount: {}", (Object)mapTypeId, (Object)mapCount);
        }
        catch (Exception e) {
            logger.error("ValueSetAndMappingutil_updateMapCountCache error,", (Throwable)e);
        }
    }

    public static Integer queryMapRowCountCache(Long mapTypeId) {
        return (Integer)FAHDataCacheMgr.instance.getMappingRowCountCacheService().loadFromCache((Object)mapTypeId, new Object[0]);
    }

    public static boolean checkMapCountCacheConfig(Long mapTypeId) {
        Map mapCountCacheConfigCache = (Map)ThreadCache.get((Object)"ValueSetAndMappingutil.checkMapCountCacheConfig", HashMap::new);
        return mapCountCacheConfigCache.computeIfAbsent(mapTypeId, k -> {
            Integer mapRowCount = ValueSetAndMappingutil.queryMapRowCountCache(mapTypeId);
            String maxMapRowCountStr = SysParamConfig.get((String)"fah.evt.maxMapRowCount", (String)"100000");
            return mapRowCount <= Integer.parseInt(maxMapRowCountStr);
        });
    }

    public static enum buildSqlType {
        insert,
        delete,
        update;

    }

    public static enum buildSqlSource {
        SingleLineValueSetTypeModel,
        SingleValueSetData,
        ValueSetDataCollection,
        ValueSetTypeCollectionMeta,
        MappingDataCollection,
        SingleLineMappingData,
        SingleLineMappingDataTmp,
        FlexFieldCfg,
        FlexFieldGrpCfg;

    }
}

