/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.helper.BizPartnerHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ApgrouprecTreeRpt
extends AbstractReportTreeDataPlugin {
    public List<TreeNode> query(ReportQueryParam arg0, String arg1) throws Throwable {
        ArrayList<TreeNode> rootNodeList = new ArrayList();
        FilterInfo filterInfo = arg0.getFilter();
        DynamicObjectCollection orgcoll = filterInfo.getDynamicObjectCollection("org");
        rootNodeList = this.getTree(orgcoll, filterInfo);
        return rootNodeList;
    }

    private List<TreeNode> getTree(DynamicObjectCollection orgcoll, FilterInfo filterInfo) {
        ArrayList<TreeNode> rootNodeList = new ArrayList<TreeNode>();
        ArrayList childerNodeList = new ArrayList();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApgrouprecTreeRpt_0", (String)"fi-ap-report", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        QFilter filter = new QFilter("org", "in", (Object)StringUtils.getPks((DynamicObjectCollection)orgcoll));
        filter.and(new QFilter("currency", "=", filterInfo.getDynamicObject("currency").getPkValue()));
        filter.and(new QFilter("bizdate", ">=", (Object)DateUtils.getMinMonthDate((Date)filterInfo.getDate("month"))));
        filter.and(new QFilter("bizdate", "<", (Object)DateUtils.getMaxMonthDate((Date)filterInfo.getDate("month"))));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("asstacttype", "!=", (Object)"bos_user"));
        String entity = "ap_finapbill";
        if (!"ap".equals(filterInfo.getString("recondirection"))) {
            entity = "ar_finarbill";
        }
        DataSet billSet = null;
        billSet = QueryServiceHelper.queryDataSet((String)"", (String)entity, (String)"org,asstacttype,asstact", (QFilter[])new QFilter[]{filter}, null);
        GroupbyDataSet billGroupDataSet = billSet.groupBy(new String[]{"asstacttype", "asstact"});
        billSet = billGroupDataSet.finish();
        billSet.forEach(row -> {
            DynamicObject object;
            if (row.get("asstact") != null && StringUtils.isNotEmpty((String)row.getString("asstacttype")) && BizPartnerHelper.isinternalOrg((DynamicObject)(object = BusinessDataServiceHelper.loadSingle((Object)row.get("asstact"), (String)row.getString("asstacttype"))))) {
                List<TreeNode> childrenNodeList = this.getchildren(object);
                childerNodeList.addAll(childrenNodeList);
                root.setId(root.getId() + "-" + object.getPkValue());
            }
        });
        if (root.getId().contains("-")) {
            root.setId(root.getId().replaceFirst("-", ""));
        } else {
            root.setId("-1");
        }
        rootNodeList.add(root);
        root.setChildren(childerNodeList);
        return rootNodeList;
    }

    private List<TreeNode> getchildren(DynamicObject dynamicObject) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        TreeNode root = new TreeNode();
        root.setText(dynamicObject.getString("name"));
        root.setId(String.valueOf(dynamicObject.getLong("id")));
        root.setIsOpened(false);
        nodeList.add(root);
        return nodeList;
    }
}

