/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BizPartnerHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.vo.BalanceInfo;
import kd.fi.arapcommon.vo.IntragroupParam;

public class InternalrecDataRpt
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        if ("-1".equals(arg1)) {
            return this.createDataSet(null);
        }
        IntragroupParam param = this.getParam(arg0, arg1);
        DataSet dataset = this.getsettleBalance(param);
        dataset = dataset.addField("0", "sumlevel");
        SumParam sumParam = new SumParam(SumParam.SumType.TOTAL);
        sumParam.addSummaryField(new String[]{"reconperiod", "conperiod", "perioddiff"});
        sumParam.addSummaryField(new String[]{"reconcurrentinc", "concurrentinc", "incdiff"});
        sumParam.addSummaryField(new String[]{"reconcurrentdec", "concurrentdec", "decdiff"});
        sumParam.addSummaryField(new String[]{"reconbalance", "conbalance", "balancediff"});
        DataSet sumDataSet = DataSetUtils.sum((DataSet)dataset, (SumParam)sumParam);
        return dataset.union(sumDataSet);
    }

    private DataSet getsettleBalance(IntragroupParam param) {
        DynamicObjectCollection orgColl = param.getOrgs();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>();
        for (int i = 0; i < orgColl.size(); ++i) {
            for (int a = 0; a < param.getAsstact().size(); ++a) {
                Long asstactId = Long.valueOf((String)param.getAsstact().get(a));
                if (!this.ishappend(param, ((DynamicObject)orgColl.get(i)).getLong("id"), asstactId)) continue;
                DynamicObject asstact = null;
                asstact = QueryServiceHelper.exists((String)"bd_customer", (Object)asstactId) ? BusinessDataServiceHelper.loadSingle((Object)asstactId, (String)"bd_customer") : BusinessDataServiceHelper.loadSingle((Object)asstactId, (String)"bd_supplier");
                BalanceInfo info = new BalanceInfo();
                info.setOrg(((DynamicObject)orgColl.get(i)).getLong("id"));
                info.setAsstact(asstact.getLong("id"));
                info.setAsstactName(asstact.getString("name"));
                info.setDirection(param.getDirection());
                info.setCurrency(param.getCurrencys().getLong("id"));
                info = this.fillRow(info, param);
                if ("havedifference".equals(param.getDatatype())) {
                    if (info.isZero(info)) continue;
                    balanceInfos.add(info);
                    continue;
                }
                if ("nodifference".equals(param.getDatatype())) {
                    if (!info.isZero(info)) continue;
                    balanceInfos.add(info);
                    continue;
                }
                balanceInfos.add(info);
            }
        }
        return this.createDataSet(balanceInfos);
    }

    private boolean ishappend(IntragroupParam param, long orgId, Long asstact) {
        QFilter filter = new QFilter("org", "in", (Object)orgId);
        filter.and(new QFilter("currency", "=", param.getCurrencys().getPkValue()));
        filter.and(new QFilter("bizdate", ">=", (Object)param.getStartDate()));
        filter.and(new QFilter("bizdate", "<", (Object)param.getStopDate()));
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("asstact", "=", (Object)asstact));
        filter.and(new QFilter("asstacttype", "!=", (Object)"bos_user"));
        String entity = "ap_finapbill";
        if (!"ap".equals(param.getDirection())) {
            entity = "ar_finarbill";
        }
        return QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{filter});
    }

    private BalanceInfo fillRow(BalanceInfo info, IntragroupParam param) {
        this.fillperiodamt(info, param);
        this.fillhappen(info, param);
        this.fillbalance(info, param);
        return info;
    }

    private void fillbalance(BalanceInfo balanceInfo, IntragroupParam param) {
        balanceInfo.setBalanceamt(balanceInfo.getPeriodamt().add(balanceInfo.getIncrementamt()).subtract(balanceInfo.getReductionamt()));
        balanceInfo.setCorbalanceamt(balanceInfo.getCorperiodamt().add(balanceInfo.getCorincrementamt()).subtract(balanceInfo.getCorreductionamt()));
    }

    private void fillhappen(BalanceInfo info, IntragroupParam param) {
        QFilter banhappenFilter = new QFilter("bizdate", ">=", (Object)param.getStartDate());
        banhappenFilter.and("bizdate", "<", (Object)param.getStopDate());
        info.setStopdate(param.getStopDate());
        if ("ap".equals(info.getDirection())) {
            this.gethappenInfo(banhappenFilter, info, false, true);
            this.getarhappenInfo(banhappenFilter, info, false, false);
        } else {
            this.getarhappenInfo(banhappenFilter, info, false, true);
            this.gethappenInfo(banhappenFilter, info, false, false);
        }
    }

    private void fillperiodamt(BalanceInfo info, IntragroupParam param) {
        DataSet mainBalance = this.queryMainBalance(param, info);
        for (Row row : mainBalance) {
            info.setPeriodamt(row.getBigDecimal("periodamt"));
            info.setStopdate(param.getStartDate());
        }
        IntragroupParam assparam = this.getassparam(param, info);
        DataSet asstactBalance = this.queryAsstactBalance(assparam, info);
        for (Row row : asstactBalance) {
            info.setCorperiodamt(row.getBigDecimal("periodamt"));
            info.setCorrstopDate(param.getStartDate());
        }
    }

    private DataSet queryMainBalance(IntragroupParam mainParam, BalanceInfo info) {
        DynamicObjectCollection orgColl = mainParam.getOrgs();
        List orgIds = DynamicObjectHelper.getLongIds((Collection)orgColl);
        Date startDate = mainParam.getStartDate();
        DynamicObject currency = mainParam.getCurrencys();
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
        customFilters.add(new QFilter("asstact", "=", (Object)info.getAsstact()));
        customFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        List<String> balanceDimensions = Arrays.asList("org", "asstacttype", "asstact", "currency");
        BalanceType banlanceType = "ap".equals(info.getDirection()) ? BalanceType.AP_FIN_PREPAID : BalanceType.AR_FIN_RECEIVED;
        BalanceQuerier balanceQuerier = new BalanceQuerier(banlanceType);
        return balanceQuerier.queryBalance(orgIds, startDate, balanceDimensions, customFilters);
    }

    private DataSet queryAsstactBalance(IntragroupParam asstactParam, BalanceInfo info) {
        DynamicObject org = asstactParam.getCororg();
        Date startDate = asstactParam.getStartDate();
        DynamicObject currency = asstactParam.getCurrencys();
        DynamicObject[] asstactObjects = asstactParam.getCorasstact();
        if (asstactObjects == null) {
            String orgName = asstactParam.getOrgs() == null || asstactParam.getOrgs().size() < 1 ? "" : ((DynamicObject)asstactParam.getOrgs().get(0)).getString("name");
            String message = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u975e\u5185\u90e8\u5ba2\u5546\uff0c\u65e0\u6cd5\u8fdb\u884c\u96c6\u56e2\u5185\u90e8\u5bf9\u8d26\u3002", (String)"InternalrecDataRpt_0", (String)"fi-ap-report", (Object[])new Object[0]), orgName);
            throw new KDBizException(message);
        }
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
        customFilters.add(new QFilter("asstact", "in", (Object)StringUtils.getPks((DynamicObject[])asstactObjects)));
        customFilters.add(new QFilter("currency", "=", currency.getPkValue()));
        List<Long> orgIds = Collections.singletonList(org.getLong("id"));
        List<String> balanceDimensions = Arrays.asList("org", "currency");
        BalanceType banlanceType = "ap".equals(asstactParam.getDirection()) ? BalanceType.AP_FIN_PREPAID : BalanceType.AR_FIN_RECEIVED;
        BalanceQuerier balanceQuerier = new BalanceQuerier(banlanceType);
        return balanceQuerier.queryBalance(orgIds, startDate, balanceDimensions, customFilters);
    }

    private IntragroupParam getassparam(IntragroupParam mainparam, BalanceInfo info) {
        IntragroupParam param = new IntragroupParam();
        DynamicObject[] cussup = BizPartnerHelper.getcussup((long)info.getOrg());
        param.setCorasstact(cussup);
        info.setCorasstacts(cussup);
        DynamicObject cus = null;
        cus = QueryServiceHelper.exists((String)"bd_supplier", (Object)info.getAsstact()) ? BusinessDataServiceHelper.loadSingle((Object)info.getAsstact(), (String)"bd_supplier") : BusinessDataServiceHelper.loadSingle((Object)info.getAsstact(), (String)"bd_customer");
        DynamicObject org = BizPartnerHelper.getinternalOrg((DynamicObject)cus);
        param.setCororg(org);
        info.setCororg(org.getLong("id"));
        param.setCurrencys(mainparam.getCurrencys());
        param.setStartDate(mainparam.getStartDate());
        param.setDirection("ap".equals(mainparam.getDirection()) ? "ar" : "ap");
        param.setOrgs(mainparam.getOrgs());
        return param;
    }

    private BalanceInfo gethappenInfo(QFilter happenFilter, BalanceInfo balanceInfo, boolean isperiod, boolean ismain) {
        QFilter baseFilter = this.getHanppenFilter(balanceInfo, ismain);
        String[] fingroup = null;
        fingroup = ismain ? new String[]{"org", "asstact"} : new String[]{"org"};
        DataSet finSet = null;
        finSet = QueryServiceHelper.queryDataSet((String)"", (String)"ap_finapbill", (String)"org,asstacttype,asstact,currency,pricetaxtotal,pricetaxtotalbase,bizdate", (QFilter[])new QFilter[]{baseFilter, happenFilter}, null);
        GroupbyDataSet balanceGroupDataSet = finSet.groupBy(fingroup);
        balanceGroupDataSet.sum("pricetaxtotal", "sumamount");
        finSet = balanceGroupDataSet.finish();
        finSet.forEach(row -> {
            if (isperiod) {
                if (ismain) {
                    balanceInfo.setPeriodamt(balanceInfo.getPeriodamt().add(row.getBigDecimal("sumamount")));
                } else {
                    balanceInfo.setCorperiodamt(balanceInfo.getCorperiodamt().add(row.getBigDecimal("sumamount")));
                }
            } else if (ismain) {
                balanceInfo.setIncrementamt(balanceInfo.getIncrementamt().add(row.getBigDecimal("sumamount")));
            } else {
                balanceInfo.setCorincrementamt(balanceInfo.getCorincrementamt().add(row.getBigDecimal("sumamount")));
            }
        });
        DataSet paySet = null;
        QFilter payFilter = this.getpayFilter(balanceInfo, ismain);
        String[] paygroup = null;
        paygroup = ismain ? new String[]{"org", "payee"} : new String[]{"org"};
        paySet = QueryServiceHelper.queryDataSet((String)"", (String)"cas_paybill", (String)"org,payeeformid,payee,currency,actpayamt", (QFilter[])new QFilter[]{payFilter, happenFilter}, null);
        GroupbyDataSet payGroupDataSet = paySet.groupBy(paygroup);
        payGroupDataSet.sum("actpayamt", "sumamount");
        paySet = payGroupDataSet.finish();
        paySet.forEach(row -> {
            if (isperiod) {
                if (ismain) {
                    balanceInfo.setPeriodamt(balanceInfo.getPeriodamt().subtract(row.getBigDecimal("sumamount")));
                } else {
                    balanceInfo.setCorperiodamt(balanceInfo.getCorperiodamt().subtract(row.getBigDecimal("sumamount")));
                }
            } else if (ismain) {
                balanceInfo.setReductionamt(row.getBigDecimal("sumamount"));
            } else {
                balanceInfo.setCorreductionamt(row.getBigDecimal("sumamount"));
            }
        });
        QFilter settleFilter = this.getSettleFilter(balanceInfo, ismain);
        QFilter settleDateFilter = new QFilter("settledate", ">=", happenFilter.getValue());
        settleDateFilter.and("settledate", "<=", ((QFilter.QFilterNest)happenFilter.getNests(false).get(0)).getFilter().getValue());
        String[] settlegroup = null;
        settlegroup = ismain ? new String[]{"org", "mainasstactid"} : new String[]{"org"};
        DataSet settleSet = QueryServiceHelper.queryDataSet((String)"", (String)"ap_settlerecord", (String)"org,mainasstacttype,mainasstactid,totalsettleamt,maincurrency", (QFilter[])new QFilter[]{settleFilter, settleDateFilter}, null);
        QFilter orgFilter = new QFilter("org", "=", (Object)(ismain ? balanceInfo.getOrg() : balanceInfo.getCororg()));
        QFilter settleRelationFilter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.ARAPSETTLE.getValue());
        QFilter currencyFilter = new QFilter("maincurrency", "=", (Object)balanceInfo.getCurrency());
        QFilter asstAsstactFilter = new QFilter("entry.asstactid", "in", (Object)(ismain ? Long.valueOf(balanceInfo.getAsstact()) : StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
        DataSet asstSettleRecord = QueryServiceHelper.queryDataSet((String)"queryapasst", (String)"ar_settlerecord", (String)"org,entry.asstacttype mainasstacttype,entry.asstactid mainasstactid,entry.settleamt totalsettleamt,maincurrency", (QFilter[])new QFilter[]{orgFilter, settleRelationFilter, currencyFilter, asstAsstactFilter, settleDateFilter}, null);
        settleSet = settleSet.union(asstSettleRecord);
        GroupbyDataSet settleGroupDataSet = settleSet.groupBy(settlegroup);
        settleGroupDataSet.sum("totalsettleamt", "sumamount");
        settleSet = settleGroupDataSet.finish();
        settleSet.forEach(row -> {
            if (isperiod) {
                if (ismain) {
                    balanceInfo.setPeriodamt(balanceInfo.getPeriodamt().subtract(row.getBigDecimal("sumamount")));
                } else {
                    balanceInfo.setCorperiodamt(balanceInfo.getCorperiodamt().subtract(row.getBigDecimal("sumamount")));
                }
            } else if (ismain) {
                balanceInfo.setReductionamt(balanceInfo.getReductionamt().add(row.getBigDecimal("sumamount")));
            } else {
                balanceInfo.setCorreductionamt(balanceInfo.getCorreductionamt().add(row.getBigDecimal("sumamount")));
            }
        });
        return balanceInfo;
    }

    private QFilter getSettleFilter(BalanceInfo balanceInfo, boolean ismain) {
        ArrayList<String> settlerelation = new ArrayList<String>();
        settlerelation.add(SettleRelationEnum.APLIQUIDATIONSETTLE.getValue());
        settlerelation.add(SettleRelationEnum.PAYTRANS.getValue());
        settlerelation.add(SettleRelationEnum.APARSETTLE.getValue());
        settlerelation.add(SettleRelationEnum.BADDEBTLOSS.getValue());
        settlerelation.add(SettleRelationEnum.APRECSETTLE.getValue());
        QFilter filters = new QFilter("settlerelation", "in", settlerelation);
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getOrg())) {
            if (ismain) {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getOrg()));
            } else {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getCororg()));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getAsstact())) {
            if (ismain) {
                filters.and(new QFilter("mainasstactid", "=", (Object)balanceInfo.getAsstact()));
            } else {
                filters.and(new QFilter("mainasstactid", "in", (Object)StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getCurrency())) {
            filters.and(new QFilter("maincurrency", "=", (Object)balanceInfo.getCurrency()));
        }
        return filters;
    }

    private QFilter getpayFilter(BalanceInfo balanceInfo, boolean ismain) {
        QFilter filters = new QFilter("billstatus", "=", (Object)"D");
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getOrg())) {
            if (ismain) {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getOrg()));
            } else {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getCororg()));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getAsstact())) {
            if (ismain) {
                filters.and(new QFilter("payee", "=", (Object)balanceInfo.getAsstact()));
            } else {
                filters.and(new QFilter("payee", "in", (Object)StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getCurrency())) {
            filters.and(new QFilter("currency", "=", (Object)balanceInfo.getCurrency()));
        }
        return filters;
    }

    private BalanceInfo getarhappenInfo(QFilter dateFilter, BalanceInfo balanceInfo, boolean isperiod, boolean ismain) {
        QFilter baseFilter = this.getHanppenFilter(balanceInfo, ismain);
        String[] finargroupBy = new String[]{};
        finargroupBy = ismain ? new String[]{"org", "asstact"} : new String[]{"org"};
        DataSet finSet = null;
        finSet = QueryServiceHelper.queryDataSet((String)"", (String)"ar_finarbill", (String)"org,asstacttype,asstact,currency,recamount,reclocalamt,bizdate", (QFilter[])new QFilter[]{baseFilter, dateFilter}, null);
        GroupbyDataSet balanceGroupDataSet = finSet.groupBy(finargroupBy);
        balanceGroupDataSet.sum("recamount", "sumamount");
        finSet = balanceGroupDataSet.finish();
        finSet.forEach(row -> {
            if (isperiod) {
                if (ismain) {
                    balanceInfo.setPeriodamt(balanceInfo.getPeriodamt().add(row.getBigDecimal("sumamount")));
                } else {
                    balanceInfo.setCorperiodamt(balanceInfo.getCorperiodamt().add(row.getBigDecimal("sumamount")));
                }
            } else if (ismain) {
                balanceInfo.setIncrementamt(balanceInfo.getIncrementamt().add(row.getBigDecimal("sumamount")));
            } else {
                balanceInfo.setCorincrementamt(balanceInfo.getCorincrementamt().add(row.getBigDecimal("sumamount")));
            }
        });
        DataSet recSet = null;
        QFilter recFilter = this.getrecFilter(balanceInfo, ismain);
        String[] recgroupBy = new String[]{};
        recgroupBy = ismain ? new String[]{"org", "payer"} : new String[]{"org"};
        recSet = QueryServiceHelper.queryDataSet((String)"", (String)"cas_recbill", (String)"org,payerformid,payer,currency,actrecamt", (QFilter[])new QFilter[]{recFilter, dateFilter}, null);
        GroupbyDataSet recGroupDataSet = recSet.groupBy(recgroupBy);
        recGroupDataSet.sum("actrecamt", "sumamount");
        recSet = recGroupDataSet.finish();
        recSet.forEach(row -> {
            if (isperiod) {
                if (ismain) {
                    balanceInfo.setPeriodamt(balanceInfo.getPeriodamt().subtract(row.getBigDecimal("sumamount")));
                } else {
                    balanceInfo.setCorperiodamt(balanceInfo.getCorperiodamt().subtract(row.getBigDecimal("sumamount")));
                }
            } else if (ismain) {
                balanceInfo.setReductionamt(balanceInfo.getReductionamt().add(row.getBigDecimal("sumamount")));
            } else {
                balanceInfo.setCorreductionamt(balanceInfo.getCorreductionamt().add(row.getBigDecimal("sumamount")));
            }
        });
        QFilter settleFilter = this.getArSettleFilter(balanceInfo, ismain);
        String[] settlegroup = null;
        settlegroup = ismain ? new String[]{"org", "mainasstactid"} : new String[]{"org"};
        DataSet settleSet = null;
        QFilter settleDateFilter = new QFilter("settledate", ">=", dateFilter.getValue());
        settleDateFilter.and("settledate", "<=", ((QFilter.QFilterNest)dateFilter.getNests(false).get(0)).getFilter().getValue());
        settleSet = QueryServiceHelper.queryDataSet((String)"", (String)"ap_settlerecord", (String)"org,mainasstacttype,mainasstactid,totalsettleamt,maincurrency", (QFilter[])new QFilter[]{settleFilter, settleDateFilter}, null);
        QFilter orgFilter = new QFilter("org", "=", (Object)(ismain ? balanceInfo.getOrg() : balanceInfo.getCororg()));
        QFilter settleRelationFilter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.APARSETTLE.getValue());
        QFilter currencyFilter = new QFilter("maincurrency", "=", (Object)balanceInfo.getCurrency());
        QFilter asstAsstactFilter = new QFilter("entry.asstactid", "in", (Object)(ismain ? Long.valueOf(balanceInfo.getAsstact()) : StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
        DataSet asstSettleRecord = QueryServiceHelper.queryDataSet((String)"queryarasst", (String)"ap_settlerecord", (String)"org,entry.asstacttype mainasstacttype,entry.asstactid mainasstactid,entry.settleamt totalsettleamt,maincurrency", (QFilter[])new QFilter[]{orgFilter, settleRelationFilter, currencyFilter, asstAsstactFilter, settleDateFilter}, null);
        settleSet = settleSet.union(asstSettleRecord);
        GroupbyDataSet settleGroupDataSet = settleSet.groupBy(settlegroup);
        settleGroupDataSet.sum("totalsettleamt", "sumamount");
        settleSet = settleGroupDataSet.finish();
        settleSet.forEach(row -> {
            if (isperiod) {
                if (ismain) {
                    balanceInfo.setPeriodamt(balanceInfo.getPeriodamt().subtract(row.getBigDecimal("sumamount")));
                } else {
                    balanceInfo.setCorperiodamt(balanceInfo.getCorperiodamt().subtract(row.getBigDecimal("sumamount")));
                }
            } else if (ismain) {
                balanceInfo.setReductionamt(balanceInfo.getReductionamt().add(row.getBigDecimal("sumamount")));
            } else {
                balanceInfo.setCorreductionamt(balanceInfo.getCorreductionamt().add(row.getBigDecimal("sumamount")));
            }
        });
        return balanceInfo;
    }

    private QFilter getArSettleFilter(BalanceInfo balanceInfo, boolean ismain) {
        ArrayList<String> settlerelation = new ArrayList<String>();
        settlerelation.add(SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue());
        settlerelation.add(SettleRelationEnum.ARTRANSFER.getValue());
        settlerelation.add(SettleRelationEnum.BADDEBTLOSS.getValue());
        settlerelation.add(SettleRelationEnum.ARAPSETTLE.getValue());
        settlerelation.add(SettleRelationEnum.ARPAYSETTLE.getValue());
        QFilter filters = new QFilter("settlerelation", "in", settlerelation);
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getOrg())) {
            if (ismain) {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getOrg()));
            } else {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getCororg()));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getAsstact())) {
            if (ismain) {
                filters.and(new QFilter("mainasstactid", "=", (Object)balanceInfo.getAsstact()));
            } else {
                filters.and(new QFilter("mainasstactid", "in", (Object)StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getCurrency())) {
            filters.and(new QFilter("maincurrency", "=", (Object)balanceInfo.getCurrency()));
        }
        return filters;
    }

    private QFilter getrecFilter(BalanceInfo balanceInfo, boolean ismain) {
        QFilter filters = new QFilter("billstatus", "=", (Object)"D");
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getOrg())) {
            if (ismain) {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getOrg()));
            } else {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getCororg()));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getAsstact())) {
            if (ismain) {
                filters.and(new QFilter("payer", "=", (Object)balanceInfo.getAsstact()));
            } else {
                filters.and(new QFilter("payer", "in", (Object)StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getCurrency())) {
            filters.and(new QFilter("currency", "=", (Object)balanceInfo.getCurrency()));
        }
        return filters;
    }

    private DataSet createDataSet(List<BalanceInfo> balanceList) {
        List<Object[]> rows = this.createRow(balanceList);
        Algo algo = Algo.create((String)(((Object)((Object)this)).getClass().getName() + ".query"));
        DataSetBuilder builder = algo.createDataSetBuilder(this.getRowMeta());
        if (rows != null && rows.size() > 0) {
            for (Object[] values : rows) {
                builder.append(values);
            }
        }
        return builder.build();
    }

    private RowMeta getRowMeta() {
        List<Field> fields = this.getRowMetaField();
        return new RowMeta(fields.toArray(new Field[0]));
    }

    private List<Field> getRowMetaField() {
        ArrayList<Field> fields = new ArrayList<Field>(18);
        fields.add(new Field("reorgunit", (DataType)DataType.LongType));
        fields.add(new Field("basecurrency", (DataType)DataType.LongType));
        fields.add(new Field("corassact", (DataType)DataType.StringType));
        fields.add(new Field("recondir", (DataType)DataType.StringType));
        fields.add(new Field("corcondir", (DataType)DataType.StringType));
        fields.add(new Field("receonmonth", (DataType)DataType.StringType));
        fields.add(new Field("reconperiod", (DataType)DataType.BigDecimalType));
        fields.add(new Field("conperiod", (DataType)DataType.BigDecimalType));
        fields.add(new Field("perioddiff", (DataType)DataType.BigDecimalType));
        fields.add(new Field("reconcurrentinc", (DataType)DataType.BigDecimalType));
        fields.add(new Field("concurrentinc", (DataType)DataType.BigDecimalType));
        fields.add(new Field("incdiff", (DataType)DataType.BigDecimalType));
        fields.add(new Field("reconcurrentdec", (DataType)DataType.BigDecimalType));
        fields.add(new Field("concurrentdec", (DataType)DataType.BigDecimalType));
        fields.add(new Field("decdiff", (DataType)DataType.BigDecimalType));
        fields.add(new Field("reconbalance", (DataType)DataType.BigDecimalType));
        fields.add(new Field("conbalance", (DataType)DataType.BigDecimalType));
        fields.add(new Field("balancediff", (DataType)DataType.BigDecimalType));
        return fields;
    }

    private List<Object[]> createRow(List<BalanceInfo> balanceList) {
        if (balanceList == null) {
            return null;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(balanceList.size());
        for (int i = 0; i < balanceList.size(); ++i) {
            BalanceInfo info = balanceList.get(i);
            Object[] row = new Object[18];
            row[0] = info.getOrg();
            row[1] = info.getCurrency();
            row[2] = info.getAsstactName();
            row[3] = info.getDirection();
            row[4] = "ap".equals(info.getDirection()) ? "ar" : "ap";
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
            row[5] = formatter.format(info.getStopdate());
            row[6] = info.getPeriodamt();
            row[7] = info.getCorperiodamt();
            row[8] = info.getPeriodamt().subtract(info.getCorperiodamt());
            row[9] = info.getIncrementamt();
            row[10] = info.getCorincrementamt();
            row[11] = info.getIncrementamt().subtract(info.getCorincrementamt());
            row[12] = info.getReductionamt();
            row[13] = info.getCorreductionamt();
            row[14] = info.getReductionamt().subtract(info.getCorreductionamt());
            row[15] = info.getBalanceamt();
            row[16] = info.getCorbalanceamt();
            row[17] = info.getBalanceamt().subtract(info.getCorbalanceamt());
            rows.add(row);
        }
        return rows;
    }

    private QFilter getHanppenFilter(BalanceInfo balanceInfo, boolean ismain) {
        QFilter filters = new QFilter("billstatus", "=", (Object)"C");
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getOrg())) {
            if (ismain) {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getOrg()));
            } else {
                filters.and(new QFilter("org", "=", (Object)balanceInfo.getCororg()));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getAsstact())) {
            if (ismain) {
                filters.and(new QFilter("asstact", "=", (Object)balanceInfo.getAsstact()));
            } else {
                filters.and(new QFilter("asstact", "in", (Object)StringUtils.getPks((DynamicObject[])balanceInfo.getCorasstacts())));
            }
        }
        if (!EmptyUtils.isEmpty((Object)balanceInfo.getCurrency())) {
            filters.and(new QFilter("currency", "=", (Object)balanceInfo.getCurrency()));
        }
        return filters;
    }

    private IntragroupParam getParam(ReportQueryParam arg0, Object arg1) {
        IntragroupParam param = new IntragroupParam();
        FilterInfo filter = arg0.getFilter();
        param.setOrgs(filter.getDynamicObjectCollection("org"));
        param.setDirection(filter.getString("recondirection"));
        Date filterDate = filter.getDate("month");
        param.setStartDate(DateUtils.getMinMonthDate((Date)filterDate));
        param.setStopDate(DateUtils.getMaxMonthDate((Date)filterDate));
        param.setCurrencys(filter.getDynamicObject("currency"));
        param.setAsstact(Arrays.asList(arg1.toString().split("-")));
        param.setDatatype(filter.getString("state"));
        return param;
    }
}

