/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.ap.helper.OrgHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.helper.BaseDataHelper;

public class MaturityLiabFormRpt
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7();
        ReportList rptList = (ReportList)this.getView().getControl("reportlistap");
        rptList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent event) {
                String scope = (String)MaturityLiabFormRpt.this.getModel().getValue("billscope");
                if ("billno".equals(event.getFieldName())) {
                    int rowIndex = event.getRowIndex();
                    ReportList reportList = (ReportList)event.getSource();
                    IReportListModel reportModel = reportList.getReportModel();
                    DynamicObject rowData = reportModel.getRowData(rowIndex);
                    MaturityLiabFormRpt.this.showFormEditPage(scope, rowData);
                }
            }
        });
        BasedataEdit asstactEdit = (BasedataEdit)this.getControl("asstact");
        asstactEdit.addBeforeF7SelectListener(event -> {
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
            if (orgs.isEmpty()) {
                return;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>();
            for (DynamicObject org : orgs) {
                orgIds.add(org.getDynamicObject("fbasedataid").getLong("id"));
            }
            String asstactType = (String)this.getModel().getValue("asstacttype");
            if (!ObjectUtils.isEmpty((Object)asstactType)) {
                QFilter basedataFilter = BaseDataHelper.getBasedataFilter((String)asstactType, orgIds);
                List qFilters = listShowParameter.getListFilterParameter().getQFilters();
                qFilters.add(basedataFilter);
            }
        });
    }

    private void initF7() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        List orglist = OrgHelper.getAuthorizedInitializedOrgs((String)"ap_mlreport", (String)"47150e89000000ac");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (orgCtrl.getQFilter() == null) {
                QFilter qFilter = new QFilter("id", "in", (Object)OrgHelper.getIdList((List)orglist));
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        List orgList = OrgHelper.getAuthorizedInitializedOrgs((String)"ap_mlreport", (String)"47150e89000000ac");
        List orgIdList = OrgHelper.getIdList((List)orgList);
        long loginOrgID = RequestContext.get().getOrgId();
        if (!orgIdList.isEmpty()) {
            long orgId = (Long)orgIdList.get(0);
            if (orgIdList.contains(loginOrgID)) {
                orgId = loginOrgID;
            }
            this.getModel().setValue("org", (Object)new Object[]{orgId});
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObjectCollection orgs = queryParam.getFilter().getDynamicObjectCollection("org");
        if (orgs == null || orgs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MaturityLiabFormRpt_1", (String)"fi-ap-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        Date date = queryParam.getFilter().getDate("date");
        if (ObjectUtils.isEmpty((Object)date)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u65e5\u671f\u3002", (String)"MaturityLiabFormRpt_4", (String)"fi-ap-report", (Object[])new Object[0]), Integer.valueOf(3000));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            Date duedate = row.getDate("duedate");
            Date date = queryParam.getFilter().getDate("date");
            if (duedate == null || date == null) continue;
            row.set("duedays", (Object)DateUtils.getDiffDaysIgnoreTime((Date)duedate, (Date)date));
        }
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn col = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = col.getFieldKey();
        if (2 == rowData.getInt("sumlevel") && "asstactcol".equals(fieldKey)) {
            packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"total", (String)"fi-ap-report", (Object[])new Object[0]));
        }
    }

    private void showFormEditPage(String scope, DynamicObject rowData) {
        String formId = "FIN".equals(scope) ? "ap_finapbill" : "ap_businessapbill";
        BillShowParameter parameter = new BillShowParameter();
        if (rowData.getLong("pk") > 0L) {
            parameter.setPkId((Object)rowData.getLong("pk"));
            parameter.setFormId(formId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            boolean isPeriod = rowData.getBoolean("isperiod");
            parameter.setCustomParam("isPeriod", (Object)isPeriod);
            if (isPeriod) {
                String caption = "ap_finapbill".equals(formId) ? ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"MaturityLiabFormRpt_2", (String)"fi-ap-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u521d\u6682\u4f30\u5e94\u4ed8\u5355", (String)"MaturityLiabFormRpt_3", (String)"fi-ap-report", (Object[])new Object[0]);
                parameter.setCaption(caption);
            }
            this.getView().showForm((FormShowParameter)parameter);
        }
    }
}

