/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.helper.OrgHelper;
import kd.fi.arapcommon.report.ReportHelper;

public class MaturityLiabRptListDataPlugin
extends AbstractReportListDataPlugin {
    private FilterInfo filterInfo;
    private static final Log logger = LogFactory.getLog(MaturityLiabRptListDataPlugin.class);

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        this.filterInfo = queryParam.getFilter();
        String billscope = this.filterInfo.getString("billscope");
        try {
            DataSet ds = null;
            if ("FIN".equals(billscope)) {
                ds = this.getFinDataSet();
            } else if ("BUS".equals(billscope)) {
                // empty if block
            }
            return ds;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    protected DataSet getFinDataSet() {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"Query.Fin", (String)"ap_finapbill", (String)"id pk,isperiod,org orgcol,asstacttype asstacttypecol,asstact asstactcol,currency currencycol,payorg,billtypeid billtype,billno,billstatus,bizdate,duedate,pricetaxtotal,unsettleamount,detailentry.lockedamt lockedamt,detailentry.settledamt settledamt,0 dueamt,0 dueunverifyamt,0 duenoninvamt,remark", (QFilter[])this.getFinQueryFilter().toArray(), (String)"bizdate,duedate");
        dataSet = dataSet.groupBy(new String[]{"pk", "isperiod", "orgcol", "asstacttypecol", "asstactcol", "currencycol", "payorg", "billtype", "billno", "billstatus", "bizdate", "duedate", "pricetaxtotal", "unsettleamount", "dueamt", "dueunverifyamt", "duenoninvamt", "remark"}).sum("lockedamt").sum("settledamt").finish();
        dataSet = dataSet.addField("lockedamt-settledamt", "topayamt");
        dataSet = dataSet.filter("orgcol>0");
        dataSet = dataSet.addField("0", "sumlevel");
        DataSet sumDataSet = dataSet.groupBy().sum("pricetaxtotal").sum("unsettleamount").sum("topayamt").finish();
        sumDataSet = sumDataSet.select(new String[]{"null pk", "null isperiod", "null orgcol", "null asstacttype", "null asstact", "null currencycol", "null payorg", "null billtype", "'' billno", "'' billstatus", "null bizdate", "null duedate", "pricetaxtotal", "unsettleamount", "null dueamt", "null dueunverifyamt", "null duenoninvamt", "'' remark", "null lockedamt", "null settledamt", "topayamt", "2 sumlevel"});
        dataSet = dataSet.union(sumDataSet);
        dataSet = dataSet.orderBy(new String[]{"sumlevel", "orgcol", "currencycol"});
        return dataSet;
    }

    @Deprecated
    protected QFilter getFinQueryFilter() {
        QFilter filter = this.getBaseQueryFilter();
        Date date = this.filterInfo.getDate("date");
        if (date != null) {
            filter = filter.and("duedate", "<", (Object)date);
        }
        filter = filter.and("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"});
        filter = filter.and("pricetaxtotal", "<>", (Object)BigDecimal.ZERO);
        return filter;
    }

    protected QFilter getBusQueryFilter() {
        QFilter filter = this.getBaseQueryFilter();
        Date date = this.filterInfo.getDate("date");
        if (date != null) {
            filter = filter.and("duedate", "<", (Object)date);
        }
        filter = filter.and("verifystatus", "in", (Object)new String[]{"A", "C"});
        return filter;
    }

    protected QFilter getBaseQueryFilter() {
        boolean isIncludeUnaudit;
        DynamicObjectCollection orgColl = this.filterInfo.getDynamicObjectCollection("org");
        QFilter filter = new QFilter("org", "in", (Object)OrgHelper.getIdList((List)orgColl));
        String asstacttype = this.filterInfo.getString("asstacttype");
        if (asstacttype != null && !"".equals(asstacttype)) {
            filter = filter.and("asstacttype", "=", (Object)asstacttype);
            DynamicObject asstact = this.filterInfo.getDynamicObject("asstact");
            List asstactIds = ReportHelper.getBasedataIds((DynamicObject)asstact);
            if (!asstactIds.isEmpty()) {
                filter = filter.and("asstact", "in", (Object)asstactIds);
            }
        } else {
            filter = filter.and(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        DynamicObjectCollection currencyColl = this.filterInfo.getDynamicObjectCollection("currency");
        if (currencyColl != null && currencyColl.size() > 0) {
            filter = filter.and("currency", "in", (Object)OrgHelper.getIdList((List)currencyColl));
        }
        filter = (isIncludeUnaudit = this.filterInfo.getBoolean("isincludesubmit")) ? filter.and("billstatus", "in", (Object)new String[]{"B", "C"}) : filter.and("billstatus", "=", (Object)"C");
        return filter;
    }
}

