/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report.acctage;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.ap.report.acctage.ApAcctageQuerierExt;
import kd.fi.ap.report.acctage.impl.ApAcctageQuerier;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.acctage.AcctageCustomizer;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ApAcctageListDataRptExt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ApAcctageListDataRptExt.class);

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        try {
            DataSet queryData = this.queryData(queryParam);
            return queryData;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private DataSet queryData(ReportQueryParam queryParam) throws Exception {
        String entity = (String)queryParam.getFilter().getFilterItem("sourceentity").getValue();
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isShowLocalAmt = filterInfo.getBoolean("showlocalamt");
        ApAcctageQuerierExt acctageQuerier = new ApAcctageQuerierExt();
        if ("ap_finapbill".equals(entity)) {
            AcctageRptParam finQueryParam = this.setCommonParam(queryParam, "ap_finapbill");
            return acctageQuerier.queryFinData(finQueryParam, true, isShowLocalAmt);
        }
        if ("ap_busbill".equals(entity)) {
            AcctageRptParam busQueryParam = this.setCommonParam(queryParam, "ap_busbill");
            return acctageQuerier.queryBusData(busQueryParam, true, isShowLocalAmt);
        }
        if ("ALL".equals(entity)) {
            AcctageRptParam finQueryParam = this.setCommonParam(queryParam, "ap_finapbill");
            AcctageRptParam busQueryParam = this.setCommonParam(queryParam, "ap_busbill");
            return acctageQuerier.queryAll(finQueryParam, busQueryParam, isShowLocalAmt);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u6790\u8868\u6682\u4e0d\u652f\u6301\u6570\u636e\u6e90\u201c%s\u201d\u3002", (String)"ApAcctageListDataRpt_0", (String)"fi-ap-report", (Object[])new Object[0]), entity));
    }

    private AcctageRptParam setCommonParam(ReportQueryParam queryParam, String entityKey) {
        Date queryDate;
        FilterInfo filterInfo = queryParam.getFilter();
        AcctageRptParam param = new AcctageRptParam();
        DynamicObjectCollection billTypes = queryParam.getFilter().getDynamicObjectCollection("billtypes");
        param.setBillTypes((List)billTypes);
        param.setEntity(entityKey);
        param.setOrgIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("orgs")));
        param.setCurrencyIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("q_currency")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            DynamicObjectCollection acctacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactPks(ReportHelper.getBasedataIds((List)acctacts));
        }
        if ((queryDate = filterInfo.getDate("date")) != null) {
            queryDate = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        }
        param.setQueryDate(queryDate);
        param.setRecoverHistoryData(true);
        param.setGroups((List)filterInfo.getFilterItem("groups").getValue());
        String compareDateFieldKey = filterInfo.getString("standard");
        param.setCompareDateField(compareDateFieldKey, StringUtils.removePrefix((String)compareDateFieldKey));
        param.setIsHyperLinkClick(filterInfo.getBoolean("isHyperLinkClickByGroup"));
        DynamicProperty property = EntityMetadataUtils.getProperty((String)entityKey, (String)StringUtils.removePrefix((String)compareDateFieldKey));
        IDataEntityType parent = property.getParent();
        if (parent instanceof EntryType) {
            param.setEntryName(parent.getName());
        }
        boolean containsUnaudit = queryParam.getFilter().getBoolean("containsunaudit");
        List<QFilter> baseFilters = new ApAcctageQuerier().getBaseFilters(param, containsUnaudit);
        param.getFilters().addAll(baseFilters);
        AcctageCustomizer acctageCustomSettingHelper = (AcctageCustomizer)BeanFactory.getBean(AcctageCustomizer.class, (Object[])new Object[]{queryParam});
        acctageCustomSettingHelper.customize(param);
        return param;
    }
}

