/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report.detail;

import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.fi.ap.helper.OrgHelper;
import kd.fi.arapcommon.form.AbstractARAPReportFormPlugin;
import kd.fi.arapcommon.report.BizTypeDisplayNameProvider;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApDetailFormRpt
extends AbstractARAPReportFormPlugin
implements HyperLinkClickListener {
    private List<Long> orgIds = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        this.addItemClickListeners(new String[]{"toolbarap"});
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected List<Long> getOrgIds() {
        if (this.orgIds == null) {
            List orgs = OrgHelper.getAuthorizedInitializedOrgs((String)"ap_detailrpt_new", (String)"47150e89000000ac");
            this.orgIds = OrgHelper.getIdList((List)orgs);
        }
        return this.orgIds;
    }

    protected String getInitEntity() {
        return "ap_init";
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        BizTypeDisplayNameProvider bizTypeDisplayNameProvider = new BizTypeDisplayNameProvider(new String[]{"ap_finapbill", "ap_busbill", "cas_paybill", "ap_paidbill", "ap_settlerecord"});
        for (int i = 0; i < rowData.size(); ++i) {
            ILocaleString displayName;
            DynamicObject row = (DynamicObject)rowData.get(i);
            String bizType = row.getString("biztype");
            if (EmptyUtils.isEmpty((Object)bizType) || (displayName = bizTypeDisplayNameProvider.getDisplayName(bizType)) == null) continue;
            row.set("biztype", (Object)displayName.getLocaleValue());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        ReportList reportList = (ReportList)arg0.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(arg0.getRowIndex());
        String type = rowData.getString("type");
        if ("sum".equals(type) || "totalsum".equals(type) || "periodbalance".equals(type)) {
            return;
        }
        if ("ar_settlerecord".equals(type) || "ap_settlerecord".equals(type)) {
            String message = ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u4e0d\u652f\u6301\u8054\u67e5\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ApDetailFormRpt_1", (String)"fi-ap-report", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        long billId = rowData.getLong("billid");
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(type);
        parameter.setPkId((Object)billId);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        Boolean showReceived = (Boolean)this.getModel().getValue("containsprepaid");
        if (!showReceived.booleanValue()) {
            List columns = event.getColumns();
            for (AbstractReportColumn column : columns) {
                if (!(column instanceof ReportColumnGroup)) continue;
                ReportColumnGroup rc = (ReportColumnGroup)column;
                List cols = rc.getChildren();
                Iterator it0 = cols.iterator();
                while (it0.hasNext()) {
                    AbstractReportColumn col = (AbstractReportColumn)it0.next();
                    if (!ResManager.loadKDString((String)"\u672c\u671f\u4ed8\u6b3e", (String)"ApDetailFormRpt_0", (String)"fi-ap-report", (Object[])new Object[0]).equals(col.getCaption().toString())) continue;
                    it0.remove();
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        List orgIds = orgs.stream().map(t -> t.getLong("fbasedataid.id")).collect(Collectors.toList());
        if ("journalcheck".equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ap_journal_check");
            parameter.setCustomParam("org", orgIds);
            this.getView().showForm(parameter);
        }
    }
}

