/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report.invoice;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.ap.helper.OrgHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ApInvoiceFormRpt
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("orgs");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getOrgIds()));
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        Date newDate;
        List<Long> orgIds;
        super.initDefaultQueryParam(queryParam);
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("orgs")) && !ObjectUtils.isEmpty(orgIds = this.getOrgIds())) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("orgs", (Object)new Object[]{orgId});
        }
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("invoicestartdate"))) {
            newDate = new Date();
            this.getModel().setValue("invoicestartdate", (Object)DateUtils.getMinMonthDate((Date)newDate));
            this.getModel().setValue("invoicestopdate", (Object)newDate);
        }
        if (EmptyUtils.isEmpty((Object)this.getModel().getValue("bizstartdate"))) {
            newDate = new Date();
            this.getModel().setValue("bizstartdate", (Object)DateUtils.getMinMonthDate((Date)newDate));
            this.getModel().setValue("bizstopdate", (Object)newDate);
        }
    }

    private List<Long> getOrgIds() {
        List orgs = OrgHelper.getAuthorizedInitializedOrgs((String)"ap_invoicerpt", (String)"47150e89000000ac");
        return OrgHelper.getIdList((List)orgs);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo == null) {
            return false;
        }
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("orgs");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApInvoiceFormRpt_0", (String)"fi-ap-report", (Object[])new Object[0]));
            return false;
        }
        Date invoiceStartDate = filterInfo.getDate("invoicestartdate");
        if (invoiceStartDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u7968\u65e5\u671f\u8303\u56f4\u201d\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"ApInvoiceFormRpt_1", (String)"fi-ap-report", (Object[])new Object[0]));
            return false;
        }
        Date invoiceStopDate = filterInfo.getDate("invoicestopdate");
        if (invoiceStopDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f00\u7968\u65e5\u671f\u8303\u56f4\u201d\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"ApInvoiceFormRpt_2", (String)"fi-ap-report", (Object[])new Object[0]));
            return false;
        }
        Date bizStartDate = filterInfo.getDate("bizstartdate");
        if (bizStartDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u65e5\u671f\u8303\u56f4\u201d\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"ApInvoiceFormRpt_3", (String)"fi-ap-report", (Object[])new Object[0]));
            return false;
        }
        Date bizStopDate = filterInfo.getDate("invoicestopdate");
        if (bizStopDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5355\u636e\u65e5\u671f\u8303\u56f4\u201d\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"ApInvoiceFormRpt_4", (String)"fi-ap-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject rowData = packageDataEvent.getRowData();
        ReportColumn col = (ReportColumn)packageDataEvent.getSource();
        String fieldKey = col.getFieldKey();
        if (2 == rowData.getInt("sumlevel") && "asstacttype".equals(fieldKey)) {
            packageDataEvent.setFormatValue((Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"total", (String)"fi-ap-report", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName;
        ReportList reportList = (ReportList)arg0.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(arg0.getRowIndex());
        BillShowParameter parameter = new BillShowParameter();
        switch (fieldName = arg0.getFieldName()) {
            case "billno": {
                parameter.setFormId("ap_finapbill");
                parameter.setPkId((Object)rowData.getLong("finbillid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "invoicebillno": {
                parameter.setFormId("ap_invoice");
                parameter.setPkId((Object)rowData.getLong("invid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "voucherno": {
                parameter.setFormId("gl_voucher");
                parameter.setPkId((Object)rowData.getLong("voucherid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }
}

