/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report.invoice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;

public class ApInvoiceListDataRpt
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        return this.query(queryParam);
    }

    private DataSet query(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DataSet finBillDataSet = this.getFinBillDataSet(filterInfo);
        DataSet unionDataSet = this.unionInvoice(finBillDataSet);
        DataSet mergeDataSet = this.unionVoucher(unionDataSet);
        DataSet totalSumData = this.sum(mergeDataSet);
        return totalSumData;
    }

    private DataSet getFinBillDataSet(FilterInfo filterInfo) {
        List<QFilter> finBillFilters = this.getFinBillFilters(filterInfo);
        List<String> queryFields = this.getFinQueryFields();
        String selectors = String.join((CharSequence)",", queryFields);
        return QueryServiceHelper.queryDataSet((String)"ap.ApInvoiceListDataRpt.queryFinBills", (String)"ap_finapbill", (String)selectors, (QFilter[])finBillFilters.toArray(new QFilter[0]), null);
    }

    private List<QFilter> getFinBillFilters(FilterInfo filterInfo) {
        String isVoucher;
        List invoiceTypeIds;
        String invoiceTypeStr;
        List orgIds = DynamicObjectHelper.getLongIds((Collection)filterInfo.getDynamicObjectCollection("orgs"));
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        Date bizStartDate = DateUtils.getDataFormat((Date)filterInfo.getDate("bizstartdate"), (boolean)true);
        Date bizStopDate = DateUtils.getDataFormat((Date)filterInfo.getDate("bizstopdate"), (boolean)false);
        QFilter bizStartDateFilter = new QFilter("bizdate", ">=", (Object)bizStartDate);
        QFilter bizStopDateFilter = new QFilter("bizdate", "<=", (Object)bizStopDate);
        Date invoiceStartDate = DateUtils.getDataFormat((Date)filterInfo.getDate("invoicestartdate"), (boolean)true);
        Date invoiceStopDate = DateUtils.getDataFormat((Date)filterInfo.getDate("invoicestopdate"), (boolean)false);
        QFilter invoiceStartDateFilter = new QFilter("inventry.i_invoicedate", ">=", (Object)invoiceStartDate);
        QFilter invoiceStopDateFilter = new QFilter("inventry.i_invoicedate", "<=", (Object)invoiceStopDate);
        LinkedList<QFilter> finBillFilters = new LinkedList<QFilter>();
        finBillFilters.add(orgFilter);
        finBillFilters.add(bizStartDateFilter);
        finBillFilters.add(bizStopDateFilter);
        finBillFilters.add(invoiceStartDateFilter);
        finBillFilters.add(invoiceStopDateFilter);
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            QFilter asstactTypeFilter = new QFilter("asstacttype", "=", (Object)asstactType);
            finBillFilters.add(asstactTypeFilter);
        } else {
            finBillFilters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        DynamicObjectCollection asstacts = filterInfo.getDynamicObjectCollection(asstactType);
        if (!ObjectUtils.isEmpty((Object)asstactType) && !ObjectUtils.isEmpty((Object)asstacts)) {
            List asstactIds = ReportHelper.getBasedataIds((List)asstacts);
            finBillFilters.add(new QFilter("asstact", "in", (Object)asstactIds));
        }
        if (!ObjectUtils.isEmpty((Object)(invoiceTypeStr = filterInfo.getString("invoicetypes")))) {
            String[] split = invoiceTypeStr.split(",");
            ArrayList<String> invoiceTypes = new ArrayList<String>(split.length - 1);
            for (String s : split) {
                if (ObjectUtils.isEmpty((Object)s)) continue;
                invoiceTypes.add(s);
            }
            finBillFilters.add(new QFilter("inventry.i_invoicetype", "in", invoiceTypes));
        }
        if (!ObjectUtils.isEmpty((Object)(invoiceTypeIds = DynamicObjectHelper.getLongIds((Collection)filterInfo.getDynamicObjectCollection("invoicetypef7s"))))) {
            finBillFilters.add(new QFilter("inventry.i_invoicetypef7", "in", (Object)invoiceTypeIds));
        }
        if ("0".equals(isVoucher = filterInfo.getString("q_isvoucher"))) {
            finBillFilters.add(new QFilter("isvoucher", "=", (Object)Boolean.FALSE));
        } else if ("1".equals(isVoucher)) {
            finBillFilters.add(new QFilter("isvoucher", "=", (Object)Boolean.TRUE));
        }
        return finBillFilters;
    }

    private List<String> getFinQueryFields() {
        LinkedList<String> queryFields = new LinkedList<String>();
        queryFields.add("id finbillid");
        queryFields.add("org");
        queryFields.add("asstacttype");
        queryFields.add("asstact");
        queryFields.add("billno");
        queryFields.add("billstatus");
        queryFields.add("bizdate");
        queryFields.add("createtime");
        queryFields.add("billtypeid");
        queryFields.add("settlestatus");
        queryFields.add("currency");
        queryFields.add("isvoucher");
        queryFields.add("inventry.i_invoicedate invoicedate");
        queryFields.add("inventry.i_invoicetype invoicetype");
        queryFields.add("inventry.i_invoicetypef7 invoicetypef7");
        queryFields.add("inventry.i_invoicecode invoicecode");
        queryFields.add("inventry.i_invoiceno invoiceno");
        queryFields.add("inventry.i_pricetaxtotal pricetaxtotal");
        queryFields.add("inventry.i_taxrate taxrate");
        queryFields.add("inventry.i_tax tax");
        queryFields.add("inventry.i_amount amount");
        queryFields.add("inventry.i_usedamt usedamt");
        queryFields.add("inventry.i_billno invoicebillno");
        queryFields.add("inventry.invid invid");
        queryFields.add("inventry.i_buyername buyername");
        queryFields.add("inventry.i_asstactname asstactname");
        queryFields.add("inventry.i_remark remark");
        queryFields.add("inventry.i_istaxdeduction istaxdeduction");
        queryFields.add("(CASE WHEN inventry.i_istaxdeduction = '1' THEN inventry.i_tax ELSE 0 END) taxdeduction");
        return queryFields;
    }

    private DataSet unionInvoice(DataSet billDataSet) {
        DataSet copy = billDataSet.copy();
        HashSet<Long> invoiceIds = new HashSet<Long>(64);
        for (Row row : copy) {
            invoiceIds.add(row.getLong("invid"));
        }
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"ap.ApInvoiceListDataRpt.queryInvoices", (String)"ap_invoice", (String)"id,billstatus invoicestatus,buyertin,sellertin", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)}, null);
        return billDataSet.leftJoin(invoiceDataSet).on("invid", "id").select(billDataSet.getRowMeta().getFieldNames(), new String[]{"invoicestatus", "buyertin", "sellertin"}).finish();
    }

    private DataSet unionVoucher(DataSet unionDataSet) {
        DataSet copy = unionDataSet.copy();
        HashSet<Long> finBillIds = new HashSet<Long>(64);
        for (Row row : copy) {
            finBillIds.add(row.getLong("finbillid"));
        }
        DataSet dapTrackers = QueryServiceHelper.queryDataSet((String)"ap.ApInvoiceListDataRpt.queryDapTracker", (String)"ai_daptracker", (String)"sourcebillid,voucherid trackvoucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", finBillIds)}, null);
        DataSet copyDapTrackers = dapTrackers.copy();
        HashSet<Long> voucherIds = new HashSet<Long>(64);
        for (Row row : copyDapTrackers) {
            voucherIds.add(row.getLong("trackVoucherId"));
        }
        QFilter voucherIdFilter = new QFilter("id", "in", voucherIds);
        QFilter voucherTypeFilter = new QFilter("booktype.accounttype", "=", (Object)"1");
        DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)"ap.ApInvoiceListDataRpt.queryVoucher", (String)"gl_voucher", (String)"billno voucherno,id voucherid", (QFilter[])new QFilter[]{voucherIdFilter, voucherTypeFilter}, null);
        DataSet voucherUnionDataSet = dapTrackers.leftJoin(voucherDataSet).on("trackvoucherid", "voucherid").select(dapTrackers.getRowMeta().getFieldNames(), voucherDataSet.getRowMeta().getFieldNames()).finish();
        return unionDataSet.leftJoin(voucherUnionDataSet).on("finbillid", "sourcebillid").select(unionDataSet.getRowMeta().getFieldNames(), new String[]{"voucherno", "voucherid"}).finish();
    }

    protected DataSet sum(DataSet dataSet) {
        SumParam sumParam = new SumParam(SumParam.SumType.TOTAL);
        ArrayList<String> sumArgs = new ArrayList<String>(3);
        sumArgs.add("pricetaxtotal");
        sumArgs.add("tax");
        sumArgs.add("amount");
        sumParam.setSummaryFields(sumArgs);
        DataSet groupByUnionData = DataSetUtils.sum((DataSet)dataSet, (SumParam)sumParam);
        return dataSet.addNullField("sumlevel").union(groupByUnionData);
    }
}

