/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.report.sum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.DefaultCustomSettingParser;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.RptCustomSettingParser;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.util.CollectionUtils;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;

public class ApSumListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ApSumListDataRpt.class);
    private ARAPSumParam param;
    private RptCustomSettingParser customSettingParser;
    private String[] journalDimensionAlias;
    private FilterInfo filterInfo;

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error("context", (Throwable)e);
            throw e;
        }
    }

    private DataSet query(ReportQueryParam queryParam) {
        this.filterInfo = queryParam.getFilter();
        this.param = this.getSumParam(queryParam);
        this.customSettingParser = new DefaultCustomSettingParser(queryParam);
        List orgIds = DynamicObjectHelper.getLongIds((Collection)this.param.getOrgs());
        List<QFilter> journalFilters = this.getJournalFilters(this.filterInfo);
        List journalDimensions = this.customSettingParser.getStatisticalDimensions();
        List<String> journalSelectors = this.getJournalSelectors();
        ArrayList<String> amtFields = new ArrayList<String>();
        amtFields.add("payableamt");
        amtFields.add("localpayableamt");
        amtFields.add("settleamt");
        amtFields.add("localsettleamt");
        if (this.isContainsPrepaid()) {
            amtFields.add("prepaidamt");
            amtFields.add("localprepaidamt");
            amtFields.add("paysettleamt");
            amtFields.add("localpaysettleamt");
        }
        DataSet journals = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ap_journal", (String)String.join((CharSequence)",", journalSelectors), (QFilter[])journalFilters.toArray(new QFilter[0]), null);
        GroupbyDataSet journalGroupByDataSet = journals.groupBy(this.journalDimensionAlias);
        for (String amtField : amtFields) {
            journalGroupByDataSet.sum(amtField);
        }
        journals = journalGroupByDataSet.finish();
        List journalSelectedFields = DataSetUtils.getSelectedFields((DataSet)journals, (String[])new String[0]);
        List<String> balanceDimensions = this.getBalanceDimensions();
        BalanceQuerier balanceQuerier = new BalanceQuerier(this.getBalanceType());
        DataSet lastestBalance = balanceQuerier.queryBalance(orgIds, this.param.getStartDate(), balanceDimensions, this.getBalanceQueryCustomFilters(this.filterInfo));
        JoinDataSet temJoinDataSet = journals.join(lastestBalance, JoinType.FULL);
        for (int i = 0; i < this.journalDimensionAlias.length; ++i) {
            temJoinDataSet = temJoinDataSet.on(this.journalDimensionAlias[i], balanceDimensions.get(i));
        }
        String[] balanceSelectedFields = (String[])CollectionUtils.mergeArrays((Object[])balanceDimensions.toArray(new String[0]), (Object[])new String[]{"periodamt", "localperiodamt"});
        amtFields.add("periodamt");
        amtFields.add("localperiodamt");
        DataSet mergedDataSet = temJoinDataSet.select(journalSelectedFields.toArray(new String[0]), balanceSelectedFields).finish();
        ArrayList<String> exp = new ArrayList<String>(journalDimensions.size() + amtFields.size());
        for (int i = 0; i < journalDimensions.size(); ++i) {
            String journalField = (String)journalDimensions.get(i) + "2";
            exp.add(String.format("case when %s=null then %s else %s end as %s", journalField, balanceDimensions.get(i), journalField, journalDimensions.get(i)));
        }
        for (String amtField : amtFields) {
            exp.add(String.format("case when %s=null then 0 else %s end as %s", amtField, amtField, amtField));
        }
        DataSet totalDataSet = mergedDataSet.select(exp.toArray(new String[0]));
        totalDataSet = this.isContainsPrepaid() ? totalDataSet.addField("periodamt+payableamt-prepaidamt-settleamt+paysettleamt", "balanceamt").addField("localperiodamt+localpayableamt-localprepaidamt-localsettleamt+localpaysettleamt", "localbalanceamt") : totalDataSet.addField("periodamt+payableamt-settleamt", "balanceamt").addField("localperiodamt+localpayableamt-localsettleamt", "localbalanceamt");
        totalDataSet = this.param.isShowMainCurrency() ? (this.param.isNotShowZero() && this.param.isNotShowNull() ? (this.isContainsPrepaid() ? totalDataSet.filter("(balanceamt <> 0 or localbalanceamt <> 0) and (payableamt <> 0 or prepaidamt<> 0 or settleamt <> 0 or paysettleamt <> 0 or localpayableamt <> 0 or localprepaidamt <> 0 or localsettleamt <> 0 or localpaysettleamt <> 0)") : totalDataSet.filter("(balanceamt <> 0 or localbalanceamt <> 0) and (payableamt <> 0 or settleamt <> 0 or localpayableamt <> 0 or localsettleamt <> 0)")) : (this.param.isNotShowNull() ? (this.isContainsPrepaid() ? totalDataSet.filter("payableamt <> 0 or prepaidamt<> 0 or settleamt <> 0 or paysettleamt <> 0 or localpayableamt <> 0 or localprepaidamt <> 0 or localsettleamt <> 0 or localpaysettleamt <> 0") : totalDataSet.filter("payableamt <> 0 or settleamt <> 0 or localpayableamt <> 0 or localsettleamt <> 0")) : (this.param.isNotShowZero() ? totalDataSet.filter("balanceamt <> 0 or localbalanceamt <> 0") : (this.isContainsPrepaid() ? totalDataSet.filter("periodamt <> 0 or payableamt <> 0 or prepaidamt<> 0 or settleamt <> 0 or paysettleamt <> 0 or localperiodamt <> 0 or localpayableamt <> 0 or localprepaidamt <> 0 or localsettleamt <> 0 or localpaysettleamt <> 0") : totalDataSet.filter("periodamt <> 0 or payableamt <> 0 or settleamt <> 0 or localperiodamt <> 0 or localpayableamt <> 0 or localsettleamt <> 0"))))) : (this.param.isNotShowZero() && this.param.isNotShowNull() ? (this.isContainsPrepaid() ? totalDataSet.filter("(balanceamt <> 0) and (payableamt <> 0 or prepaidamt<> 0 or settleamt <> 0 or paysettleamt <> 0)") : totalDataSet.filter("(balanceamt <> 0) and (payableamt <> 0 or settleamt <> 0)")) : (this.param.isNotShowNull() ? (this.isContainsPrepaid() ? totalDataSet.filter("payableamt <> 0 or prepaidamt<> 0 or settleamt <> 0 or paysettleamt <> 0") : totalDataSet.filter("payableamt <> 0 or settleamt <> 0")) : (this.param.isNotShowZero() ? totalDataSet.filter("balanceamt <> 0") : (this.isContainsPrepaid() ? totalDataSet.filter("periodamt <> 0 or payableamt <> 0 or prepaidamt<> 0 or settleamt <> 0 or paysettleamt <> 0") : totalDataSet.filter("periodamt <> 0 or payableamt <> 0 or settleamt <> 0")))));
        totalDataSet = totalDataSet.addField("0", "sumlevel");
        List<String> summaryFields = null;
        summaryFields = this.isContainsPrepaid() ? Arrays.asList("periodamt", "payableamt", "prepaidamt", "settleamt", "paysettleamt", "balanceamt", "localperiodamt", "localpayableamt", "localprepaidamt", "localsettleamt", "localpaysettleamt", "localbalanceamt") : Arrays.asList("periodamt", "payableamt", "settleamt", "balanceamt", "localperiodamt", "localpayableamt", "localsettleamt", "localbalanceamt");
        SumParam sumParam = new SumParam(SumParam.SumType.TOTAL);
        sumParam.setSummaryFields(summaryFields);
        DataSet sumDataSet = DataSetUtils.sum((DataSet)totalDataSet, (SumParam)sumParam);
        DataSet dataSet = totalDataSet.union(sumDataSet);
        LinkedHashSet<String> orderByFields = new LinkedHashSet<String>();
        orderByFields.addAll(sumParam.getGroupByFields());
        orderByFields.add("sumlevel");
        orderByFields.addAll(this.customSettingParser.getSortFields());
        dataSet = dataSet.orderBy(orderByFields.toArray(new String[0]));
        return dataSet;
    }

    private BalanceType getBalanceType() {
        String billScope = this.filterInfo.getString("billscope");
        if ("ALL".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AP_FIN_BUS_PREPAID : BalanceType.AP_FIN_BUS;
        }
        if ("ap_finapbill".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AP_FIN_PREPAID : BalanceType.AP_FIN;
        }
        if ("ap_busbill".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AP_BUS_PREPAID : BalanceType.AP_BUS;
        }
        throw new KDBizException("Unknow Report Data Source " + billScope);
    }

    private List<String> getJournalSelectors() {
        String notCasSettleRealtionExp;
        List journalDimensions = this.customSettingParser.getStatisticalDimensions();
        this.journalDimensionAlias = new String[journalDimensions.size()];
        ArrayList<String> journalSelectors = new ArrayList<String>(this.journalDimensionAlias.length);
        for (int i = 0; i < this.journalDimensionAlias.length; ++i) {
            String journalField = (String)journalDimensions.get(i);
            String journalAlias = journalField + "2";
            journalSelectors.add(journalField + " " + journalAlias);
            this.journalDimensionAlias[i] = journalAlias;
        }
        journalSelectors.add("sourcebilltype");
        journalSelectors.add("sourcebillid");
        journalSelectors.add("biztype");
        String payableAmtExpression = "case when SOURCEBILLTYPE ='ap_finapbill' then payableamt when SOURCEBILLTYPE='ap_busbill' then estimatedamt else 0 end as payableamt";
        journalSelectors.add(payableAmtExpression);
        String localPayableAmtExpression = "case when SOURCEBILLTYPE ='ap_finapbill' then localpayableamt when SOURCEBILLTYPE='ap_busbill' then localestimatedamt else 0 end as localpayableamt";
        journalSelectors.add(localPayableAmtExpression);
        if (this.isContainsPrepaid()) {
            notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself'";
            String settleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-payableamt else 0 end as settleamt";
            journalSelectors.add(settleAmtExpression);
            String localSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-localpayableamt else 0 end as localsettleamt";
            journalSelectors.add(localSettleAmtExpression);
            String casSettleRealtionExp = "BIZTYPE in('payrecsettle','payself','recpaysettle','arpaysettle','appaysettle','payclearing')";
            String casSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-prepaidamt else 0 end as paysettleamt";
            journalSelectors.add(casSettleAmtExpression);
            String localCasSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-localprepaidamt else 0 end as localpaysettleamt";
            journalSelectors.add(localCasSettleAmtExpression);
            journalSelectors.add("case when SOURCEBILLTYPE in ('cas_paybill','ap_paidbill') then prepaidamt else 0 end as prepaidamt");
            journalSelectors.add("case when SOURCEBILLTYPE in ('cas_paybill','ap_paidbill') then localprepaidamt else 0 end as localprepaidamt");
        } else {
            notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself'";
            journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-payableamt else 0 end as settleamt");
            journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-localpayableamt else 0 end as localsettleamt");
            journalSelectors.add("0 prepaidamt");
            journalSelectors.add("0 localprepaidamt");
            journalSelectors.add("0 paysettleamt");
            journalSelectors.add("0 localpaysettleamt");
        }
        return journalSelectors;
    }

    private boolean isContainsPrepaid() {
        return this.filterInfo.getBoolean("containsprepaid");
    }

    private List<String> getBalanceDimensions() {
        List journalDimensions = this.customSettingParser.getStatisticalDimensions();
        ArrayList<String> balanceDimensions = new ArrayList<String>();
        BalJouMapper mapper = BalJouMapper.getMapper((boolean)true);
        BalanceSettingParser balanceSettingParser = new BalanceSettingParser(mapper);
        for (String journalField : journalDimensions) {
            List balanceFields = balanceSettingParser.getBalanceFields(journalField);
            if (balanceFields == null || balanceFields.isEmpty()) {
                throw new KDBizException("");
            }
            balanceDimensions.addAll(balanceFields);
        }
        return balanceDimensions;
    }

    private List<QFilter> getBalanceQueryCustomFilters(FilterInfo filterInfo) {
        DynamicObjectCollection currencys;
        ArrayList<QFilter> balanceCustomFilters = new ArrayList<QFilter>();
        if (!EmptyUtils.isEmpty((Object)this.param.getAsstactType())) {
            QFilter asstactTypeFilter = new QFilter("asstacttype", "=", (Object)this.param.getAsstactType());
            balanceCustomFilters.add(asstactTypeFilter);
        } else {
            balanceCustomFilters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        DynamicObjectCollection asstact = this.param.getAsstact();
        if (!EmptyUtils.isEmpty((Object)asstact)) {
            List asstactPks = DynamicObjectHelper.getIdList((Collection)asstact);
            QFilter asstactFilter = new QFilter("asstact", "in", (Object)asstactPks);
            balanceCustomFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty((Object)(currencys = this.param.getCurrencys()))) {
            List currencyPks = DynamicObjectHelper.getIdList((Collection)currencys);
            QFilter currencyFilter = new QFilter("currency", "in", (Object)currencyPks);
            balanceCustomFilters.add(currencyFilter);
        }
        balanceCustomFilters.addAll(this.customSettingParser.getCustomFilters());
        return balanceCustomFilters;
    }

    private List<QFilter> getJournalFilters(FilterInfo filterInfo) {
        DynamicObjectCollection currencys;
        List orgIds = DynamicObjectHelper.getLongIds((Collection)this.param.getOrgs());
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        QFilter beginDateFilter = new QFilter("bizdate", ">=", (Object)this.param.getStartDate());
        QFilter endDateFilter = new QFilter("bizdate", "<=", (Object)this.param.getStopDate());
        ArrayList<QFilter> journalFilters = new ArrayList<QFilter>();
        journalFilters.add(orgFilter);
        journalFilters.add(beginDateFilter);
        journalFilters.add(endDateFilter);
        if (!EmptyUtils.isEmpty((Object)this.param.getAsstactType())) {
            QFilter asstactTypeFilter = new QFilter("asstacttype", "=", (Object)this.param.getAsstactType());
            journalFilters.add(asstactTypeFilter);
        } else {
            journalFilters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        DynamicObjectCollection asstact = this.param.getAsstact();
        if (!EmptyUtils.isEmpty((Object)asstact)) {
            List asstactPks = DynamicObjectHelper.getIdList((Collection)asstact);
            QFilter asstactFilter = new QFilter("asstact", "in", (Object)asstactPks);
            journalFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty((Object)(currencys = this.param.getCurrencys()))) {
            List currencyPks = DynamicObjectHelper.getIdList((Collection)currencys);
            QFilter currencyFilter = new QFilter("currency", "in", (Object)currencyPks);
            journalFilters.add(currencyFilter);
        }
        journalFilters.addAll(this.customSettingParser.getCustomFilters());
        ArrayList<String> journalSourceEntityTypes = new ArrayList<String>();
        String billScope = filterInfo.getString("billscope");
        if ("ALL".equals(billScope)) {
            journalSourceEntityTypes.add("ap_finapbill");
            journalSourceEntityTypes.add("ap_settlerecord");
            journalSourceEntityTypes.add("ar_settlerecord");
            journalSourceEntityTypes.add("ap_busbill");
        } else if ("ap_finapbill".equals(billScope)) {
            journalSourceEntityTypes.add("ap_finapbill");
            journalSourceEntityTypes.add("ap_settlerecord");
            journalSourceEntityTypes.add("ar_settlerecord");
        } else if ("ap_busbill".equals(billScope)) {
            journalSourceEntityTypes.add("ap_busbill");
        } else {
            throw new KDBizException("Unknow Report Data Source " + billScope);
        }
        if (this.isContainsPrepaid()) {
            journalSourceEntityTypes.add("cas_paybill");
            journalSourceEntityTypes.add("ap_paidbill");
        }
        journalFilters.add(new QFilter("sourcebilltype", "in", journalSourceEntityTypes));
        return journalFilters;
    }

    private ARAPSumParam getSumParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        ARAPSumParam param = new ARAPSumParam();
        param.setOrgs(filterInfo.getDynamicObjectCollection("orgs"));
        param.setAsstactType(filterInfo.getString("q_asstacttype"));
        if (!EmptyUtils.isEmpty((Object)param.getAsstactType())) {
            DynamicObjectCollection asstacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstact(ReportHelper.getBasedatas((DynamicObjectCollection)asstacts));
        }
        param.setCurrencys(filterInfo.getDynamicObjectCollection("currencys"));
        param.setStartDate(DateUtils.getDataFormat((Date)filterInfo.getDate("startdate"), (boolean)true));
        param.setStopDate(DateUtils.getDataFormat((Date)filterInfo.getDate("stopdate"), (boolean)false));
        param.setBillScope(filterInfo.getString("billscope"));
        param.setIncludUnAudit(filterInfo.getBoolean("includunaudit"));
        param.setNotShowZero(filterInfo.getBoolean("notshowzero"));
        param.setNotShowNull(filterInfo.getBoolean("notshownull"));
        param.setNotShowNullAndZero(filterInfo.getBoolean("notshownullandzero"));
        param.setShowMainCurrency(filterInfo.getBoolean("showmaincurrency"));
        return param;
    }
}

