/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.enums;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public enum AttachTypeEnum {
    PDF("1", "pdf"),
    PNG("2", "png"),
    DOC("3", "doc"),
    XLS("6", "xls"),
    PPTX("7", "ppt"),
    TXT("8", "txt");

    public static final String DOT = ".";
    private String type;
    private String extension;

    private AttachTypeEnum(String type, String extension) {
        this.type = type;
        this.extension = extension;
    }

    public static String getExtByType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return "unknown";
        }
        AttachTypeEnum[] values = AttachTypeEnum.values();
        Optional<AttachTypeEnum> findFirst = Stream.of(values).filter(v -> v.getType().equals(type)).findFirst();
        if (findFirst.isPresent()) {
            return findFirst.get().getExtension();
        }
        return "unknown";
    }

    public String getType() {
        return this.type;
    }

    public String getExtension() {
        return this.extension;
    }
}

