/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.helper.InitHelper;

public class BaseDataHelper {
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == null || targetCurrencyId == null) {
            return exchangeRate;
        }
        if (sourceCurrencyId == 0L || targetCurrencyId == 0L) {
            return exchangeRate;
        }
        if (sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        InitHelper init = new InitHelper(orgId.longValue(), "ap_init");
        Long exchangeRateTableId = init.getExrateTable().getLong("id");
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        return exchangeRate;
    }

    public static boolean checkPermission(long userId, long orgId, String entityId, String permissionItemId) {
        int res = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"ap", (String)entityId, (String)permissionItemId);
        return res != 0;
    }

    public static boolean checkCurrentUserPermission(long orgId, String entityId, String permissionItemId) {
        return BaseDataHelper.checkPermission(RequestContext.get().getCurrUserId(), orgId, entityId, permissionItemId);
    }

    public static BigDecimal getCasExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (date == null) {
            date = new Date();
        }
        if (sourceCurrencyId == null || targetCurrencyId == null) {
            return exchangeRate;
        }
        if (sourceCurrencyId == 0L || targetCurrencyId == 0L) {
            return exchangeRate;
        }
        if (sourceCurrencyId.equals(targetCurrencyId)) {
            return exchangeRate;
        }
        InitHelper init = new InitHelper(orgId.longValue(), "ap_init");
        Long exchangeRateTableId = init.getExrateTable().getLong("id");
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)date);
        return exchangeRate;
    }

    public static List<Long> getExpense() {
        ArrayList<Long> idList = new ArrayList<Long>();
        String querySQL = "SELECT FID from t_er_expenseitem WHERE FENABLE = '1'";
        try (DataSet ds = DB.queryDataSet((String)"getExpense", (DBRoute)DBRouteConst.BASEDATA, (String)querySQL, null);){
            Iterator rowIterator = ds.iterator();
            if (rowIterator != null) {
                while (rowIterator.hasNext()) {
                    Row data = (Row)rowIterator.next();
                    idList.add(data.getLong("FID"));
                }
            }
        }
        return idList;
    }

    public static boolean executeSql(String sql) {
        return DB.execute((DBRoute)DBRouteConst.BASEDATA, (String)sql);
    }

    public static DynamicObject getDefaultSettleType() {
        QFilter[] filters = new QFilter[]{new QFilter("isdefault", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id, name, number, ispaythroughbe, settlementtype", (QFilter[])filters);
    }
}

