/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.InvoiceBizTypeEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApBillHelper {
    public static final String bizIds = "83bfebc8000002ac";
    public static final String APFIN_PURFEE_BT_S = "ApFin_purfee_BT_S";
    public static final String APFIN_SALEFEE_BT_S = "ApFin_salefee_BT_S";
    public static final String ARFIN_OTHER_BT_S = "arfin_other_BT_S";

    @Deprecated
    public static void writeOffCheck(IDataModel model, IFormView formView, BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (!"tblwriteoff".equals(itemKey)) {
            return;
        }
        String message = FinApBillHelper.getWriteOffCheckMessage(model.getDataEntity());
        if (EmptyUtils.isEmpty((Object)message)) {
            return;
        }
        formView.showTipNotification(message);
        evt.setCancel(true);
    }

    public static void writeOffCheck(Object[] pks, IFormView formView, BeforeDoOperationEventArgs evt) {
        DynamicObject entity;
        QFilter qf = new QFilter("sourcebilltype", "!=", (Object)"ap_invoice");
        qf.and("id", "in", (Object)pks);
        DynamicObject[] entities = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"sourcebilltype,billno,id,inventry.i_srctype", (QFilter[])new QFilter[]{qf});
        String message = "";
        DynamicObject[] dynamicObjectArray = entities;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n && !EmptyUtils.isNotEmpty((Object)(message = FinApBillHelper.getWriteOffCheckMessage(entity = dynamicObjectArray[i]))); ++i) {
        }
        if (EmptyUtils.isEmpty((Object)message)) {
            return;
        }
        formView.showTipNotification(message);
        evt.setCancel(true);
    }

    public static String getWriteOffCheckMessage(DynamicObject entity) {
        return "";
    }

    private static boolean invoiceAssigned(DynamicObject entity) {
        DynamicObjectCollection invoiceEntries = entity.getDynamicObjectCollection("inventry");
        if (EmptyUtils.isEmpty((Object)invoiceEntries)) {
            return FinApBillHelper.sourceInvoiceAssigned(entity);
        }
        for (DynamicObject invoiceEntry : invoiceEntries) {
            String srcType = invoiceEntry.getString("i_srctype");
            if (!"3".equals(srcType) && !"4".equals(srcType)) continue;
            return true;
        }
        return false;
    }

    private static boolean sourceInvoiceAssigned(DynamicObject entity) {
        Set invoiceIdList = BOTPHelper.findSouBillIds((String)entity.getDataEntityType().getName(), (Long)entity.getLong("id"), (String)"ap_invoice");
        if (EmptyUtils.isEmpty((Object)invoiceIdList)) {
            return false;
        }
        DynamicObjectCollection finEntries = QueryServiceHelper.query((String)"ap_invoice", (String)"finentry.finid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)invoiceIdList)});
        long targetFinId = entity.getLong("id");
        for (DynamicObject finEntry : finEntries) {
            long finId = finEntry.getLong("finentry.finid");
            if (targetFinId != finId) continue;
            return true;
        }
        return false;
    }

    public static void setImptsuppliers(List<DynamicObject> datas, String entryFiled) {
        Set asstactIdSet = datas.stream().map(t -> t.getLong("asstact.id")).collect(Collectors.toSet());
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"deliversupplierid,invoicesupplierid,receivingsupplierid,bizfunction", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIdSet)});
        for (DynamicObject entity : datas) {
            Object asstactId = entity.get("asstact.id");
            DynamicObject supplier = null;
            if (asstactMap != null) {
                supplier = (DynamicObject)asstactMap.get(asstactId);
            }
            if (supplier == null) continue;
            DynamicObject invoiceSupplier = supplier.getDynamicObject("invoicesupplierid");
            DynamicObject deliversupplier = supplier.getDynamicObject("deliversupplierid");
            DynamicObject recesupplier = supplier.getDynamicObject("receivingsupplierid");
            if (entity.get("receivingsupplierid") == null) {
                entity.set("receivingsupplierid", (Object)recesupplier);
            }
            DynamicObjectCollection entries = entity.getDynamicObjectCollection(entryFiled);
            String bizFunction = supplier.getString("bizfunction");
            for (DynamicObject entry : entries) {
                if (supplier == null) continue;
                if (entry.get("e_invoicesupplierid") == null && bizFunction.contains("1")) {
                    entry.set("e_invoicesupplierid", (Object)invoiceSupplier);
                }
                if (entry.get("e_deliversupplierid") != null) continue;
                entry.set("e_deliversupplierid", (Object)deliversupplier);
            }
        }
    }

    public static Map<String, Object> setSuppliersToViewCash(IDataModel m, IPageCache cash) {
        HashMap<String, Object> suppliersMap = new HashMap<String, Object>(8);
        String asstactType = (String)m.getValue("asstacttype");
        DynamicObject asstact = (DynamicObject)m.getValue("asstact");
        if (asstact == null) {
            return suppliersMap;
        }
        if ("bd_supplier".equals(asstactType)) {
            DynamicObject asstactCache = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)"bd_supplier", (String)"invoicesupplierid,receivingsupplierid,deliversupplierid,bizfunction,invoicecategory");
            m.setValue("receivingsupplierid", asstactCache.get("receivingsupplierid.id"));
            Long invoiceTypeId = asstactCache.getLong("invoicecategory.id");
            if (invoiceTypeId == null || invoiceTypeId == 0L) {
                suppliersMap.put("invoicebiztype", InvoiceBizTypeEnum.SP00002_S.getValue());
            } else {
                Map rawResult = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"InvoiceBizTypeService", (String)"getInvoiceBizType", (Object[])new Object[]{invoiceTypeId, bizIds});
                if (rawResult != null && rawResult.get("id") != null) {
                    suppliersMap.put("invoicebiztype", rawResult.get("id").toString());
                } else {
                    suppliersMap.put("invoicebiztype", InvoiceBizTypeEnum.SP00002_S.getValue() + "");
                }
            }
            Long invoiceSupplierId = asstactCache.getLong("invoicesupplierid.id");
            Long deliverSupplierId = asstactCache.getLong("deliversupplierid.id");
            String bizFunction = asstactCache.getString("bizfunction");
            if (bizFunction.contains("1") && invoiceSupplierId != 0L) {
                suppliersMap.put("invoiceSupplierId", invoiceSupplierId);
            }
            if (deliverSupplierId != 0L) {
                suppliersMap.put("deliverSupplierId", deliverSupplierId);
            }
        }
        return suppliersMap;
    }

    public static boolean getUsedInvBillnos(Object[] pks) {
        boolean isWarn = false;
        DynamicObjectCollection apBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"billno,inventry.invid,inventry.i_serialno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks).and("inventry.i_srctype", "!=", (Object)"2")});
        DynamicObjectCollection preBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"billno,inventry.invid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)pks).and("ispremium", "=", (Object)Boolean.TRUE).and("inventry.i_srctype", "!=", (Object)"2")});
        Set apInvIds = apBills.stream().map(t -> t.getLong("inventry.invid")).collect(Collectors.toSet());
        Set preInvIds = preBills.stream().map(t -> t.getLong("inventry.invid")).collect(Collectors.toSet());
        if (apInvIds.size() > 0 || preInvIds.size() > 0) {
            apInvIds.addAll(preInvIds);
            HashSet<Long> sysInvIds = new HashSet<Long>(8);
            HashSet<Long> noStatusInvIds = new HashSet<Long>(8);
            DataSet invDataSet = QueryServiceHelper.queryDataSet((String)"invoiceselectbyid", (String)"ap_invoice", (String)"id,invoicestatus,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", apInvIds)}, (String)"id");
            for (Row row : invDataSet) {
                String status = row.getString("invoicestatus");
                Long invId = row.getLong("id");
                if ("0".equals(status)) {
                    sysInvIds.add(invId);
                }
                if (!"".equals(status)) continue;
                noStatusInvIds.add(invId);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("sendwarnmsg", "false");
            OperationServiceHelper.executeOperate((String)"updateinvstatus", (String)"ap_invoice", (Object[])sysInvIds.toArray(new Object[0]), (OperateOption)option);
            DynamicObjectCollection invs = QueryServiceHelper.query((String)"ap_invoice", (String)"id,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", apInvIds).and("invoicestatus", "=", (Object)"0")});
            isWarn = invs != null && invs.size() > 0 || noStatusInvIds.size() > 0;
        }
        return isWarn;
    }

    public static boolean isPushOtherFinAr(DynamicObject[] datas) {
        ArrayList<String> pks = new ArrayList<String>(8);
        block0: for (DynamicObject data : datas) {
            String billTypeName = data.getString("billtypeid.number");
            if (!APFIN_PURFEE_BT_S.equals(billTypeName) && !APFIN_SALEFEE_BT_S.equals(billTypeName)) continue;
            DynamicObjectCollection entries = data.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean("e_prepaid")) continue;
                pks.add(data.getString("id"));
                continue block0;
            }
        }
        QFilter qf = new QFilter("sourcebillid", "in", pks);
        qf.and("sourcebilltype", "=", (Object)"ap_finapbill");
        qf.and("billtype.number", "=", (Object)ARFIN_OTHER_BT_S);
        return QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qf});
    }

    public static boolean isPushOtherFinAr(DynamicObject data, DynamicObjectCollection entries) {
        ArrayList<String> pks = new ArrayList<String>(8);
        String billTypeName = data.getString("billtypeid.number");
        if (APFIN_PURFEE_BT_S.equals(billTypeName) || APFIN_SALEFEE_BT_S.equals(billTypeName)) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean("e_prepaid")) continue;
                pks.add(data.getString("id"));
                break;
            }
        }
        QFilter qf = new QFilter("sourcebillid", "in", pks);
        qf.and("sourcebilltype", "=", (Object)"ap_finapbill");
        qf.and("billtype.number", "=", (Object)ARFIN_OTHER_BT_S);
        return QueryServiceHelper.exists((String)"ar_finarbill", (QFilter[])new QFilter[]{qf});
    }

    public static String supplierWarnTips(String entity, List<Object> pks, String opKey) {
        if (pks.size() <= 0) {
            return "";
        }
        switch (entity) {
            case "ap_finapbill": {
                DynamicObject[] apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billno,org.id,asstact.name,inventry.i_asstactname,inventry.i_billno", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
                Set orgIds = Arrays.stream(apBills).map(t -> t.getLong("org.id")).collect(Collectors.toSet());
                Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
                HashMap finapWarnMap = new HashMap(apBills.length);
                for (DynamicObject apBill : apBills) {
                    Long orgId = apBill.getLong("org.id");
                    DynamicObject config = (DynamicObject)configByOrg.get(orgId);
                    if (config == null || !"1".equals(config.getString("identicalpartyinvcom"))) continue;
                    String asstactName = apBill.getString("asstact.name");
                    DynamicObjectCollection entrys = apBill.getDynamicObjectCollection("inventry");
                    String billno = apBill.getString("billno");
                    ArrayList<String> invBillNos = new ArrayList<String>(10);
                    for (DynamicObject invEntry : entrys) {
                        String invAsstactName = invEntry.getString("i_asstactname");
                        if (asstactName.equals(invAsstactName)) continue;
                        String invBillno = invEntry.getString("i_billno");
                        invBillNos.add(invBillno);
                    }
                    if (invBillNos == null || invBillNos.size() <= 0) continue;
                    finapWarnMap.put(billno, invBillNos);
                }
                StringBuilder apWarns = new StringBuilder();
                if (finapWarnMap.size() <= 0) break;
                for (Map.Entry WarnMap : finapWarnMap.entrySet()) {
                    String finapBillNo = (String)WarnMap.getKey();
                    List invBillNos = (List)WarnMap.getValue();
                    String warns = ResManager.loadKDString((String)"%1$s\uff1a\u5e94\u4ed8\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\uff08\u6536\u7968\u5355\u7f16\u53f7: %2$s\uff09\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"FinApBillHelper_0", (String)"fi-ap-common", (Object[])new Object[]{finapBillNo, StringUtils.join((Object[])invBillNos.toArray(), (String)",")});
                    apWarns.append(warns).append('\n');
                }
                return apWarns.toString();
            }
            case "ap_invoice": {
                DynamicObject[] invBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"billno,org.id,receivablessupp.name,asstactname", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
                Set invOrgIds = Arrays.stream(invBills).map(t -> t.getLong("org.id")).collect(Collectors.toSet());
                Map invConfigByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(invOrgIds);
                StringBuilder invWarns = new StringBuilder();
                for (DynamicObject invoiceBill : invBills) {
                    String invName;
                    String asstactName;
                    Long orgId = invoiceBill.getLong("org.id");
                    DynamicObject config = (DynamicObject)invConfigByOrg.get(orgId);
                    if (config == null || !"1".equals(config.getString("identicalpartyinvcom")) || (asstactName = invoiceBill.getString("receivablessupp.name")).equals(invName = invoiceBill.getString("asstactname"))) continue;
                    String warns = "";
                    warns = "submit".equals(opKey) ? ResManager.loadKDString((String)"%s: \u6536\u7968\u5355\u5f80\u6765\u6237\u4e0e\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"FinApBillHelper_1", (String)"fi-ap-common", (Object[])new Object[]{invoiceBill.getString("billno")}) : ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\uff08\u6536\u7968\u5355\u7f16\u53f7:%s\uff09\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"FinApBillHelper_2", (String)"fi-ap-common", (Object[])new Object[]{invoiceBill.getString("billno")});
                    invWarns.append(warns).append('\n');
                }
                return invWarns.toString();
            }
            case "ap_payapply": {
                DynamicObject[] applyBills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"applyorg.id,entry.seq,entry.e_asstact,inventry.invid,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
                HashSet<Long> applyOrgIds = new HashSet<Long>(applyBills.length);
                HashSet<Long> invIds = new HashSet<Long>(8);
                for (DynamicObject applyBill : applyBills) {
                    applyOrgIds.add(applyBill.getLong("applyorg.id"));
                    DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
                    for (DynamicObject inv : invEntry) {
                        invIds.add(inv.getLong("invid"));
                    }
                }
                Map applyConfigByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(applyOrgIds);
                if (applyConfigByOrg.size() <= 0 || invIds.size() <= 0) break;
                DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,asstactname,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", invIds)});
                Map invMap = invoices.stream().collect(Collectors.toMap(t -> t.getLong("id"), Function.identity()));
                StringBuilder applyWarns = new StringBuilder();
                for (DynamicObject applyBill : applyBills) {
                    Long orgId = applyBill.getLong("applyorg.id");
                    DynamicObject config = (DynamicObject)applyConfigByOrg.get(orgId);
                    if (config == null || !"1".equals(config.getString("identicalpartyinvcom"))) continue;
                    DynamicObjectCollection applyEntrys = applyBill.getDynamicObjectCollection("entry");
                    DynamicObjectCollection invEntrys = applyBill.getDynamicObjectCollection("inventry");
                    block17: for (DynamicObject invEntry : invEntrys) {
                        DynamicObject invBill = (DynamicObject)invMap.get(invEntry.getLong("invid"));
                        for (DynamicObject applyEntry : applyEntrys) {
                            String asstName = applyEntry.getString("e_asstact.name");
                            if (asstName.equals(invBill.getString("asstactname"))) continue;
                            String warn = ResManager.loadKDString((String)"%1$s\uff1a\u4ed8\u6b3e\u7533\u8bf7\u5355\u5f80\u6765\u6237\u4e0e\u53d1\u7968\uff08\u6536\u7968\u5355\u7f16\u53f7: %2$s\uff09\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5173\u6ce8\u3002", (String)"FinApBillHelper_3", (String)"fi-ap-common", (Object[])new Object[]{applyBill.getString("billno"), invBill.getString("billno")});
                            applyWarns.append(warn).append('\n');
                            continue block17;
                        }
                    }
                }
                return applyWarns.toString();
            }
        }
        return "";
    }
}

