/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.enums.BillStatusEnum;

public class FinapPremHelper {
    public static boolean isFinPrem(DynamicObject entity) {
        DynamicObject finapobject = BusinessDataServiceHelper.loadSingle((Object)entity.getPkValue(), (String)"ap_finapbill", (String)"iswrittenoff,hadwrittenoff,sourcebillid,payproperty,ispremium,sourcebilltype,isadjust,istanspay,settlestatus");
        boolean ispremium = finapobject.getBoolean("ispremium");
        return ispremium;
    }

    public static List<DynamicObject> gettargetFinPrem(DynamicObject entity) {
        HashSet finBillIds;
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ap_finapbill", (Long[])new Long[]{(Long)entity.getPkValue()});
        List<Object> finPrems = new ArrayList<DynamicObject>(targetBills.size());
        if (!targetBills.isEmpty() && !ObjectUtils.isEmpty((Object)(finBillIds = (HashSet)targetBills.get("ap_finapbill")))) {
            DynamicObject[] finBills = BusinessDataServiceHelper.load((Object[])finBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ap_finapbill"));
            finPrems = Arrays.stream(finBills).filter(bill -> bill.getBoolean("ispremium")).collect(Collectors.toList());
        }
        return finPrems;
    }

    public static boolean isPushPremiumBill(Object[] pks) {
        QFilter qf = new QFilter("sourcebillid", "in", (Object)pks);
        qf.and("ispremium", "=", (Object)Boolean.TRUE);
        qf.and("sourcebilltype", "=", (Object)"ap_finapbill");
        qf.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return QueryServiceHelper.exists((String)"ap_finapbill", (QFilter[])new QFilter[]{qf});
    }

    public static void writeOff(List<Long> srcBillIDs) {
        Long[] srcBillIDArr = srcBillIDs.toArray(new Long[srcBillIDs.size()]);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ap_finapbill", (Long[])srcBillIDArr);
        if (ObjectUtils.isEmpty((Object)targetBills)) {
            return;
        }
        HashSet targetFinPKSet = (HashSet)targetBills.get("ap_finapbill");
        if (ObjectUtils.isEmpty((Object)targetFinPKSet)) {
            return;
        }
        QFilter premFilter = new QFilter("id", "in", (Object)targetFinPKSet);
        premFilter.and(new QFilter("ispremium", "=", (Object)Boolean.TRUE));
        Object[] premBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,ispremium", (QFilter[])new QFilter[]{premFilter});
        if (ObjectUtils.isEmpty((Object[])premBills)) {
            return;
        }
        HashSet<Object> targetFinPremPKSet = new HashSet<Object>();
        for (Object premBill : premBills) {
            targetFinPremPKSet.add(premBill.getPkValue());
        }
        QFilter writeFilter = new QFilter("sourcebillid", "in", targetFinPremPKSet);
        writeFilter.and("iswrittenoff", "=", (Object)Boolean.TRUE);
        DynamicObject[] writeOffBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,sourcebillid,iswrittenoff", (QFilter[])new QFilter[]{writeFilter});
        Object[] writeOffPKs = new Object[writeOffBills.length];
        for (int i = 0; i < writeOffBills.length; ++i) {
            writeOffPKs[i] = writeOffBills[i].getPkValue();
        }
        OperateOption unduitop = OperateOption.create();
        unduitop.setVariableValue("fiap_unaduit_mode", "auto");
        OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_finapbill", (Object[])writeOffPKs, (OperateOption)unduitop);
    }
}

