/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ViewsettleHelper {
    public static void itemClick(ItemClickEvent evt, IDataModel model, IFormView view, boolean isList) {
        Object[] pks;
        HashSet<Long> orgIds = new HashSet<Long>(8);
        if (isList) {
            BillList billList = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ViewsettleHelper_0", (String)"fi-ap-common", (Object[])new Object[0]));
                return;
            }
            pks = selectedRows.getPrimaryKeyValues();
            String entityId = ((ListView)view).getBillFormId();
            String entityType = FormMetadataCache.getFormConfig((String)entityId).getEntityTypeId();
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entityType, (String)"id,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
            Iterator iterator = bills.iterator();
            while (iterator.hasNext()) {
                DynamicObject bill = (DynamicObject)iterator.next();
                orgIds.add(bill.getLong("org"));
            }
        } else {
            pks = new Object[]{model.getDataEntity().getPkValue()};
            orgIds.add((Long)model.getDataEntity().getDynamicObject("org").getPkValue());
        }
        HashSet<Long> settleRecordIds = new HashSet<Long>(8);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"ViewSettleByAllBill", (String)"ap_settlerecord", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", (Object)pks), new QFilter("org", "in", orgIds)}, null);
        DataSet asstsDataSet = QueryServiceHelper.queryDataSet((String)"ViewSettleByAllBill", (String)"ap_settlerecord", (String)"id,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("entry.billid", "in", (Object)pks)}, null);
        DataSet dataSet = mainDataSet.union(asstsDataSet);
        for (Row row : dataSet) {
            settleRecordIds.add(row.getLong("id"));
        }
        if (settleRecordIds.size() > 0) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("ap_settlerecord");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("id", "in", settleRecordIds));
            parameter.setListFilterParameter(param);
            parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
            view.showForm((FormShowParameter)parameter);
        } else {
            String errorMessage;
            StringBuffer errorMsg = new StringBuffer();
            DynamicObjectCollection settledBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks), new QFilter("settlestatus", "=", (Object)"settled"), new QFilter("amount", "=", (Object)BigDecimal.ZERO)});
            if (!ObjectUtils.isEmpty((Object)settledBills)) {
                for (DynamicObject bill : settledBills) {
                    String billno = bill.getString("billno");
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\uff1a0\u91d1\u989d\u65e0\u9700\u7ed3\u7b97\uff0c\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002%2$s", (String)"ViewsettleHelper_1", (String)"fi-ap-common", (Object[])new Object[0]), billno, System.lineSeparator()));
                }
            }
            if (settledBills.size() != pks.length) {
                DynamicObjectCollection unsettledBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks), new QFilter("settlestatus", "!=", (Object)"settled").or("amount", "!=", (Object)BigDecimal.ZERO)});
                for (DynamicObject bill : unsettledBills) {
                    String billno = bill.getString("billno");
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\uff1a\u672a\u7ed3\u7b97\uff0c\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002%2$s", (String)"ViewsettleHelper_2", (String)"fi-ap-common", (Object[])new Object[0]), billno, System.lineSeparator()));
                }
            }
            if (StringUtils.isEmpty((String)(errorMessage = errorMsg.toString()))) {
                errorMessage = ResManager.loadKDString((String)"\u6682\u65e0\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ViewsettleHelper_3", (String)"fi-ap-common", (Object[])new Object[0]);
            }
            view.showTipNotification(errorMessage);
        }
    }
}

