/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ViewverHelper {
    public static void itemClick(ItemClickEvent evt, IDataModel model, IFormView view, boolean isList) {
        Object pk = 0L;
        if (isList) {
            BillList billList = (BillList)view.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] pks = selectedRows.getPrimaryKeyValues();
            if (selectedRows.size() == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ViewverHelper_0", (String)"fi-ap-common", (Object[])new Object[0]));
                return;
            }
            if (pks.length != 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"ViewverHelper_1", (String)"fi-ap-common", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow row = selectedRows.get(0);
            pk = row.getPrimaryKeyValue();
        } else {
            pk = model.getDataEntity().getPkValue();
        }
        Set<Long> vrPKs = ViewverHelper.getBillVerifyRecordPKs(pk);
        if (!vrPKs.isEmpty()) {
            ListShowParameter parameter = new ListShowParameter();
            String billFormId = CommonVerifyServiceHelper.isFiVerifyRecord(vrPKs, (boolean)false) ? "ap_verifyrecord" : "cal_purwfrecord";
            parameter.setBillFormId(billFormId);
            parameter.setLookUp(true);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter param = new ListFilterParameter();
            param.setFilter(new QFilter("id", "in", vrPKs));
            parameter.setListFilterParameter(param);
            parameter.setCustomParam("billId", pk);
            parameter.setCustomParam("entity", (Object)"ap_finapbill");
            view.showForm((FormShowParameter)parameter);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6838\u9500\u8bb0\u5f55\u3002", (String)"ViewverHelper_2", (String)"fi-ap-common", (Object[])new Object[0]));
        }
    }

    public static Set<Long> getBillVerifyRecordPKs(Object billId) {
        return ViewverHelper.getBillVerifyRecordPKs(new Object[]{billId}, "ap_finapbill");
    }

    public static Set<Long> getBillVerifyRecordPKs(Object[] billIds, String entityName) {
        HashSet<Long> billTypeSet = new HashSet<Long>(8);
        if (billIds == null || billIds.length == 0 || StringUtils.isEmpty((String)entityName)) {
            return billTypeSet;
        }
        QFilter mainFilter = new QFilter("billid", "in", (Object)billIds);
        QFilter asstFilter = new QFilter("entry.e_billid", "in", (Object)billIds);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)entityName, (Object[])billIds, (boolean)false);
        asstFilter.and(commonFilter);
        DataSet vr4Mains = QueryServiceHelper.queryDataSet((String)"queryVR4Main", (String)"ap_verifyrecord", (String)"id", (QFilter[])new QFilter[]{mainFilter}, null);
        for (Row vr4Main : vr4Mains) {
            billTypeSet.add(vr4Main.getLong("id"));
        }
        DataSet vr4Assts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ap_verifyrecord", (String)"id", (QFilter[])new QFilter[]{asstFilter}, null);
        for (Row vr4Asst : vr4Assts) {
            billTypeSet.add(vr4Asst.getLong("id"));
        }
        return billTypeSet;
    }

    @Deprecated
    public static Set<Long> getBillVerifyRecordPKs(Object[] billIds) {
        HashSet<Long> billTypeSet = new HashSet<Long>(8);
        if (billIds == null || billIds.length == 0) {
            return billTypeSet;
        }
        DataSet vr4Mains = QueryServiceHelper.queryDataSet((String)"queryVR4Main", (String)"ap_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("billid", "in", (Object)billIds)}, null);
        for (Row vr4Main : vr4Mains) {
            billTypeSet.add(vr4Main.getLong("id"));
        }
        DataSet vr4Assts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ap_verifyrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("entry.e_billid", "in", (Object)billIds)}, null);
        for (Row vr4Asst : vr4Assts) {
            billTypeSet.add(vr4Asst.getLong("id"));
        }
        return billTypeSet;
    }
}

