/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.piaozone;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.arapcommon.enums.ECTxBizEnum;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StdConfig;

public class InvoiceHelper {
    public static void updateInvoiceStatus(Long[] invoiceIds) {
        if (ObjectUtils.isEmpty((Object[])invoiceIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("mutex_writeback", "false");
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ignoreValidation", "true");
        OperationServiceHelper.executeOperate((String)"updateinvstatus", (String)"ap_invoice", (Object[])invoiceIds, (OperateOption)option);
    }

    public static List<ECTxBizEnum> getInvoiceECTxBiz() {
        ArrayList<ECTxBizEnum> needValidatorECTxs = new ArrayList<ECTxBizEnum>(8);
        needValidatorECTxs.add(ECTxBizEnum.AP_EMPLOYINVCLOUD);
        needValidatorECTxs.add(ECTxBizEnum.AP_PULLINVIMAGE);
        needValidatorECTxs.add(ECTxBizEnum.AP_UPDATETAXDEDUCTION);
        return needValidatorECTxs;
    }

    public static String validatorInvoiceExist(Map<Long, String> invoiceMap, DynamicObject[] invoices) {
        if (ObjectUtils.isEmpty(invoiceMap) || invoices == null) {
            return null;
        }
        HashMap<Long, String> invoiceBillNoMap = new HashMap<Long, String>(invoiceMap);
        for (DynamicObject invoice : invoices) {
            invoiceBillNoMap.remove(invoice.getLong("id"));
        }
        if (invoiceBillNoMap.isEmpty()) {
            return null;
        }
        return ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5173\u8054\u7684\u6536\u7968\u5355\uff1a%s\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceHelper_0", (String)"fi-ap-common", (Object[])new Object[]{String.join((CharSequence)",", invoiceBillNoMap.values())});
    }

    public static Map<Long, DynamicObject> getInvoiceMap(ExtendedDataEntity[] dataEntities) {
        HashSet invoiceIds = new HashSet(64);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            invEntry.forEach(invRow -> invoiceIds.add(invRow.getLong("invid")));
        }
        if (invoiceIds.isEmpty()) {
            return new HashMap<Long, DynamicObject>(2);
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,billno,invoicestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return invoices.stream().collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
    }

    public static void deleteRelation(String tarEntityKey, Long tarBillId, Long srcBillId) {
        try (TXHandle h = TX.requiresNew();){
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
            String sBuilder = "delete from T_BOTP_BillTracker where FSBillId= ? and FTBillId= ?";
            params.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
            params.add(new SqlParameter(":FTBillId", -5, (Object)tarBillId));
            DB.execute((DBRoute)DBRoute.basedata, (String)sBuilder, (Object[])params.toArray(new SqlParameter[0]));
        }
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)tarEntityKey);
        String hintTable = mt.getAlias();
        MainEntityType targetEntityType = MetadataServiceHelper.getDataEntityType((String)tarEntityKey);
        String dbRouteKey = targetEntityType.getDBRouteKey();
        DBRoute tarDbRoute = DBRoute.of((String)dbRouteKey);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)tarEntityKey);
        try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)hintTable, (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.eq, (Object)tarBillId)});){
            String tcTableName = linkSet.getTrackerTable();
            ArrayList<SqlParameter> paramTc = new ArrayList<SqlParameter>(2);
            String tcDeleteSql = "delete from " + tcTableName + " where FSBillId= ? and FTBillId= ?";
            paramTc.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
            paramTc.add(new SqlParameter(":FTBillId", -5, (Object)tarBillId));
            DB.execute((DBRoute)tarDbRoute, (String)tcDeleteSql, (Object[])paramTc.toArray(new SqlParameter[0]));
            LinkSetElement loadLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)tarEntityKey);
            ArrayList<SqlParameter> paramLk = new ArrayList<SqlParameter>(1);
            paramLk.add(new SqlParameter(":FSBillId", -5, (Object)srcBillId));
            paramLk.add(new SqlParameter(":fid", -5, (Object)tarBillId));
            String lkDeleteSql = "delete from " + ((LinkSetItemElement)loadLinkSet.getItems().get(0)).getTableName() + " where FSBillId= ? and fid = ?";
            DB.execute((DBRoute)tarDbRoute, (String)lkDeleteSql, (Object[])paramLk.toArray(new SqlParameter[0]));
        }
    }

    public static Map<Long, List<String>> getSerialMap(DynamicObject[] entities) {
        HashMap<Long, List<String>> serialMap = new HashMap<Long, List<String>>(64);
        if (ObjectUtils.isEmpty((Object[])entities)) {
            return serialMap;
        }
        String entityKey = entities[0].getDataEntityType().getName();
        for (DynamicObject entity : entities) {
            String serialNo;
            List serialNos;
            DynamicObjectCollection invEntry;
            long orgId;
            if ("ap_finapbill".equals(entityKey)) {
                orgId = entity.getLong("org.id");
                invEntry = entity.getDynamicObjectCollection("inventry");
                serialNos = serialMap.getOrDefault(orgId, new ArrayList(8));
                for (DynamicObject invRow : invEntry) {
                    serialNo = invRow.getString("i_serialno");
                    if (ObjectUtils.isEmpty((Object)serialNo)) continue;
                    serialNos.add(serialNo);
                }
                if (serialNos.isEmpty()) continue;
                serialMap.put(orgId, serialNos);
                continue;
            }
            if ("ap_invoice".equals(entityKey)) {
                String serialNo2 = entity.getString("serialno");
                if (ObjectUtils.isEmpty((Object)serialNo2)) continue;
                long orgId2 = entity.getLong("org.id");
                List serials = serialMap.getOrDefault(orgId2, new ArrayList(64));
                serials.add(serialNo2);
                if (serials.isEmpty()) continue;
                serialMap.put(orgId2, serials);
                continue;
            }
            if ("ap_payapply".equals(entityKey)) {
                orgId = entity.getLong("settleorg.id");
                invEntry = entity.getDynamicObjectCollection("inventry");
                serialNos = serialMap.getOrDefault(orgId, new ArrayList(8));
                for (DynamicObject invRow : invEntry) {
                    serialNo = invRow.getString("i_serialno");
                    if (ObjectUtils.isEmpty((Object)serialNo)) continue;
                    serialNos.add(serialNo);
                }
                if (serialNos.isEmpty()) continue;
                serialMap.put(orgId, serialNos);
                continue;
            }
            if (!"ap_replaceinvapply".equals(entityKey)) continue;
            orgId = entity.getLong("org.id");
            invEntry = entity.getDynamicObjectCollection("newinventry");
            serialNos = serialMap.getOrDefault(orgId, new ArrayList(8));
            for (DynamicObject invRow : invEntry) {
                serialNo = invRow.getString("n_serialno");
                if (ObjectUtils.isEmpty((Object)serialNo)) continue;
                serialNos.add(serialNo);
            }
            if (serialNos.isEmpty()) continue;
            serialMap.put(orgId, serialNos);
        }
        return serialMap;
    }

    public static Map<Long, String> getOrgForSerialMap(DynamicObject[] entities) {
        Map<Long, List<String>> serialMap = InvoiceHelper.getSerialMap(entities);
        if (ObjectUtils.isEmpty(serialMap)) {
            return new HashMap<Long, String>(8);
        }
        HashMap<Long, String> orgForSerialMap = new HashMap<Long, String>(64);
        for (Map.Entry<Long, List<String>> entrySet : serialMap.entrySet()) {
            orgForSerialMap.put(entrySet.getKey(), String.join((CharSequence)",", (Iterable<? extends CharSequence>)entrySet.getValue()));
        }
        return orgForSerialMap;
    }

    public static Set<String> getCollectInvoiceSrcTypeEnums(boolean isFinAp) {
        HashSet<String> invoiceSrcTypeEnums = new HashSet<String>(8);
        if (isFinAp) {
            invoiceSrcTypeEnums.add(InvoiceSrcTypeEnum.INVOICECOLLECT.getValue());
            invoiceSrcTypeEnums.add(InvoiceSrcTypeEnum.COORDINATEINVOICE.getValue());
            invoiceSrcTypeEnums.add(InvoiceSrcTypeEnum.SUPPLIERCOORDINATE.getValue());
            List<String> extendRowTypes = InvoiceHelper.getExtendSrcTypes();
            invoiceSrcTypeEnums.addAll(extendRowTypes);
        }
        return invoiceSrcTypeEnums;
    }

    public static List<String> getExtendSrcTypes() {
        String invoiceCollectExtendRowType = StdConfig.get((String)"invoiceCollectExtendRowType");
        if (!ObjectUtils.isEmpty((Object)invoiceCollectExtendRowType)) {
            return Arrays.asList(invoiceCollectExtendRowType.split(","));
        }
        return new ArrayList<String>(2);
    }

    public static void saveFinAndWriteBack(DynamicObject[] finApBills) {
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])finApBills);
        Object[] billIds = (Long[])Arrays.stream(finApBills).map(bill -> bill.getLong("id")).toArray(Long[]::new);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("WF", "false");
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"valid", (String)"ap_finapbill", (Object[])billIds, (OperateOption)operateOption);
        OperationHelper.assertResult((OperationResult)saveResult);
    }

    public static void updateFinTaxDeductionLogic(DynamicObject[] finBills, boolean isIgnoreSys) {
        if (ObjectUtils.isEmpty((Object[])finBills)) {
            return;
        }
        if (!isIgnoreSys) {
            ArrayList<Long> orgIds = new ArrayList<Long>(8);
            DynamicObject[] dynamicObjectArray = finBills;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject finApBill = dynamicObjectArray[i];
                orgIds.add(finApBill.getLong("org.id"));
            }
            Map ap035Map = SystemParameterHelper.batchGetAppParameter((Boolean)Boolean.FALSE, orgIds, (String)"ap_035");
            finBills = (DynamicObject[])Arrays.stream(finBills).filter(bill -> Boolean.parseBoolean(String.valueOf(ap035Map.get(bill.getLong("org.id"))))).toArray(DynamicObject[]::new);
        }
        if (ObjectUtils.isEmpty((Object[])finBills)) {
            return;
        }
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection invEntry = finBill.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            DynamicObject invRow = (DynamicObject)invEntry.get(0);
            boolean isCloud = !ObjectUtils.isEmpty((Object)invRow.getString("i_serialno"));
            boolean invoiceDeduction = invRow.getBoolean("i_istaxdeduction");
            String taxPayerType = finBill.getString("org.taxpayertype");
            String invoiceBizTypeNumber = finBill.getString("invoicebiztype.number");
            if (isCloud) {
                if (invoiceDeduction) {
                    if ("1".equals(taxPayerType)) {
                        finBill.set("istaxdeduction", (Object)Boolean.TRUE);
                    } else if ("2".equals(taxPayerType)) {
                        finBill.set("istaxdeduction", (Object)Boolean.FALSE);
                    }
                } else if ("1".equals(taxPayerType) || "2".equals(taxPayerType)) {
                    finBill.set("istaxdeduction", (Object)Boolean.FALSE);
                }
                if (!ObjectUtils.isEmpty((Object)taxPayerType)) continue;
                finBill.set("istaxdeduction", (Object)invoiceDeduction);
                continue;
            }
            if ("1".equals(taxPayerType)) {
                if ("SP00004_S".equals(invoiceBizTypeNumber) || "SP00002_S".equals(invoiceBizTypeNumber)) {
                    finBill.set("istaxdeduction", (Object)Boolean.TRUE);
                }
                if (!"SP00001_S".equals(invoiceBizTypeNumber) && !"SP00003_S".equals(invoiceBizTypeNumber)) continue;
                finBill.set("istaxdeduction", (Object)Boolean.FALSE);
                continue;
            }
            if ("2".equals(taxPayerType)) {
                if (!"SP00001_S".equals(invoiceBizTypeNumber) && !"SP00002_S".equals(invoiceBizTypeNumber) && !"SP00003_S".equals(invoiceBizTypeNumber) && !"SP00004_S".equals(invoiceBizTypeNumber) && !ObjectUtils.isEmpty((Object)invoiceBizTypeNumber)) continue;
                finBill.set("istaxdeduction", (Object)Boolean.FALSE);
                continue;
            }
            if (!"SP00001_S".equals(invoiceBizTypeNumber) && !"SP00003_S".equals(invoiceBizTypeNumber)) continue;
            finBill.set("istaxdeduction", (Object)Boolean.FALSE);
        }
        ApFarmTaxAmtHelper.setFinDecuAmt((DynamicObject[])finBills);
    }

    public static Map<String, Set<String>> getInvoiceOtherOccupyMap(DynamicObject[] finApBills, Set<Long> assignInvoiceIds) {
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return new HashMap<String, Set<String>>(2);
        }
        HashMap<Object, Set> invoiceForFinApMap = new HashMap<Object, Set>(8);
        HashSet<Long> hasInDbFinApIds = new HashSet<Long>(8);
        for (DynamicObject finApBill2 : finApBills) {
            String billNo = finApBill2.getString("billno");
            DynamicObjectCollection invEntry = finApBill2.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                if (!"A".equals(finApBill2.getString("billstatus")) && BigDecimal.ZERO.compareTo(invRow.getBigDecimal("i_usedamt")) == 0) continue;
                long invId = invRow.getLong("invid");
                Set finApBillNos = invoiceForFinApMap.getOrDefault(invId, new HashSet(8));
                finApBillNos.add(billNo);
                invoiceForFinApMap.put(invId, finApBillNos);
            }
            long billId = finApBill2.getLong("id");
            if (billId == 0L) continue;
            hasInDbFinApIds.add(billId);
        }
        if (!ObjectUtils.isEmpty(assignInvoiceIds)) {
            String billNo = finApBills[0].getString("billno");
            for (Long assignInvoiceId : assignInvoiceIds) {
                Set finApBillNos = invoiceForFinApMap.getOrDefault(assignInvoiceId, new HashSet(8));
                finApBillNos.add(billNo);
                invoiceForFinApMap.put(assignInvoiceId, finApBillNos);
            }
        }
        Set orgIds = Arrays.stream(finApBills).map(finApBill -> finApBill.getLong("org.id")).collect(Collectors.toSet());
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("inventry.invid", "in", invoiceForFinApMap.keySet());
        filter.and("inventry.i_usedamt", "!=", (Object)BigDecimal.ZERO);
        filter.and("hadwrittenoff", "in", (Object)Boolean.FALSE);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"getInvoiceAssignOthers", (String)"ap_finapbill", (String)"id,billno,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"");
        for (Row row : queryDataSet) {
            if (hasInDbFinApIds.contains(row.getLong("id"))) continue;
            Long invId = row.getLong("inventry.invid");
            Set finApBillNos = invoiceForFinApMap.getOrDefault(invId, new HashSet(64));
            finApBillNos.add(row.getString("billno"));
            invoiceForFinApMap.put(invId, finApBillNos);
        }
        DataSet invoiceDataSet = QueryServiceHelper.queryDataSet((String)"queryInvoiceBillno", (String)"ap_invoice", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceForFinApMap.keySet())}, (String)"");
        HashMap<Long, String> invoiceBillNoMap = new HashMap<Long, String>(8);
        for (Row invoiceRow : invoiceDataSet) {
            invoiceBillNoMap.put(invoiceRow.getLong("id"), invoiceRow.getString("billno"));
        }
        HashMap<String, Set<String>> moreOccupyInvApMap = new HashMap<String, Set<String>>(8);
        for (Map.Entry entrySet : invoiceForFinApMap.entrySet()) {
            Long invoiceId = (Long)entrySet.getKey();
            Set finApBillNos = (Set)entrySet.getValue();
            if (finApBillNos.size() <= 1) continue;
            for (String finApBillNo : finApBillNos) {
                Set invoiceNos = moreOccupyInvApMap.getOrDefault(finApBillNo, new HashSet(8));
                invoiceNos.add(invoiceBillNoMap.get(invoiceId));
                moreOccupyInvApMap.put(finApBillNo, invoiceNos);
            }
        }
        return moreOccupyInvApMap;
    }

    public static Set<String> getInvoiceAdjustSelectors() {
        HashSet<String> selectors = new HashSet<String>(64);
        selectors.add("currency");
        selectors.add("billstatus");
        selectors.add("uninvoicedamt");
        selectors.add("isvoucher");
        selectors.add("quantity");
        selectors.add("e_uninvoicedamt");
        selectors.add("e_invoicedamt");
        selectors.add("inventry.invid");
        selectors.add("inventry.i_usedamt");
        selectors.add("inventry.seq");
        selectors.add("inventry.i_billno");
        selectors.add("inventry.i_invoicetype");
        selectors.add("inventry.i_invoicetypef7");
        selectors.add("inventry.i_invoicecode");
        selectors.add("inventry.i_invoiceno");
        selectors.add("inventry.i_invoicedate");
        selectors.add("inventry.i_pricetaxtotal");
        selectors.add("inventry.i_taxrate");
        selectors.add("inventry.i_tax");
        selectors.add("inventry.i_srctype");
        selectors.add("inventry.i_amount");
        selectors.add("inventry.i_asstactname");
        selectors.add("inventry.i_buyername");
        selectors.add("inventry.i_istaxdeduction");
        selectors.add("inventry.i_remark");
        selectors.add("inventry.i_serialno");
        selectors.add("inventry.i_issupplement");
        selectors.add("inventry.i_currency");
        selectors.add("paycond");
        selectors.add("termsdate");
        selectors.add("planentity");
        selectors.add("planduedate");
        selectors.add("duedate");
        selectors.add("org");
        selectors.add("istaxdeduction");
        selectors.add("bilselectorsatus");
        selectors.add("isinvoicematch");
        selectors.add("amount");
        selectors.add("pricetaxtotal");
        selectors.add("tax");
        selectors.add("unlockamt");
        selectors.add("e_taxdiffamt");
        selectors.add("e_amountdiffamt");
        selectors.add("e_pricetaxdiffamt");
        selectors.add("e_tax");
        selectors.add("e_amount");
        selectors.add("e_pricetaxtotal");
        selectors.add("e_adjustamount");
        selectors.add("planpricetaxloc");
        selectors.add("unplanlockamt");
        selectors.add("unplansettleamt");
        selectors.add("unplansettlelocamt");
        selectors.add("splitscheme");
        selectors.add("sourcebilltype");
        selectors.add("detailentry.seq");
        selectors.add("e_unverifyamount");
        selectors.add("unsettleamt");
        selectors.add("unverifyamount");
        selectors.add("unsettleamount");
        selectors.add("e_taxlocalamt");
        selectors.add("e_amountbase");
        selectors.add("e_pricetaxtotalbase");
        selectors.add("planpricetax");
        selectors.add("taxlocamt");
        selectors.add("amountbase");
        selectors.add("pricetaxtotalbase");
        selectors.add("basecurrency");
        selectors.add("quotation");
        selectors.add("exchangerate");
        selectors.add("settlementtype");
        selectors.add("unsettleamtbase");
        selectors.add("planentity.plansettletype");
        selectors.add("planentity.e_freezestate");
        selectors.add("unsettleamountbase");
        selectors.add("lockedamt");
        selectors.add("bizdate");
        selectors.add("istanspay");
        selectors.add("iswrittenoff");
        selectors.add("ispremium");
        selectors.add("material");
        selectors.add("planmaterial");
        selectors.add("settleamount");
        selectors.add("e_farmproducts");
        selectors.add("deductiblerate");
        selectors.add("taxrate");
        selectors.add("invoicebiztype");
        selectors.add("curdeductibleamt");
        selectors.add("intercostamt");
        selectors.add("e_unallocatedamt");
        selectors.add("isexpensealloc");
        selectors.add("allocatebyper");
        selectors.add("isintax");
        selectors.add("preentry");
        selectors.add("preentry.y_settleamt");
        selectors.add("preentry.y_unsettleamt");
        selectors.add("preentry.y_amount");
        selectors.add("preentry.y_billtype");
        selectors.add("preentry.y_billid");
        selectors.add("a_allocationamt");
        selectors.add("a_localamt");
        selectors.add("a_allocationper");
        selectors.add("relationpay");
        selectors.add("planentity.seq");
        selectors.add("inventry.i_canuseamt");
        selectors.add("isincludetax");
        selectors.add("ispricetotal");
        selectors.add("discountmode");
        selectors.add("discountrate");
        selectors.add("discountamount");
        selectors.add("price");
        selectors.add("premiumamt");
        selectors.add("premiumrate");
        selectors.add("settledamt");
        selectors.add("verifyamount");
        selectors.add("settledamtbase");
        selectors.add("billno");
        selectors.add("corebillno");
        selectors.add("corebillid");
        selectors.add("plancorebillno");
        selectors.add("plancorebillid");
        selectors.add("haspaperticket");
        selectors.add("isprepayinv");
        selectors.add("asstact");
        selectors.add("e_sourcebillid");
        selectors.add("e_sourcebillentryid");
        selectors.add("billsrctype");
        return selectors;
    }
}

