/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.piaozone.page;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.ap.piaozone.page.AbstractInvoiceCloud;
import kd.fi.ap.vo.VoucherRelation;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionResponse;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionWrapper4Op;
import kd.fi.arapcommon.business.piaozone.kingdee.action.DeleteAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.GenVoucherAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.IAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.SaveAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UpdateAction;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

@Deprecated
public class InvoiceCloud
extends AbstractInvoiceCloud {
    private static Log logger = LogFactory.getLog(InvoiceCloud.class);
    private static final String INVOICE_PAGE_ON_PC = "onPC";
    private static final String INVOICE_PAGE_TAX_REG_NUM = "taxRegNum";
    private static final String INVOICE_PAGE_ACTION_TYPE = "actionType";
    private static final String ER_INVOICECLOUDPAGE_PC = "er_invoicecloudpage_pc";

    @Override
    public AbstractInvoiceCloud buildShowSelect(AbstractFormPlugin plugin, DynamicObject org) {
        this.plugin = plugin;
        String taxRegNum = this.getTaxNo(org);
        Tuple<String, Long> tuple = this.getBillNo();
        HashMap<String, Object> customParam = new HashMap<String, Object>(8);
        customParam.put(INVOICE_PAGE_ACTION_TYPE, "selectInvoice");
        customParam.put(INVOICE_PAGE_TAX_REG_NUM, taxRegNum);
        customParam.put(INVOICE_PAGE_ON_PC, Boolean.TRUE);
        customParam.put("bxd_key", tuple.item1);
        customParam.put("billNumber", tuple.item1);
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("billId", tuple.item1);
        param.put(INVOICE_PAGE_TAX_REG_NUM, taxRegNum);
        param.put("invoiceCompanyId", org.getPkValue());
        customParam.put("importInvoiceIframeUrlReqParam", JSON.toJSONString(param));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("800");
        styleCss.setHeight("530");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "selectInvoice_" + tuple.item2);
        this.parameter.setFormId(ER_INVOICECLOUDPAGE_PC);
        this.parameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.parameter.getCustomParams().putAll(customParam);
        this.parameter.setShowTitle(false);
        this.parameter.setCloseCallBack(closeCallBack);
        return this;
    }

    private String getTaxNo(DynamicObject org) {
        InvoiceCloudCfg config;
        String taxRegNum = "";
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            config = KingdeeInvoiceCloudConfig.getConfig((Long)((Long)org.getPkValue()));
            String taxRegnums = config.getTaxRegnum();
            taxRegNum = taxRegnums.split("=")[0];
        }
        if (StringUtils.isEmpty((String)taxRegNum)) {
            config = KingdeeInvoiceCloudConfig.getConfig((DynamicObject)org);
            taxRegNum = config.getTaxRegnum();
        }
        return taxRegNum;
    }

    @Override
    public AbstractInvoiceCloud buildShowSelectFirView(AbstractFormPlugin formPlugin, DynamicObject inv, Collection<String> serialNos, Long invoiceOrgId) {
        DynamicObjectCollection invEntries;
        this.plugin = formPlugin;
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((Long)invoiceOrgId);
        String invId = ShowInvoiceCloudPageUtil.getBillNoCachedInCloud(inv);
        logger.info("\u8c03\u7528\u524d\u7aef\u67e5\u770b\u53d1\u7968\u5217\u8868\u754c\u9762>>> serialNosKey:" + invId + ", serialNos:" + serialNos);
        String entityName = inv.getDynamicObjectType().getName();
        ArrayList<String> relevanceExpenseIdList = new ArrayList<String>(10);
        if ("ap_finapbill".equals(entityName) && EmptyUtils.isNotEmpty((Object)(invEntries = inv.getDynamicObjectCollection("inventry")))) {
            for (int i = 0; i < invEntries.size(); ++i) {
                DynamicObject invEntry = (DynamicObject)invEntries.get(i);
                String invBillId = invEntry.getString("invid");
                if (!StringUtils.isNotEmpty((String)invBillId)) continue;
                relevanceExpenseIdList.add("ap_invoice_" + invBillId);
            }
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put(INVOICE_PAGE_ACTION_TYPE, "viewInvoiceList");
        customParam.put("invoiceOrgId", invoiceOrgId);
        customParam.put(INVOICE_PAGE_ON_PC, Boolean.TRUE);
        customParam.put("billNumber", invId);
        customParam.put("serialNo", JsonUtils.objToJson(serialNos));
        HashMap<String, Object> showInvoiceParam = new HashMap<String, Object>();
        showInvoiceParam.put("billId", invId);
        showInvoiceParam.put("billNumber", inv.getString("billno"));
        showInvoiceParam.put("orgId", invoiceOrgId);
        showInvoiceParam.put("serialNos", new ArrayList<String>(serialNos));
        String taxRegnums = config.getTaxRegnum();
        String taxRegNum = taxRegnums.split("=")[0];
        showInvoiceParam.put(INVOICE_PAGE_TAX_REG_NUM, taxRegNum);
        if (relevanceExpenseIdList.size() > 0) {
            String relevanceExpenseId = String.join((CharSequence)",", relevanceExpenseIdList);
            logger.info("\u67e5\u8be2\u53d1\u7968\u5173\u8054\u7684\u5355\u636eID" + relevanceExpenseId);
            showInvoiceParam.put("relevanceExpenseId", relevanceExpenseId);
        }
        customParam.put("showInvoiceUrlReqParam", JsonUtils.objToJson(showInvoiceParam));
        this.parameter.setFormId(ER_INVOICECLOUDPAGE_PC);
        this.parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        this.parameter.setCaption("");
        this.parameter.setShowTitle(false);
        this.parameter.getCustomParams().putAll(customParam);
        return this;
    }

    @Override
    public void saveAndUpdateInv(OperationResult operationResult, BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject inv2 : dataEntities = e.getDataEntities()) {
            String serialno = inv2.getString("serialno");
            if (!EmptyUtils.isNotEmpty((Object)serialno)) continue;
            InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((Long)inv2.getLong("org.id"));
            String[] serialNos = new String[]{inv2.getString("serialno")};
            SaveAction saveAction = new SaveAction(config, inv2.getPkValue(), inv2.getString("billno"), serialNos);
            ActionWrapper4Op saveWrapper = new ActionWrapper4Op((IAction)saveAction, operationResult, inv2.getPkValue(), inv2.getString("billno"));
            ActionResponse actionResponse = saveWrapper.executeResponse();
            if (!actionResponse.success()) continue;
            UpdateAction updateAction = new UpdateAction(config, inv2.getPkValue(), inv2.getString("billno"));
            ActionWrapper4Op updateWrapper = new ActionWrapper4Op((IAction)updateAction, operationResult, inv2);
            updateWrapper.executeResponse();
        }
        Set failedIds = operationResult.getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toSet());
        dataEntities = (DynamicObject[])Stream.of(dataEntities).filter(inv -> !failedIds.contains(inv.getPkValue())).toArray(DynamicObject[]::new);
        e.setDataEntities(dataEntities);
    }

    @Override
    public void deleteInvRelation(OperationResult operationResult, BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject inv2 : dataEntities = e.getDataEntities()) {
            if (EmptyUtils.isEmpty((Object)inv2.getString("serialno"))) continue;
            DeleteAction deleteAction = new DeleteAction(inv2.getDynamicObject("org"), inv2.getPkValue(), inv2.getString("billno"));
            ActionWrapper4Op deleteWrapper = new ActionWrapper4Op((IAction)deleteAction, operationResult, inv2.getPkValue(), inv2.getString("billno"));
            deleteWrapper.executeResponse();
        }
        Set failedIds = operationResult.getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toSet());
        dataEntities = (DynamicObject[])Stream.of(dataEntities).filter(inv -> !failedIds.contains(inv.getPkValue())).toArray(DynamicObject[]::new);
        e.setDataEntities(dataEntities);
    }

    @Override
    public void genVoucher(VoucherRelation relation, OperationResult operationResult) {
        DynamicObject[] vouchers = relation.getVouchers();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject invoice = relation.getInvoice();
        Long invoiceId = relation.getInvoiceId();
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("expenseId", "ap_invoice_" + invoiceId);
        HashMap<String, Object> invoiceMap = new HashMap<String, Object>(2);
        invoiceMap.put("serialNo", invoice.get("serialno"));
        invoiceMap.put("deductionFlag", invoice.getBoolean("istaxdeduction") ? "1" : "0");
        param.put("invoiceData", Collections.singletonList(invoiceMap));
        if (EmptyUtils.isNotEmpty((Object)vouchers)) {
            ArrayList voucherInfo = new ArrayList(8);
            for (DynamicObject voucher : vouchers) {
                HashMap<String, Object> voucherMap = new HashMap<String, Object>(8);
                voucherMap.put("vouchId", voucher.getLong("id"));
                voucherMap.put("vouchNo", voucher.getString("billno"));
                DynamicObject period = voucher.getDynamicObject("period");
                if (period != null) {
                    voucherMap.put("period", period.get("number"));
                }
                voucherMap.put("businessDate", sdf.format(voucher.getDate("bizdate")));
                voucherMap.put("accountDate", sdf.format(voucher.getDate("bookeddate")));
                voucherInfo.add(voucherMap);
            }
            param.put("voucherInfo", voucherInfo);
        }
        logger.info("UpdateInvoiceCloudHelp genVoucher param is " + param);
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((Long)invoice.getLong("org.id"));
        GenVoucherAction genVoucherAction = new GenVoucherAction(config.getTaxRegnum(), param);
        if (operationResult != null) {
            genVoucherAction.setToken(APIHelper.getToken((String)genVoucherAction.getTaxRegNum()));
            ActionWrapper4Op wrapper4Op = new ActionWrapper4Op((IAction)genVoucherAction, operationResult, (Object)invoiceId, invoice.getString("billno"));
            ActionResponse actionResponse = wrapper4Op.executeResponse();
            if (actionResponse.success()) {
                logger.info("UpdateInvoiceCloudHelp : genVoucher is success ! invoiceId is" + invoiceId);
            } else {
                relation.setUpdate(Boolean.FALSE);
                logger.info("UpdateInvoiceCloudHelp : genVoucher exist error ! invoiceId is [ " + invoiceId + "] error message is : " + actionResponse.getErrcode());
            }
        } else {
            Map response = APIHelper.invokeAction((AbstractAction)genVoucherAction);
            Object errCode = response.get("errcode");
            if ("0000".equals(errCode)) {
                logger.info("UpdateInvoiceCloudHelp : genVoucher is success ! invoiceId is :" + invoiceId);
            } else {
                relation.setUpdate(Boolean.FALSE);
                Object desc = response.get("description");
                logger.info("UpdateInvoiceCloudHelp : genVoucher exist error ! invoiceId is [ " + invoiceId + "] error message is : " + desc + "(" + errCode + ")");
            }
        }
    }

    @Override
    public List<InvoiceVO> queryInvStatus(DynamicObject[] datas) {
        ArrayList<InvoiceVO> allinvoiceVOS = new ArrayList<InvoiceVO>(10);
        Map<Long, List<DynamicObject>> orgsMap = Arrays.stream(datas).collect(Collectors.groupingBy(t -> t.getLong("org.id")));
        for (Map.Entry<Long, List<DynamicObject>> m : orgsMap.entrySet()) {
            List<DynamicObject> invBills = m.getValue();
            DynamicObject org = invBills.get(0).getDynamicObject("org");
            HashSet<String> orgSerNos = new HashSet<String>(8);
            for (int i = 0; i < invBills.size(); ++i) {
                DynamicObject invBill = invBills.get(i);
                orgSerNos.add(invBill.getString("serialno"));
            }
            String serialNosStr = String.join((CharSequence)",", orgSerNos);
            QueryInvoiceDetailInfo queryInvoiceDetail = InvoiceCollectHelper.buildQueryInvoiceDetail(org, serialNosStr);
            List invoiceVOS = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailInfo)queryInvoiceDetail);
            allinvoiceVOS.addAll(invoiceVOS);
        }
        return allinvoiceVOS;
    }
}

