/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.piaozone.page;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.ap.piaozone.ShowInvoiceCloudPageUtil;
import kd.fi.ap.piaozone.page.AbstractInvoiceCloud;
import kd.fi.ap.vo.VoucherRelation;
import kd.fi.arapcommon.business.piaozone.exception.PZAuthException;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceDetailRetrunVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.SaveVoucherRequestParam;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionResponse;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ActionWrapper4Op;
import kd.fi.arapcommon.business.piaozone.kingdee.action.DeleteActionXh;
import kd.fi.arapcommon.business.piaozone.kingdee.action.GenVoucherActionXh;
import kd.fi.arapcommon.business.piaozone.kingdee.action.IAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UpdateActionXh;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

@Deprecated
public class InvoiceCloudXH
extends AbstractInvoiceCloud {
    private static Log logger = LogFactory.getLog(InvoiceCloudXH.class);

    @Override
    public AbstractInvoiceCloud buildShowSelect(AbstractFormPlugin plugin, DynamicObject org) {
        this.plugin = plugin;
        Tuple<String, Long> tuple = this.getBillNo();
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("billType", "ap_invoice");
        customParams.put("billNo", tuple.item1);
        customParams.put("billId", tuple.item2 + "");
        customParams.put("entityId", "ap_invoice");
        customParams.put("viewPage", "ap_invoice");
        customParams.put("orgId", org.getPkValue());
        customParams.put("resource", "4");
        ArrayList companyInfo = new ArrayList(16);
        Map<String, String> taxNo = this.getTaxNo(org);
        for (Map.Entry<String, String> entry : taxNo.entrySet()) {
            HashMap<String, String> map11 = new HashMap<String, String>(8);
            map11.put("taxNo", entry.getKey());
            map11.put("name", entry.getValue());
            companyInfo.add(map11);
        }
        customParams.put("companyInfo", companyInfo);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "selectInvoice_" + tuple.item2);
        this.parameter.setCustomParams(customParams);
        this.parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.parameter.setFormId("rim_fpzs_main");
        this.parameter.setCloseCallBack(closeCallBack);
        return this;
    }

    private Map<String, String> getTaxNo(DynamicObject org) {
        InvoiceCloudCfg config;
        HashMap<String, String> paramMap = new HashMap<String, String>(8);
        if (KingdeeInvoiceCloudConfig.isGroupPattern()) {
            config = KingdeeInvoiceCloudConfig.getConfig((Long)((Long)org.getPkValue()));
            String[] taxRegnum = config.getTaxRegnum().split("=");
            String[] firmname = config.getFirmname().split("=");
            int size = Math.min(taxRegnum.length, firmname.length);
            for (int i = 0; i < size; ++i) {
                paramMap.put(taxRegnum[i], firmname[i]);
            }
        }
        if (paramMap.isEmpty()) {
            config = KingdeeInvoiceCloudConfig.getConfig((DynamicObject)org);
            paramMap.put(config.getTaxRegnum(), config.getFirmname());
        }
        return paramMap;
    }

    @Override
    public AbstractInvoiceCloud buildShowSelectFirView(AbstractFormPlugin formPlugin, DynamicObject inv, Collection<String> serialNos, Long invoiceOrgId) {
        DynamicObjectCollection invEntries;
        this.plugin = formPlugin;
        String invId = ShowInvoiceCloudPageUtil.getBillNoCachedInCloud(inv);
        String[] invIdExistLine = invId.split("_");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        String entityName = inv.getDynamicObjectType().getName();
        customParams.put("billId", invIdExistLine[invIdExistLine.length - 1]);
        customParams.put("entityId", entityName);
        customParams.put("serialNos", new ArrayList<String>(serialNos));
        customParams.put("billType", entityName);
        customParams.put("orgId", String.valueOf(invoiceOrgId));
        ArrayList<String> relevanceExpenseIdList = new ArrayList<String>(10);
        if ("ap_finapbill".equals(entityName) && EmptyUtils.isNotEmpty((Object)(invEntries = inv.getDynamicObjectCollection("inventry")))) {
            for (int i = 0; i < invEntries.size(); ++i) {
                DynamicObject invEntry = (DynamicObject)invEntries.get(i);
                String invBillId = invEntry.getString("invid");
                if (!StringUtils.isNotEmpty((String)invBillId)) continue;
                relevanceExpenseIdList.add(invBillId);
            }
        }
        if (relevanceExpenseIdList.size() > 0) {
            customParams.put("relevanceExpenseId", relevanceExpenseIdList);
        }
        this.parameter.setCustomParams(customParams);
        logger.info("\u661f\u701a\u53d1\u7968\u67e5\u770b\u53c2\u6570{}", customParams);
        this.parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.parameter.setFormId("rim_view_invoice");
        return this;
    }

    @Override
    public void saveAndUpdateInv(OperationResult operationResult, BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject inv2 : dataEntities = e.getDataEntities()) {
            String serialno = inv2.getString("serialno");
            if (!EmptyUtils.isNotEmpty((Object)serialno)) continue;
            InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig((Long)inv2.getLong("org.id"));
            UpdateActionXh updateActionXh = new UpdateActionXh(config, inv2.getPkValue(), inv2.getString("billno"), inv2);
            ActionWrapper4Op updateWrapperXh = new ActionWrapper4Op((IAction)updateActionXh, operationResult, inv2);
            updateWrapperXh.executeResponse();
        }
        Set failedIds = operationResult.getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toSet());
        dataEntities = (DynamicObject[])Stream.of(dataEntities).filter(inv -> !failedIds.contains(inv.getPkValue())).toArray(DynamicObject[]::new);
        e.setDataEntities(dataEntities);
    }

    @Override
    public void deleteInvRelation(OperationResult operationResult, BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject inv2 : dataEntities = e.getDataEntities()) {
            if (EmptyUtils.isEmpty((Object)inv2.getString("serialno"))) continue;
            DeleteActionXh deleteActionXh = new DeleteActionXh(inv2.getDynamicObject("org"), inv2.getPkValue(), inv2);
            ActionWrapper4Op deleteWrapperXh = new ActionWrapper4Op((IAction)deleteActionXh, operationResult, inv2.getPkValue(), inv2.getString("billno"));
            deleteWrapperXh.executeResponse();
        }
        Set failedIds = operationResult.getAllErrorInfo().stream().map(OperateInfo::getPkValue).collect(Collectors.toSet());
        dataEntities = (DynamicObject[])Stream.of(dataEntities).filter(inv -> !failedIds.contains(inv.getPkValue())).toArray(DynamicObject[]::new);
        e.setDataEntities(dataEntities);
    }

    @Override
    public void genVoucher(VoucherRelation relation, OperationResult operationResult) {
        DynamicObject[] vouchers = relation.getVouchers();
        DynamicObject invoice = relation.getInvoice();
        Long invoiceId = relation.getInvoiceId();
        SaveVoucherRequestParam saveParam = new SaveVoucherRequestParam();
        saveParam.setExpenseId(String.valueOf(invoiceId));
        ArrayList<SaveVoucherRequestParam.VoucherInfo> vouchArray = new ArrayList<SaveVoucherRequestParam.VoucherInfo>(2);
        if (EmptyUtils.isNotEmpty((Object)vouchers)) {
            for (DynamicObject voucher : vouchers) {
                SaveVoucherRequestParam.VoucherInfo voucherInfo = new SaveVoucherRequestParam.VoucherInfo();
                voucherInfo.setVouchId(voucher.getString("id"));
                voucherInfo.setVouchNo(voucher.getString("billno"));
                voucherInfo.setAccountTime(voucher.getDate("bizdate"));
                voucherInfo.setAccountDate(voucher.getDate("bookeddate"));
                vouchArray.add(voucherInfo);
            }
            saveParam.setVouchArray(vouchArray);
            this.updateVoucher(saveParam, operationResult, invoice, relation);
        }
    }

    private void updateVoucher(SaveVoucherRequestParam saveParam, OperationResult operationResult, DynamicObject invoice, VoucherRelation relation) {
        logger.info("UpdateInvoiceCloudHelp genVoucher param is " + JSON.toJSONString((Object)saveParam));
        GenVoucherActionXh genVoucherActionXh = new GenVoucherActionXh(invoice.getString("buyertin"), saveParam);
        Long invoiceId = relation.getInvoiceId();
        if (operationResult != null) {
            ActionWrapper4Op wrapper4Op = new ActionWrapper4Op((IAction)genVoucherActionXh, operationResult, (Object)invoiceId, invoice.getString("billno"));
            ActionResponse actionResponse = wrapper4Op.executeResponse();
            String errCode = actionResponse.getErrcode();
            if ("0000".equals(errCode)) {
                logger.info("UpdateInvoiceCloudHelp : genVoucher is success ! invoiceId is :" + invoiceId);
            } else {
                relation.setUpdate(Boolean.FALSE);
                String desc = actionResponse.getDescription();
                logger.info("UpdateInvoiceCloudHelp : genVoucher exist error ! invoiceId is [ " + invoiceId + "] error message is : " + desc + "(" + errCode + ")");
            }
        }
    }

    @Override
    public List<InvoiceVO> queryInvStatus(DynamicObject[] dataEntities) {
        List serialNos = Arrays.stream(dataEntities).map(bill -> bill.getString("serialno")).collect(Collectors.toList());
        logger.info("\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(serialNos));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"query", (Object[])new Object[]{serialNos});
        String respJson = JSON.toJSONString((Object)result);
        logger.info("\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", serialNos, (Object)respJson);
        InvoiceDetailRetrunVO invoiceDetailReturnVO = (InvoiceDetailRetrunVO)JSON.parseObject((String)respJson, InvoiceDetailRetrunVO.class);
        String errcode = invoiceDetailReturnVO.getErrcode();
        if ("0000".equals(errcode)) {
            logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
            List invoiceVOS = invoiceDetailReturnVO.getData();
            return invoiceVOS;
        }
        logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + errcode);
        ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
        throw new PZAuthException(ec);
    }
}

